/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.jetbrains.annotations.NotNull;

public class ContainsKeyOp {
    public static boolean execute(ExecutablePool pool, String region, Object key, MODE mode) {
        ContainsKeyOpImpl op = new ContainsKeyOpImpl(region, key, mode);
        Boolean result = (Boolean)pool.execute(op);
        return result;
    }

    private ContainsKeyOp() {
    }

    private static class ContainsKeyOpImpl
    extends AbstractOp {
        private final String region;
        private final Object key;
        private final MODE mode;

        public ContainsKeyOpImpl(String region, Object key, MODE mode) {
            super(38, 3);
            this.getMessage().addStringPart(region, true);
            this.getMessage().addStringOrObjPart(key);
            this.getMessage().addIntPart(mode.ordinal());
            this.region = region;
            this.key = key;
            this.mode = mode;
        }

        @Override
        protected Object processResponse(@NotNull Message msg) throws Exception {
            return this.processObjResponse(msg, "containsKey");
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 39;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startContainsKey();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endContainsKeySend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endContainsKey(start, this.hasTimedOut(), this.hasFailed());
        }

        public String toString() {
            return "ContainsKeyOp(region=" + this.region + ";key=" + String.valueOf(this.key) + ";mode=" + String.valueOf((Object)this.mode);
        }
    }

    public static enum MODE {
        KEY,
        VALUE_FOR_KEY,
        VALUE;

    }
}

