/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.GatewayConfigurationException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.ServerRefusedConnectionException;
import org.apache.geode.cache.client.internal.AuthenticateUserOp;
import org.apache.geode.cache.client.internal.ClientSideHandshakeImpl;
import org.apache.geode.cache.client.internal.ClientUpdater;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionConnector;
import org.apache.geode.cache.client.internal.ConnectionFactory;
import org.apache.geode.cache.client.internal.ConnectionImpl;
import org.apache.geode.cache.client.internal.ConnectionSource;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.EndpointManager;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.QueueManager;
import org.apache.geode.cache.client.internal.ServerDenyList;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;

public class ConnectionFactoryImpl
implements ConnectionFactory {
    private static final Logger logger = LogService.getLogger();
    private final ServerDenyList denyList;
    private final ConnectionSource source;
    private final PoolImpl pool;
    private final CancelCriterion cancelCriterion;
    private final ConnectionConnector connectionConnector;
    @MutableForTesting
    public static boolean testFailedConnectionToServer = false;

    ConnectionFactoryImpl(ConnectionSource source, EndpointManager endpointManager, InternalDistributedSystem sys, int socketBufferSize, int handshakeTimeout, int readTimeout, ClientProxyMembershipID proxyId, CancelCriterion cancelCriterion, boolean usedByGateway, GatewaySender sender, long pingInterval, boolean multiuserSecureMode, PoolImpl pool, DistributionConfig distributionConfig) {
        this(new ConnectionConnector(endpointManager, sys, socketBufferSize, handshakeTimeout, readTimeout, usedByGateway, sender, usedByGateway || sender != null ? SocketCreatorFactory.getSocketCreatorForComponent(distributionConfig, SecurableCommunicationChannel.GATEWAY) : SocketCreatorFactory.getSocketCreatorForComponent(distributionConfig, SecurableCommunicationChannel.SERVER), new ClientSideHandshakeImpl(proxyId, sys, sys.getSecurityService(), multiuserSecureMode), pool.getSocketFactory()), source, pingInterval, pool, cancelCriterion);
    }

    public ConnectionFactoryImpl(ConnectionConnector connectionConnector, ConnectionSource source, long pingInterval, PoolImpl pool, CancelCriterion cancelCriterion) {
        this.connectionConnector = connectionConnector;
        this.source = source;
        this.pool = pool;
        this.cancelCriterion = cancelCriterion;
        this.denyList = new ServerDenyList(pingInterval);
    }

    public void start(ScheduledExecutorService background) {
        this.denyList.start(background);
    }

    @Override
    public ServerDenyList getDenyList() {
        return this.denyList;
    }

    @Override
    public Connection createClientToServerConnection(ServerLocation location, boolean forQueue) throws GemFireSecurityException {
        ServerDenyList.FailureTracker failureTracker = this.denyList.getFailureTracker(location);
        ConnectionImpl connection = null;
        try {
            connection = this.connectionConnector.connectClientToServer(location, forQueue);
            failureTracker.reset();
            this.authenticateIfRequired(connection);
        }
        catch (CancelException | GemFireConfigException | GatewayConfigurationException | GemFireSecurityException e) {
            throw e;
        }
        catch (ServerRefusedConnectionException src) {
            logger.warn("Could not create a new connection to server: {}", (Object)src.getMessage());
            testFailedConnectionToServer = true;
            throw src;
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message != null && (message.contains("Connection refused") || message.contains("Connection reset") || message.contains("Remote host terminated the handshake"))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unable to connect to {}: connection refused", (Object)location);
                }
            } else {
                logger.warn("Could not connect to: " + String.valueOf(location), (Throwable)e);
            }
            testFailedConnectionToServer = true;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void authenticateIfRequired(Connection conn) {
        this.cancelCriterion.checkCancelInProgress(null);
        if (this.pool.isUsedByGateway() || this.pool.getMultiuserAuthentication()) {
            return;
        }
        ServerLocation server = conn.getServer();
        if (!server.getRequiresCredentials()) {
            return;
        }
        ServerLocation serverLocation = server;
        synchronized (serverLocation) {
            if (server.getUserId() != -1L) {
                return;
            }
            Long uniqueID = AuthenticateUserOp.executeOn(conn, (ExecutablePool)this.pool);
            if (uniqueID == null) {
                throw new ServerConnectivityException("Connection refused");
            }
            server.setUserId(uniqueID);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("CFI.authenticateIfRequired() Completed authentication on {}", (Object)conn);
        }
    }

    @Override
    public ServerLocation findBestServer(ServerLocation currentServer, Set<ServerLocation> excludedServers) {
        if (currentServer != null && this.source.isBalanced()) {
            return currentServer;
        }
        Set<ServerLocation> origExcludedServers = excludedServers;
        excludedServers = new HashSet<ServerLocation>(excludedServers);
        Set<ServerLocation> denyListedServers = this.denyList.getBadServers();
        excludedServers.addAll(denyListedServers);
        ServerLocation server = this.source.findReplacementServer(currentServer, excludedServers);
        if (server == null && excludedServers.size() > origExcludedServers.size()) {
            server = this.source.findReplacementServer(currentServer, origExcludedServers);
        }
        if (server == null && logger.isDebugEnabled()) {
            logger.debug("Source was unable to findForReplacement any servers");
        }
        return server;
    }

    @Override
    public Connection createClientToServerConnection(Set<ServerLocation> excludedServers) throws GemFireSecurityException {
        Set<ServerLocation> origExcludedServers = excludedServers;
        excludedServers = new HashSet<ServerLocation>(excludedServers);
        Set<ServerLocation> denyListedServers = this.denyList.getBadServers();
        excludedServers.addAll(denyListedServers);
        Connection conn = null;
        ServerRefusedConnectionException fatalException = null;
        boolean tryDenyList = true;
        do {
            ServerLocation server;
            if ((server = this.source.findServer(excludedServers)) == null) {
                if (tryDenyList) {
                    tryDenyList = false;
                    int size = excludedServers.size();
                    excludedServers.removeAll(denyListedServers);
                    excludedServers.addAll(origExcludedServers);
                    if (excludedServers.size() < size) continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Source was unable to locate any servers");
                }
                if (fatalException != null) {
                    throw fatalException;
                }
                return null;
            }
            try {
                conn = this.createClientToServerConnection(server, false);
            }
            catch (CancelException | GatewayConfigurationException | GemFireSecurityException e) {
                throw e;
            }
            catch (ServerRefusedConnectionException srce) {
                fatalException = srce;
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerRefusedConnectionException attempting to connect to {}", (Object)server, (Object)srce);
                }
            }
            catch (Exception e) {
                logger.warn(String.format("Could not connect to: %s", server), (Throwable)e);
            }
            excludedServers.add(server);
        } while (conn == null);
        return conn;
    }

    @Override
    public ClientUpdater createServerToClientConnection(Endpoint endpoint, QueueManager qManager, boolean isPrimary, ClientUpdater failedUpdater) {
        String clientUpdateName = "Cache Client Updater Thread  on " + String.valueOf(endpoint.getMemberId()) + " port " + endpoint.getLocation().getPort();
        if (logger.isDebugEnabled()) {
            logger.debug("Establishing: {}", (Object)clientUpdateName);
        }
        return this.connectionConnector.connectServerToClient(endpoint, qManager, isPrimary, failedUpdater, clientUpdateName);
    }
}

