/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.ToDataException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.client.NoAvailableLocatorsException;
import org.apache.geode.cache.client.NoAvailableServersException;
import org.apache.geode.cache.client.SocketFactory;
import org.apache.geode.cache.client.internal.ConnectionSource;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.cache.client.internal.LocatorDiscoveryCallback;
import org.apache.geode.cache.client.internal.LocatorDiscoveryCallbackAdapter;
import org.apache.geode.cache.client.internal.LocatorList;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.locator.ClientConnectionRequest;
import org.apache.geode.cache.client.internal.locator.ClientConnectionResponse;
import org.apache.geode.cache.client.internal.locator.ClientReplacementRequest;
import org.apache.geode.cache.client.internal.locator.GetAllServersRequest;
import org.apache.geode.cache.client.internal.locator.GetAllServersResponse;
import org.apache.geode.cache.client.internal.locator.LocatorListRequest;
import org.apache.geode.cache.client.internal.locator.LocatorListResponse;
import org.apache.geode.cache.client.internal.locator.QueueConnectionRequest;
import org.apache.geode.cache.client.internal.locator.QueueConnectionResponse;
import org.apache.geode.cache.client.internal.locator.ServerLocationRequest;
import org.apache.geode.cache.client.internal.locator.ServerLocationResponse;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AutoConnectionSourceImpl
implements ConnectionSource {
    private static final Logger logger = LogService.getLogger();
    private final TcpClient tcpClient;
    @Immutable
    private static final LocatorListRequest LOCATOR_LIST_REQUEST = new LocatorListRequest();
    private final List<HostAndPort> initialLocators;
    private final String serverGroup;
    private final AtomicReference<LocatorList> locators = new AtomicReference();
    private final AtomicReference<LocatorList> onlineLocators = new AtomicReference();
    protected InternalPool pool;
    private final int connectionTimeout;
    private long locatorUpdateInterval;
    private volatile LocatorDiscoveryCallback locatorCallback = new LocatorDiscoveryCallbackAdapter();
    private volatile boolean isBalanced = true;
    private final Map<InetSocketAddress, Exception> locatorState = new HashMap<InetSocketAddress, Exception>();

    public AutoConnectionSourceImpl(@NotNull List<HostAndPort> contacts, @NotNull String serverGroup, int handshakeTimeout, @NotNull SocketFactory socketFactory) {
        this(contacts, serverGroup, handshakeTimeout, new TcpClient((TcpSocketCreator)SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.LOCATOR), InternalDataSerializer.getDSFIDSerializer().getObjectSerializer(), InternalDataSerializer.getDSFIDSerializer().getObjectDeserializer(), socketFactory::createSocket));
    }

    AutoConnectionSourceImpl(@NotNull List<HostAndPort> contacts, @NotNull String serverGroup, int handshakeTimeout, @NotNull TcpClient tcpClient) {
        this.locators.set(new LocatorList(new ArrayList<HostAndPort>(contacts)));
        this.onlineLocators.set(new LocatorList(Collections.emptyList()));
        this.initialLocators = Collections.unmodifiableList(this.locators.get().getLocatorAddresses());
        this.connectionTimeout = handshakeTimeout;
        this.serverGroup = serverGroup;
        this.tcpClient = tcpClient;
    }

    @Override
    public boolean isBalanced() {
        return this.isBalanced;
    }

    @Override
    public List<ServerLocation> getAllServers() {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return null;
        }
        GetAllServersRequest request = new GetAllServersRequest(this.serverGroup);
        GetAllServersResponse response = (GetAllServersResponse)this.queryLocators(request);
        if (response != null) {
            return response.getServers();
        }
        return null;
    }

    @Override
    public ServerLocation findReplacementServer(ServerLocation currentServer, Set<ServerLocation> excludedServers) {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return null;
        }
        ClientReplacementRequest request = new ClientReplacementRequest(currentServer, excludedServers, this.serverGroup);
        ClientConnectionResponse response = (ClientConnectionResponse)this.queryLocators(request);
        if (response == null) {
            throw new NoAvailableLocatorsException("Unable to connect to any locators in the list " + String.valueOf(this.locators));
        }
        if (!response.hasResult()) {
            throw new NoAvailableServersException("No servers found");
        }
        return response.getServer();
    }

    @Override
    public ServerLocation findServer(Set<ServerLocation> excludedServers) {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return null;
        }
        ClientConnectionRequest request = new ClientConnectionRequest(excludedServers, this.serverGroup);
        ClientConnectionResponse response = (ClientConnectionResponse)this.queryLocators(request);
        if (response == null) {
            throw new NoAvailableLocatorsException("Unable to connect to any locators in the list " + String.valueOf(this.locators));
        }
        if (!response.hasResult()) {
            throw new NoAvailableServersException("No servers found");
        }
        return response.getServer();
    }

    @Override
    public List<ServerLocation> findServersForQueue(Set<ServerLocation> excludedServers, int numServers, ClientProxyMembershipID proxyId, boolean findDurableQueue) {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return new ArrayList<ServerLocation>();
        }
        QueueConnectionRequest request = new QueueConnectionRequest(proxyId, numServers, excludedServers, this.serverGroup, findDurableQueue);
        QueueConnectionResponse response = (QueueConnectionResponse)this.queryLocators(request);
        if (response == null) {
            throw new NoAvailableLocatorsException("Unable to connect to any locators in the list " + String.valueOf(this.locators));
        }
        if (!response.hasResult()) {
            throw new NoAvailableServersException("No servers found");
        }
        return response.getServers();
    }

    @Override
    public List<InetSocketAddress> getOnlineLocators() {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<InetSocketAddress>(this.onlineLocators.get().getLocators()));
    }

    private ServerLocationResponse queryOneLocator(HostAndPort locator, ServerLocationRequest request) {
        return this.queryOneLocatorUsingConnection(locator, request, this.tcpClient);
    }

    ServerLocationResponse queryOneLocatorUsingConnection(HostAndPort locator, ServerLocationRequest request, TcpClient locatorConnection) {
        Object returnObj = null;
        try {
            this.pool.getStats().incLocatorRequests();
            returnObj = locatorConnection.requestToServer(locator, (Object)request, this.connectionTimeout, true);
            ServerLocationResponse response = (ServerLocationResponse)returnObj;
            this.pool.getStats().incLocatorResponses();
            if (response != null) {
                this.reportLiveLocator(locator.getSocketInetAddress());
            }
            return response;
        }
        catch (IOException | ToDataException ioe) {
            if (ioe instanceof ToDataException) {
                logger.warn("Encountered ToDataException when communicating with a locator.  This is expected if the locator is shutting down.", (Throwable)ioe);
            }
            this.reportDeadLocator(locator.getSocketInetAddress(), ioe);
            return null;
        }
        catch (ClassNotFoundException e) {
            logger.warn("Received exception from locator {}", (Object)locator, (Object)e);
            return null;
        }
        catch (ClassCastException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Received odd response object from the locator: {}", returnObj);
            }
            this.reportDeadLocator(locator.getSocketInetAddress(), e);
            return null;
        }
    }

    ServerLocationResponse queryLocators(ServerLocationRequest request) {
        ServerLocationResponse response = null;
        boolean isDebugEnabled = logger.isDebugEnabled();
        for (HostAndPort locator : this.locators.get()) {
            if (isDebugEnabled) {
                logger.debug("Sending query to locator {}: {}", (Object)locator, (Object)request);
            }
            ServerLocationResponse tempResponse = this.queryOneLocator(locator, request);
            if (isDebugEnabled) {
                logger.debug("Received query response from locator {}: {}", (Object)locator, (Object)tempResponse);
            }
            if (tempResponse == null || !(response = tempResponse).hasResult()) continue;
            break;
        }
        return response;
    }

    private void updateLocatorList(LocatorListResponse response) {
        if (response == null) {
            return;
        }
        this.isBalanced = response.isBalanced();
        List<ServerLocation> locatorResponse = response.getLocators();
        ArrayList<HostAndPort> newLocatorAddresses = new ArrayList<HostAndPort>(locatorResponse.size());
        ArrayList<HostAndPort> newOnlineLocators = new ArrayList<HostAndPort>(locatorResponse.size());
        HashSet<HostAndPort> badLocators = new HashSet<HostAndPort>(this.initialLocators);
        for (ServerLocation locator : locatorResponse) {
            HostAndPort hostAddress = new HostAndPort(locator.getHostName(), locator.getPort());
            newLocatorAddresses.add(hostAddress);
            newOnlineLocators.add(hostAddress);
            badLocators.remove(hostAddress);
        }
        this.addBadLocators(newLocatorAddresses, badLocators);
        LocatorList newLocatorList = new LocatorList(newLocatorAddresses);
        LocatorList oldLocators = this.locators.getAndSet(newLocatorList);
        this.onlineLocators.set(new LocatorList(newOnlineLocators));
        this.pool.getStats().setLocatorCount(newLocatorAddresses.size());
        if (logger.isInfoEnabled() || !this.locatorCallback.getClass().equals(LocatorDiscoveryCallbackAdapter.class)) {
            List<InetSocketAddress> newLocators = newLocatorList.getLocators();
            ArrayList<InetSocketAddress> removedLocators = new ArrayList<InetSocketAddress>(oldLocators.getLocators());
            removedLocators.removeAll(newLocators);
            ArrayList<InetSocketAddress> addedLocators = new ArrayList<InetSocketAddress>(newLocators);
            addedLocators.removeAll(oldLocators.getLocators());
            if (!addedLocators.isEmpty()) {
                this.locatorCallback.locatorsDiscovered(Collections.unmodifiableList(addedLocators));
                logger.info("AutoConnectionSource discovered new locators {}", addedLocators);
            }
            if (!removedLocators.isEmpty()) {
                this.locatorCallback.locatorsRemoved(Collections.unmodifiableList(removedLocators));
                logger.info("AutoConnectionSource dropping previously discovered locators {}", removedLocators);
            }
        }
    }

    protected void addBadLocators(List<HostAndPort> newLocators, Set<HostAndPort> badLocators) {
        for (HostAndPort badLocator : badLocators) {
            boolean addIt = true;
            for (HostAndPort goodLocator : newLocators) {
                boolean isSameHost = badLocator.getHostName().equals(goodLocator.getHostName());
                if (!isSameHost || badLocator.getPort() != goodLocator.getPort()) continue;
                addIt = false;
                break;
            }
            if (!addIt) continue;
            newLocators.add(badLocator);
        }
    }

    @Override
    public void start(InternalPool pool) {
        this.pool = pool;
        pool.getStats().setInitialContacts(this.locators.get().size());
        this.locatorUpdateInterval = Long.getLong("gemfire.LOCATOR_UPDATE_INTERVAL", pool.getPingInterval());
        if (this.locatorUpdateInterval > 0L) {
            pool.getBackgroundProcessor().scheduleWithFixedDelay(new UpdateLocatorListTask(), 0L, this.locatorUpdateInterval, TimeUnit.MILLISECONDS);
            logger.info("AutoConnectionSource UpdateLocatorListTask started with interval={} ms.", (Object)this.locatorUpdateInterval);
        }
    }

    @Override
    public void stop() {
    }

    public void setLocatorDiscoveryCallback(LocatorDiscoveryCallback callback) {
        this.locatorCallback = callback;
    }

    private synchronized void reportLiveLocator(InetSocketAddress l) {
        Object prevState = this.locatorState.put(l, null);
        if (prevState != null) {
            logger.info("Communication has been restored with locator {}.", (Object)l);
        }
    }

    private synchronized void reportDeadLocator(InetSocketAddress l, Exception ex) {
        Exception prevState = this.locatorState.put(l, ex);
        if (prevState == null) {
            if (ex instanceof ConnectException) {
                logger.info("locator {} is not running.", (Object)l, (Object)ex);
            } else {
                logger.info("Communication with locator {} failed", (Object)l, (Object)ex);
            }
        }
    }

    long getLocatorUpdateInterval() {
        return this.locatorUpdateInterval;
    }

    protected class UpdateLocatorListTask
    extends PoolImpl.PoolTask {
        protected UpdateLocatorListTask() {
        }

        @Override
        public void run2() {
            if (AutoConnectionSourceImpl.this.pool.getCancelCriterion().isCancelInProgress()) {
                return;
            }
            LocatorListResponse response = (LocatorListResponse)AutoConnectionSourceImpl.this.queryLocators(LOCATOR_LIST_REQUEST);
            AutoConnectionSourceImpl.this.updateLocatorList(response);
        }
    }
}

