/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.geode.admin.AdminDistributedSystem;
import org.apache.geode.admin.DistributedSystemConfig;
import org.apache.geode.admin.ManagedEntityConfig;
import org.apache.geode.admin.internal.DistributionLocatorImpl;
import org.apache.geode.admin.internal.InternalManagedEntity;
import org.apache.geode.admin.internal.ManagedEntityController;
import org.apache.geode.internal.ProcessOutputReader;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

@Deprecated
class EnabledManagedEntityController
implements ManagedEntityController {
    private static final Logger logger = LogService.getLogger();
    private static final String[] ERROR_OUTPUTS = new String[]{"No such file or directory", "The system cannot find the file specified.", "Access is denied.", "cannot open", "ERROR"};
    private static final String HOST = "{HOST}";
    private static final String CMD = "{CMD}";
    private final AdminDistributedSystem system;

    EnabledManagedEntityController(AdminDistributedSystem system) {
        this.system = system;
    }

    private boolean outputIsError(String output) {
        if (output == null) {
            return false;
        }
        boolean error = false;
        for (String errorOutput : ERROR_OUTPUTS) {
            boolean bl = error = output.indexOf(errorOutput) > -1;
            if (!error) continue;
            return error;
        }
        return error;
    }

    protected String execute(String command, InternalManagedEntity entity) {
        if (command == null || command.length() == 0) {
            throw new IllegalArgumentException("Execution command is empty");
        }
        File workingDir = new File(entity.getEntityConfig().getWorkingDirectory());
        logger.info("Executing remote command: {} in directory {}", (Object)command, (Object)workingDir);
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(command, null, workingDir);
        }
        catch (IOException e) {
            logger.fatal("While executing " + command, (Throwable)e);
            return null;
        }
        ProcessOutputReader pos = new ProcessOutputReader(p);
        int retCode = pos.getExitCode();
        String output = pos.getOutput();
        logger.info("Result of executing {} is {}", (Object)command, (Object)retCode);
        logger.info("Output of {} is {}", (Object)command, (Object)output);
        if (retCode != 0 || this.outputIsError(output)) {
            logger.warn("Remote execution of {} failed.", (Object)command);
            return null;
        }
        return output;
    }

    private boolean endsWithSeparator(String path) {
        return path.endsWith("/") || path.endsWith("\\");
    }

    private String getOSPath(String path) {
        if (this.pathIsWindows(path)) {
            return path.replace('/', '\\');
        }
        return path.replace('\\', '/');
    }

    private boolean pathIsWindows(String path) {
        if (path != null && path.length() > 1) {
            return Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' || path.startsWith("//") || path.startsWith("\\\\");
        }
        return false;
    }

    private String arrangeRemoteCommand(InternalManagedEntity entity, String cmd) {
        String end;
        String start;
        String host = entity.getEntityConfig().getHost();
        if (LocalHostUtil.isLocalHost((Object)host)) {
            return cmd;
        }
        Object prefix = entity.getEntityConfig().getRemoteCommand();
        if (prefix == null || ((String)prefix).length() <= 0) {
            prefix = entity.getDistributedSystem().getRemoteCommand();
        }
        if (prefix == null || ((String)prefix).length() <= 0) {
            throw new IllegalStateException(String.format("A remote command must be specified to operate on a managed entity on host %s", host));
        }
        int hostIdx = ((String)prefix).indexOf(HOST);
        int cmdIdx = ((String)prefix).indexOf(CMD);
        if (hostIdx == -1 && cmdIdx == -1) {
            return (String)prefix + " " + host + " " + cmd;
        }
        if (hostIdx >= 0) {
            start = ((String)prefix).substring(0, hostIdx);
            end = null;
            end = hostIdx + HOST.length() >= ((String)prefix).length() ? "" : ((String)prefix).substring(hostIdx + HOST.length());
            prefix = start + host + end;
            cmdIdx = ((String)prefix).indexOf(CMD);
        }
        if (cmdIdx >= 0) {
            start = ((String)prefix).substring(0, cmdIdx);
            end = null;
            end = cmdIdx + CMD.length() >= ((String)prefix).length() ? "" : ((String)prefix).substring(cmdIdx + CMD.length());
            prefix = start + cmd + end;
        }
        return prefix;
    }

    @Override
    public String getProductExecutable(InternalManagedEntity entity, String executable) {
        String productDirectory = entity.getEntityConfig().getProductDirectory();
        Object path = null;
        File productDir = new File(productDirectory);
        path = productDir.getPath();
        if (!this.endsWithSeparator((String)path)) {
            path = (String)path + File.separator;
        }
        path = (String)path + "bin" + File.separator;
        String bat = "";
        if (this.pathIsWindows((String)path)) {
            bat = ".bat";
        }
        return this.getOSPath((String)path) + executable + bat;
    }

    @Override
    public String buildSSLArguments(DistributedSystemConfig config) {
        Properties sslProps = this.buildSSLProperties(config, true);
        if (sslProps == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : sslProps.keySet()) {
            String key = (String)o;
            String value = sslProps.getProperty(key);
            sb.append(" -J-D" + key + "=" + value);
        }
        return sb.toString();
    }

    private Properties buildSSLProperties(DistributedSystemConfig config, boolean forCommandLine) {
        if (!config.isSSLEnabled()) {
            return null;
        }
        String prefix = "";
        if (forCommandLine) {
            prefix = "gemfire.";
        }
        Properties sslProps = (Properties)config.getSSLProperties().clone();
        sslProps.setProperty(prefix + "mcast-port", "0");
        sslProps.setProperty(prefix + "cluster-ssl-enabled", String.valueOf(config.isSSLEnabled()));
        sslProps.setProperty(prefix + "cluster-ssl-ciphers", config.getSSLCiphers());
        sslProps.setProperty(prefix + "cluster-ssl-protocols", config.getSSLProtocols());
        sslProps.setProperty(prefix + "cluster-ssl-require-authentication", String.valueOf(config.isSSLAuthenticationRequired()));
        return sslProps;
    }

    @Override
    public void start(InternalManagedEntity entity) {
        String command = this.arrangeRemoteCommand(entity, entity.getStartCommand());
        LoggingThread start = new LoggingThread("Start " + entity.getEntityType(), false, () -> this.execute(command, entity));
        start.start();
    }

    @Override
    public void stop(InternalManagedEntity entity) {
        String command = this.arrangeRemoteCommand(entity, entity.getStopCommand());
        LoggingThread stop = new LoggingThread("Stop " + entity.getEntityType(), false, () -> this.execute(command, entity));
        stop.start();
    }

    @Override
    public boolean isRunning(InternalManagedEntity entity) {
        String command = this.arrangeRemoteCommand(entity, entity.getIsRunningCommand());
        String output = this.execute(command, entity);
        if (output == null || output.indexOf("stop") != -1 || output.indexOf("killed") != -1 || output.indexOf("starting") != -1) {
            return false;
        }
        if (output.indexOf("running") != -1) {
            return true;
        }
        throw new IllegalStateException(String.format("Could not determine if managed entity was running: %s", output));
    }

    @Override
    public String getLog(DistributionLocatorImpl locator) {
        String command = this.arrangeRemoteCommand(locator, locator.getLogCommand());
        return this.execute(command, locator);
    }

    private String listDirectory(InternalManagedEntity entity, String dir) {
        ManagedEntityConfig config = entity.getEntityConfig();
        String listFile = this.pathIsWindows(config.getProductDirectory()) ? "dir " : "ls ";
        String command = this.arrangeRemoteCommand(entity, listFile + dir);
        return this.execute(command, entity);
    }
}

