/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authorization.helper;

import com.sas.framework.commons.holders.ClientApplicationNameHolder;
import com.sas.services.ServiceException;
import com.sas.services.security.ApplicationAuthorization;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.authentication.helper.FoundationServicesUserSessionFactory;
import com.sas.svcs.authorization.client.AuthorityType;
import com.sas.svcs.authorization.client.CapabilityResolver;
import com.sas.svcs.authorization.client.TypedGrantedAuthority;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.core.GrantedAuthority;

public class OMRCapabilityResolver
implements RoleHierarchy,
CapabilityResolver {
    private static final Logger logger = LogManager.getLogger(OMRCapabilityResolver.class);
    private FoundationServicesUserSessionFactory userSessionFactory;
    private String prefix = "PRIV_";

    public OMRCapabilityResolver(FoundationServicesUserSessionFactory userSessionFactory) {
        this.userSessionFactory = userSessionFactory;
    }

    public void setPrefix(String privilegePrefix) {
        this.prefix = privilegePrefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Set<GrantedAuthority> getCurrentUserCapabilities() {
        String appName = ClientApplicationNameHolder.getBaseApplicationName();
        if (null == appName) {
            logger.error("No application name found, cannot retrieve metadata capabilities. Is there an application name set in web.xml or passed from the remote invocation?");
            throw new IllegalStateException("No application name found, cannot retrieve metadata capabilities.");
        }
        logger.debug("Found application name '" + appName + "'.");
        UserContextInterface userContext = null;
        try {
            userContext = this.userSessionFactory.getLocalUser();
        }
        catch (Throwable t) {
            logger.warn("Exception encountered getting local user.", t);
        }
        if (null == userContext) {
            logger.warn("No local user found, cannot retrieve metadata capabilities.");
            return Collections.emptySet();
        }
        Set<GrantedAuthority> capabilities = Collections.emptySet();
        try {
            Map actions = userContext.getGrantedApplicationActions(new String[]{appName});
            capabilities = new HashSet<GrantedAuthority>(actions.size());
            for (ApplicationAuthorization authorization : actions.values()) {
                capabilities.add((GrantedAuthority)new TypedGrantedAuthority(this.prefix + authorization.getActionIdentifier(), AuthorityType.PRIVILEGE));
            }
        }
        catch (ServiceException e) {
            logger.warn("Error retrieving granted capabilities from metadata.", (Throwable)e);
        }
        catch (RemoteException e) {
            logger.warn("Error retrieving granted capabilities from metadata.", (Throwable)e);
        }
        return capabilities;
    }

    public Collection<? extends GrantedAuthority> getReachableGrantedAuthorities(Collection<? extends GrantedAuthority> authorities) {
        return this.getCurrentUserCapabilities();
    }
}

