/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authorization.helper;

import com.sas.svcs.authorization.helper.OMRCapabilityResolver;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.web.access.expression.DefaultHttpSecurityExpressionHandler;
import org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler;
import org.springframework.security.web.access.expression.WebExpressionAuthorizationManager;
import org.springframework.security.web.access.expression.WebExpressionVoter;
import org.springframework.security.web.access.intercept.RequestMatcherDelegatingAuthorizationManager;
import org.springframework.security.web.util.matcher.RequestMatcherEntry;

public class CapabilityHelperBean
implements ApplicationContextAware {
    private static final Logger logger = LogManager.getLogger(CapabilityHelperBean.class);
    private static final SimpleGrantedAuthority ANONYMOUS_AUTHORITY = new SimpleGrantedAuthority("ROLE_ANONYMOUS");
    private ApplicationContext context;
    private final OMRCapabilityResolver capabilityResolver;

    public CapabilityHelperBean(OMRCapabilityResolver capabilityResolver) {
        this.capabilityResolver = capabilityResolver;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @PostConstruct
    public void init() {
        this.injectOmrCapabilityResolver();
    }

    private void injectOmrCapabilityResolver() {
        DefaultWebSecurityExpressionHandler expressionHandler = new DefaultWebSecurityExpressionHandler();
        OMRCapabiltyResolverProxy internalCapabilityResolver = new OMRCapabiltyResolverProxy();
        expressionHandler.setRoleHierarchy((RoleHierarchy)internalCapabilityResolver);
        DefaultHttpSecurityExpressionHandler expressionHandler2 = new DefaultHttpSecurityExpressionHandler();
        expressionHandler2.setRoleHierarchy((RoleHierarchy)internalCapabilityResolver);
        int setCountAM = 0;
        for (AuthorizationManager v : this.context.getBeansOfType(AuthorizationManager.class).values()) {
            if (!(v instanceof RequestMatcherDelegatingAuthorizationManager)) continue;
            try {
                RequestMatcherDelegatingAuthorizationManager am = (RequestMatcherDelegatingAuthorizationManager)v;
                Field field = FieldUtils.getField(am.getClass(), (String)"mappings", (boolean)true);
                List mappings = (List)field.get(am);
                for (RequestMatcherEntry m : mappings) {
                    AuthorizationManager e = (AuthorizationManager)m.getEntry();
                    if (!(e instanceof WebExpressionAuthorizationManager)) continue;
                    WebExpressionAuthorizationManager we = (WebExpressionAuthorizationManager)e;
                    we.setExpressionHandler((SecurityExpressionHandler)expressionHandler2);
                    ++setCountAM;
                }
            }
            catch (Exception e) {
                logger.error("Failed to set ", (Throwable)e);
            }
        }
        if (setCountAM != 0) {
            logger.info(String.format("Added OMRCapabilityResolver to %d (NEW) web expression handlers", setCountAM));
        }
        int setCountVoter = 0;
        Map decisionManagers = this.context.getBeansOfType(AffirmativeBased.class);
        for (AffirmativeBased decisionManager : decisionManagers.values()) {
            for (AccessDecisionVoter accessDecisionVoter : decisionManager.getDecisionVoters()) {
                if (!(accessDecisionVoter instanceof WebExpressionVoter)) continue;
                ((WebExpressionVoter)accessDecisionVoter).setExpressionHandler((SecurityExpressionHandler)expressionHandler);
                ++setCountVoter;
            }
        }
        if (setCountVoter != 0) {
            logger.info(String.format("Added OMRCapabilityResolver to %d web expression handlers", setCountVoter));
        }
        if (setCountVoter == 0 && setCountAM == 0) {
            logger.error("No web expression hanlders found to set OMRCapabilityResolver");
        }
    }

    public final class OMRCapabiltyResolverProxy
    implements RoleHierarchy {
        public Collection<? extends GrantedAuthority> getReachableGrantedAuthorities(Collection<? extends GrantedAuthority> authorities) {
            if (authorities.contains(ANONYMOUS_AUTHORITY)) {
                return new ArrayList();
            }
            return CapabilityHelperBean.this.capabilityResolver.getReachableGrantedAuthorities(authorities);
        }
    }
}

