/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.helper;

import com.sas.framework.commons.holders.SessionHolder;
import com.sas.services.ServiceException;
import com.sas.services.connection.PasswordCredential;
import com.sas.services.session.LockingException;
import com.sas.services.session.RemoteSessionContextStateChangedListener;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionContextStateChangedEvent;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import com.sas.svcs.authentication.helper.FixedKeyCredentialCacheManager;
import com.sas.svcs.authentication.helper.FoundationServicesUserSessionFactory;
import com.sas.svcs.authentication.helper.LoginHelper;
import com.sas.svcs.authentication.helper.PasswordRecoveryUtil;
import com.sas.svcs.authentication.helper.PublicUserHelper;
import com.sas.svcs.authentication.helper.TrustedAuthenticationException;
import com.sas.svcs.authentication.helper.TrustedUserFactory;
import com.sas.svcs.authentication.helper.UserContextIdentityInterceptor;
import com.sas.svcs.commons.util.EventingMap;
import com.sas.svcs.commons.util.EventingMapEvent;
import com.sas.svcs.commons.util.EventingMapListener;
import com.sas.svcs.commons.util.EventingMapListenerAdapter;
import com.sas.svcs.config.client.ConfigurationServiceInterface;
import jakarta.annotation.Resource;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.aopalliance.aop.Advice;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class UserSessionFactory
implements FoundationServicesUserSessionFactory,
InitializingBean {
    private static final Logger LOGGER = LogManager.getLogger(UserSessionFactory.class);
    public static final String DEFAULT_SESSION_ID = "sas.svcs.userSessionFactory.defaultSession";
    private static final String applicationName = "USER-SESSION-FACTORY-LOCK";
    private static final String lockObjectKey = "com.sas.svcs.authentication.helper.UserSessionFactory.lockObjectKey";
    ConcurrentMap<Object, ConcurrentMap<String, String>> cache = new ConcurrentHashMap<Object, ConcurrentMap<String, String>>(50);
    ConcurrentMap<String, KeyIdentifierPair> reverseCache = new ConcurrentHashMap<String, KeyIdentifierPair>(50);
    TrustedUserFactory trustedUserFactory;
    SessionServiceInterface localSessionService;
    UserServiceInterface localUserService;
    String domain;
    PasswordRecoveryUtil passwordRecoveryUtil;
    Map<String, String> identityCache;
    ConfigurationServiceInterface configService;
    String[] proxiedUserContextMethods = new String[]{"getIdentityByDomain", "getIdentities", "getIdentitiesByDomain", "requestCredentialList", "requestCredentials"};
    String[] proxiedUserContextGetSessionMethods = new String[]{"getSessionContext"};
    String[] proxiedSessionContextGetUserMethods = new String[]{"getUserContext"};
    EventingMap<Object, Object> serviceTicketMap;
    EventingMapListener<Object, Object> mapListener = new MapListener();
    RemoteSessionContextStateChangedListener sessionListener = new SessionListener();

    @Resource(name="sas.svcs.serviceTicketMap")
    public void setServiceTicketMap(EventingMap<Object, Object> serviceTicketMap) {
        this.serviceTicketMap = serviceTicketMap;
    }

    @Autowired
    public void setTrustedUserFactory(TrustedUserFactory trustedUserFactory) {
        this.trustedUserFactory = trustedUserFactory;
    }

    @Autowired
    public void setLocalSessionService(SessionServiceInterface localSessionService) {
        this.localSessionService = localSessionService;
    }

    @Autowired(required=false)
    public void setLocalUserService(UserServiceInterface localUserService) {
        this.localUserService = localUserService;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Autowired(required=false)
    public void setPasswordRecoveryUtil(PasswordRecoveryUtil passwordRecoveryUtil) {
        this.passwordRecoveryUtil = passwordRecoveryUtil;
    }

    public void setIdentityCache(Map<String, String> identityCache) {
        this.identityCache = identityCache;
    }

    @Autowired(required=false)
    public void setConfigService(ConfigurationServiceInterface configService) {
        this.configService = configService;
    }

    public void setProxiedUserContextMethodNames(String[] names) {
        this.proxiedUserContextMethods = names;
    }

    public void setProxiedUserContextGetSessionMethodNames(String[] names) {
        this.proxiedUserContextGetSessionMethods = names;
    }

    public void setProxiedSessionContextGetUserMethodNames(String[] names) {
        this.proxiedSessionContextGetUserMethods = names;
    }

    public void setMapListener(EventingMapListener<Object, Object> mapListener) {
        this.mapListener = mapListener;
    }

    UserContextInterface attachProxy(UserContextInterface userContext) throws ServiceException, RemoteException {
        String session = SessionHolder.get();
        if (null == session) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Could not attach identity proxy because there was no session in the session holder");
            }
            return userContext;
        }
        if (null == this.identityCache) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No identity cache to attach to user context");
            }
            return userContext;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Attempting to proxy user context for session " + session);
        }
        FixedKeyCredentialCacheManager cacheManager = new FixedKeyCredentialCacheManager(this.identityCache, session);
        UserContextIdentityInterceptor identityAdvice = new UserContextIdentityInterceptor(cacheManager, userContext);
        ProxyFactory pf = new ProxyFactory((Object)userContext);
        NameMatchMethodPointcutAdvisor advisor = new NameMatchMethodPointcutAdvisor((Advice)identityAdvice);
        advisor.setMappedNames(this.proxiedUserContextMethods);
        pf.addAdvisor((Advisor)advisor);
        pf.setFrozen(true);
        return (UserContextInterface)pf.getProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionContextInterface getLocalSession(SecurityContext securityContext, String identifier) {
        this.localSessionService.getClass();
        Authentication authentication = securityContext.getAuthentication();
        Object key = authentication.getCredentials();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getLocalSession: key=" + key);
        }
        try {
            Object object = key;
            synchronized (object) {
                SessionContextInterface localSession = this.getLocalSessionFromCache(key, identifier);
                if (localSession == null && !this.saveLocalSessionInCache(localSession = this.createLocalSession(securityContext), key, identifier)) {
                    this.destroyLocalSession(localSession);
                    return this.getLocalSession(securityContext, identifier);
                }
                return localSession;
            }
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to find local session...", e);
        }
    }

    @Override
    public SessionContextInterface getLocalSession(SecurityContext securityContext) {
        return this.getLocalSession(securityContext, null);
    }

    @Override
    public SessionContextInterface getLocalSession() {
        return this.getLocalSession((String)null);
    }

    @Override
    public SessionContextInterface getLocalSession(String identifier) {
        SecurityContext external = SecurityContextHolder.getContext();
        if (null == external || null == external.getAuthentication()) {
            throw new IllegalStateException("SecurityContextHolder is not populated. There must be a SecurityContext in order to create a derivative session/user.");
        }
        return this.getLocalSession(external, identifier);
    }

    @Override
    public UserContextInterface getLocalUser() {
        return this.getLocalUser((String)null);
    }

    @Override
    public UserContextInterface getLocalUser(String identifier) {
        try {
            return this.getLocalSession(identifier).getUserContext();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to find local user...", e);
        }
    }

    @Override
    public UserContextInterface getLocalUser(SecurityContext securityContext) {
        return this.getLocalUser(securityContext, null);
    }

    @Override
    public UserContextInterface getLocalUser(SecurityContext securityContext, String identifier) {
        try {
            return this.getLocalSession(securityContext, identifier).getUserContext();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to find local user...", e);
        }
    }

    @Override
    public void releaseLocalSession(SessionContextInterface localSession) {
    }

    @Override
    public void releaseLocalSessionForUser(UserContextInterface localUser) {
    }

    private ConcurrentMap<String, String> getSessions(Object key) {
        ConcurrentMap oldSessions;
        ConcurrentMap sessions = (ConcurrentHashMap)this.cache.get(key);
        if (null == sessions && null != (oldSessions = (ConcurrentMap)this.cache.putIfAbsent(key, sessions = new ConcurrentHashMap()))) {
            sessions = oldSessions;
        }
        return sessions;
    }

    private SessionContextInterface getLocalSessionFromCache(Object key, String identifier) throws RemoteException {
        String id;
        ConcurrentMap<String, String> sessionMap = this.getSessions(key);
        String entityKey = (String)sessionMap.get(id = identifier != null ? identifier : DEFAULT_SESSION_ID);
        if (entityKey == null) {
            return null;
        }
        SessionContextInterface localSession = this.localSessionService.getSessionContext(entityKey);
        if (localSession == null || localSession.isDestroyPending()) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            KeyIdentifierPair pair = new KeyIdentifierPair(key, id);
            LOGGER.debug("Got session context " + entityKey + " from cache for " + pair);
        }
        return localSession;
    }

    private SessionContextInterface createLocalSession(SecurityContext securityContext) throws RemoteException, ServiceException, TrustedAuthenticationException {
        return this.createLocalSession(securityContext, applicationName, lockObjectKey);
    }

    public SessionContextInterface createLocalSession(SecurityContext securityContext, String applicationName, String lockObjectKey) throws RemoteException, ServiceException, TrustedAuthenticationException {
        Authentication authentication = securityContext.getAuthentication();
        if (LOGGER.isDebugEnabled()) {
            Object key = authentication.getCredentials();
            LOGGER.debug("Creating new SessionContext for: " + key);
        }
        String userid = LoginHelper.getLoginForAuthentication(authentication);
        PasswordCredential cred = this.passwordRecoveryUtil != null ? this.passwordRecoveryUtil.recoverUserNameAndPassword(securityContext) : null;
        UserContextInterface localUser = null;
        try {
            localUser = cred != null && this.localUserService != null && this.domain != null ? this.localUserService.newUser(cred.getUserName(), cred.getPassword(), this.domain) : this.trustedUserFactory.create(userid);
        }
        catch (UserInitializationException e) {
            localUser = PublicUserHelper.handlePublicUser(e, this.configService, this.domain);
        }
        localUser = this.attachProxy(localUser);
        SessionContextInterface localSessionContext = this.localSessionService.newSessionContext(localUser);
        Object lockObject = localSessionContext.lock(applicationName);
        localSessionContext.setAttribute(lockObjectKey, lockObject);
        if (LOGGER.isDebugEnabled()) {
            String entityKey = localSessionContext.getEntityKey();
            LOGGER.debug("Added lock " + lockObject + " to session context " + entityKey);
        }
        return localSessionContext;
    }

    private boolean saveLocalSessionInCache(SessionContextInterface localSession, Object key, String identifier) throws RemoteException {
        ConcurrentMap<String, String> sessionMap = this.getSessions(key);
        String id = identifier != null ? identifier : DEFAULT_SESSION_ID;
        KeyIdentifierPair pair = new KeyIdentifierPair(key, id);
        String entityKey = localSession.getEntityKey();
        String oldEntityKey = sessionMap.putIfAbsent(id, entityKey);
        if (oldEntityKey != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cache already has session context  for " + pair + " with value " + oldEntityKey);
            }
            return false;
        }
        this.reverseCache.put(entityKey, pair);
        String randomKey = UUID.randomUUID().toString();
        localSession.setAttribute(randomKey, (Object)this.sessionListener);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Added session context " + entityKey + " to cache for " + pair);
        }
        return true;
    }

    private void removeLocalSessionFromCache(SessionContextInterface localSession) throws RemoteException {
        Object key;
        ConcurrentMap sessionMap;
        String entityKey = localSession.getEntityKey();
        KeyIdentifierPair pair = (KeyIdentifierPair)this.reverseCache.remove(entityKey);
        if (pair != null && (sessionMap = (ConcurrentMap)this.cache.get(key = pair.getKey())) != null) {
            String identifier = pair.getIdentifier();
            sessionMap.remove(identifier);
        }
    }

    private void destroyLocalSession(SessionContextInterface localSession) throws RemoteException {
        UserSessionFactory.destroyLocalSession(localSession, lockObjectKey);
    }

    public static void destroyLocalSession(SessionContextInterface localSession, String lockObjectKey) throws RemoteException {
        block13: {
            String entityKey;
            block12: {
                entityKey = localSession.getEntityKey();
                Object lockObject = null;
                try {
                    lockObject = localSession.getAttribute(lockObjectKey);
                    if (lockObject != null) {
                        localSession.removeAttribute(lockObjectKey);
                        localSession.unlock(lockObject);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Removed lock " + lockObject + " from session context " + entityKey);
                        }
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Session context " + entityKey + " has already been unlocked");
                    }
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn("Unrecognized lock object " + lockObject + " for session context " + entityKey, (Throwable)iae);
                }
                catch (IllegalStateException ise) {
                    if (!LOGGER.isDebugEnabled()) break block12;
                    LOGGER.debug("Cannot unlock SessionContext " + entityKey + " because it has already been destroyed.");
                }
            }
            try {
                localSession.destroy();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Destroyed local session " + entityKey);
                }
            }
            catch (LockingException le) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Cannot destroy SessionContext " + entityKey + " because it is still locked by another application.");
                }
            }
            catch (IllegalStateException ise) {
                if (!LOGGER.isDebugEnabled()) break block13;
                LOGGER.debug("Cannot destroy SessionContext " + entityKey + " because it has already been destroyed.");
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding MapListener: " + this.mapListener);
        }
        this.serviceTicketMap.addListener(this.mapListener);
    }

    public void removeTicket(String ticket) {
        ConcurrentMap sessions = (ConcurrentMap)this.cache.remove(ticket);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entryRemoved: ticket=" + ticket + ", sessions=" + sessions);
        }
        if (sessions != null) {
            for (String entityKey : sessions.values()) {
                try {
                    SessionContextInterface localSessionContext = this.localSessionService.getSessionContext(entityKey);
                    if (null == localSessionContext || localSessionContext.isDestroyPending()) continue;
                    this.destroyLocalSession(localSessionContext);
                }
                catch (Throwable t) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Exception attempting to destroy session: " + entityKey, t);
                        continue;
                    }
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("Exception attempting to destroy session: " + entityKey);
                }
            }
        }
    }

    private class MapListener
    extends EventingMapListenerAdapter<Object, Object> {
        private MapListener() {
        }

        public void entryRemoved(EventingMapEvent<Object, Object> event) {
            UserSessionFactory.this.removeTicket((String)event.getKey());
        }
    }

    private class SessionListener
    implements RemoteSessionContextStateChangedListener {
        private SessionListener() {
        }

        public void contextStateChanged(SessionContextStateChangedEvent event) throws RemoteException {
            SessionContextInterface localSessionContext;
            if (2 == event.getStateChange() && (localSessionContext = event.getSessionContext()) != null) {
                UserSessionFactory.this.removeLocalSessionFromCache(localSessionContext);
            }
        }
    }

    private static final class KeyIdentifierPair {
        private Object _key;
        private String _identifier;

        private KeyIdentifierPair(Object key, String identifier) {
            this._key = key;
            this._identifier = identifier;
        }

        public String toString() {
            return "key=" + this._key + ",identifier=" + this._identifier;
        }

        private Object getKey() {
            return this._key;
        }

        private String getIdentifier() {
            return this._identifier;
        }
    }
}

