/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.helper;

import com.sas.services.InitializationException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceInterface;
import java.rmi.RemoteException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class UserContextByNameFactoryBean
implements FactoryBean<UserContextInterface>,
InitializingBean,
DisposableBean {
    private static final Logger logger = LogManager.getLogger(UserContextByNameFactoryBean.class);
    private UserServiceInterface userService;
    private SessionServiceInterface sessionService;
    private UserContextInterface securedUser;
    private String name;
    private UserContextInterface theUser;
    private Object lock;

    public void setUserService(UserServiceInterface userService) {
        this.userService = userService;
    }

    public void setSessionService(SessionServiceInterface sessionService) {
        this.sessionService = sessionService;
    }

    public void setSecuredUser(UserContextInterface securedUser) {
        this.securedUser = securedUser;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UserContextInterface getObject() throws Exception {
        return this.theUser;
    }

    public Class<UserContextInterface> getObjectType() {
        return UserContextInterface.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.theUser = this.userService.getUser(this.securedUser, this.name);
            if (null == this.theUser) {
                throw new IllegalStateException("Unable to retrieve requested user, " + this.name + ". Is one defined in the remote UserService with the required name?");
            }
            SessionContextInterface session = this.theUser.getSessionContext();
            if (null == session) {
                if (null != this.sessionService) {
                    session = this.sessionService.newSessionContext(this.theUser);
                    session.setTimeoutDisabled(true);
                } else {
                    logger.warn("Unable to create SessionContext for the requested user because the SessionServiceInterface instance was not provided.");
                }
            }
            if (null != session) {
                this.lock = session.lock("UserContextByNameFactory_Lock");
            }
        }
        catch (RemoteException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Error retrieving user: " + this.name);
        }
        catch (InitializationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Error retrieve user: " + this.name + ". Unable to create session context.");
        }
    }

    public void destroy() throws Exception {
        SessionContextInterface session = this.theUser.getSessionContext();
        if (null != session) {
            session.unlock(this.lock);
        }
    }
}

