/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.helper;

import com.sas.services.ServiceException;
import com.sas.services.session.SessionContextInterface;
import com.sas.svcs.authentication.client.AuthenticationException;
import com.sas.svcs.authentication.client.SecurityContext;
import com.sas.svcs.authentication.client.SecurityContextHolder;
import com.sas.svcs.authentication.helper.SecurityContextFactory;
import java.rmi.RemoteException;

public class SecurityContextHelper {
    public static synchronized void clearSecurityContext() {
        SecurityContextHolder.clear();
    }

    public static synchronized void setSecurityContext(SessionContextInterface context) throws AuthenticationException, ServiceException, RemoteException {
        SecurityContext secContext = SecurityContextHolder.get();
        if (secContext == null || !secContext.getKey().equals(context.getEntityKey())) {
            SecurityContextHelper.resetSecurityContext(context);
        }
    }

    private static void resetSecurityContext(SessionContextInterface sessionContext) throws AuthenticationException, ServiceException, RemoteException {
        SecurityContextHelper.clearSecurityContext();
        SecurityContext sc = SecurityContextFactory.newSecurityContext(sessionContext);
        SecurityContextHolder.set((SecurityContext)sc);
    }

    static {
        SecurityContextHolder.setStrategyName((String)"MODE_GLOBAL");
    }
}

