/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFFlowSource;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFXMLSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class JFXMLStringSource
implements JFFlowSource {
    private Document m_document = null;
    private Exception m_exception = null;

    JFXMLStringSource(String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            documentBuilder.setEntityResolver(new ResolveDTD());
            InputSource inputSource = new InputSource(stringReader);
            inputSource.setSystemId("com.platform.LSFJobFlow.api");
            this.m_document = documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            this.m_document = null;
            this.m_exception = sAXException;
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.m_document = null;
            this.m_exception = parserConfigurationException;
            return;
        }
    }

    @Override
    public JFFlow createFlow() throws JFException {
        if (this.m_document == null) {
            throw new JFException(JFResource.getString("DEFN_FILE_DEFN_DOC") + ": " + this.m_exception.getMessage());
        }
        Element element = this.m_document.getDocumentElement();
        JFXMLSource jFXMLSource = new JFXMLSource(element);
        return jFXMLSource.createFlow();
    }

    JFJob createJob() throws JFException {
        if (this.m_document == null) {
            throw new JFException(JFResource.getString("DEFN_FILE_DEFN_DOC") + ": " + this.m_exception.getMessage());
        }
        return new JFXMLSource(null).getJob(this.m_document.getDocumentElement());
    }

    class ResolveDTD
    implements EntityResolver {
        ResolveDTD() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            if (string2.endsWith("JobFlowDef30.dtd")) {
                InputStream inputStream = this.getClass().getResourceAsStream("JobFlowDef30.dtd");
                return new InputSource(inputStream);
            }
            return null;
        }
    }
}

