/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFTokenTypes;
import java.text.Format;
import java.text.MessageFormat;

public class JFVariableExpression
implements JFTokenTypes {
    private String m_expr = "";
    private int offset;
    private int leftParenthesisNum;
    private static final String ERROR_HEADER = JFResource.getString("Invalid_variable_expression_") + "\n";
    private token[] tokenArray = new token[]{new token("&&", 2, 1), new token("||", 2, 2), new token(">=", 2, 10), new token("<=", 2, 12), new token("!=", 2, 14), new token("!", 1, 3), new token("(", 1, 4), new token(")", 1, 5), new token("#", 1, 6), new token("{", 1, 7), new token("}", 1, 8), new token(">", 1, 9), new token("<", 1, 11), new token("=", 1, 13), new token(null, 0, -1)};

    public JFVariableExpression(String string) {
        this.setExpression(string);
    }

    public String getExpression() {
        return this.m_expr;
    }

    public void setExpression(String string) {
        this.m_expr = string;
    }

    public void validate() throws JFException {
        int n;
        int n2 = -1;
        this.offset = 0;
        this.leftParenthesisNum = 0;
        JFDebug.println(this.m_expr);
        String string = this.m_expr.trim();
        if ("".equals(string)) {
            throw new JFException(ERROR_HEADER + JFResource.getString("Variable_expression_empty"));
        }
        while ((n = this.getToken(string)) != -1) {
            block1 : switch (n) {
                case 6: {
                    Object object;
                    Object object2;
                    Object object3;
                    JFDebug.println("TOKEN_SHARP");
                    if (n2 != 1 && n2 != 2 && n2 != -1 && n2 != 4) {
                        object3 = new Object[]{String.valueOf(this.offset)};
                        object2 = JFResource.getString("Variable_expression_syntax_error");
                        object = new MessageFormat((String)object2);
                        throw new JFException(ERROR_HEADER + ((Format)object).format(object3));
                    }
                    int n3 = this.getToken(string);
                    if (n3 != 7) {
                        object3 = new Object[]{"{", String.valueOf(this.offset)};
                        object2 = JFResource.getString("Variable_expression_expect_character");
                        object = new MessageFormat((String)object2);
                        throw new JFException(ERROR_HEADER + ((Format)object).format(object3));
                    }
                    n3 = this.getToken(string);
                    if (n3 != 15) {
                        object3 = new Object[]{String.valueOf(this.offset)};
                        object2 = JFResource.getString("Variable_expression_variable_name");
                        object = new MessageFormat((String)object2);
                        throw new JFException(ERROR_HEADER + ((Format)object).format(object3));
                    }
                    int n4 = string.indexOf("}", this.offset);
                    if (n4 == -1) {
                        object3 = new Object[]{"}", String.valueOf(this.offset)};
                        object2 = JFResource.getString("Variable_expression_expect_character");
                        object = new MessageFormat((String)object2);
                        throw new JFException(ERROR_HEADER + ((Format)object).format(object3));
                    }
                    object3 = string.substring(this.offset, n4);
                    this.offset = n4 + 1;
                    if (!JFCommon.isValidVarName((String)object3)) {
                        throw new JFException(ERROR_HEADER + JFResource.getString("Variable_expression_invalid_variable_name"));
                    }
                    n3 = this.getToken(string);
                    switch (n3) {
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: {
                            int n5 = this.getToken(string);
                            if (n5 != 15) {
                                object2 = new Object[]{String.valueOf(this.offset)};
                                object = JFResource.getString("Variable_expression_expect_number_string");
                                MessageFormat messageFormat = new MessageFormat((String)object);
                                throw new JFException(ERROR_HEADER + messageFormat.format(object2));
                            }
                            if (string.regionMatches(this.offset, "\"", 0, 1)) {
                                ++this.offset;
                                n4 = string.indexOf("\"", this.offset);
                                if (n4 == -1) {
                                    object2 = new Object[]{"\"", String.valueOf(this.offset)};
                                    object = JFResource.getString("Variable_expression_expect_character");
                                    MessageFormat messageFormat = new MessageFormat((String)object);
                                    throw new JFException(ERROR_HEADER + messageFormat.format(object2));
                                }
                                this.offset = n4 + 1;
                                if (n3 != 13 && n3 != 14) {
                                    throw new JFException(ERROR_HEADER + JFResource.getString("Variable_expression_error_compare_string"));
                                }
                            } else {
                                int n6 = this.offset;
                                while (this.offset <= string.length()) {
                                    n5 = this.getToken(string);
                                    if (n5 != 15) {
                                        this.roolbackOffset(n5);
                                        break;
                                    }
                                    ++this.offset;
                                }
                                object = string.substring(n6, this.offset).trim();
                                boolean bl = true;
                                try {
                                    object2 = Float.valueOf((String)object);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    bl = false;
                                }
                                if (!bl && n3 != 13 && n3 != 14) {
                                    Object[] objectArray = new Object[]{String.valueOf(this.offset)};
                                    String string2 = JFResource.getString("Variable_expression_error_compare_string");
                                    MessageFormat messageFormat = new MessageFormat(string2);
                                    throw new JFException(ERROR_HEADER + messageFormat.format(objectArray));
                                }
                            }
                            n2 = 15;
                            break block1;
                        }
                    }
                    object2 = new Object[]{String.valueOf(this.offset)};
                    object = JFResource.getString("Variable_expression_expect_operator");
                    MessageFormat messageFormat = new MessageFormat((String)object);
                    throw new JFException(ERROR_HEADER + messageFormat.format(object2));
                }
                case 1: {
                    Object object;
                    Object object2;
                    JFDebug.println("TOKEN_AND");
                    if (n2 != 15 && n2 != 5) {
                        object2 = new Object[]{String.valueOf(this.offset)};
                        object = JFResource.getString("Variable_expression_syntax_error");
                        MessageFormat messageFormat = new MessageFormat((String)object);
                        throw new JFException(ERROR_HEADER + messageFormat.format(object2));
                    }
                    int n3 = this.getToken(string);
                    if (n3 == -1) {
                        object2 = new Object[]{String.valueOf(this.offset)};
                        object = JFResource.getString("Variable_expression_syntax_error");
                        MessageFormat messageFormat = new MessageFormat((String)object);
                        throw new JFException(ERROR_HEADER + messageFormat.format(object2));
                    }
                    this.roolbackOffset(n3);
                    n2 = 1;
                    break;
                }
                case 2: {
                    Object object;
                    Object object2;
                    JFDebug.println("TOKEN_OR");
                    if (n2 != 15 && n2 != 5) {
                        object2 = new Object[]{String.valueOf(this.offset)};
                        object = JFResource.getString("Variable_expression_syntax_error");
                        MessageFormat messageFormat = new MessageFormat((String)object);
                        throw new JFException(ERROR_HEADER + messageFormat.format(object2));
                    }
                    int n3 = this.getToken(string);
                    if (n3 == -1) {
                        object2 = new Object[]{String.valueOf(this.offset)};
                        object = JFResource.getString("Variable_expression_syntax_error");
                        MessageFormat messageFormat = new MessageFormat((String)object);
                        throw new JFException(ERROR_HEADER + messageFormat.format(object2));
                    }
                    this.roolbackOffset(n3);
                    n2 = 2;
                    break;
                }
                case 4: {
                    Object object;
                    Object object2;
                    JFDebug.println("TOKEN_LEFT_PARENTHESIS");
                    if (n2 != 3 && n2 != 1 && n2 != 2 && n2 != 4 && n2 != -1) {
                        object2 = new Object[]{String.valueOf(this.offset)};
                        object = JFResource.getString("Variable_expression_syntax_error");
                        MessageFormat messageFormat = new MessageFormat((String)object);
                        throw new JFException(ERROR_HEADER + messageFormat.format(object2));
                    }
                    n2 = 4;
                    ++this.leftParenthesisNum;
                    break;
                }
                case 5: {
                    Object object;
                    Object object2;
                    JFDebug.println("TOKEN_RIGHT_PARENTHESIS");
                    if (n2 != 15 && n2 != 5) {
                        object2 = new Object[]{String.valueOf(this.offset)};
                        object = JFResource.getString("Variable_expression_syntax_error");
                        MessageFormat messageFormat = new MessageFormat((String)object);
                        throw new JFException(ERROR_HEADER + messageFormat.format(object2));
                    }
                    n2 = 5;
                    --this.leftParenthesisNum;
                    break;
                }
                case 3: {
                    Object object;
                    Object object2;
                    JFDebug.println("TOKEN_NOT");
                    if (n2 != 1 && n2 != 2 && n2 != -1) {
                        object2 = new Object[]{String.valueOf(this.offset)};
                        object = JFResource.getString("Variable_expression_syntax_error");
                        MessageFormat messageFormat = new MessageFormat((String)object);
                        throw new JFException(ERROR_HEADER + messageFormat.format(object2));
                    }
                    int n3 = this.getToken(string);
                    if (n3 != 4) {
                        object2 = new Object[]{"(", String.valueOf(this.offset)};
                        object = JFResource.getString("Variable_expression_expect_character");
                        MessageFormat messageFormat = new MessageFormat((String)object);
                        throw new JFException(ERROR_HEADER + messageFormat.format(object2));
                    }
                    --this.offset;
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    Object object2 = new Object[]{String.valueOf(this.offset)};
                    Object object = JFResource.getString("Variable_expression_syntax_error");
                    MessageFormat messageFormat = new MessageFormat((String)object);
                    throw new JFException(ERROR_HEADER + messageFormat.format(object2));
                }
                default: {
                    Object[] objectArray = new Object[]{String.valueOf(this.offset)};
                    String string3 = JFResource.getString("Variable_expression_unexpected_token");
                    MessageFormat messageFormat = new MessageFormat(string3);
                    throw new JFException(ERROR_HEADER + messageFormat.format(objectArray));
                }
            }
        }
        if (this.leftParenthesisNum != 0) {
            throw new JFException(ERROR_HEADER + JFResource.getString("Variable_expression_unmatched_parenthesis"));
        }
    }

    private int getToken(String string) {
        while (string.regionMatches(this.offset, " ", 0, 1)) {
            ++this.offset;
        }
        int n = 0;
        while (this.tokenArray[n].name != null) {
            if (string.regionMatches(this.offset, this.tokenArray[n].name, 0, this.tokenArray[n].namelen)) {
                this.offset += this.tokenArray[n].namelen;
                return this.tokenArray[n].type;
            }
            ++n;
        }
        if (this.offset < string.length()) {
            return 15;
        }
        return -1;
    }

    private void roolbackOffset(int n) {
        if (n != 15 && n != -1) {
            this.offset = n == 1 || n == 2 || n == 10 || n == 12 || n == 14 ? (this.offset -= 2) : --this.offset;
        }
    }

    static void main(String[] stringArray) {
        String string = "test JFVariableExpressionValidator";
        JFDebug.println(string);
        String string2 = "!(#{A}=abcdefg && (#{B} > 10 || #{C} <9.99))";
        JFVariableExpression jFVariableExpression = new JFVariableExpression(string2);
        try {
            jFVariableExpression.validate();
        }
        catch (JFException jFException) {
            JFDebug.println(jFException.getMessage());
        }
        String string3 = "!(#{A}=abcdefg && !(#{B} > 10 || #{C} <9.99))";
        JFVariableExpression jFVariableExpression2 = new JFVariableExpression(string3);
        try {
            jFVariableExpression2.validate();
        }
        catch (JFException jFException) {
            JFDebug.println(jFException.getMessage());
        }
        String string4 = "!(#{A}=abcdefg && #{B} > 10 || #{C} <9.99)";
        JFVariableExpression jFVariableExpression3 = new JFVariableExpression(string4);
        try {
            jFVariableExpression3.validate();
        }
        catch (JFException jFException) {
            JFDebug.println(jFException.getMessage());
        }
        String string5 = "#{A}=abcdefg && #{B} ( > 10 || #{C} <9.99)";
        JFVariableExpression jFVariableExpression4 = new JFVariableExpression(string5);
        try {
            jFVariableExpression4.validate();
        }
        catch (JFException jFException) {
            JFDebug.println(jFException.getMessage());
        }
    }

    class token {
        public String name;
        public int namelen;
        public int type;

        token(String string, int n, int n2) {
            this.name = string;
            this.namelen = n;
            this.type = n2;
        }
    }
}

