/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFCharBuffer;
import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFConfigManager;

public class JFUTFConverter {
    public static String toUnicodeEscape(String string) {
        if (string == null) {
            return null;
        }
        if (JFConfigManager.getConfig("JS_UNICODE_ESCAPE_CONVERT", "true").equalsIgnoreCase("false")) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u007f') {
                String string2 = Integer.toHexString(c);
                int n = string2.length();
                if (n == 2) {
                    string2 = "00" + string2;
                } else if (n == 3) {
                    string2 = "0" + string2;
                }
                stringBuffer.append("\\u" + string2);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String fromUnicodeEscape(String string) {
        if (null == string) {
            return null;
        }
        if (JFConfigManager.getConfig("JS_UNICODE_ESCAPE_CONVERT", "true").equalsIgnoreCase("false")) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (i + 5 < n && (string.substring(i, i + 2).equals("\\u") || string.substring(i, i + 2).equals("U+")) && JFUTFConverter.isHexChar(string.charAt(i + 2)) && JFUTFConverter.isHexChar(string.charAt(i + 3)) && JFUTFConverter.isHexChar(string.charAt(i + 4)) && JFUTFConverter.isHexChar(string.charAt(i + 5))) {
                String string2 = string.substring(i + 2, i + 6);
                int n2 = Integer.parseInt(string2, 16);
                stringBuffer.append((char)n2);
                i += 5;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static char[] fromUnicodeEscape(char[] cArray, int n) {
        if (JFConfigManager.getConfig("JS_UNICODE_ESCAPE_CONVERT", "true").equalsIgnoreCase("false")) {
            return cArray;
        }
        JFCharBuffer jFCharBuffer = new JFCharBuffer(n);
        for (int i = 0; i < n; ++i) {
            if (i + 5 < n && (cArray[i] == '\\' && cArray[i + 1] == 'u' || cArray[i] == 'U' && cArray[i + 1] == '+') && JFUTFConverter.isHexChar(cArray[i + 2]) && JFUTFConverter.isHexChar(cArray[i + 3]) && JFUTFConverter.isHexChar(cArray[i + 4]) && JFUTFConverter.isHexChar(cArray[i + 5])) {
                jFCharBuffer.append((char)Integer.parseInt(String.valueOf(cArray, i + 2, 4), 16));
                i += 5;
                continue;
            }
            jFCharBuffer.append(cArray[i]);
        }
        return jFCharBuffer.array();
    }

    private static boolean isHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static boolean hasUnicode(String string) {
        return JFCommon.containNonASCIIChar(string);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray == null || stringArray.length < 1) {
            System.out.println("Error: Provide argument of a string in unicode escape sequence.");
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = JFUTFConverter.fromUnicodeEscape(stringArray[i]);
            if (string.indexOf(" ") > 0 && !string.startsWith("\"")) {
                string = "\"" + string + "\"";
            }
            System.out.print(string + " ");
        }
    }
}

