/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFEncryptionINF;
import com.platform.LSFJobFlow.api.JFEncryptor;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFInvalidTemplateException;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFTemplateParameterDef;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JFTemplateParameter
implements Cloneable {
    private boolean m_immutable = false;
    private String m_name;
    private String m_caption;
    private String[] m_input;
    private JFTemplateParameterDef m_def;
    private JFEncryptionINF m_encryption;
    private static final byte[] key = new byte[]{112, 8, 8, 113, 16, 8, -110, 18};

    JFTemplateParameter(Element element) throws JFInvalidTemplateException {
        NodeList nodeList;
        if (element == null) {
            throw new NullPointerException("<param> element is null!");
        }
        if (!element.hasAttribute("Name")) {
            throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_INVALID_CONTENT") + ": " + JFResource.getString("TEMPLATE_PARAM_NAME_NULL"));
        }
        this.m_name = element.getAttribute("Name");
        if (element.hasAttribute("Caption")) {
            this.m_caption = element.getAttribute("Caption");
            if (this.m_caption.trim().equals("")) {
                this.m_caption = null;
            }
        }
        if ((nodeList = element.getElementsByTagName("Repeat")) != null && nodeList.getLength() > 0) {
            this.m_input = new String[nodeList.getLength()];
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                if (!((Element)nodeList.item(i)).hasAttribute("Input")) {
                    throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_INVALID_CONTENT") + ": " + JFResource.getString("TEMPLATE_REPEATABLE_INPUT_NULL"));
                }
                this.m_input[i] = ((Element)nodeList.item(i)).getAttribute("Input");
            }
        } else if (element.hasAttribute("Input")) {
            this.m_input = new String[1];
            this.m_input[0] = element.getAttribute("Input");
        } else {
            throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_INVALID_CONTENT") + ": " + JFResource.getString("TEMPLATE_PARAM_INPUT_NULL"));
        }
    }

    public JFTemplateParameter(String string, String string2, String[] stringArray) {
        this.m_name = string;
        if (this.m_name == null) {
            throw new NullPointerException("Parameter <Name> is null!");
        }
        this.m_caption = string2;
        this.m_input = stringArray;
    }

    public JFTemplateParameter(String string, String string2, String string3) {
        this(string, string2, new String[1]);
        String[] stringArray = new String[]{string3};
        this.m_input = stringArray;
    }

    public JFTemplateParameter() {
    }

    public JFTemplateParameterDef getParameterDefinition() {
        return this.m_def;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
        if (this.m_name == null) {
            throw new NullPointerException("Parameter <Name> is null!");
        }
    }

    public String getCaption() {
        return this.m_caption;
    }

    public void setCaption(String string) {
        this.m_caption = string;
    }

    public String[] getUserInput() {
        return this.m_input;
    }

    public void setUserInput(String[] stringArray) {
        this.m_input = stringArray;
    }

    public String getExpression() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_def != null) {
            for (int i = 0; i < this.m_input.length; ++i) {
                stringBuffer.append(this.m_def.getExpression(this.m_input[i]).trim()).append(" ");
            }
            return stringBuffer.toString().trim();
        }
        return null;
    }

    protected void setDef(JFTemplateParameterDef jFTemplateParameterDef) {
        this.m_def = jFTemplateParameterDef;
    }

    public void encryptInput() throws JFException {
        this.m_encryption = JFEncryptor.getEncryptor(key);
        this.m_input[0] = this.m_encryption.marshallChannel(this.m_input[0].getBytes());
    }
}

