/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFInParams;
import com.platform.LSFJobFlow.api.JFIncompatibleException;
import com.platform.LSFJobFlow.api.JFIncompatibleIOException;
import com.platform.LSFJobFlow.api.JFOutParams;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFSAXParser;
import com.platform.LSFJobFlow.api.JFServiceProxy;
import java.io.IOException;
import java.net.ProtocolException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class JFMethodInvoker {
    private String methodName = null;
    private JFServiceProxy serviceProxy = null;
    private Document reqDoc = null;
    public JFInParams inParams = null;
    public JFOutParams outParams = null;

    public JFMethodInvoker(JFServiceProxy jFServiceProxy, String string) {
        this.serviceProxy = jFServiceProxy;
        this.methodName = string;
        this.reset();
    }

    public void reset() {
        try {
            this.reqDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return;
        }
        Element element = this.reqDoc.createElement(this.methodName);
        this.reqDoc.appendChild(element);
        this.inParams = new JFInParams(element);
        this.outParams = null;
    }

    public void invoke() throws IOException, JFException {
        try {
            Document document = this.serviceProxy.invoke(this.reqDoc);
            Element element = document.getDocumentElement();
            this.outParams = new JFOutParams(element);
        }
        catch (JFIncompatibleIOException jFIncompatibleIOException) {
            if (jFIncompatibleIOException.getMessage().equals(JFResource.getString("Login_required_setting_conflict"))) {
                throw new JFIncompatibleException(jFIncompatibleIOException.getMessage());
            }
            throw jFIncompatibleIOException;
        }
        catch (Exception exception) {
            throw new ProtocolException(JFResource.getString("SVC_ERR") + ": " + JFResource.getString("SVC_MTHD_MSG_ERR") + " - " + exception.getMessage());
        }
    }

    JFSAXParser invokeBySAX() throws IOException {
        JFSAXParser jFSAXParser = null;
        try {
            jFSAXParser = this.serviceProxy.invokeBySAX(this.reqDoc);
        }
        catch (Exception exception) {
            throw new ProtocolException(JFResource.getString("SVC_ERR") + ": " + JFResource.getString("SVC_MTHD_MSG_ERR") + " - " + exception.getMessage());
        }
        return jFSAXParser;
    }
}

