/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFCharReader;
import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFEncryptionINF;
import com.platform.LSFJobFlow.api.JFEncryptor;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFHandler;
import com.platform.LSFJobFlow.api.JFJobEvent;
import com.platform.LSFJobFlow.api.JFJobExceptionEvent;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFSAXParser;
import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.api.JFVersion;
import com.platform.LSFJobFlow.api.JFXMLSource;
import com.platform.LSFJobFlow.api.JFXMLStringSource;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class JFJob
implements Cloneable {
    public static final String EXECUTION_TYPE_LSF = "lsf";
    public static final String EXECUTION_TYPE_SCRIPT = "script";
    public static final String EXECUTION_TYPE_MANUAL = "manual";
    public static final String EXECUTION_TYPE_LOCAL = "local";
    public static final String EXECUTION_TYPE_OTHER_BATCH = "otherbatch";
    public static final String EXECUTION_TYPE_SUBMISSION_FORM = "submissionForm";
    public static final String EXECUTION_TYPE_VE = "variable";
    public static final String EXECUTION_TYPE_ALARM = "alarm";
    public static final String EXECUTION_TYPE_ORACLE = "oracle";
    public static final String EXECUTION_TYPE_ZOS = "zos";
    static final String EXECUTION_TYPE_LINK = "link";
    public static final String SUBMISSION_CMD = "SubmissionCmd";
    public static final String JOB_CMD_LINE = "JobCmdLine";
    public static final String OTHER_BATCH_NAME = "BatchName";
    public static final String OTHER_BATCH_SUBMIT_OPTIONS = "SubmitOptions";
    public static final String JOB_INSTANCE_NAME = "JobInstanceName";
    public static final String RES_REQ_STR = "ResReqStr";
    public static final String STD_IN = "Stdin";
    public static final String STD_OUT = "Stdout";
    public static final String STD_OUT_CREATE = "CreateStdout";
    public static final String STD_OUT_OVERRIDE = "StdoutOverride";
    public static final String STD_ERR = "Stderr";
    public static final String STD_ERR_CREATE = "CreateStderr";
    public static final String STD_ERR_OVERRIDE = "StderrOverride";
    public static final String FILE_TRANSFER = "FileTransfer";
    public static final String URL_FILE_TRANSFER = "URLFileTransfer";
    public static final String TIME_EVENT = "TimeEvent";
    public static final String DEPEND_COND = "DependCond";
    public static final String EECEPT_HANDLER = "ExceptHandler";
    public static final String QUEUE_SELECT = "QueueSelect";
    public static final String APP_PROFILE_SELECT = "APPSelect";
    public static final String SERVICE_CLASS_SELECT = "SLASelect";
    public static final String JOB_ENV_VARS = "JobEnvVars";
    public static final String WORKING_DIRECTORY = "WorkingDirectory";
    public static final String HOST_SELECT = "HostSelect";
    public static final String HOST_DEPENDENT = "HostDependent";
    public static final String MIN_MAX_CPU = "MinMaxCPU";
    public static final String BEGIN_TIME = "BeginTime";
    public static final String FINISH_DEADLINE = "FinishDeadline";
    public static final String MAIL_DESTIMATION = "MailDestination";
    public static final String USER_PRE_EXEC_CMD = "UserPreExecCmd";
    public static final String CPU_TIME_LIMIT = "CPUTimeLimit";
    public static final String RUN_TIME_LIMIT = "RunTimeLimit";
    public static final String FILE_SIZE_LIMIT = "FileSizeLimit";
    public static final String PEAK_MEM_LIMIT = "PeakMemLimit";
    public static final String PEAK_SWAP_LIMIT = "PeakSwapLimit";
    public static final String DATA_SIZE_LIMIT = "DataSizeLimit";
    public static final String STACK_SIZE_LIMIT = "StackSizeLimit";
    public static final String CORE_SIZE_LIMIT = "CoreSizeLimit";
    public static final String LOGIN_SHELL = "LoginShell";
    public static final String PROJECT_NAME = "ProjectName";
    public static final String USER_GROUP = "UserGroup";
    public static final String JOB_PRIORITY = "JobPriority";
    public static final String USER_NAME = "UserName";
    public static final String COPY_CMD_BEFORE_SUBMIT = "CopyCmdBeforeSubmit";
    public static final String RUN_ON_OTHER_BATCH_AS = "RunOnOtherBatchAs";
    public static final String DESCRIPTION = "Description";
    public static final String ON_HOLD = "OnHold";
    public static final String JOB_TYPE_NAME = "JobTypeName";
    public static final String SUBMISSION_DIR = "SubmissionDir";
    public static final String ESTIMATED_CPU_TIME = "EstimatedCpuTime";
    public static final String ESTIMATED_RUN_TIME = "EstimatedRunTime";
    public static final String SUBMISSION_ENV = "SubmissionEnv";
    public static final String HOLD = "Hold";
    public static final String EXCLUSIVE_EXEC = "ExclusiveExec";
    public static final String RERUNABLE = "Rerunable";
    public static final String MAIL_WHEN_START = "MailWhenStart";
    public static final String MAIL_WHEN_FINISH = "MailWhenFinish";
    public static final String LOCAL_JOB_DISABLE_SUSPEND = "DisableSuspend";
    public static final String MANUAL_JOB_NOTIFICATION_ADDRESS = "NotificationAddress";
    public static final String MANUAL_JOB_NOTIFICATION_MESSAGE = "NotificationMessage";
    public static final String BOOLEAN_TRUE = "Yes";
    public static final String BOOLEAN_FALSE = "No";
    public static final String NON_ZERO_SUCCESS_EXIT_CODES = "NonZeroSuccessExitCodes";
    public static final String INPUT_FILES = "InputFiles";
    public static final String OUTPUT_FILES = "OutputFiles";
    protected Properties m_defProps = null;
    protected String m_curUser = null;
    protected String m_jobDefName = null;
    protected String m_executionType = "lsf";
    List m_handlerList = new LinkedList();
    protected boolean m_subObject = false;
    private JFEncryptionINF m_encryption = null;
    private boolean m_bEncrypt = false;
    private static final byte[] key = new byte[]{112, 8, 8, 113, 16, 8, -110, 18, 32, -105, 6, 32, -103, 3, 35, -1};
    public static final String OTHER_OPTIONS = "OtherOption";
    public static final String AVAILABLE_JOBS = "DependentJob";
    public static final String SELECTED_JOBS = "PreSubmitJob";

    public JFJob() {
        this.m_executionType = EXECUTION_TYPE_LSF;
        this.m_defProps = new Properties();
    }

    public JFJob(String string) {
        this.m_executionType = EXECUTION_TYPE_LSF;
        if (string == null) {
            throw new NullPointerException(JFResource.getString("JOBNAME_NULL"));
        }
        if (string.equals("")) {
            throw new IllegalArgumentException(JFResource.getString("INVALID_NAME"));
        }
        this.m_defProps = new Properties();
        this.m_jobDefName = string;
        this.m_curUser = JFLoginManager.getUserName();
        if (this.m_curUser == null) {
            this.m_curUser = "";
        }
        this.m_defProps.setProperty(USER_NAME, this.m_curUser);
        try {
            this.m_encryption = JFEncryptor.getEncryptor(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JFJob(String string, String string2) {
        this.m_executionType = string2;
        if (string == null) {
            throw new NullPointerException(JFResource.getString("JOBNAME_NULL"));
        }
        if (string.equals("")) {
            throw new IllegalArgumentException(JFResource.getString("INVALID_NAME"));
        }
        this.m_defProps = new Properties();
        this.m_jobDefName = string;
        this.m_curUser = JFLoginManager.getUserName();
        this.m_defProps.setProperty(USER_NAME, this.m_curUser);
        if (this.m_executionType.equals(EXECUTION_TYPE_MANUAL)) {
            this.setAttribute(MANUAL_JOB_NOTIFICATION_ADDRESS, new JFUser(this.m_curUser).getName());
        }
        if (this.m_executionType.equals(EXECUTION_TYPE_LOCAL)) {
            this.setAttribute(LOCAL_JOB_DISABLE_SUSPEND, BOOLEAN_FALSE);
        }
        try {
            this.m_encryption = JFEncryptor.getEncryptor(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAttribute(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        this.m_defProps.setProperty(string, string2);
    }

    public void removeAttribute(String string) {
        if (string == null) {
            return;
        }
        this.m_defProps.remove(string);
    }

    public boolean setUserName(String string) {
        String string2 = this.m_defProps.getProperty(USER_NAME);
        if (string2 != null) {
            if (string2.equals(string)) {
                return false;
            }
            if (string2.equalsIgnoreCase(string)) {
                String string3 = JFUser.getServerType();
                if (string3 != null && string3.equals("WIN32")) {
                    return false;
                }
                if (string3 == null && string.indexOf("\\") != -1) {
                    return false;
                }
            }
        }
        this.m_defProps.setProperty(USER_NAME, string);
        return true;
    }

    public String getUserName() {
        return this.getAttribute(USER_NAME);
    }

    @Deprecated
    public void setUserPassword(String string) {
        try {
            String string2 = this.m_encryption.marshallChannel(string.getBytes());
            this.m_defProps.setProperty("PassWord", string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deprecated
    public String getUserPassword() {
        String string = this.m_defProps.getProperty("PassWord");
        if (string != null && string.length() > 0) {
            try {
                return new String(this.m_encryption.unmarshallChannel(string));
            }
            catch (Exception exception) {
                return "";
            }
        }
        return "";
    }

    public Properties getAttributes() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.m_defProps);
        return properties;
    }

    public void setAttributes(Properties properties) {
        this.m_defProps = properties;
    }

    public String getAttribute(String string) {
        return this.m_defProps.getProperty(string);
    }

    public void removeAllAttributes() {
        this.m_defProps = new Properties();
    }

    public String getName() {
        return this.m_jobDefName;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("JOBNAME_NULL"));
        }
        this.m_jobDefName = string;
    }

    public void addPrefix(String string) {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("JOBNAME_NULL"));
        }
        JFHandler[] jFHandlerArray = this.getHandlers();
        for (int i = 0; i < jFHandlerArray.length; ++i) {
            JFHandler jFHandler = jFHandlerArray[i];
            if (jFHandler.getAction() != 2) continue;
            jFHandler.getAlarmJob().setName(string + jFHandler.getAlarmJob().getName());
        }
    }

    public void setExecutionType(String string) {
        this.m_executionType = string;
    }

    public String getExecutionType() {
        return this.m_executionType;
    }

    public String generateDefinition() {
        return this.toXML(null);
    }

    public JFJob initFromDefinition(String string) throws JFException, IOException {
        JFXMLStringSource jFXMLStringSource = new JFXMLStringSource(string);
        JFJob jFJob = jFXMLStringSource.createJob();
        this.m_jobDefName = jFJob.m_jobDefName;
        this.m_curUser = jFJob.m_curUser;
        this.m_defProps = (Properties)jFJob.m_defProps.clone();
        this.m_handlerList = new LinkedList();
        Iterator iterator = jFJob.m_handlerList.iterator();
        while (iterator.hasNext()) {
            this.addHandler((JFHandler)((JFHandler)iterator.next()).clone());
        }
        return this;
    }

    public void initHandlersFromDefinition(String string) throws JFException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("EVENT_DEFN_NULL"));
        }
        if (this.m_jobDefName == null) {
            throw new NullPointerException(JFResource.getString("JOBNAME_NULL"));
        }
        if (this.m_jobDefName.equals("")) {
            throw new IllegalArgumentException(JFResource.getString("INVALID_NAME"));
        }
        List<JFHandler> list = null;
        JFCharReader jFCharReader = null;
        try {
            jFCharReader = new JFCharReader(string.toCharArray());
            JFSAXParser jFSAXParser = new JFSAXParser(jFCharReader);
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
            xmlPullParser.setInput((Reader)jFCharReader);
            list = jFSAXParser.getHandlers(xmlPullParser);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                JFEvent jFEvent;
                JFHandler jFHandler = list.get(i);
                JFEvent jFEvent2 = jFHandler.getEvent();
                if (jFEvent2 instanceof JFJobExceptionEvent) {
                    jFEvent = (JFJobExceptionEvent)jFEvent2;
                    ((JFJobExceptionEvent)jFEvent).setJobName(this.m_jobDefName);
                    continue;
                }
                if (jFEvent2 instanceof JFJobEvent) {
                    jFEvent = (JFJobEvent)jFEvent2;
                    ((JFJobEvent)jFEvent).setJobName(this.m_jobDefName);
                    continue;
                }
                throw new JFException(JFResource.getString("JOBEVENT_INVALID_TYPE"));
            }
        }
        catch (Exception exception) {
            throw new JFException(JFResource.getString("DEFN_FILE_DEFN_DOC") + ": " + exception.getMessage());
        }
        finally {
            if (jFCharReader != null) {
                try {
                    jFCharReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.m_handlerList = list;
    }

    protected void appendAttribute(StringBuffer stringBuffer, String string, String string2) {
        if (string == null || string2 == null || string2.length() == 0) {
            return;
        }
        if (stringBuffer == null) {
            throw new NullPointerException(JFResource.getString("INTERNAL_ERROR"));
        }
        stringBuffer.append("\n  <" + string);
        stringBuffer.append("  Value=\"" + string2 + "\"");
        stringBuffer.append("/>");
    }

    String toXML(String string) {
        JFHandler[] jFHandlerArray;
        StringBuffer stringBuffer = new StringBuffer(1024);
        String string2 = this.getName();
        if (string != null) {
            string2 = string + ":" + string2;
        }
        stringBuffer.append("\n<JobDef ExecutionType=\"" + this.m_executionType + "\" Name=\"" + string2 + "\"");
        stringBuffer.append(">");
        for (String jFHandlerArray2 : this.m_defProps.keySet()) {
            if (jFHandlerArray2.equals("PositionX") || jFHandlerArray2.equals("PositionY")) continue;
            String i = this.m_defProps.getProperty(jFHandlerArray2);
            if (jFHandlerArray2.equals(HOST_DEPENDENT) && string != null) {
                i = JFXMLSource.mergeName(string, i);
            }
            this.appendAttribute(stringBuffer, jFHandlerArray2, JFXMLSource.convertToXMLAttrString(i));
        }
        if (string == null && (jFHandlerArray = this.getHandlers()) != null) {
            stringBuffer.append("\n  <Exceptions>");
            for (int i = 0; i < jFHandlerArray.length; ++i) {
                stringBuffer.append(jFHandlerArray[i].toXML());
            }
            stringBuffer.append("\n  </Exceptions>");
        }
        stringBuffer.append("\n</JobDef>");
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return null;
    }

    public Object clone() {
        JFJob jFJob = null;
        try {
            jFJob = (JFJob)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        jFJob.m_jobDefName = this.m_jobDefName;
        jFJob.m_curUser = this.m_curUser;
        jFJob.m_defProps = (Properties)this.m_defProps.clone();
        jFJob.m_handlerList = new LinkedList();
        Iterator iterator = this.m_handlerList.iterator();
        while (iterator.hasNext()) {
            JFHandler jFHandler = (JFHandler)((JFHandler)iterator.next()).clone();
            if (!this.m_subObject) {
                jFHandler.setEventObject(jFJob);
            }
            jFJob.addHandler(jFHandler);
        }
        return jFJob;
    }

    public boolean equals(JFJob jFJob) {
        if (this.m_handlerList == null && jFJob.m_handlerList == null || this.m_handlerList != null && ((Object)this.m_handlerList).equals(jFJob.m_handlerList)) {
            return this.m_defProps.equals(jFJob.m_defProps) && this.m_jobDefName.equals(jFJob.m_jobDefName) && this.m_executionType.equals(jFJob.m_executionType);
        }
        return false;
    }

    public void addHandler(JFHandler jFHandler) {
        if (jFHandler == null) {
            return;
        }
        this.m_handlerList.add(jFHandler);
    }

    public void removeHandlers() {
        this.m_handlerList.clear();
    }

    public JFHandler[] getHandlers() {
        JFHandler[] jFHandlerArray = new JFHandler[this.m_handlerList.size()];
        this.m_handlerList.toArray(jFHandlerArray);
        return jFHandlerArray;
    }

    public void setHandlers(JFHandler[] jFHandlerArray) {
        if (jFHandlerArray == null || jFHandlerArray.length == 0) {
            return;
        }
        this.m_handlerList = Arrays.asList(jFHandlerArray);
    }

    public void setAsSubObject() {
        this.m_subObject = true;
    }

    public void setEventObject(Object object) {
        Iterator iterator = this.m_handlerList.iterator();
        while (iterator.hasNext()) {
            ((JFHandler)iterator.next()).setEventObject(object);
        }
    }

    public void validate() throws JFException {
        if (this.m_executionType.equals(EXECUTION_TYPE_LSF) || this.m_executionType.equals(EXECUTION_TYPE_LOCAL)) {
            String string = null;
            string = null != this.getAttribute(JOB_CMD_LINE) ? this.getCommandFromCommandLine(this.getAttribute(JOB_CMD_LINE).trim()) : this.getCommandFromCommandLine("");
            if (string != null) {
                try {
                    if (JFCommon.containNonASCIIChar(string) && JFConfigManager.getServerVersion(true).compareTo(new JFVersion("6.2")) < 0) {
                        throw new JFException(this.getStringWithOneParam("Localized_input_not_supported", JFResource.getString("Job_Cmd_Line")));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            String[][] stringArrayArray = new String[13][];
            String[] stringArray = new String[2];
            stringArray[0] = RES_REQ_STR;
            stringArray[1] = "Job_ResReqStr";
            stringArrayArray[0] = stringArray;
            String[] stringArray2 = new String[2];
            stringArray2[0] = STD_IN;
            stringArray2[1] = "Job_Stdin";
            stringArrayArray[1] = stringArray2;
            String[] stringArray3 = new String[2];
            stringArray3[0] = STD_OUT;
            stringArray3[1] = "Job_Stdout";
            stringArrayArray[2] = stringArray3;
            String[] stringArray4 = new String[2];
            stringArray4[0] = STD_ERR;
            stringArray4[1] = "Job_Stderr";
            stringArrayArray[3] = stringArray4;
            String[] stringArray5 = new String[2];
            stringArray5[0] = FILE_TRANSFER;
            stringArray5[1] = "Job_FileTransfer";
            stringArrayArray[4] = stringArray5;
            String[] stringArray6 = new String[2];
            stringArray6[0] = URL_FILE_TRANSFER;
            stringArray6[1] = "Job_URLFileTransfer";
            stringArrayArray[5] = stringArray6;
            String[] stringArray7 = new String[2];
            stringArray7[0] = HOST_SELECT;
            stringArray7[1] = "Job_HostSelect";
            stringArrayArray[6] = stringArray7;
            String[] stringArray8 = new String[2];
            stringArray8[0] = HOST_DEPENDENT;
            stringArray8[1] = "Job_HostDependent";
            stringArrayArray[7] = stringArray8;
            String[] stringArray9 = new String[2];
            stringArray9[0] = MAIL_DESTIMATION;
            stringArray9[1] = "Job_MailDestination";
            stringArrayArray[8] = stringArray9;
            String[] stringArray10 = new String[2];
            stringArray10[0] = USER_GROUP;
            stringArray10[1] = "Job_UserGroup";
            stringArrayArray[9] = stringArray10;
            String[] stringArray11 = new String[2];
            stringArray11[0] = USER_NAME;
            stringArray11[1] = "Job_UserName";
            stringArrayArray[10] = stringArray11;
            String[] stringArray12 = new String[2];
            stringArray12[0] = WORKING_DIRECTORY;
            stringArray12[1] = "Job_WorkingDirectory";
            stringArrayArray[11] = stringArray12;
            String[] stringArray13 = new String[2];
            stringArray13[0] = JOB_ENV_VARS;
            stringArray13[1] = "Job_EnvVars";
            stringArrayArray[12] = stringArray13;
            String[][] stringArrayArray2 = stringArrayArray;
            int n = stringArrayArray2.length;
            for (int i = 0; i < n; ++i) {
                if (!JFCommon.containNonASCIIChar(this.getAttribute(stringArrayArray2[i][0]))) continue;
                throw new JFException(this.getStringWithOneParam("Localized_input_not_supported", JFResource.getString(stringArrayArray2[i][1])));
            }
            this.validatePresubmit();
            return;
        }
        this.validateEnvVars();
        if (this.m_executionType.equals(EXECUTION_TYPE_MANUAL)) {
            if (JFCommon.containNonASCIIChar(this.getAttribute(MANUAL_JOB_NOTIFICATION_ADDRESS))) {
                throw new JFException(this.getStringWithOneParam("Localized_input_not_supported", JFResource.getString("Manual_Job_MailDestination")));
            }
            return;
        }
        if (this.m_executionType.equals(EXECUTION_TYPE_OTHER_BATCH)) {
            try {
                if (JFConfigManager.getServerVersion(true).compareTo(new JFVersion("9.1")) < 0) {
                    throw new JFException(JFResource.getString("Not_Support_Other_Batch_System"));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void validatePresubmit() throws JFException {
        String string = this.getAttribute(OTHER_OPTIONS);
        if (string == null || string.trim().equals("")) {
            return;
        }
        String string2 = ".*(-I|-Ip|-Is|-K).*";
        if (string.matches(string2)) {
            throw new JFException(JFResource.getString("Other_Options_Check1"));
        }
        String string3 = "";
        string = " " + string;
        StringBuffer stringBuffer = new StringBuffer("");
        if (string.indexOf(" -J") >= 0) {
            stringBuffer.append("-J ");
        }
        if (string.indexOf(" -R") >= 0) {
            stringBuffer.append("-R ");
        }
        if (string.indexOf(" -i ") >= 0) {
            stringBuffer.append("-i ");
        }
        if (string.indexOf(" -o") >= 0) {
            stringBuffer.append("-o ");
        }
        if (string.indexOf(" -e") >= 0) {
            stringBuffer.append("-e ");
        }
        if (string.indexOf(" -f") >= 0) {
            stringBuffer.append("-f ");
        }
        if (string.indexOf(" -app") >= 0) {
            stringBuffer.append("-app ");
        }
        if (string.indexOf(" -sla") >= 0) {
            stringBuffer.append("-sla ");
        }
        if (string.indexOf(" -q") >= 0) {
            stringBuffer.append("-q ");
        }
        if (string.indexOf(" -m") >= 0) {
            stringBuffer.append("-m ");
        }
        if (string.indexOf(" -n") >= 0) {
            stringBuffer.append("-n ");
        }
        if (string.indexOf(" -u") >= 0) {
            stringBuffer.append("-u ");
        }
        if (string.indexOf(" -E ") >= 0) {
            stringBuffer.append("-E ");
        }
        if (string.matches(".* -c(?=\\d| |#\\{|$).*")) {
            stringBuffer.append("-c ");
        }
        if (string.matches(".* -W(?=\\d| |#\\{|$).*")) {
            stringBuffer.append("-W ");
        }
        if (string.indexOf(" -F") >= 0) {
            stringBuffer.append("-F ");
        }
        if (string.indexOf(" -M") >= 0) {
            stringBuffer.append("-M ");
        }
        if (string.indexOf(" -D") >= 0) {
            stringBuffer.append("-D ");
        }
        if (string.indexOf(" -S") >= 0) {
            stringBuffer.append("-S ");
        }
        if (string.indexOf(" -C") >= 0) {
            stringBuffer.append("-C ");
        }
        if (string.indexOf(" -L ") >= 0) {
            stringBuffer.append("-L ");
        }
        if (string.indexOf(" -P") >= 0) {
            stringBuffer.append("-P ");
        }
        if (string.indexOf(" -G") >= 0) {
            stringBuffer.append("-G ");
        }
        if (string.indexOf(" -sp") >= 0) {
            stringBuffer.append("-sp ");
        }
        if (string.indexOf(" -x") >= 0) {
            stringBuffer.append("-x ");
        }
        if (string.indexOf(" -B") >= 0) {
            stringBuffer.append("-B ");
        }
        if (string.indexOf(" -N") >= 0) {
            stringBuffer.append("-N ");
        }
        if (!(string3 = stringBuffer.toString()).equals("")) {
            throw new JFException(this.getStringWithOneParam("Other_Options_Check2", string3));
        }
        String string4 = this.getAttribute(SELECTED_JOBS);
        int n = string.indexOf(" -w");
        if (n >= 0 && string4 != null && !string4.trim().equals("")) {
            throw new JFException(JFResource.getString("Repeating_Other_Option_Warning"));
        }
    }

    private void validateEnvVars() throws JFException {
        String string = this.getAttribute(JOB_ENV_VARS);
        if (string != null && !JFCommon.checkEnvVars(string)) {
            throw new JFException(this.getStringWithOneParam("JOB_ENV_VARS_INVALID", this.getName()));
        }
    }

    private String getStringWithOneParam(String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        String string3 = JFResource.getString(string);
        MessageFormat messageFormat = new MessageFormat(string3);
        return messageFormat.format(objectArray);
    }

    private String getCommandFromCommandLine(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        int n = 0;
        int n2 = -1;
        while ((n2 = string2.indexOf(32)) != -1) {
            int n3;
            int n4;
            boolean bl = false;
            while ((n4 = string2.indexOf(34)) != -1 && n4 <= n2 && (n3 = string2.substring(n4 + 1).indexOf(34)) != -1) {
                if ((n3 += n4 + 1) > n2) {
                    n += n3 + 1;
                    string2 = string2.substring(n3 + 1);
                    bl = true;
                    break;
                }
                n += n3 + 1;
                string2 = string2.substring(n3 + 1);
                n2 -= n3 + 1;
            }
            if (bl) continue;
            break;
        }
        String string3 = n2 == -1 ? string : string.substring(0, n + n2);
        return string3;
    }

    public String convertHandlersToXML() {
        StringBuffer stringBuffer = new StringBuffer();
        JFHandler[] jFHandlerArray = this.getHandlers();
        if (jFHandlerArray != null) {
            stringBuffer.append("<Exceptions>");
            for (int i = 0; i < jFHandlerArray.length; ++i) {
                stringBuffer.append(jFHandlerArray[i].toXML());
            }
            stringBuffer.append("\n  </Exceptions>");
            return stringBuffer.toString();
        }
        return null;
    }
}

