/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFilter;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFFlowArrayInstance;
import com.platform.LSFJobFlow.api.JFFlowInstance;
import com.platform.LSFJobFlow.api.JFInstanceManagerPolicy;
import com.platform.LSFJobFlow.api.JFMethodInvoker;
import com.platform.LSFJobFlow.api.JFPseudoFlowInstance;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFSecurityUtils;
import com.platform.LSFJobFlow.api.JFServiceProxy;
import com.platform.LSFJobFlow.api.JFVersion;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class JFFlowManager {
    private JFServiceProxy instanceManagerInvoker = new JFServiceProxy("JFInstanceManager");
    private static final int IMGR_ERR_NO_ERROR = 0;
    private static final int IMGR_ERR_FILTER_SYNTAX = 8001;
    private static final int IMGR_ERR_UNKNOWN_STATE = 8002;
    private static final int IMGR_ERR_POLICY_FAILED = 8003;
    private static final int IMGR_ERR_NOT_FOUND = 8004;
    private static final int IMGR_ERR_INVALID_OPERATION = 8005;
    private static final int IMGR_ERR_OUT_OF_MEMORY = 8006;
    private static final int IMGR_ERR_NOT_IMPLEMENTED = 8007;
    private static final int ENGINE_ERR_PERMISSION_DENIED = 2013;
    private static final int IMGR_ERR_FLOW_STILL_ACTIVE = 2014;
    private static final int IMGR_ERR_FLOW_NOT_FOUND = 2015;
    private static final int IMGR_ERR_FLOW_NOT_EXIT = 2016;
    private static final int IMGR_ERR_REQUEST_UNSUPPORTED = 2017;
    private static final int IMGR_ERR_DUPLICATE_FLOW = 2018;
    private static final int IMGR_ERR_FLOW_RERUN_DELAY = 2029;
    private static final int COMMON_ERR_PERMISSION_DENIED = 7;
    private static final int SNAPSHOT_INPROCESS_NOTIFICATION = 22;
    private static final int COMP_DEP_WORK_ITEM_NOT_FOUND = 2034;
    private static final int COMP_DEP_EVENT_ALREADY_OCCURRED = 2035;
    private static final int COMP_DEP_EVENT_NOT_FOUND = 2036;
    private static final int COMP_DEP_FLOW_FINISHED = 2038;
    private static final int FLOW_FINISHED = 2041;
    private static final int FLOW_HAS_FLOW_ARRAY = 2045;
    private static final int INVALID_START_POINT_TYPE = 2046;
    private static final int ITEM_IS_NOT_A_START_POINT = 2047;
    private static final int INVALID_STATUS_FOR_START_PONIT = 2048;
    private static final int RERUN_KILLED_FLOW = 2057;
    private static final int FLOW_CANNOT_RERUN = 2058;
    private static final int NO_START_POINT = 2059;
    private static final int NO_EXITED_ITEM = 2060;
    private static final int RERUN_COMPLETED_FLOW_WITH_SINGLE_RUNNING_JOB = 2062;
    private static final int JOBARRAY_RERUN_EMPTYELEMENTLIST = 2073;
    private static final int JOBARRAY_RERUN_INVALIDELEMENTINDEX = 2075;
    private static final int INVALID_USER_NAME = 37;

    static String iMgrErrorToString(int n) {
        switch (n) {
            case 0: {
                return JFResource.getString("IMGR_ERR_NO_ERROR");
            }
            case 8001: {
                return JFResource.getString("IMGR_ERR_FILTER_SYNTAX");
            }
            case 8002: {
                return JFResource.getString("IMGR_ERR_UNKNOWN_STATE");
            }
            case 8003: {
                return JFResource.getString("IMGR_ERR_POLICY_FAILED");
            }
            case 8004: {
                return JFResource.getString("IMGR_ERR_NOT_FOUND");
            }
            case 8005: {
                return JFResource.getString("IMGR_ERR_INVALID_OPERATION");
            }
            case 8006: {
                return JFResource.getString("IMGR_ERR_OUT_OF_MEMORY");
            }
            case 8007: {
                return JFResource.getString("IMGR_ERR_NOT_IMPLEMENTED");
            }
            case 7: 
            case 2013: {
                return JFResource.getString("IMGR_ERR_COMMON_PERMISSION_DENIED");
            }
            case 2014: {
                return JFResource.getString("IMGR_ERR_FLOW_STILL_ACTIVE");
            }
            case 2015: {
                return JFResource.getString("IMGR_ERR_FLOW_NOT_FOUND");
            }
            case 2016: {
                return JFResource.getString("IMGR_ERR_FLOW_NOT_EXIT");
            }
            case 2017: {
                return JFResource.getString("IMGR_ERR_REQUEST_UNSUPPORTED");
            }
            case 2018: {
                return JFResource.getString("IMGR_ERR_DUPLICATE_FLOW");
            }
            case 2029: {
                return JFResource.getString("IMGR_ERR_FLOW_RERUN_DELAY");
            }
            case 22: {
                return JFResource.getString("SNAPSHOT_INPROCESS_NOTIFICATION");
            }
            case 2034: {
                return JFResource.getString("COMP_DEP_WORK_ITEM_NOT_FOUND");
            }
            case 2035: {
                return JFResource.getString("COMP_DEP_EVENT_ALREADY_OCCURRED");
            }
            case 2036: {
                return JFResource.getString("COMP_DEP_EVENT_NOT_FOUND");
            }
            case 2038: {
                return JFResource.getString("COMP_DEP_FLOW_FINISHED");
            }
            case 2041: {
                return JFResource.getString("FLOW_FINISHED");
            }
            case 2045: {
                return JFResource.getString("FLOW_HAS_FLOW_ARRAY");
            }
            case 2046: {
                return JFResource.getString("INVALID_START_POINT_TYPE");
            }
            case 2047: {
                return JFResource.getString("ITEM_IS_NOT_A_START_POINT");
            }
            case 2048: {
                return JFResource.getString("INVALID_STATUS_FOR_START_PONIT");
            }
            case 37: {
                return JFResource.getString("INVALID_USER_NAME");
            }
            case 2057: {
                return JFResource.getString("RERUN_KILLED_FLOW");
            }
            case 2062: {
                return JFResource.getString("RERUN_COMPLETED_FLOW_WITH_SINGLE_RUNNING_JOB");
            }
            case 2058: {
                return JFResource.getString("FLOW_CANNOT_RERUN");
            }
            case 2059: {
                return JFResource.getString("NO_START_POINT");
            }
            case 2060: {
                return JFResource.getString("NO_EXITED_ITEM");
            }
            case 2073: {
                return JFResource.getString("JOBARRAY_RERUN_EMPTYELEMENTLIST");
            }
            case 2075: {
                return JFResource.getString("JOBARRAY_RERUN_INVALIDELEMENTINDEX");
            }
        }
        return JFResource.getString("IMGR_ERR_UNKNOWN");
    }

    public JFPseudoFlowInstance[] getPseudoInstances(JFFilter jFFilter) throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.instanceManagerInvoker, "JF_GetPseudoInstances");
        if (jFFilter != null && !jFFilter.isEmpty()) {
            jFMethodInvoker.inParams.addParam("filter", jFFilter.toXML());
        }
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            if (8004 == n) {
                return new JFPseudoFlowInstance[0];
            }
            throw new JFException(JFFlowManager.iMgrErrorToString(n));
        }
        return jFMethodInvoker.outParams.getParamPseudoFlowInstanceArray("pseudoInstances");
    }

    public JFFlowInstance getInstance(long l) throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.instanceManagerInvoker, "JF_GetInstanceInfo");
        jFMethodInvoker.inParams.addParam("id", l);
        JFFlowInstance jFFlowInstance = jFMethodInvoker.invokeBySAX().getFlowInstance();
        return jFFlowInstance;
    }

    public JFFlowInstance getFlowArrayElementInstance(JFFlowArrayInstance jFFlowArrayInstance, int n) throws JFException, IOException {
        String string = jFFlowArrayInstance.getName();
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.instanceManagerInvoker, "JF_GetFlowArrayInstanceInfo");
        jFMethodInvoker.inParams.addParam("arrayName", string);
        jFMethodInvoker.inParams.addParam("index", n);
        jFMethodInvoker.invoke();
        int n2 = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n2) {
            throw new JFException(JFFlowManager.iMgrErrorToString(n2));
        }
        JFFlowInstance jFFlowInstance = jFMethodInvoker.outParams.getParamFlowInstance("flowInstance");
        jFFlowArrayInstance.addFlowInstance(jFFlowInstance);
        return jFFlowInstance;
    }

    public void killInstance(long l) throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.instanceManagerInvoker, "JF_KillInstance");
        jFMethodInvoker.inParams.addParam("id", l);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(JFFlowManager.iMgrErrorToString(n));
        }
    }

    public void suspendInstance(long l) throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.instanceManagerInvoker, "JF_SuspendInstance");
        jFMethodInvoker.inParams.addParam("id", l);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(JFFlowManager.iMgrErrorToString(n));
        }
    }

    public void resumeInstance(long l) throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.instanceManagerInvoker, "JF_ResumeInstance");
        jFMethodInvoker.inParams.addParam("id", l);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(JFFlowManager.iMgrErrorToString(n));
        }
    }

    public void rerunInstance(long l) throws JFException, IOException {
        this.rerunInstance(l, "");
    }

    public void rerunInstance(long l, String string) throws JFException, IOException {
        this.rerunInstance(l, string, false);
    }

    public void rerunInstance(long l, String string, boolean bl) throws JFException, IOException {
        JFFlowInstance jFFlowInstance;
        if (bl) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Rerun_From_Starting_Points_Only"));
        }
        if ((jFFlowInstance = this.getInstance(l)).getState() != 3) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Rerun_Active_Flow"));
        }
        if (JFCommon.containNonASCIIChar(string)) {
            Object[] objectArray = new Object[]{JFResource.getString("Rerun_flow_instance_with_var")};
            String string2 = JFResource.getString("Localized_input_not_supported");
            MessageFormat messageFormat = new MessageFormat(string2);
            throw new JFException(messageFormat.format(objectArray));
        }
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.instanceManagerInvoker, "JF_RerunInstance");
        jFMethodInvoker.inParams.addParam("id", l);
        if (string != null) {
            jFMethodInvoker.inParams.addParam("variableList", string);
        } else {
            jFMethodInvoker.inParams.addParam("variableList", "");
        }
        jFMethodInvoker.inParams.addParam("startPointsOnly", bl);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        String string3 = jFMethodInvoker.outParams.getParamString("errormessages");
        if (0 != n) {
            throw new JFException(string3);
        }
    }

    public void rerunInstanceWithNewDef(JFFlow jFFlow, long l, String string, boolean bl) throws JFException, IOException {
        JFFlowInstance jFFlowInstance;
        if (bl) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Rerun_From_Starting_Points_Only"));
        }
        if ((jFFlowInstance = this.getInstance(l)).getState() != 3) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Rerun_Active_Flow"));
        }
        if (JFCommon.containNonASCIIChar(string)) {
            Object[] objectArray = new Object[]{JFResource.getString("Rerun_flow_instance_with_var")};
            String string2 = JFResource.getString("Localized_input_not_supported");
            MessageFormat messageFormat = new MessageFormat(string2);
            throw new JFException(messageFormat.format(objectArray));
        }
        jFFlow.validate();
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.instanceManagerInvoker, "JF_RerunInstanceWithNewDef");
        jFMethodInvoker.inParams.addParam("xmlFlowDef", jFFlow);
        jFMethodInvoker.inParams.addParam("id", l);
        if (string != null) {
            jFMethodInvoker.inParams.addParam("variableList", string);
        } else {
            jFMethodInvoker.inParams.addParam("variableList", "");
        }
        jFMethodInvoker.inParams.addParam("startPointsOnly", bl);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        String string3 = jFMethodInvoker.outParams.getParamString("errormessages");
        if (0 != n) {
            throw new JFException(string3);
        }
    }

    public int refreshInstanceWithNewDef(JFFlow jFFlow, long l) throws JFException, IOException {
        JFFlowInstance jFFlowInstance = this.getInstance(l);
        if (jFFlowInstance.getState() != 3) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Rerun_Active_Flow"));
        }
        jFFlow.validate();
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.instanceManagerInvoker, "JF_RefreshInstanceWithNewDef");
        jFMethodInvoker.inParams.addParam("xmlFlowDef", jFFlow);
        jFMethodInvoker.inParams.addParam("id", l);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (2074 == n) {
            return 2074;
        }
        if (0 != n) {
            throw new JFException(JFFlowManager.iMgrErrorToString(n));
        }
        return 0;
    }

    void signalInstance(long l, int n) throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.instanceManagerInvoker, "JF_SignalInstance");
        jFMethodInvoker.inParams.addParam("id", l);
        jFMethodInvoker.inParams.addParam("signalId", n);
        jFMethodInvoker.invoke();
        int n2 = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n2) {
            throw new JFException(JFFlowManager.iMgrErrorToString(n2));
        }
    }

    public void completeDependency(JFEvent jFEvent, String string) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Complete_dependency"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.instanceManagerInvoker, "JF_CompleteDependency");
        int n = string.indexOf(58);
        if (n <= 0) {
            throw new JFException(JFResource.getString("INVALID_WORK_ITEM_NAME"));
        }
        String string2 = string.substring(0, n);
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JFException(JFResource.getString("INVALID_WORK_ITEM_NAME"));
        }
        String string3 = this.getParentName(string);
        String string4 = this.getParentName(jFEvent.getFullWorkItemName());
        if (jFEvent.isProxy()) {
            jFEvent.setAttribute("Destination", string2);
        } else if (!string3.equals(string4)) {
            jFEvent.setParentName(string3);
        }
        jFMethodInvoker.inParams.addParam("id", n2);
        jFMethodInvoker.inParams.addParam("workItemName", string);
        jFMethodInvoker.inParams.addParam("dependency", jFEvent);
        jFMethodInvoker.invoke();
        int n3 = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n3) {
            throw new JFException(JFResource.getString("COMP_DEP_FAIL") + JFFlowManager.iMgrErrorToString(n3));
        }
    }

    public JFInstanceManagerPolicy getPolicyInfo() throws JFException, IOException {
        String string;
        try {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("6.2"), JFResource.getString("Get_policy_info"));
        }
        catch (JFException jFException) {
            return null;
        }
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.instanceManagerInvoker, "JF_GetPolicyInfo");
        String string2 = System.getProperty("os.name");
        if (!JFConfigManager.isExternalLogin() && string2 != null && !string2.startsWith("Windows") && (string = JFSecurityUtils.getKRBCache()) != null && string != "") {
            jFMethodInvoker.inParams.addParam("KRBTGT", string);
        }
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("JFCFG_GET_SERVER_POLICY_FAIL") + JFFlowManager.iMgrErrorToString(n));
        }
        return jFMethodInvoker.outParams.getParamPolicyInfo("policy");
    }

    private String getParentName(String string) {
        int n = string.lastIndexOf(58);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    private String getRealJobName(long l, String string) throws JFException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        long l2 = 0L;
        String string2 = null;
        try {
            l2 = Long.parseLong(stringTokenizer.nextToken());
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken("").substring(1);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JFException(JFResource.getString("JOB_INVALID_ID"));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JFException(JFResource.getString("JOB_INVALID_NAME"));
        }
        if (string2 == null) {
            throw new JFException(JFResource.getString("JOB_INVALID_NAME"));
        }
        if (l2 != l) {
            throw new JFException(JFResource.getString("JOB_INVALID_ID"));
        }
        return string2;
    }

    public void setJobAsRerunStartingPoint(long l, String string, boolean bl) throws JFException, IOException {
        if (bl) {
            this.setJobAsRerunStartingPoint(l, string, "ALL");
        } else {
            this.setJobAsRerunStartingPoint(l, string, "");
        }
    }

    public void setJobAsRerunStartingPoint(long l, String string, String string2) throws JFException, IOException {
        String string3 = null;
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Set_Unset_Starting_Point"));
        JFFlowInstance jFFlowInstance = this.getInstance(l);
        if (jFFlowInstance.getState() != 3) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Set_Start_Point_For_Active_Flow"));
        }
        string3 = this.getRealJobName(l, string);
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.instanceManagerInvoker, "JF_SetJobAsRerunStartingPoint");
        jFMethodInvoker.inParams.addParam("id", l);
        jFMethodInvoker.inParams.addParam("jobname", string3);
        if (string2.equals("ALL")) {
            jFMethodInvoker.inParams.addParam("inallelements", true);
        } else {
            jFMethodInvoker.inParams.addParam("inallelements", false);
        }
        jFMethodInvoker.inParams.addParam("FAElementsListString", string2);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(JFFlowManager.iMgrErrorToString(n));
        }
    }

    public void setJobArrayAsRerunStartingPoint(long l, String string, boolean bl) throws JFException, IOException {
        this.setJobArrayAsRerunStartingPoint(l, string, bl, false, "");
    }

    public void setJobArrayAsRerunStartingPoint(long l, String string, boolean bl, boolean bl2, String string2) throws JFException, IOException {
        if (bl) {
            this.setJobArrayAsRerunStartingPoint(l, string, bl2, string2, "ALL");
        } else {
            this.setJobArrayAsRerunStartingPoint(l, string, bl2, string2, "");
        }
    }

    public void setJobArrayAsRerunStartingPoint(long l, String string, boolean bl, String string2, String string3) throws JFException, IOException {
        String string4 = null;
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Set_Unset_Starting_Point"));
        JFFlowInstance jFFlowInstance = this.getInstance(l);
        if (jFFlowInstance.getState() != 3) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Set_Start_Point_For_Active_Flow"));
        }
        string4 = this.getRealJobName(l, string);
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.instanceManagerInvoker, "JF_SetJobArrayAsRerunStartingPoint");
        jFMethodInvoker.inParams.addParam("id", l);
        jFMethodInvoker.inParams.addParam("jobname", string4);
        if (string3.equals("ALL")) {
            jFMethodInvoker.inParams.addParam("inallelements", true);
        } else {
            jFMethodInvoker.inParams.addParam("inallelements", false);
        }
        jFMethodInvoker.inParams.addParam("runExitedElements", bl);
        jFMethodInvoker.inParams.addParam("elementsListString", string2);
        jFMethodInvoker.inParams.addParam("FAElementsListString", string3);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(JFFlowManager.iMgrErrorToString(n));
        }
    }

    public void unsetJobAsRerunStartingPoint(long l, String string) throws JFException, IOException {
        String string2 = null;
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Set_Unset_Starting_Point"));
        JFFlowInstance jFFlowInstance = this.getInstance(l);
        if (jFFlowInstance.getState() != 3) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Set_Start_Point_For_Active_Flow"));
        }
        string2 = this.getRealJobName(l, string);
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.instanceManagerInvoker, "JF_unSetJobAsRerunStartingPoint");
        jFMethodInvoker.inParams.addParam("id", l);
        jFMethodInvoker.inParams.addParam("jobname", string2);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(JFFlowManager.iMgrErrorToString(n));
        }
    }

    public void unsetJobArrayAsRerunStartingPoint(long l, String string) throws JFException, IOException {
        String string2 = null;
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Set_Unset_Starting_Point"));
        JFFlowInstance jFFlowInstance = this.getInstance(l);
        if (jFFlowInstance.getState() != 3) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Set_Start_Point_For_Active_Flow"));
        }
        string2 = this.getRealJobName(l, string);
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.instanceManagerInvoker, "JF_unSetJobArrayAsRerunStartingPoint");
        jFMethodInvoker.inParams.addParam("id", l);
        jFMethodInvoker.inParams.addParam("jobname", string2);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(JFFlowManager.iMgrErrorToString(n));
        }
    }

    public void clearStartingPoint(long l) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("10.201"), JFResource.getString("Clear_All_Starting_Points"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.instanceManagerInvoker, "JF_ClearStartingPoint");
        jFMethodInvoker.inParams.addParam("id", l);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(JFFlowManager.iMgrErrorToString(n));
        }
    }
}

