/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFDateTimeParser;
import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFEventInstance;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFFlowArray;
import com.platform.LSFJobFlow.api.JFFlowArrayElementInfo;
import com.platform.LSFJobFlow.api.JFFlowArrayEvent;
import com.platform.LSFJobFlow.api.JFFlowArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFFlowEvent;
import com.platform.LSFJobFlow.api.JFFlowExceptionEvent;
import com.platform.LSFJobFlow.api.JFFlowInstance;
import com.platform.LSFJobFlow.api.JFJobArrayEvent;
import com.platform.LSFJobFlow.api.JFJobArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFJobEvent;
import com.platform.LSFJobFlow.api.JFJobExceptionEvent;
import com.platform.LSFJobFlow.api.JFLinkEvent;
import com.platform.LSFJobFlow.api.JFLinkEventInstance;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFTime;
import com.platform.LSFJobFlow.api.JFVariableEvent;
import com.platform.LSFJobFlow.api.JFVersion;
import com.platform.LSFJobFlow.api.JFXMLSource;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JFFlowArrayInstance
extends Observable {
    public static final int WAITING = 0;
    public static final int RUNNING = 1;
    public static final int DONE = 2;
    public static final int EXIT = 3;
    public static final int KILLED = 4;
    public static final int SUSPENDED = 5;
    protected JFFlow m_flowDefinition = null;
    protected JFFlowArray m_flowArrayDefinition = null;
    protected LinkedList events = new LinkedList();
    protected String m_name = null;
    protected String m_owner = null;
    protected int m_state;
    protected int m_exitCode;
    protected JFTime m_startTime = null;
    protected JFTime m_finishTime = null;
    protected String m_firstElement;
    protected String m_lastElement;
    private Properties m_localVariables = null;
    private HashMap localVarsMap = null;
    private HashMap inputVarsMap = null;
    protected HashMap m_element = null;
    private HashMap m_flowInstances = new HashMap();
    private int firstIndex = 0;
    private int lastIndex = 0;

    JFFlowArrayInstance() {
        this.m_localVariables = new Properties();
        this.localVarsMap = new HashMap();
        this.inputVarsMap = new HashMap();
    }

    public void addFlowInstance(JFFlowInstance jFFlowInstance) {
        this.m_flowInstances.put(jFFlowInstance.getName(), jFFlowInstance);
    }

    public JFFlowInstance getFlowInstance(String string) {
        return (JFFlowInstance)this.m_flowInstances.get(string);
    }

    void createElements(int n, int n2) {
        this.m_element = new HashMap();
        int n3 = n;
        while (n3 <= n2) {
            JFFlowArrayElementInfo jFFlowArrayElementInfo = new JFFlowArrayElementInfo();
            jFFlowArrayElementInfo.m_name = this.m_name;
            jFFlowArrayElementInfo.m_index = n3++;
            String string = jFFlowArrayElementInfo.m_name + "(" + jFFlowArrayElementInfo.m_index + ")";
            this.m_element.put(string, jFFlowArrayElementInfo);
            JFDebug.println("createElements: added: <" + string + ">");
        }
    }

    void updateElement(String string, int n, Date date, Date date2, String string2) {
        if (null == this.m_element) {
            return;
        }
        if (!this.m_element.containsKey(string)) {
            JFDebug.println("JFFlowArrayInstance:updateElement: m_element doesn't contain: <" + string + ">");
            return;
        }
        JFFlowArrayElementInfo jFFlowArrayElementInfo = (JFFlowArrayElementInfo)this.m_element.get(string);
        JFDebug.println("updateElement: m_element contains: <" + string + ">");
        jFFlowArrayElementInfo.m_state = n;
        if (jFFlowArrayElementInfo.m_state == 1) {
            jFFlowArrayElementInfo.m_startTime = date;
        } else if (jFFlowArrayElementInfo.m_state == 2 || jFFlowArrayElementInfo.m_state == 3 || jFFlowArrayElementInfo.m_state == 4) {
            jFFlowArrayElementInfo.m_finishTime = date2;
            if (string2 != null) {
                try {
                    jFFlowArrayElementInfo.m_exitCode = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public JFFlow getFlowDefinition() {
        return this.m_flowDefinition;
    }

    public String getOwner() {
        return this.m_owner;
    }

    public JFFlowArray getFlowArrayDefinition() {
        return this.m_flowArrayDefinition;
    }

    public String getName() {
        return this.m_name;
    }

    public int getState() {
        return this.m_state;
    }

    public int getExitCode() {
        return this.m_exitCode;
    }

    public Date getStartTime() {
        if (this.m_startTime != null) {
            return this.m_startTime.getTime();
        }
        return null;
    }

    public Date getFinishTime() {
        if (this.m_finishTime != null) {
            return this.m_finishTime.getTime();
        }
        return null;
    }

    public void setState(int n) {
        this.m_state = n;
    }

    public void setExitCode(int n) {
        this.m_exitCode = n;
    }

    void setStartTime(JFTime jFTime) {
        this.m_startTime = jFTime;
    }

    void setFinishTime(JFTime jFTime) {
        this.m_finishTime = jFTime;
    }

    public boolean isFinished() {
        return this.m_state == 2 || this.m_state == 3 || this.m_state == 4;
    }

    public JFEventInstance[] getEventInstances() {
        if (this.events == null) {
            return new JFEventInstance[0];
        }
        JFEventInstance[] jFEventInstanceArray = new JFEventInstance[this.events.size()];
        this.events.toArray(jFEventInstanceArray);
        return jFEventInstanceArray;
    }

    public JFFlowArrayElementInfo[] getElementInfo() {
        if (this.m_element == null) {
            return null;
        }
        return this.m_element.values().toArray(new JFFlowArrayElementInfo[0]);
    }

    void fromXML(Node node) throws JFException {
        this.fromXML(node, null);
    }

    void fromXML(Node node, JFFlow jFFlow) throws JFException {
        Hashtable hashtable = new Hashtable();
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        JFVersion jFVersion = JFConfigManager.getServerVersion();
        if (jFVersion != null && jFVersion.compareTo("5.5") < 0) {
            bl = true;
        }
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Object object;
            Node node2 = node.getChildNodes().item(i);
            if (node2.getNodeName().equals("flowDefinition")) {
                object = new JFXMLSource(node2.getFirstChild());
                this.m_flowDefinition = ((JFXMLSource)object).createFlow();
            }
            if (node2.getNodeName().equals("name")) {
                this.m_name = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("owner")) {
                this.m_owner = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("state")) {
                this.m_state = Integer.parseInt(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("statusCode")) {
                this.m_exitCode = Integer.parseInt(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("startTime")) {
                if (bl) {
                    try {
                        this.m_startTime = new JFTime(JFDateTimeParser.oldParse(node2.getFirstChild().getNodeValue()));
                    }
                    catch (ParseException parseException) {
                        JFDebug.println("JFFlowInstance::fromXML: wrong format of startTime " + parseException.getMessage());
                    }
                } else {
                    this.m_startTime = new JFTime(node2.getFirstChild());
                }
            }
            if (node2.getNodeName().equals("finishTime")) {
                if (bl) {
                    try {
                        this.m_finishTime = new JFTime(JFDateTimeParser.oldParse(node2.getFirstChild().getNodeValue()));
                    }
                    catch (ParseException parseException) {
                        JFDebug.println("JFFlowInstance::fromXML: wrong format of startTime " + parseException.getMessage());
                    }
                } else {
                    this.m_finishTime = new JFTime(node2.getFirstChild());
                }
            }
            if (node2.getNodeName().equals("ItemlocalVars")) {
                object = node2.getChildNodes();
                for (int j = 0; j < object.getLength(); ++j) {
                    Element element = (Element)object.item(j);
                    if (element == null || !"item".equals(element.getNodeName())) continue;
                    String string = JFXMLSource.decodeXML(element.getAttribute("varName"));
                    String string2 = JFXMLSource.decodeXML(element.getAttribute("varValue"));
                    if (string == null || string2 == null) continue;
                    this.m_localVariables.put(string, string2);
                }
            }
            if (node2.getNodeName().equals("firstElement")) {
                this.m_firstElement = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("lastElement")) {
                this.m_lastElement = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("elements")) {
                this.createElementInfo(node2);
            }
            if (!node2.getNodeName().equals("events")) continue;
            this.eventsFromXML_(node2, jFFlow);
        }
        if (this.m_owner == null) {
            this.m_owner = this.getUserByFlowArrayName(this.m_flowDefinition.getName());
        }
        this.m_flowArrayDefinition = new JFFlowArray(this.m_name, this.m_flowDefinition, this.m_firstElement, this.m_lastElement);
        if (jFFlow != null) {
            this.initializeEventInstances(jFFlow);
        }
    }

    String getUserByFlowArrayName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        int n = string.indexOf(58);
        string2 = n != -1 ? string.substring(0, n) : JFLoginManager.getUserName();
        return string2;
    }

    protected void createElementInfo(Node node) {
        if (node.getChildNodes().getLength() == 0) {
            JFDebug.println("No element info");
            return;
        }
        this.m_element = new HashMap();
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            JFFlowArrayElementInfo jFFlowArrayElementInfo = new JFFlowArrayElementInfo();
            jFFlowArrayElementInfo.m_name = this.m_name;
            Node node2 = node.getChildNodes().item(i);
            for (int j = 0; j < node2.getChildNodes().getLength(); ++j) {
                String string;
                String string2;
                Element element;
                int n;
                Properties properties;
                NodeList nodeList;
                Node node3 = node2.getChildNodes().item(j);
                if (node3.getNodeName().equals("index")) {
                    jFFlowArrayElementInfo.m_index = Integer.parseInt(node3.getFirstChild().getNodeValue());
                    if (this.firstIndex == 0 || this.firstIndex > jFFlowArrayElementInfo.m_index) {
                        this.firstIndex = jFFlowArrayElementInfo.m_index;
                    }
                    if (this.lastIndex == 0 || this.lastIndex < jFFlowArrayElementInfo.m_index) {
                        this.lastIndex = jFFlowArrayElementInfo.m_index;
                    }
                }
                if (node3.getNodeName().equals("state")) {
                    jFFlowArrayElementInfo.m_state = Integer.parseInt(node3.getFirstChild().getNodeValue());
                }
                if (node3.getNodeName().equals("statusCode")) {
                    jFFlowArrayElementInfo.m_exitCode = Integer.parseInt(node3.getFirstChild().getNodeValue());
                }
                if (node3.getNodeName().equals("startTime")) {
                    jFFlowArrayElementInfo.m_startTime = new JFTime(node3.getFirstChild()).getTime();
                }
                if (node3.getNodeName().equals("finishTime")) {
                    jFFlowArrayElementInfo.m_finishTime = new JFTime(node3.getFirstChild()).getTime();
                }
                if (node3.getNodeName().equals("localVars")) {
                    nodeList = node3.getChildNodes();
                    properties = new Properties();
                    for (n = 0; n < nodeList.getLength(); ++n) {
                        element = (Element)nodeList.item(n);
                        if (element == null || !"item".equals(element.getNodeName())) continue;
                        string2 = JFXMLSource.decodeXML(element.getAttribute("varName"));
                        string = JFXMLSource.decodeXML(element.getAttribute("varValue"));
                        if (string2 == null || string == null) continue;
                        properties.put(string2, string);
                    }
                    this.localVarsMap.put(new Long(jFFlowArrayElementInfo.m_index), properties);
                }
                if (!node3.getNodeName().equals("inputVars")) continue;
                nodeList = node3.getChildNodes();
                properties = new Properties();
                for (n = 0; n < nodeList.getLength(); ++n) {
                    element = (Element)nodeList.item(n);
                    if (element == null || !"item".equals(element.getNodeName())) continue;
                    string2 = JFXMLSource.decodeXML(element.getAttribute("varName"));
                    string = JFXMLSource.decodeXML(element.getAttribute("varValue"));
                    if (string2 == null || string == null) continue;
                    properties.put(string2, string);
                }
                this.inputVarsMap.put(new Long(jFFlowArrayElementInfo.m_index), properties);
            }
            String string = jFFlowArrayElementInfo.m_name + "(" + jFFlowArrayElementInfo.m_index + ")";
            this.m_element.put(string, jFFlowArrayElementInfo);
        }
    }

    protected void eventsFromXML_(Node node, JFFlow jFFlow) throws JFException {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            JFEvent jFEvent;
            JFEventInstance jFEventInstance = new JFEventInstance();
            jFEventInstance.fromXML(node.getChildNodes().item(i));
            JFEvent jFEvent2 = jFEventInstance.getEventDefinition();
            String string = jFEvent2.getEventGeneratorType();
            if (string.equals("lsf") || string.equals("manual") || string.equals("otherbatch") || string.equals("local")) {
                jFEvent = (JFJobEvent)jFEvent2;
                jFEvent.m_jobRef = jFFlow.getJob(jFEvent.m_jobName);
            } else if (string.equals("variable")) {
                jFEvent = (JFVariableEvent)jFEvent2;
                ((JFVariableEvent)jFEvent).m_jobRef = jFFlow.getJob(((JFVariableEvent)jFEvent).m_jobName);
            } else if (string.equals("link")) {
                jFEvent = (JFLinkEvent)jFEvent2;
                jFEventInstance = new JFLinkEventInstance();
                jFEventInstance.fromXML(node.getChildNodes().item(i));
                ((JFLinkEvent)jFEventInstance.eventDefinition).m_linkJobRef = jFFlow.getJob(((JFLinkEvent)jFEvent).m_linkJobName);
            } else if (string.equals("flow")) {
                jFEvent = (JFFlowEvent)jFEvent2;
                ((JFFlowEvent)jFEvent).m_flowRef = jFFlow.getFlow(((JFFlowEvent)jFEvent).m_flowName);
            } else if (string.equals("jobarray")) {
                jFEvent = (JFJobArrayEvent)jFEvent2;
                ((JFJobArrayEvent)jFEvent).m_jobArrRef = jFFlow.getJobArray(((JFJobArrayEvent)jFEvent).m_jobArrName);
            } else if (string.equals("job_except")) {
                jFEvent = (JFJobExceptionEvent)jFEvent2;
                ((JFJobExceptionEvent)jFEvent).m_jobRef = jFFlow.getJob(((JFJobExceptionEvent)jFEvent).m_jobName);
            } else if (string.equals("jobarray_except")) {
                jFEvent = (JFJobArrayExceptionEvent)jFEvent2;
                ((JFJobArrayExceptionEvent)jFEvent).m_jobArrRef = jFFlow.getJobArray(((JFJobArrayExceptionEvent)jFEvent).m_jobArrName);
            } else if (string.equals("flow_except")) {
                jFEvent = (JFFlowExceptionEvent)jFEvent2;
                ((JFFlowExceptionEvent)jFEvent).m_flowRef = jFFlow.getFlow(((JFFlowExceptionEvent)jFEvent).m_flowName);
            } else if (string.equals("flowarray")) {
                jFEvent = (JFFlowArrayEvent)jFEvent2;
                ((JFFlowArrayEvent)jFEvent).m_flowArrRef = jFFlow.getFlowArray(((JFFlowArrayEvent)jFEvent).m_flowArrName);
            } else if (string.equals("flowarray_except")) {
                jFEvent = (JFFlowArrayExceptionEvent)jFEvent2;
                ((JFFlowArrayExceptionEvent)jFEvent).m_flowArrRef = jFFlow.getFlowArray(((JFFlowArrayExceptionEvent)jFEvent).m_flowArrName);
            }
            this.events.add(jFEventInstance);
        }
    }

    protected void initializeEventInstances(JFFlow jFFlow) {
        Iterator iterator = jFFlow.getEvents(this.getFlowDefinition().getName());
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            JFEventInstance jFEventInstance;
            JFEvent jFEvent = (JFEvent)iterator.next();
            Iterator iterator2 = this.events.iterator();
            if (iterator2 == null) continue;
            boolean bl = false;
            while (iterator2.hasNext()) {
                jFEventInstance = (JFEventInstance)iterator2.next();
                if (!jFEventInstance.getEventDefinition().equals(jFEvent)) continue;
                if (jFEventInstance instanceof JFLinkEventInstance) {
                    jFEventInstance.eventDefinition = jFEvent;
                }
                bl = true;
                break;
            }
            if (bl) continue;
            jFEventInstance = null;
            jFEventInstance = !jFEvent.getEventGeneratorType().equals("link") ? new JFEventInstance() : new JFLinkEventInstance();
            jFEventInstance.eventDefinition = jFEvent;
            this.events.add(jFEventInstance);
        }
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public Properties getItemLocalVariables() {
        return this.m_localVariables;
    }

    public Properties getLocalVariables(int n) {
        return (Properties)this.localVarsMap.get(new Long(n));
    }

    public Properties getInputVariables(int n) {
        return (Properties)this.inputVarsMap.get(new Long(n));
    }

    void setFirstElement(String string) {
        this.m_firstElement = string;
    }

    void setLastElement(String string) {
        this.m_lastElement = string;
    }

    void putLocalVars(Long l, Properties properties) {
        this.localVarsMap.put(l, properties);
    }

    void putInputVars(Long l, Properties properties) {
        this.inputVarsMap.put(l, properties);
    }

    void setFlowDefinition(JFFlow jFFlow) {
        this.m_flowDefinition = jFFlow;
    }

    void setOwner(String string) {
        this.m_owner = string;
    }

    void setName(String string) {
        this.m_name = string;
    }

    void addJFEventInstance(JFEventInstance jFEventInstance) {
        this.events.add(jFEventInstance);
    }

    void setJFFlowArray(JFFlowArray jFFlowArray) {
        this.m_flowArrayDefinition = jFFlowArray;
    }

    String getFirstElement() {
        return this.m_firstElement;
    }

    String getLastElement() {
        return this.m_lastElement;
    }

    void putJFFlowArrayElementInfo(JFFlowArrayElementInfo jFFlowArrayElementInfo) {
        if (this.m_element == null) {
            this.m_element = new HashMap();
        }
        String string = jFFlowArrayElementInfo.m_name + "(" + jFFlowArrayElementInfo.m_index + ")";
        this.m_element.put(string, jFFlowArrayElementInfo);
    }

    void setFirstIndex(int n) {
        this.firstIndex = n;
    }

    void setLastIndex(int n) {
        this.lastIndex = n;
    }

    void setItemLocalVariables(Properties properties) {
        this.m_localVariables = properties;
    }
}

