/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

class JFDateTimeParser {
    public static final String INVALID_DATE_FORMAT = "000 000 00 00:00:00 0 0000";
    private SimpleDateFormat m_formatter;

    static String format(Date date, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", new Locale("en"));
        if (timeZone != null) {
            simpleDateFormat.setTimeZone(timeZone);
        }
        return simpleDateFormat.format(date);
    }

    public JFDateTimeParser(String string) {
        this.m_formatter = new SimpleDateFormat(string, new Locale("en"));
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone != null) {
            this.m_formatter.setTimeZone(timeZone);
        }
    }

    public Date parse(String string) throws ParseException {
        return this.m_formatter.parse(string);
    }

    static Date oldParse(String string) throws ParseException {
        if (string.equals(INVALID_DATE_FORMAT)) {
            return null;
        }
        return new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", new Locale("en")).parse(string);
    }
}

