/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFAdminManager;
import com.platform.LSFJobFlow.api.JFAlarmDef;
import com.platform.LSFJobFlow.api.JFAlarmInfo;
import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFilter;
import com.platform.LSFJobFlow.api.JFHistory;
import com.platform.LSFJobFlow.api.JFHistoryManager;
import com.platform.LSFJobFlow.api.JFHistoryRecord;
import com.platform.LSFJobFlow.api.JFStatusListener;
import com.platform.LSFJobFlow.api.JFTime;
import com.platform.LSFJobFlow.api.JFUpdateMsg;
import java.util.HashMap;

public class JFAlarmView
extends JFStatusListener {
    private static final String m_szTopic = "js_alarms";
    JFAdminManager m_adminMgr = null;
    JFHistoryManager m_histMgr = null;
    private JFFilter m_filter = null;
    private HashMap m_alarmMap = new HashMap();
    private static Object mutex = new Object();

    public JFAlarmView() throws Exception {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JFAlarmView(JFFilter jFFilter) throws Exception {
        this.m_filter = jFFilter;
        this.m_adminMgr = new JFAdminManager();
        this.m_histMgr = new JFHistoryManager();
        Object object = mutex;
        synchronized (object) {
            this.refresh();
        }
    }

    @Override
    public void registerWithJMS() {
    }

    @Override
    public void unregisterWithJMS() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Object object = mutex;
        synchronized (object) {
            this.m_alarmMap.clear();
            this.getInfoFromDaemon();
        }
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStatusUpdate(JFUpdateMsg jFUpdateMsg) {
        String string = "JFAlarmView::onStatusUpdate";
        JFDebug.println("Entered: " + string);
        Object object = mutex;
        synchronized (object) {
            String string2 = jFUpdateMsg.getAttributeValue("Name");
            String string3 = jFUpdateMsg.getAttributeValue("AlarmName");
            JFDebug.println(string + ": Operation: <" + jFUpdateMsg.getOperation() + ">" + "Name: <" + string2 + ">" + "alarmName: <" + string3 + ">");
            if (jFUpdateMsg.getOperation().equals("Add")) {
                try {
                    String string4 = jFUpdateMsg.getAttributeValue("Description");
                    String string5 = jFUpdateMsg.getAttributeValue("Type");
                    String string6 = jFUpdateMsg.getAttributeValue("Notification");
                    String string7 = jFUpdateMsg.getAttributeValue("FinishTime");
                    String string8 = jFUpdateMsg.getAttributeValue("Output");
                    string7 = new JFTime(string7).getTimeString();
                    JFAlarmInfo jFAlarmInfo = new JFAlarmInfo(string3, string5, string4, string6, string7, string8);
                    this.m_alarmMap.put(string3, jFAlarmInfo);
                }
                catch (Exception exception) {
                    JFDebug.printStackTrace(exception);
                }
            } else if (jFUpdateMsg.getOperation().equals("Remove")) {
                this.m_alarmMap.remove(string3);
            }
        }
        this.setChanged();
        this.notifyObservers();
        JFDebug.println("Finished: " + string);
    }

    @Override
    public void setFilter(JFFilter jFFilter) {
        this.m_filter = jFFilter;
    }

    @Override
    public void removeFilter() {
        this.setFilter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JFAlarmInfo[] getAlarmList() {
        Object object = mutex;
        synchronized (object) {
            return this.m_alarmMap.values().toArray(new JFAlarmInfo[0]);
        }
    }

    public void finalize() {
    }

    private void getInfoFromDaemon() {
        Object object;
        String string = "SELECT * from Alarm";
        if (this.m_filter != null && (object = this.m_filter.getUser()) != null && !((String)object).equals("")) {
            string = string + " WHERE USERNAME=" + (String)object;
        }
        object = null;
        try {
            object = this.m_histMgr.getHistoryObject(string);
        }
        catch (JFException jFException) {
            JFDebug.println("ignore the exception since it is called from fresh\n" + jFException);
        }
        catch (Exception exception) {
            JFDebug.printStackTrace(exception);
            return;
        }
        if (object == null) {
            return;
        }
        JFHistoryRecord[] jFHistoryRecordArray = ((JFHistory)object).getRecords();
        if (jFHistoryRecordArray.length <= 0) {
            return;
        }
        JFAlarmDef[] jFAlarmDefArray = null;
        try {
            jFAlarmDefArray = this.m_adminMgr.getAlarmDefinitions();
        }
        catch (Exception exception) {
            JFDebug.printStackTrace(exception);
        }
        for (int i = 0; i < jFHistoryRecordArray.length; ++i) {
            String string2 = jFHistoryRecordArray[i].getUser();
            String string3 = jFHistoryRecordArray[i].getTime();
            String string4 = jFHistoryRecordArray[i].getKey();
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String[] stringArray = jFHistoryRecordArray[i].getActionData();
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].indexOf("Type") == 0) {
                    string5 = stringArray[j].substring(stringArray[j].indexOf(61) + 1);
                    continue;
                }
                if (stringArray[j].indexOf("Description") == 0) {
                    string6 = stringArray[j].substring(stringArray[j].indexOf(61) + 1);
                    continue;
                }
                if (stringArray[j].indexOf("Output") == 0) {
                    string7 = stringArray[j].substring(stringArray[j].indexOf(61) + 1);
                    continue;
                }
                if (string7 == null) continue;
                string7 = string7 + "\n" + stringArray[j];
            }
            JFAlarmInfo jFAlarmInfo = new JFAlarmInfo(string4, string5, string6, this.getNotificationField(jFAlarmDefArray, string5), string3, string7);
            this.m_alarmMap.put(string4, jFAlarmInfo);
        }
    }

    private String getNotificationField(JFAlarmDef[] jFAlarmDefArray, String string) {
        if (jFAlarmDefArray == null || string == null) {
            return null;
        }
        JFAlarmDef jFAlarmDef = null;
        for (int i = 0; i < jFAlarmDefArray.length; ++i) {
            if (!string.equalsIgnoreCase(jFAlarmDefArray[i].getName())) continue;
            jFAlarmDef = jFAlarmDefArray[i];
            break;
        }
        if (jFAlarmDef != null && jFAlarmDef.getNotificationAddress() != null) {
            return jFAlarmDef.getNotificationMethod() + "[" + ((Object)jFAlarmDef.getNotificationAddress()).toString() + "]";
        }
        return null;
    }
}

