/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.job;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.job.JobObject;
import com.sas.metadata.logical.job.RB;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.UpgradeLogicalObjectVersionAction;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.WAGeneralPropertyTab;
import com.sas.workspace.visuals.WsGenericGeneralPropertyTab;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;

public class JobObjectFactory
implements ObjectFactoryInterface {
    private TypeInterface m_type;
    private Factory m_factory;

    public JobObjectFactory(TypeInterface type, Factory factory) {
        this.m_type = type;
        this.m_factory = factory;
    }

    public Factory getFactory() {
        return this.m_factory;
    }

    public LogicalObjectInterface createItemFromMetadataObject(Root mdo) throws RemoteException {
        return new JobObject((Job)mdo, this.m_type, this.m_factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllObjects(String sRepositoryFQID) throws MdException, RemoteException {
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("<Templates><");
            sb.append(this.m_type.getMetadataType());
            sb.append(" ");
            sb.append(this.m_factory.getTemplateFormOfRequiredAndNeededAttributes(this.m_type));
            sb.append("/></Templates>");
            int fFlags = 260;
            List lJobs = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, sRepositoryFQID, "Job", fFlags, sb.toString());
            ArrayList<LogicalObjectInterface> lObjects = new ArrayList<LogicalObjectInterface>(lJobs.size());
            for (int iJob = 0; iJob < lJobs.size(); ++iJob) {
                lObjects.add(this.createItemFromMetadataObject((Root)((Job)lJobs.get(iJob))));
            }
            ArrayList<LogicalObjectInterface> arrayList = lObjects;
            return arrayList;
        }
        finally {
            store.dispose();
        }
    }

    public List getPropertyTabs(LogicalObjectInterface lob, Root mdo, Config config) throws MdException, RemoteException {
        ArrayList<Object> lTabs = new ArrayList<Object>(2);
        WAGeneralPropertyTab tabGeneral = new WAGeneralPropertyTab((CMetadata)mdo, "", false, false, true, true);
        WsGenericGeneralPropertyTab tabAdvanced = new WsGenericGeneralPropertyTab((CMetadata)mdo);
        tabGeneral.setName(RB.getStringResource("JobObjectFactory.General.txt"));
        tabAdvanced.setName(RB.getStringResource("JobObjectFactory.Advanced.txt"));
        lTabs.add(tabGeneral);
        lTabs.add(tabAdvanced);
        return lTabs;
    }

    public Action[] getActions(LogicalObjectInterface lobData, Root mdoData, Config config) {
        Action[] upgradeActions = new Action[]{};
        if (lobData != null && lobData.getTypeInterface().getPublicType().equals(this.m_type.getPublicType())) {
            upgradeActions = UpgradeLogicalObjectVersionAction.getActions((Frame)this.getFactory().getFrame(), (LogicalObjectInterface)lobData, (Root)mdoData);
        }
        return upgradeActions;
    }

    public Action[] getActions(LogicalObjectInterface[] aLogicalObjects, Root[] aObjects, Config config) {
        return UpgradeLogicalObjectVersionAction.NO_ACTIONS;
    }
}

