/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.job;

import com.sas.metadata.logical.BaseLogicalObject;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.job.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.util.UsageVersion;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.LinkedList;

public class JobObject
extends BaseLogicalObject {
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    public static final UsageVersion FAILED_MIGRATION_VERSION = new UsageVersion(0, 5);

    public JobObject(Job mdoJob, TypeInterface type, Factory factory) throws RemoteException {
        super((Root)mdoJob, type, factory);
        this.setCompatibility(FAILED_MIGRATION_VERSION, CURRENT_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(OperationUserInteractionInterface deleteInterface) throws LogicalTypeException, RemoteException {
        if (!this.isDeleteAllowed()) {
            throw new UnsupportedOperationException("This object cannot be deleted.");
        }
        String progressText = this.getProgressMessageForDelete();
        deleteInterface.updateProgress(progressText);
        MdObjectStore store = null;
        Job job = null;
        try {
            MdFactory metadataFactory = this.getFactory().getMdFactory();
            store = Workspace.getMdFactory().createObjectStore(null, "JobObject:delete:" + this.getID());
            job = (Job)store.getFactory().createComplexMetadataObject(store, this.getName(), this.getTypeInterface().getMetadataType(), this.getID());
            if (deleteInterface.isUserInteractionSupported()) {
                int i;
                AssociationList lStoredProcesses;
                AssociationList lJFJobs = job.getJFJobs();
                boolean bAssociationsExist = this.hasJFJobsOrStoredProcesses(lJFJobs, lStoredProcesses = job.getTransformationSources());
                if (!bAssociationsExist) {
                    boolean bl = super.delete(deleteInterface);
                    return bl;
                }
                LinkedList<LogicalObjectInterface> logicalToDelete = new LinkedList<LogicalObjectInterface>();
                for (i = 0; i < lJFJobs.size(); ++i) {
                    JFJob jfJob = (JFJob)lJFJobs.get(i);
                    LogicalObjectInterface loi = Factory.getInstance().getObject((Root)jfJob);
                    if (loi == null) continue;
                    logicalToDelete.add(loi);
                }
                if (lStoredProcesses.size() > 0) {
                    for (i = 0; i < lStoredProcesses.size(); ++i) {
                        LogicalObjectInterface loi;
                        ClassifierMap classifierMap;
                        Object o = lStoredProcesses.get(i);
                        if (!(o instanceof ClassifierMap) || (classifierMap = (ClassifierMap)o).getPublicType().compareToIgnoreCase("StoredProcess") != 0 || (loi = Factory.getInstance().getObject((Root)classifierMap)) == null) continue;
                        logicalToDelete.add(loi);
                    }
                }
                String sMessage = UtilMisc.getMessage((String)RB.getStringResource("JobObject.DeleteDeploymentsAlso.fmt"), (Object)this.getTypeInterface().getDisplayType(), (Object)this.getName());
                int eAnswer = deleteInterface.displayMessage(RB.getStringResource("JobObject.DeleteReleatedObjects.title.txt"), sMessage, 3, OperationUserInteractionInterface.YES_NO_CANCEL_CHOICE_SET);
                if (eAnswer == 0) {
                    for (LogicalObjectInterface loi : logicalToDelete) {
                        loi.delete(deleteInterface);
                    }
                    metadataFactory.deleteMetadataObject((CMetadata)job);
                } else if (eAnswer == 3) {
                    metadataFactory.deleteMetadataObject((CMetadata)job);
                } else if (eAnswer == 2) {
                    boolean bl = false;
                    return bl;
                }
            } else {
                metadataFactory.deleteMetadataObject((CMetadata)job);
            }
            boolean lJFJobs = true;
            return lJFJobs;
        }
        catch (Exception e) {
            if (deleteInterface.continueOperationWithPrompting()) {
                String folderName = "";
                try {
                    BrowseMetadataInterface browse = this.getBrowseObject();
                    folderName = this.getFolderLocation(browse);
                }
                catch (Exception browse) {
                    // empty catch block
                }
                String messageText = null;
                messageText = folderName.length() == 0 ? UtilMisc.getMessage((String)RB.getStringResource("BLO.DelExcpOccrdNoFolder.fmt.txt"), (Object)this._ti.getDisplayType(), (Object)this.getName(), (Object)UtilMisc.getExceptionMessageText((Exception)e)) : UtilMisc.getMessage((String)RB.getStringResource("BLO.DelExcpOccrd.fmt.txt"), (Object)this._ti.getDisplayType(), (Object)this.getName(), (Object)folderName, (Object)UtilMisc.getExceptionMessageText((Exception)e));
                if (deleteInterface.isUserInteractionSupported()) {
                    int choice = deleteInterface.displayMessage(RB.getStringResource("BLO.DelDlgTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                    OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)deleteInterface, (int)choice);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (store != null) {
                store.dispose();
            }
        }
    }

    private boolean hasJFJobsOrStoredProcesses(AssociationList lJFJobs, AssociationList lStoredProcesses) throws RemoteException {
        boolean bAssociationsExist = false;
        if (lJFJobs.size() > 0) {
            bAssociationsExist = true;
        }
        if (!bAssociationsExist && lStoredProcesses.size() > 0) {
            for (int i = 0; i < lStoredProcesses.size() && !bAssociationsExist; ++i) {
                ClassifierMap classifierMap;
                Object classObject = lStoredProcesses.get(i);
                if (!(classObject instanceof ClassifierMap) || (classifierMap = (ClassifierMap)classObject).getPublicType().compareToIgnoreCase("StoredProcess") != 0) continue;
                bAssociationsExist = true;
            }
        }
        return bAssociationsExist;
    }

    public boolean isExportAllowed() throws LogicalTypeException {
        boolean exportAllowed = true;
        UsageVersion uv = this.getUsageVersion();
        if (uv != null && uv.encode() < CURRENT_VERSION.encode()) {
            exportAllowed = false;
        }
        if (exportAllowed) {
            exportAllowed = super.isExportAllowed();
        }
        return exportAllowed;
    }

    public boolean isRenameAllowed() throws LogicalTypeException {
        boolean renameAllowed = true;
        UsageVersion uv = this.getUsageVersion();
        if (uv != null && uv.encode() < CURRENT_VERSION.encode()) {
            renameAllowed = false;
        }
        if (renameAllowed) {
            renameAllowed = super.isRenameAllowed();
        }
        return renameAllowed;
    }
}

