/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.job;

import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.job.JobConnectionManager;
import com.sas.metadata.logical.job.JobExportItem;
import com.sas.metadata.logical.job.JobImportListener;
import com.sas.metadata.logical.job.RB;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ContentHelper;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.TransportException;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.StringHolder;

public class JobExportListener
extends AbstractExportListener {
    JobConnectionManager m_manager = new JobConnectionManager();

    public JobExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return JobImportListener.CONNECTION_TYPES;
    }

    public int exportContent(ExportOperationInterface operation, List objects) throws TransportException, IOException, MdException, RemoteException {
        Log exportLogger = operation.getLogger();
        int iRC = 0;
        HashMap mapContentInfo = new HashMap();
        HashMap mapPackages = new HashMap();
        ArrayList jobContentList = new ArrayList();
        int iOptions = 284;
        for (ExportItemInterface jobExportItem : objects) {
            this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("JobExportListener.StatusIndicator.fmt"), (Object)jobExportItem.getName()));
            Job mdJob = (Job)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), "Job", jobExportItem.getID(), null, null, "<Templates><AbstractTransformation><JobActivities/><SourceCode/><Steps/><Transformations/><TransformationSources/><TransformationTargets/></AbstractTransformation><File><DeployedComponents/></File></Templates>", iOptions);
            if (mdJob == null) continue;
            this.searchJobForContent(mdJob, jobExportItem, mapContentInfo, jobContentList, exportLogger);
        }
        for (ServerContext mdSC : mapContentInfo.keySet()) {
            int iTempRC;
            List lContentInfo = (List)mapContentInfo.get(mdSC);
            if (lContentInfo == null || lContentInfo.isEmpty() || (iTempRC = this.retrieveContentFromServer(mdSC, lContentInfo, mapPackages, operation, exportLogger)) <= iRC) continue;
            iRC = iTempRC;
        }
        return iRC;
    }

    public ExportItemInterface createExportItem(String name, String id, TransportableTypeInterface type) {
        return new JobExportItem(name, id, type);
    }

    private boolean searchJobForContent(Job mdJob, ExportItemInterface jobExportItem, Map mapContentInfo, List jobContentList, Log exportLogger) throws MdException, RemoteException {
        AssociationList lActivities;
        AssociationList lJobTargets;
        String sJobName = jobExportItem.getName();
        String sJobID = jobExportItem.getID();
        boolean bContentFound = this.addContentInfoToMap(mapContentInfo, (AbstractTransformation)mdJob, sJobName, sJobID, exportLogger);
        AssociationList lJobSources = mdJob.getTransformationSources();
        if (lJobSources != null) {
            for (Object mdJobSource : lJobSources) {
                if (!(mdJobSource instanceof AbstractTransformation)) continue;
                bContentFound |= this.addContentInfoToMap(mapContentInfo, (AbstractTransformation)mdJobSource, mdJob.getName(), sJobID, exportLogger);
            }
        }
        if ((lJobTargets = mdJob.getTransformationTargets()) != null) {
            for (Object mdJobTarget : lJobTargets) {
                if (!(mdJobTarget instanceof AbstractTransformation)) continue;
                bContentFound |= this.addContentInfoToMap(mapContentInfo, (AbstractTransformation)mdJobTarget, mdJob.getName(), sJobID, exportLogger);
            }
        }
        if ((lActivities = mdJob.getJobActivities()).isEmpty()) {
            return bContentFound;
        }
        TransformationActivity mdActivity = (TransformationActivity)lActivities.get(0);
        AssociationList lSteps = mdActivity.getSteps();
        for (TransformationStep mdStep : lSteps) {
            AssociationList lStepTargets;
            bContentFound |= this.addContentInfoToMap(mapContentInfo, (AbstractTransformation)mdStep, mdJob.getName(), sJobID, exportLogger);
            AssociationList lStepSources = mdStep.getTransformationSources();
            if (lStepSources != null) {
                for (Object mdStepSource : lStepSources) {
                    if (!(mdStepSource instanceof AbstractTransformation)) continue;
                    bContentFound |= this.addContentInfoToMap(mapContentInfo, (AbstractTransformation)mdStepSource, mdJob.getName(), sJobID, exportLogger);
                }
            }
            if ((lStepTargets = mdStep.getTransformationTargets()) != null) {
                for (Object mdStepTarget : lStepTargets) {
                    if (!(mdStepTarget instanceof AbstractTransformation)) continue;
                    bContentFound |= this.addContentInfoToMap(mapContentInfo, (AbstractTransformation)mdStepTarget, mdJob.getName(), sJobID, exportLogger);
                }
            }
            AssociationList lTransformations = mdStep.getTransformations();
            for (Transformation mdTransformation : lTransformations) {
                if (mdTransformation instanceof Job) continue;
                bContentFound |= this.addContentInfoToMap(mapContentInfo, (AbstractTransformation)mdTransformation, mdJob.getName(), sJobID, exportLogger);
            }
        }
        if (bContentFound) {
            jobContentList.add(jobExportItem.getID());
        }
        return bContentFound;
    }

    private boolean addContentInfoToMap(Map mapContentInfo, AbstractTransformation mdAT, String sJobName, String sJobID, Log exportLogger) throws MdException, RemoteException {
        Text mdText = mdAT.getSourceCode();
        if (mdText instanceof File) {
            File mdFile = (File)mdText;
            AssociationList lSCs = mdFile.getDeployedComponents();
            if (lSCs.isEmpty()) {
                if (exportLogger.isDebugEnabled()) {
                    exportLogger.debug((Object)("No ServerContext found on File object " + mdFile.getFQID()));
                }
                return false;
            }
            ServerContext mdSC = (ServerContext)lSCs.get(0);
            ArrayList<JobContentInfo> lContentInfo = (ArrayList<JobContentInfo>)mapContentInfo.get(mdSC);
            if (lContentInfo == null) {
                lContentInfo = new ArrayList<JobContentInfo>();
                mapContentInfo.put(mdSC, lContentInfo);
            }
            lContentInfo.add(new JobContentInfo(sJobName, sJobID, mdFile.getFileName()));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int retrieveContentFromServer(ServerContext mdSC, List lContentInfo, Map mapPackages, ExportOperationInterface operation, Log exportLogger) throws RemoteException {
        int iRC = 0;
        WsAppServer appServer = null;
        try {
            appServer = ContentHelper.openAppServerConnection((PromotionInterface)operation, (ServerContext)mdSC);
            ContentHandlerInterface contentHandler = operation.getContentHandler();
            int iCounter = 0;
            HashSet<String> processedFilePaths = new HashSet<String>();
            for (JobContentInfo jobContentInfo : lContentInfo) {
                if (processedFilePaths.contains(jobContentInfo.m_sPath)) continue;
                processedFilePaths.add(jobContentInfo.m_sPath);
                try {
                    IFileService fileService = appServer.getWorkspace().FileService();
                    IFileref fileRef = fileService.AssignFileref("TEMP" + iCounter++, "DISK", jobContentInfo.m_sPath, "", new StringHolder());
                    IBinaryStream inStream = fileRef.OpenBinaryStream(StreamOpenMode.StreamOpenModeForReading);
                    InputStream stream = contentHandler.getInputStream(inStream);
                    contentHandler.addBinaryContent(jobContentInfo.m_sID, jobContentInfo.m_sPath, stream);
                    exportLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("JobExportListener.ExportInfo.fmt"), (Object)jobContentInfo.m_sPath, (Object)mdSC.getName(), (Object)jobContentInfo.m_sName));
                }
                catch (Exception e) {
                    iRC = 4;
                    exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("JobExportListener.ExportError.fmt"), (Object)jobContentInfo.m_sPath, (Object)mdSC.getName(), (Object)jobContentInfo.m_sName, (Object)e.getMessage()));
                }
            }
        }
        catch (WsAppServerFailException e) {
            iRC = 8;
            exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("JobExportListener.ServerError.fmt"), (Object)mdSC.getName(), (Object)e.getMessage()));
        }
        finally {
            if (appServer != null) {
                appServer.dispose();
            }
        }
        return iRC;
    }

    public int analyzeConnections(ExportOperationInterface operation, List objects) throws MdException, RemoteException {
        return this.m_manager.analyzeJobObjectConnectionsOnExport(this, operation, objects);
    }

    Job getJobMetadatObject(MdObjectStore mdStore, ExportItemInterface jobImportItem, int iOptions) throws RemoteException, MdException {
        return (Job)mdStore.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "Job", jobImportItem.getID(), null, null, "<Templates><Job><JobActivities/></Job><TransformationActivity><Steps/></TransformationActivity><TransformationStep><Transformations/></TransformationStep><ClassifierMap><TriggeredEvents/></ClassifierMap><Event><SourceTransformations/></Event><FeatureMap><FeatureSources/></FeatureMap><Column><Table/></Column></Templates>", iOptions);
    }

    private class JobContentInfo {
        String m_sName;
        String m_sID;
        String m_sPath;

        JobContentInfo(String sName, String sID, String sPath) {
            this.m_sName = sName;
            this.m_sID = sID;
            this.m_sPath = sPath;
        }
    }
}

