/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.job;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObject;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.common.PrivateObjectImportUtility;
import com.sas.metadata.logical.document.DocumentUtil;
import com.sas.metadata.logical.job.JobUtil;
import com.sas.metadata.logical.note.NoteUtil;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.ConditionActionSet;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.Feature;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MiningResult;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.WorkTable;
import com.sas.services.ServiceException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JobExportItem
extends DefaultExportItem
implements RelatedObjectsInterface {
    public JobExportItem(String name, String id, TransportableTypeInterface type) {
        super(name, id, type);
    }

    public List getRelatedObjects(int relationshipType) throws LogicalTypeException {
        try {
            ArrayList<Object> lLogicalObjects = new ArrayList<Object>();
            HashSet<Object> setMDObjects = new HashSet<Object>();
            MdObjectStore mdStore = this._exportOperation.getMetadataFactory().createObjectStore(null, "JobExportItem.getRelatedObjects");
            int iOptions = 284;
            try {
                Job mdJob = (Job)this._exportOperation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "Job", this.getID(), null, null, "<Templates><Job><Documents/><JobActivities/><Notes/></Job><ClassifierMap><ClassifierSources/><ClassifierTargets/><SourceSpecifications/></ClassifierMap><TransformationActivity><Steps/></TransformationActivity><TransformationStep><Documents/><Notes/><Transformations/></TransformationStep><WorkTable><TablePackage/></WorkTable></Templates>", iOptions);
                if (mdJob == null) {
                    throw new LogicalTypeException("Couldn't find corresponding metadata object for job \"" + this.getName() + "\".");
                }
                if (relationshipType == 0) {
                    lLogicalObjects.addAll(NoteUtil.getDependentNotes((Root)mdJob));
                    lLogicalObjects.addAll(DocumentUtil.getDependentDocuments((Root)mdJob));
                    List promptUsedLogical = PrivateObjectImportUtility.getLogicalObjectsUsedByPrompts((PromotionInterface)this._exportOperation, (Root)mdJob);
                    lLogicalObjects.addAll(promptUsedLogical);
                    AssociationList caSets = mdJob.getConditionActionSets();
                    for (ConditionActionSet cas : caSets) {
                        SimpleLogicalObjectInterface logicalCAS;
                        ConditionActionSet protoCAS = cas.getPrototypeConditionActionSet();
                        if (protoCAS == null || (logicalCAS = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)protoCAS)) == null) continue;
                        lLogicalObjects.add(logicalCAS);
                    }
                    AssociationList lActivities = mdJob.getJobActivities();
                    if (!lActivities.isEmpty()) {
                        TransformationActivity mdActivity = (TransformationActivity)lActivities.get(0);
                        AssociationList tTargets = mdActivity.getTransformationTargets();
                        for (Root metaObj : tTargets) {
                            SimpleLogicalObjectInterface logicalUser = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)metaObj);
                            if (logicalUser == null) continue;
                            lLogicalObjects.add(logicalUser);
                        }
                        AssociationList lSteps = mdActivity.getSteps();
                        for (TransformationStep mdStep : lSteps) {
                            this.addPromptSourceDependenciesFromCMorTS((Root)mdStep, lLogicalObjects);
                            List tsPromptsUsedLogical = PrivateObjectImportUtility.getLogicalObjectsUsedByPrompts((PromotionInterface)this._exportOperation, (Root)mdJob);
                            lLogicalObjects.addAll(tsPromptsUsedLogical);
                            lLogicalObjects.addAll(NoteUtil.getDependentNotes((Root)mdStep));
                            lLogicalObjects.addAll(DocumentUtil.getDependentDocuments((Root)mdStep));
                            Prototype mdPrototype = JobUtil.getGeneratedTransform(mdStep);
                            if (mdPrototype != null) {
                                SimpleLogicalObject prototypeItem = new SimpleLogicalObject(mdPrototype.getName(), mdPrototype.getFQID(), Factory.getInstance().locateTypeInterfaceForRoot((Root)mdPrototype));
                                lLogicalObjects.add(prototypeItem);
                            }
                            AssociationList caTsSets = mdStep.getConditionActionSets();
                            for (ConditionActionSet cas : caTsSets) {
                                SimpleLogicalObjectInterface logicalCAS;
                                ConditionActionSet protoCAS = cas.getPrototypeConditionActionSet();
                                if (protoCAS == null || (logicalCAS = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)protoCAS)) == null) continue;
                                lLogicalObjects.add(logicalCAS);
                            }
                            AssociationList lCMs = mdStep.getTransformations();
                            for (Transformation mdTransformation : lCMs) {
                                SimpleLogicalObject resultItem;
                                DataTable table;
                                AssociationList featureSources;
                                if (mdTransformation instanceof Job) {
                                    if (!setMDObjects.add(mdTransformation)) continue;
                                    SimpleLogicalObject jobItem = new SimpleLogicalObject(mdTransformation.getName(), mdTransformation.getFQID(), Factory.getInstance().locateTypeInterfaceForRoot((Root)mdTransformation));
                                    lLogicalObjects.add(jobItem);
                                    continue;
                                }
                                if (!(mdTransformation instanceof ClassifierMap)) continue;
                                ClassifierMap mdCM = (ClassifierMap)mdTransformation;
                                this.addPromptSourceDependenciesFromCMorTS((Root)mdCM, lLogicalObjects);
                                AssociationList lResults = mdCM.getSourceSpecifications();
                                for (Root mdResult : lResults) {
                                    Transformation t;
                                    if (mdResult instanceof MiningResult) {
                                        SimpleLogicalObject resultItem2 = new SimpleLogicalObject(mdResult.getName(), mdResult.getFQID(), Factory.getInstance().locateTypeInterfaceForRoot(mdResult));
                                        lLogicalObjects.add(resultItem2);
                                        continue;
                                    }
                                    if (!(mdResult instanceof Transformation) || (t = (Transformation)mdResult).getPublicType() == null || t.getPublicType().length() <= 0) continue;
                                    SimpleLogicalObject resultItem3 = new SimpleLogicalObject(mdResult.getName(), mdResult.getFQID(), Factory.getInstance().locateTypeInterfaceForRoot(mdResult));
                                    lLogicalObjects.add(resultItem3);
                                }
                                AssociationList events = mdCM.getTriggeredEvents();
                                for (Event event : events) {
                                    AssociationList srcTransformations = event.getSourceTransformations();
                                    for (AbstractTransformation trans : srcTransformations) {
                                        if (!(trans instanceof FeatureMap)) continue;
                                        FeatureMap fmap = (FeatureMap)trans;
                                        featureSources = fmap.getFeatureSources();
                                        for (Object colObject : featureSources) {
                                            if (!(colObject instanceof Column)) continue;
                                            Column col = (Column)colObject;
                                            table = col.getTable();
                                            resultItem = new SimpleLogicalObject(table.getName(), table.getFQID(), Factory.getInstance().locateTypeInterfaceForRoot((Root)table));
                                            lLogicalObjects.add(resultItem);
                                        }
                                    }
                                    AssociationList propertySets = event.getPropertySets();
                                    for (PropertySet propertySet : propertySets) {
                                        AssociationList setProperties = propertySet.getSetProperties();
                                        for (Property prop : setProperties) {
                                            AssociationList targetTrans = prop.getTargetTransformations();
                                            for (AbstractTransformation abstrans1 : targetTrans) {
                                                AssociationList transSources = abstrans1.getTransformationSources();
                                                for (Root rootSrc : transSources) {
                                                    if (!(rootSrc instanceof FeatureMap)) continue;
                                                    FeatureMap fm2 = (FeatureMap)rootSrc;
                                                    AssociationList featureSources2 = fm2.getFeatureSources();
                                                    for (Feature feature : featureSources2) {
                                                        if (!(feature instanceof Column)) continue;
                                                        Column column = (Column)feature;
                                                        DataTable table2 = column.getTable();
                                                        SimpleLogicalObject resultItem4 = new SimpleLogicalObject(table2.getName(), table2.getFQID(), Factory.getInstance().locateTypeInterfaceForRoot((Root)table2));
                                                        lLogicalObjects.add(resultItem4);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                AssociationList lSources = mdCM.getClassifierSources();
                                for (Classifier mdClassifier : lSources) {
                                    if ("Contents".equalsIgnoreCase(mdCM.getTransformRole())) {
                                        RelationalSchema mdRS = ((WorkTable)mdClassifier).getTablePackage();
                                        if (mdRS == null) continue;
                                        SASLibrary mdLibrary = null;
                                        if (mdRS instanceof SASLibrary) {
                                            mdLibrary = (SASLibrary)mdRS;
                                        } else {
                                            Object mdObject;
                                            AssociationList lLibraries = ((DatabaseSchema)mdRS).getUsedByPackages();
                                            if (lLibraries != null && !lLibraries.isEmpty() && (mdObject = lLibraries.get(0)) instanceof SASLibrary) {
                                                mdLibrary = (SASLibrary)mdObject;
                                            }
                                        }
                                        if (mdLibrary == null || !setMDObjects.add(mdLibrary)) continue;
                                        SimpleLogicalObject libraryItem = new SimpleLogicalObject(mdLibrary.getName(), mdLibrary.getFQID(), Factory.getInstance().locateTypeInterfaceForRoot((Root)mdLibrary));
                                        lLogicalObjects.add(libraryItem);
                                        continue;
                                    }
                                    this.checkClassifierForSupportedObject(mdClassifier, lLogicalObjects, setMDObjects);
                                }
                                AssociationList lTargets = mdCM.getClassifierTargets();
                                for (Classifier mdClassifier : lTargets) {
                                    this.checkClassifierForSupportedObject(mdClassifier, lLogicalObjects, setMDObjects);
                                }
                                AssociationList lFeatureMaps = mdCM.getFeatureMaps();
                                for (FeatureMap topFM : lFeatureMaps) {
                                    AssociationList lTransformationSrcs = topFM.getTransformationSources();
                                    for (Root rootTxFm : lTransformationSrcs) {
                                        if (!(rootTxFm instanceof FeatureMap)) continue;
                                        FeatureMap txFm = (FeatureMap)rootTxFm;
                                        AssociationList featureSources3 = txFm.getFeatureSources();
                                        for (Column srcCol : featureSources3) {
                                            DataTable table3 = srcCol.getTable();
                                            SimpleLogicalObject resultItem5 = new SimpleLogicalObject(table3.getName(), table3.getFQID(), Factory.getInstance().locateTypeInterfaceForRoot((Root)table3));
                                            lLogicalObjects.add(resultItem5);
                                        }
                                    }
                                    featureSources = topFM.getFeatureSources();
                                    for (Column srcCol : featureSources) {
                                        DataTable table4 = srcCol.getTable();
                                        SimpleLogicalObject resultItem6 = new SimpleLogicalObject(table4.getName(), table4.getFQID(), Factory.getInstance().locateTypeInterfaceForRoot((Root)table4));
                                        lLogicalObjects.add(resultItem6);
                                    }
                                    AssociationList featureTargets = topFM.getFeatureTargets();
                                    for (Column srcCol : featureTargets) {
                                        table = srcCol.getTable();
                                        resultItem = new SimpleLogicalObject(table.getName(), table.getFQID(), Factory.getInstance().locateTypeInterfaceForRoot((Root)table));
                                        lLogicalObjects.add(resultItem);
                                    }
                                }
                            }
                        }
                    }
                } else if (relationshipType == 1) {
                    AssociationList jobSteps = mdJob.getSteps();
                    for (TransformationStep step : jobSteps) {
                        AssociationList stepActivities = step.getActivities();
                        for (TransformationActivity activity : stepActivities) {
                            AssociationList jobs = activity.getJobs();
                            for (Job usedByJob : jobs) {
                                SimpleLogicalObjectInterface logicalUser = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)usedByJob);
                                if (logicalUser == null) continue;
                                lLogicalObjects.add(logicalUser);
                            }
                        }
                    }
                    AssociationList jfJobs = mdJob.getJFJobs();
                    for (JFJob jfJob : jfJobs) {
                        SimpleLogicalObjectInterface logicalUser = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)jfJob);
                        if (logicalUser == null) continue;
                        lLogicalObjects.add(logicalUser);
                    }
                    AssociationList lStoredProcesses = mdJob.getTransformationSources();
                    if (lStoredProcesses.size() > 0) {
                        for (int i = 0; i < lStoredProcesses.size(); ++i) {
                            SimpleLogicalObjectInterface logicalSP;
                            ClassifierMap classifierMap;
                            Object o = lStoredProcesses.get(i);
                            if (!(o instanceof ClassifierMap) || (classifierMap = (ClassifierMap)o).getPublicType().compareToIgnoreCase("StoredProcess") != 0 || (logicalSP = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)classifierMap)) == null) continue;
                            lLogicalObjects.add(logicalSP);
                        }
                    }
                }
            }
            catch (MdException mde) {
                throw new LogicalTypeException((Exception)((Object)mde));
            }
            catch (ServiceException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
            finally {
                mdStore.dispose();
            }
            return lLogicalObjects;
        }
        catch (RemoteException e) {
            throw new LogicalTypeException((Exception)e);
        }
    }

    private void checkClassifierForSupportedObject(Classifier mdClassifier, List lLogicalObjects, Set setMDObjects) throws LogicalTypeException, RemoteException {
        if (mdClassifier instanceof ExternalTable) {
            if (setMDObjects.add(mdClassifier)) {
                SimpleLogicalObject extFileItem = new SimpleLogicalObject(mdClassifier.getName(), mdClassifier.getFQID(), Factory.getInstance().locateTypeInterfaceForRoot((Root)mdClassifier));
                lLogicalObjects.add(extFileItem);
            }
        } else if (mdClassifier instanceof PhysicalTable && !(mdClassifier instanceof WorkTable) && setMDObjects.add(mdClassifier)) {
            SimpleLogicalObject tableItem = new SimpleLogicalObject(mdClassifier.getName(), mdClassifier.getFQID(), Factory.getInstance().locateTypeInterfaceForRoot((Root)mdClassifier));
            lLogicalObjects.add(tableItem);
        }
    }

    private void addPromptSourceDependenciesFromCMorTS(Root metaSrc, List lLogicalObjects) throws RemoteException, MdException, LogicalTypeException {
        AssociationList propertySets = metaSrc.getPropertySets();
        for (PropertySet pSet : propertySets) {
            AssociationList pSetProps = pSet.getProperties();
            for (Property prop : pSetProps) {
                AssociationList srcSpecs = prop.getSpecTargetTransformations();
                for (AbstractTransformation atransObj : srcSpecs) {
                    if (!(atransObj instanceof Transformation)) continue;
                    Transformation trans = (Transformation)atransObj;
                    AssociationList srcSpecFromTrans = trans.getSourceSpecifications();
                    for (Root rObject : srcSpecFromTrans) {
                        if (!(rObject instanceof PrimaryType)) continue;
                        SimpleLogicalObject resultItem = new SimpleLogicalObject(rObject.getName(), rObject.getFQID(), Factory.getInstance().locateTypeInterfaceForRoot(rObject));
                        lLogicalObjects.add(resultItem);
                    }
                }
            }
        }
    }
}

