/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.job;

import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.externalfile.ExternalFileUtil;
import com.sas.metadata.logical.job.JobExportListener;
import com.sas.metadata.logical.job.JobImportListener;
import com.sas.metadata.logical.job.RB;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPoint;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.Feature;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MiningResult;
import com.sas.metadata.remote.OrderByClause;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.RelationalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.Variable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class JobConnectionManager {
    private static final String PROPERTY_CASE_SENSITIVE_MATCH = "sas.promotion.columns.casesensitivemapping";
    private static final String MININGRESULT_SOURCE_ID = "MININGRESULT_SOURCE_ID";
    private static final String SOURCE_TABLE_SEARCH = "SOURCE_TABLE_SEARCH";
    private static final String LIBRARY = "LIBRARY";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String SOURCE_TABLE_ID = "SOURCE_TABLE_ID";

    int analyzeJobObjectConnectionsOnExport(JobExportListener listener, ExportOperationInterface operation, List objects) throws MdException, RemoteException {
        int rc = 0;
        int iOptions = 268;
        int index = 1;
        int importItemCount = objects.size();
        MdObjectStore mdStore = operation.getMetadataFactory().createObjectStore(null, "JobConnectionPointManager:analyzeExportConnections");
        try {
            HashMap<MiningResult, ArrayList<RelationalTable>> mapMiningResultMappings = new HashMap<MiningResult, ArrayList<RelationalTable>>();
            for (ExportItemInterface exportItem : objects) {
                listener.fireDisplayMessage(StatusMessageUtil.createStatusMessageForObject((TypeInterface)exportItem.getTypeInterface(), (String)exportItem.getName(), (int)index++, (int)importItemCount));
                operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("JobExportListener.AnalyzeConnections.fmt"), (Object)exportItem.getName()));
                Job mdJob = listener.getJobMetadatObject(mdStore, exportItem, iOptions);
                AssociationList activites = mdJob.getJobActivities();
                for (TransformationActivity transActivity : activites) {
                    AssociationList steps = transActivity.getSteps();
                    for (TransformationStep transStep : steps) {
                        AssociationList transformations = transStep.getTransformations();
                        for (Transformation transForm : transformations) {
                            AssociationList events = transForm.getTriggeredEvents();
                            for (Event event : events) {
                                AssociationList srcTransformations = event.getSourceTransformations();
                                for (AbstractTransformation atn : srcTransformations) {
                                    if (!(atn instanceof FeatureMap)) continue;
                                    FeatureMap fmap = (FeatureMap)atn;
                                    AssociationList featureSources = fmap.getFeatureSources();
                                    for (Object colObject : featureSources) {
                                        if (!(colObject instanceof Column)) continue;
                                        Column col = (Column)colObject;
                                        this.buildColumnConnectionPointForTable(operation, mdStore, exportItem, col);
                                    }
                                    AssociationList featureTargets = fmap.getFeatureTargets();
                                    for (Object colObject : featureTargets) {
                                        if (!(colObject instanceof Column)) continue;
                                        Column col = (Column)colObject;
                                        this.buildColumnConnectionPointForTable(operation, mdStore, exportItem, col);
                                    }
                                }
                                AssociationList propertySets = event.getPropertySets();
                                for (PropertySet propertySet : propertySets) {
                                    AssociationList setProperties = propertySet.getSetProperties();
                                    for (Property prop : setProperties) {
                                        AssociationList targetTrans = prop.getTargetTransformations();
                                        for (AbstractTransformation abstrans1 : targetTrans) {
                                            AssociationList transSources = abstrans1.getTransformationSources();
                                            for (Root rootSrc : transSources) {
                                                if (!(rootSrc instanceof FeatureMap)) continue;
                                                FeatureMap fm2 = (FeatureMap)rootSrc;
                                                AssociationList featureSources = fm2.getFeatureSources();
                                                for (Feature feature : featureSources) {
                                                    if (!(feature instanceof Column)) continue;
                                                    Column col = (Column)feature;
                                                    this.buildColumnConnectionPointForTable(operation, mdStore, exportItem, col);
                                                }
                                                AssociationList featureTargets = fm2.getFeatureTargets();
                                                for (Feature feature : featureTargets) {
                                                    if (!(feature instanceof Column)) continue;
                                                    Column col = (Column)feature;
                                                    this.buildColumnConnectionPointForTable(operation, mdStore, exportItem, col);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (!(transForm instanceof ClassifierMap)) continue;
                            ClassifierMap cm = (ClassifierMap)transForm;
                            this.examineClassifierMap(cm, operation, mdStore, exportItem);
                            AssociationList sourceSpecifications = cm.getSourceSpecifications();
                            for (Root rObject : sourceSpecifications) {
                                if (!(rObject instanceof MiningResult)) continue;
                                MiningResult mr = (MiningResult)rObject;
                                AssociationList tables = mr.getTransformationSources();
                                for (Root rTableObject : tables) {
                                    if (!(rTableObject instanceof RelationalTable)) continue;
                                    RelationalTable rTable = (RelationalTable)rTableObject;
                                    ArrayList<RelationalTable> mrTables = (ArrayList<RelationalTable>)mapMiningResultMappings.get(mr);
                                    if (mrTables == null) {
                                        mrTables = new ArrayList<RelationalTable>();
                                        mapMiningResultMappings.put(mr, mrTables);
                                    }
                                    mrTables.add(rTable);
                                }
                            }
                        }
                    }
                }
            }
            for (MiningResult mr : mapMiningResultMappings.keySet()) {
                List Tables = (List)mapMiningResultMappings.get(mr);
                for (RelationalTable tableObject : Tables) {
                    ConnectionPointInterface tableCP = operation.getConnectionManager().getConnection(tableObject.getId());
                    if (tableCP == null) continue;
                    tableCP.addUserDefinedProperty(MININGRESULT_SOURCE_ID, mr.getId());
                }
            }
        }
        catch (MdException mde) {
            throw mde;
        }
        finally {
            mdStore.dispose();
        }
        return rc;
    }

    private void examineFeatureMap(FeatureMap fm, ExportOperationInterface operation, MdObjectStore mdStore, ExportItemInterface exportItem) throws MdException, RemoteException {
        AssociationList ltsSources = fm.getTransformationSources();
        for (Root srcRoot : ltsSources) {
            if (!(srcRoot instanceof FeatureMap)) continue;
            FeatureMap innerFm = (FeatureMap)srcRoot;
            AssociationList lftrsrcs = innerFm.getFeatureSources();
            for (Column col : lftrsrcs) {
                this.buildColumnConnectionPointForTable(operation, mdStore, exportItem, col);
            }
            AssociationList lftrtgts = innerFm.getFeatureTargets();
            for (Column col : lftrtgts) {
                this.buildColumnConnectionPointForTable(operation, mdStore, exportItem, col);
            }
        }
        AssociationList ltsTargets = fm.getTransformationTargets();
        for (Root srcRoot : ltsTargets) {
            if (!(srcRoot instanceof FeatureMap)) continue;
            String transformRole = ((FeatureMap)srcRoot).getTransformRole();
            if (!transformRole.equalsIgnoreCase("lookup data")) break;
            FeatureMap innerFm = (FeatureMap)srcRoot;
            AssociationList lftrsrcs1 = innerFm.getFeatureSources();
            for (Column col : lftrsrcs1) {
                this.buildColumnConnectionPointForTable(operation, mdStore, exportItem, col);
            }
            AssociationList lftrtgts1 = innerFm.getFeatureTargets();
            for (Column col : lftrtgts1) {
                this.buildColumnConnectionPointForTable(operation, mdStore, exportItem, col);
            }
        }
        AssociationList lftrsrcs = fm.getFeatureSources();
        for (Column col : lftrsrcs) {
            this.buildColumnConnectionPointForTable(operation, mdStore, exportItem, col);
        }
        AssociationList lftrtgts = fm.getFeatureTargets();
        for (Column col : lftrtgts) {
            this.buildColumnConnectionPointForTable(operation, mdStore, exportItem, col);
        }
        AssociationList lsubvars = fm.getSubstitutionVariables();
        for (Object objVar : lsubvars) {
            Column col;
            if (!(objVar instanceof Variable)) continue;
            Variable subVar = (Variable)objVar;
            Root assocObj = subVar.getAssociatedObject();
            if (assocObj instanceof FeatureMap) {
                FeatureMap varFM = (FeatureMap)assocObj;
                this.examineFeatureMap(varFM, operation, mdStore, exportItem);
            }
            if (!(assocObj instanceof Column)) continue;
            col = (Column)assocObj;
            this.buildColumnConnectionPointForTable(operation, mdStore, exportItem, col);
        }
    }

    private void examineClassifierMap(ClassifierMap cm, ExportOperationInterface operation, MdObjectStore mdStore, ExportItemInterface exportItem) throws MdException, RemoteException {
        Select select;
        OrderByClause orderby;
        AssociationList featureMaps = cm.getFeatureMaps();
        for (FeatureMap fm : featureMaps) {
            this.examineFeatureMap(fm, operation, mdStore, exportItem);
        }
        if (cm instanceof Select && null != (orderby = (select = (Select)cm).getOrderByForSelect())) {
            AssociationList ordercolumns = orderby.getColumns();
            for (Column col : ordercolumns) {
                this.buildColumnConnectionPointForTable(operation, mdStore, exportItem, col);
            }
        }
        AssociationList transformationSources = cm.getTransformationSources();
        for (Root rObject : transformationSources) {
            if (!(rObject instanceof ClassifierMap)) continue;
            ClassifierMap internalCM = (ClassifierMap)rObject;
            this.examineClassifierMap(internalCM, operation, mdStore, exportItem);
        }
    }

    private void buildColumnConnectionPointForTable(ExportOperationInterface operation, MdObjectStore mdStore, ExportItemInterface exportItem, Column col) throws RemoteException, MdException {
        ConnectionPointInterface colCp = operation.getConnectionManager().getConnection(col.getId());
        String colCpPublicType = colCp.getPublicType();
        if (colCp != null && (colCpPublicType == null || colCpPublicType.equals("Column"))) {
            DataTable table = col.getTable();
            ConnectionPointInterface tableCp = operation.getConnectionManager().getConnection(table.getId());
            if (tableCp == null) {
                String path = mdStore.getFactory().getOMIUtil().getObjectPath(mdStore, (PrimaryType)table, true);
                tableCp = operation.getConnectionManager().createConnection(table.getCMetadataType(), table.getId(), table.getName());
                tableCp.setSourcePath(path);
                tableCp.setPublicType(table.getPublicType());
                tableCp.addAssociatedObject((PromotionItemInterface)exportItem);
                String sColumnSearch = colCp.getSourceSearchString();
                String sTableSearch = "[Table/*";
                int iStartIndex = sColumnSearch.indexOf(sTableSearch) + sTableSearch.length();
                sTableSearch = sColumnSearch.substring(iStartIndex);
                sTableSearch = sTableSearch.replaceFirst("]/", "][");
                sTableSearch = '*' + sTableSearch;
                tableCp.addSourceSearch(sTableSearch);
            } else {
                tableCp.addAssociatedObject((PromotionItemInterface)exportItem);
            }
            colCp.addUserDefinedProperty(SOURCE_TABLE_ID, table.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int updateColumnAssociations(ImportOperationInterface operation, MdFactory factory, List lConnectionPoints, List lUpdatedConnections) throws RemoteException, MetadataPromotionException {
        boolean bl;
        int iRC = 0;
        ArrayList<Object> lColumnCPs = new ArrayList<Object>();
        ArrayList<ConnectionPointInterface> lTableCPs = new ArrayList<ConnectionPointInterface>();
        ArrayList<ConnectionPointInterface> lIndexCPs = new ArrayList<ConnectionPointInterface>();
        for (ConnectionPointInterface connectionPointInterface : lConnectionPoints) {
            if ("Column".equals(connectionPointInterface.getMetadataType())) {
                lColumnCPs.add(connectionPointInterface);
                continue;
            }
            if ("PhysicalTable".equals(connectionPointInterface.getMetadataType())) {
                lTableCPs.add(connectionPointInterface);
                continue;
            }
            if ("ExternalTable".equals(connectionPointInterface.getMetadataType())) {
                lTableCPs.add(connectionPointInterface);
                continue;
            }
            if (!"Index".equals(connectionPointInterface.getMetadataType())) continue;
            lIndexCPs.add(connectionPointInterface);
        }
        if (operation.getPackageFileVersion() < 9200) {
            for (ConnectionPoint connectionPoint : lTableCPs) {
                Map tableMap;
                Map tableMapping;
                ImportItemInterface importedTable;
                Map deseletionItemsMap;
                String id = connectionPoint.getSourceID();
                String string = connectionPoint.getTargetID();
                if (string == null || string.equals(id) || (deseletionItemsMap = operation.getDeselectedItems()) == null || (importedTable = this.getDeselectedImportItem(operation, id)) == null || importedTable.getImportState() != 0 || (tableMapping = (Map)(tableMap = operation.getAssociationsForObject((PromotionItemInterface)importedTable, "<Template><PhysicalTable Name=\"\" ><Columns><Column Name=\"\" SASColumnType=\"\"></Column></Columns></PhysicalTable><RelationalTable Name=\"\" ><Columns><Column Name=\"\" SASColumnType=\"\"></Column></Columns></RelationalTable></Template>")).get(importedTable.getID())) == null) continue;
                List columns = (List)tableMapping.get("Columns");
                for (Map columnMap : columns) {
                    ConnectionPoint connPoint;
                    String columnId = (String)columnMap.get("Id");
                    if (columnId == null || (connPoint = (ConnectionPoint)operation.getConnectionManager().getConnection(columnId)) == null) continue;
                    this.activateConnectionPoint((ConnectionPointInterface)connPoint);
                    if (lColumnCPs.contains(connPoint)) continue;
                    lColumnCPs.add(connPoint);
                }
            }
        }
        HashMap<String, ArrayList<ConnectionPointInterface>> mapIndexes = new HashMap<String, ArrayList<ConnectionPointInterface>>();
        for (ConnectionPointInterface cpIndex : lIndexCPs) {
            String string = this.getIndexTableSearchString(cpIndex);
            if (StringUtils.isEmpty((CharSequence)string)) continue;
            ArrayList<ConnectionPointInterface> lIndexes = (ArrayList<ConnectionPointInterface>)mapIndexes.get(string);
            if (lIndexes != null) {
                lIndexes.add(cpIndex);
                continue;
            }
            lIndexes = new ArrayList<ConnectionPointInterface>();
            lIndexes.add(cpIndex);
            mapIndexes.put(string, lIndexes);
        }
        HashMap<String, ArrayList<ConnectionPointInterface>> hashMap = new HashMap<String, ArrayList<ConnectionPointInterface>>();
        for (ConnectionPointInterface connectionPointInterface : lColumnCPs) {
            String sColumnSearch = connectionPointInterface.getSourceSearchString();
            String sTableSearch = "[Table/*";
            int iStartIndex = sColumnSearch.indexOf(sTableSearch) + sTableSearch.length();
            sTableSearch = sColumnSearch.substring(iStartIndex);
            sTableSearch = sTableSearch.replaceFirst("]/", "][");
            sTableSearch = '*' + sTableSearch;
            ArrayList<ConnectionPointInterface> lColumns = (ArrayList<ConnectionPointInterface>)hashMap.get(sTableSearch);
            if (lColumns != null) {
                lColumns.add(connectionPointInterface);
                continue;
            }
            lColumns = new ArrayList<ConnectionPointInterface>();
            lColumns.add(connectionPointInterface);
            hashMap.put(sTableSearch, lColumns);
        }
        MdObjectStore mdStore = factory.createObjectStore(null, "JobImportListener:TableConnectionPanel:updateColumnAssociations");
        boolean bl2 = true;
        String caseValue = System.getProperty(PROPERTY_CASE_SENSITIVE_MATCH);
        if (caseValue != null && (caseValue.equalsIgnoreCase("true") || caseValue.equalsIgnoreCase("y"))) {
            bl = false;
            operation.getLogger().debug((Object)"Applying case-sensitive matching during column mapping.");
        }
        try {
            DataTable mdTable;
            for (String sTableSearch : mapIndexes.keySet()) {
                mdTable = null;
                for (ConnectionPointInterface cpTable : lTableCPs) {
                    if (!sTableSearch.equals(cpTable.getSourceSearchString())) continue;
                    if (cpTable.getTargetID() == null || null != (mdTable = (DataTable)mdStore.getObject(cpTable.getTargetID()))) break;
                    mdTable = (DataTable)factory.createComplexMetadataObject(mdStore, cpTable.getName(), cpTable.getMetadataType(), cpTable.getTargetID());
                    break;
                }
                if (mdTable == null || !(mdTable instanceof PhysicalTable)) continue;
                PhysicalTable ptTable = (PhysicalTable)mdTable;
                List lSourceIndexes = (List)mapIndexes.get(sTableSearch);
                ArrayList lTargetIndexes = new ArrayList(ptTable.getIndexes());
                if (lSourceIndexes == null || lSourceIndexes.isEmpty() || lTargetIndexes == null || lTargetIndexes.isEmpty()) continue;
                block12: for (ConnectionPointInterface cpIndex : lSourceIndexes) {
                    String sIndexName = cpIndex.getName();
                    Iterator iterTargetIndexes = lTargetIndexes.iterator();
                    while (iterTargetIndexes.hasNext()) {
                        Index mdIndex = (Index)iterTargetIndexes.next();
                        if (!this.isMatchingName(sIndexName, mdIndex.getName(), bl)) continue;
                        this.activateConnectionPoint(cpIndex);
                        cpIndex.setTargetID(mdIndex.getFQID());
                        lUpdatedConnections.add(cpIndex);
                        iterTargetIndexes.remove();
                        continue block12;
                    }
                }
            }
            for (String sTableSearch : hashMap.keySet()) {
                mdTable = null;
                for (ConnectionPointInterface cpTable : lTableCPs) {
                    if (!sTableSearch.equals(cpTable.getSourceSearchString())) continue;
                    if (cpTable.getTargetID() == null || null != (mdTable = (DataTable)mdStore.getObject(cpTable.getTargetID()))) break;
                    mdTable = (DataTable)factory.createComplexMetadataObject(mdStore, cpTable.getName(), cpTable.getMetadataType(), cpTable.getTargetID());
                    break;
                }
                if (mdTable == null) continue;
                List lSourceColumns = (List)hashMap.get(sTableSearch);
                ArrayList lTargetColumns = new ArrayList(mdTable.getColumns());
                if (lSourceColumns == null || lSourceColumns.isEmpty() || lTargetColumns == null || lTargetColumns.isEmpty()) continue;
                block16: for (ConnectionPointInterface cpColumn : lSourceColumns) {
                    String sColumnName = cpColumn.getName();
                    Iterator iterTargetColumns = lTargetColumns.iterator();
                    while (iterTargetColumns.hasNext()) {
                        Column mdColumn = (Column)iterTargetColumns.next();
                        if (!this.isMatchingName(sColumnName, mdColumn.getName(), bl)) continue;
                        cpColumn.setTargetID(mdColumn.getFQID());
                        lUpdatedConnections.add(cpColumn);
                        iterTargetColumns.remove();
                        continue block16;
                    }
                }
            }
            for (ConnectionPointInterface cp : lConnectionPoints) {
                String targetCPid;
                String targetTableId;
                String targetId;
                if (!cp.isActive() || (targetId = cp.getTargetID()) != null && targetId.length() != 0 || !cp.getMetadataType().equals("Column")) continue;
                ConnectionPointInterface tableCP = null;
                String tableID = cp.getUserDefinedProperty(SOURCE_TABLE_ID);
                if (tableID == null) {
                    String tableSearch = cp.getUserDefinedProperty(SOURCE_TABLE_SEARCH);
                    if (tableSearch != null) {
                        tableCP = this.getConnectionBySearchString(operation, tableSearch);
                    }
                } else {
                    tableCP = operation.getConnectionManager().getConnection(tableID);
                }
                if (tableCP == null || (targetTableId = tableCP.getTargetID()) == null) continue;
                DataTable mdTable2 = (DataTable)factory.createComplexMetadataObject(mdStore, tableCP.getName(), tableCP.getMetadataType(), targetTableId);
                AssociationList columns = mdTable2.getColumns();
                for (Column column : columns) {
                    if (!this.isMatchingName(column.getName(), cp.getName(), bl)) continue;
                    cp.setTargetID(column.getId());
                    break;
                }
                if ((targetCPid = cp.getTargetID()) != null && targetCPid.length() != 0) continue;
                operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.ColumnConnectionForTableNotFound.fmt"), (Object)tableCP.getName(), (Object)cp.getName()));
                iRC |= 4;
            }
        }
        catch (MdException mde) {
            operation.getLogger().error((Object)mde.getLocalizedMessage(), (Throwable)mde);
            iRC |= 8;
        }
        finally {
            mdStore.dispose();
        }
        return iRC;
    }

    private boolean isMatchingName(String name1, String name2, boolean ignoreCase) {
        return ignoreCase ? name1.equalsIgnoreCase(name2) : name1.equals(name2);
    }

    int updateMiningResultTables(ImportOperationInterface operation, MdFactory metadataFactory, List lConnectionPoints, List connections) throws MetadataPromotionException, RemoteException {
        int iRC = 0;
        try {
            int iOptions = 268;
            ArrayList<ConnectionPointInterface> lMiningResultsCps = new ArrayList<ConnectionPointInterface>();
            ArrayList<ConnectionPointInterface> lRelationalTables = new ArrayList<ConnectionPointInterface>();
            for (ConnectionPointInterface connPoint : lConnectionPoints) {
                if ("MiningResult".equals(connPoint.getMetadataType())) {
                    if (connPoint.getTargetID() != null) {
                        lMiningResultsCps.add(connPoint);
                        continue;
                    }
                    ImportItemInterface ii = operation.getImportItem(connPoint.getSourceID());
                    if (ii == null || ii.getTargetID() == null) continue;
                    connPoint.setTargetID(ii.getTargetID());
                    lMiningResultsCps.add(connPoint);
                    continue;
                }
                if (!"RelationalTable".equals(connPoint.getMetadataType())) continue;
                lRelationalTables.add(connPoint);
            }
            if (lMiningResultsCps.size() > 0) {
                for (ConnectionPointInterface tableCP : lRelationalTables) {
                    String miningresultTargetId;
                    ConnectionPointInterface mrCp;
                    String mrSrcId = tableCP.getUserDefinedProperty(MININGRESULT_SOURCE_ID);
                    String targetId = null;
                    if (mrSrcId != null && mrSrcId.length() > 0 && (mrCp = operation.getConnectionManager().getConnection(mrSrcId)) != null && (miningresultTargetId = mrCp.getTargetID()) != null && miningresultTargetId.length() > 0) {
                        MiningResult targetResult = (MiningResult)operation.getStore().getFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), "MiningResult", miningresultTargetId, null, null, "<Templates><MiningResults><TransformationSources/></MiningResults></Templates>", iOptions);
                        AssociationList srcTables = targetResult.getTransformationSources();
                        Iterator iterator2 = srcTables.iterator();
                        while (iterator2.hasNext() && targetId == null) {
                            Root srcTableObject = (Root)iterator2.next();
                            if (!(srcTableObject instanceof RelationalTable) || !srcTableObject.getName().equals(tableCP.getName())) continue;
                            targetId = srcTableObject.getId();
                        }
                    }
                    if (targetId == null) continue;
                    tableCP.setTargetID(targetId);
                }
            }
        }
        catch (MdException e) {
            throw new MetadataPromotionException((Throwable)e);
        }
        return iRC;
    }

    private void createTableCPforColumn(ImportOperationInterface operation, ImportItemInterface importItem, Map column) {
        ConnectionPointInterface colCP = operation.getConnectionManager().getConnection((String)column.get("Id"));
        if (colCP == null) {
            return;
        }
        if (colCP.getPublicType() != null && !colCP.getPublicType().equals("Column")) {
            return;
        }
        String sourceTableId = colCP.getUserDefinedProperty(SOURCE_TABLE_ID);
        if (sourceTableId != null && sourceTableId.length() > 0) {
            ConnectionPointInterface tableCP = operation.getConnectionManager().getConnection(sourceTableId);
            if (tableCP != null) {
                tableCP.addAssociatedObject((PromotionItemInterface)importItem);
            }
            return;
        }
        String columnSourceSearchString = colCP.getSourceSearchString();
        String libraryName = "";
        String tableSourceSearchString = "";
        String tableName = "";
        if (columnSourceSearchString.length() > 15) {
            int startIndex = columnSourceSearchString.lastIndexOf("Table/*[@Name='") + 15;
            if (startIndex > 15) {
                int startLNIndex;
                int endLNIndex;
                int tpIndex;
                int endIndex = columnSourceSearchString.indexOf("'", startIndex);
                tableName = columnSourceSearchString.substring(startIndex, endIndex);
                String searchString = "*[" + columnSourceSearchString.substring(startIndex - 7);
                int slashIndex = searchString.indexOf("/");
                if (slashIndex >= 0 && (tpIndex = (tableSourceSearchString = searchString.substring(0, slashIndex) + "[" + searchString.substring(slashIndex + 1, searchString.length())).lastIndexOf("TablePackage/*[@Name='")) > -1 && (endLNIndex = tableSourceSearchString.indexOf("'", startLNIndex = tableSourceSearchString.lastIndexOf("TablePackage/*[@Name='") + 22)) > startLNIndex) {
                    libraryName = tableSourceSearchString.substring(startLNIndex, endLNIndex);
                }
            }
        } else {
            operation.getLogger().debug((Object)("Invalid table search string for column: " + columnSourceSearchString));
            return;
        }
        List tables = (List)column.get("Table");
        if (tables != null && tables.size() > 0) {
            Map table = (Map)tables.get(0);
            String tableMetadataType = (String)table.get("MetadataObjectType");
            String tableId = (String)table.get("Id");
            ConnectionPointInterface tableCP = operation.getConnectionManager().getConnection(tableId);
            ImportItemInterface ii = operation.getImportItem(tableId);
            if (ii == null) {
                ii = this.getDeselectedImportItem(operation, tableId);
            }
            if (ii != null && ii.getImportState() != 0 && tableCP != null) {
                this.deActivateConnectionPoint(tableCP);
                this.setSourceTableId(colCP, tableId);
                return;
            }
            if (tableCP == null) {
                tableCP = operation.getConnectionManager().createConnection(tableMetadataType, tableId, (String)table.get("Name"));
                tableCP.addAssociatedObject((PromotionItemInterface)importItem);
                this.setSourceTableId(colCP, tableId);
                this.setConnectionPointPublicTypeFromMetadataType(tableMetadataType, tableCP);
                this.activateConnectionPoint(tableCP);
                tableCP.setDescription((String)table.get("Desc"));
                tableCP.addUserDefinedProperty(TABLE_NAME, (String)table.get("SASTableName"));
                tableCP.addUserDefinedProperty(LIBRARY, libraryName);
            } else {
                this.setSourceTableId(colCP, tableId);
                if (ii == null) {
                    this.activateConnectionPoint(tableCP);
                }
            }
        } else {
            ConnectionPointInterface tableCP = this.getConnectionBySearchString(operation, tableSourceSearchString);
            if (tableCP == null) {
                Map userProps;
                tableCP = this.getUnknownConnection(operation, tableSourceSearchString);
                if (tableCP != null && !(userProps = colCP.getUserDefinedProperties()).containsKey(SOURCE_TABLE_ID) && !userProps.containsKey(SOURCE_TABLE_SEARCH)) {
                    colCP.addUserDefinedProperty(SOURCE_TABLE_SEARCH, tableSourceSearchString);
                }
            } else {
                colCP.addUserDefinedProperty(SOURCE_TABLE_ID, tableCP.getSourceID());
            }
            if (tableCP == null && tableSourceSearchString.length() > 0) {
                tableCP = operation.getConnectionManager().createUnknownConnection("PhysicalTable", tableName);
                tableCP.addAssociatedObject((PromotionItemInterface)importItem);
                this.setConnectionPointPublicTypeFromMetadataType("PhysicalTable", tableCP);
                tableCP.addSourceSearch(tableSourceSearchString);
                colCP.addUserDefinedProperty(SOURCE_TABLE_SEARCH, tableSourceSearchString);
                this.activateConnectionPoint(tableCP);
                tableCP.addUserDefinedProperty(LIBRARY, libraryName);
            }
        }
    }

    private String getIndexTableSearchString(ConnectionPointInterface indexCP) {
        String tableSearchString;
        int startIndex;
        if (indexCP == null) {
            return null;
        }
        String columnSourceSearchString = indexCP.getSourceSearchString();
        String libraryName = "";
        String tableSourceSearchString = "";
        String tableName = "";
        String tableMarker = "OwningPhysicalTable/*[@Name='";
        if (StringUtils.contains((CharSequence)columnSourceSearchString, (CharSequence)tableMarker) && (startIndex = columnSourceSearchString.lastIndexOf(tableSearchString = tableMarker) + tableSearchString.length()) > tableMarker.length()) {
            int endIndex = columnSourceSearchString.indexOf("'", startIndex);
            tableName = columnSourceSearchString.substring(startIndex, endIndex);
            String searchString = "*[" + columnSourceSearchString.substring(startIndex - 7);
            int slashIndex = searchString.indexOf("/");
            if (slashIndex >= 0) {
                tableSourceSearchString = searchString.substring(0, slashIndex) + "[" + searchString.substring(slashIndex + 1, searchString.length());
            }
        }
        return tableSourceSearchString;
    }

    private ConnectionPointInterface getConnectionBySearchString(ImportOperationInterface operation, String tableSourceSearchString) {
        int indexOfDeplComp;
        ConnectionPointInterface tableCP = operation.getConnectionManager().getConnectionBySearchString(ConnectionObjectType.MetadataType, "PhysicalTable", tableSourceSearchString);
        if (tableCP == null && (tableCP = operation.getConnectionManager().getConnectionBySearchString(ConnectionObjectType.MetadataType, "ExternalTable", tableSourceSearchString)) == null) {
            tableCP = operation.getConnectionManager().getConnectionBySearchString(ConnectionObjectType.MetadataType, "RelationalTable", tableSourceSearchString);
        }
        if (tableCP == null && operation.getPackageFileVersion() < 9200 && (indexOfDeplComp = tableSourceSearchString.indexOf("/DeployedComponents/*")) > 0) {
            String newSearchString = tableSourceSearchString.substring(0, indexOfDeplComp);
            newSearchString = newSearchString + "]";
            tableCP = operation.getConnectionManager().getConnectionBySearchString(ConnectionObjectType.MetadataType, "PhysicalTable", newSearchString);
            if (tableCP == null && (tableCP = operation.getConnectionManager().getConnectionBySearchString(ConnectionObjectType.MetadataType, "ExternalTable", newSearchString)) == null) {
                tableCP = operation.getConnectionManager().getConnectionBySearchString(ConnectionObjectType.MetadataType, "RelationalTable", newSearchString);
            }
        }
        return tableCP;
    }

    private void setSourceTableId(ConnectionPointInterface colCP, String tableId) {
        String id;
        if (colCP != null && (id = colCP.getUserDefinedProperty(SOURCE_TABLE_ID)) == null) {
            colCP.addUserDefinedProperty(SOURCE_TABLE_ID, tableId);
        }
    }

    private void setConnectionPointPublicTypeFromMetadataType(String tableMetadataType, ConnectionPointInterface cp) {
        if (tableMetadataType != null) {
            if ("PhysicalTable".equals(tableMetadataType)) {
                cp.setPublicType("Table");
            } else if ("ExternalTable".equals(tableMetadataType)) {
                cp.setPublicType("ExternalFile");
            }
        }
    }

    private ConnectionPointInterface getUnknownConnection(ImportOperationInterface operation, String searchString) {
        ConnectionPointInterface returnValue = null;
        if (searchString != null && searchString.length() > 0) {
            List unknownConnections = operation.getConnectionManager().getUnknownConnections();
            Iterator iterator = unknownConnections.iterator();
            while (iterator.hasNext() && returnValue == null) {
                ConnectionPointInterface cpTest = (ConnectionPointInterface)iterator.next();
                if (!searchString.equals(cpTest.getSourceSearchString())) continue;
                returnValue = cpTest;
            }
        }
        return returnValue;
    }

    private void deActivateConnectionPoint(ConnectionPointInterface cp) {
        if (!cp.isActive() && !"RelationalTable".equals(cp.getMetadataType())) {
            ConnectionPoint cps = (ConnectionPoint)cp;
            cps.setActive(false);
        }
    }

    private void activateConnectionPoint(ConnectionPointInterface cp) {
        if (!cp.isActive() && !"RelationalTable".equals(cp.getMetadataType())) {
            ConnectionPoint cps = (ConnectionPoint)cp;
            cps.setActive(true);
        }
    }

    ImportItemInterface getDeselectedImportItem(ImportOperationInterface operation, String tableId) {
        ArrayList allObjects = new ArrayList();
        Map deselectedItems = operation.getDeselectedItems();
        if (deselectedItems != null) {
            Collection coll = operation.getDeselectedItems().values();
            Iterator<Object> iter = coll.iterator();
            while (iter.hasNext()) {
                allObjects.addAll((Collection)iter.next());
            }
            for (ImportItemInterface importItem : allObjects) {
                if (!tableId.equalsIgnoreCase(importItem.getID())) continue;
                return importItem;
            }
        }
        return null;
    }

    int analyzeJobObjectConnectionsOnImport(JobImportListener listener, ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        int index = 1;
        int importItemCount = objects.size();
        if (operation.getPackageFileVersion() > 9200) {
            for (ImportItemInterface importItem : objects) {
                listener.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)importItem.getTypeInterface(), (String)importItem.getName(), (int)index++, (int)importItemCount));
                ArrayList cpsCopy = new ArrayList(importItem.getConnectionPoints());
                for (ConnectionPointInterface pt : cpsCopy) {
                    ConnectionPointInterface tableCP;
                    String sourceTableId;
                    if (!"Column".equalsIgnoreCase(pt.getPublicType()) || (sourceTableId = pt.getUserDefinedProperty(SOURCE_TABLE_ID)) == null || sourceTableId.length() <= 0 || (tableCP = operation.getConnectionManager().getConnection(sourceTableId)) == null) continue;
                    tableCP.addAssociatedObject((PromotionItemInterface)importItem);
                }
            }
        } else {
            Map mapAllImportedJobs = operation.getAssociationsForObjects(objects, "<Template><Job Name=\"\"><JobActivities><TransformationActivity Name=\"\"><Steps><TransformationStep Name=\"\"><Transformations><ClassifierMap Name=\"\"><TriggeredEvents><Event Name=\"\"><SourceTransformations><FeatureMap Name=\"\"><FeatureSources><Column Name=\"\"><Table Name=\"\" Desc=\"\" SASTableName=\"\"/></Column></FeatureSources><FeatureTargets><Column Name=\"\"><Table Name=\"\" Desc=\"\" SASTableName=\"\"/></Column></FeatureTargets></FeatureMap></SourceTransformations><PropertySets><PropertySet Name=\"\"><SetProperties><Property Name=\"\"><TargetTransformations><FeatureMap Name=\"\"><TransformationSources><FeatureMap Name=\"\"><FeatureSources><Column Name=\"\"><Table Name=\"\" Desc=\"\" SASTableName=\"\"/></Column></FeatureSources><FeatureTargets><Column Name=\"\"><Table Name=\"\" Desc=\"\" SASTableName=\"\"/></Column></FeatureTargets></FeatureMap></TransformationSources></FeatureMap></TargetTransformations></Property></SetProperties></PropertySet></PropertySets></Event></TriggeredEvents><FeatureMaps><FeatureMap Name=\"\"><TransformationSources><FeatureMap Name=\"\"><FeatureSources><Column Name=\"\"><Table Name=\"\" Desc=\"\" SASTableName=\"\"/></Column></FeatureSources><FeatureTargets><Column Name=\"\"><Table Name=\"\" Desc=\"\" SASTableName=\"\"/></Column></FeatureTargets></FeatureMap></TransformationSources><FeatureTargets><Column Name=\"\"><Table Name=\"\" Desc=\"\" SASTableName=\"\"/></Column></FeatureTargets><FeatureSources><Column Name=\"\"><Table Name=\"\" Desc=\"\" SASTableName=\"\"/></Column></FeatureSources></FeatureMap></FeatureMaps></ClassifierMap></Transformations></TransformationStep></Steps></TransformationActivity></JobActivities></Job></Template>");
            for (ImportItemInterface importItem : objects) {
                List listJobSourceCode;
                listener.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)importItem.getTypeInterface(), (String)importItem.getName(), (int)index++, (int)importItemCount));
                Map mapJobInformation = (Map)mapAllImportedJobs.get(importItem.getID());
                if (mapJobInformation == null || (listJobSourceCode = (List)mapJobInformation.get("JobActivities")) == null) continue;
                for (Map transformationActivity : listJobSourceCode) {
                    List steps = (List)transformationActivity.get("Steps");
                    if (steps == null) continue;
                    for (int i = 0; i < steps.size(); ++i) {
                        Map step = (Map)steps.get(i);
                        List transformations = (List)step.get("Transformations");
                        if (transformations == null) continue;
                        for (Map transformation : transformations) {
                            List featureMaps;
                            List events = (List)transformation.get("TriggeredEvents");
                            if (events != null) {
                                for (Map event : events) {
                                    List propertySets;
                                    List srcTransformations = (List)event.get("SourceTransformations");
                                    if (srcTransformations != null) {
                                        for (Map featureMap : srcTransformations) {
                                            List featureTargets;
                                            List featureSources = (List)featureMap.get("FeatureSources");
                                            if (featureSources != null) {
                                                for (Map column : featureSources) {
                                                    this.createTableCPforColumn(operation, importItem, column);
                                                }
                                            }
                                            if ((featureTargets = (List)featureMap.get("FeatureTargets")) == null) continue;
                                            for (Map column : featureTargets) {
                                                this.createTableCPforColumn(operation, importItem, column);
                                            }
                                        }
                                    }
                                    if ((propertySets = (List)event.get("PropertySets")) == null) continue;
                                    for (Map propertySet : propertySets) {
                                        List setProperties = (List)propertySet.get("SetProperties");
                                        if (setProperties == null) continue;
                                        for (Map props : setProperties) {
                                            List targetTrans = (List)props.get("TargetTransformations");
                                            if (targetTrans == null) continue;
                                            for (Map fm1 : targetTrans) {
                                                List tsSrcs = (List)fm1.get("TransformationSources");
                                                if (tsSrcs == null) continue;
                                                for (Map fm2 : tsSrcs) {
                                                    List featureTargets;
                                                    List featureSrcs = (List)fm2.get("FeatureSources");
                                                    if (featureSrcs != null) {
                                                        for (Map column : featureSrcs) {
                                                            this.createTableCPforColumn(operation, importItem, column);
                                                        }
                                                    }
                                                    if ((featureTargets = (List)fm2.get("FeatureTargets")) == null) continue;
                                                    for (Map column : featureTargets) {
                                                        this.createTableCPforColumn(operation, importItem, column);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if ((featureMaps = (List)transformation.get("FeatureMaps")) == null) continue;
                            for (Map featureMap : featureMaps) {
                                List featureTargets;
                                List featureSources;
                                List transformationSources = (List)featureMap.get("TransformationSources");
                                if (transformationSources != null) {
                                    for (Map featureMaps2 : transformationSources) {
                                        List featureTargets2;
                                        List featureSources2 = (List)featureMaps2.get("FeatureSources");
                                        if (featureSources2 != null) {
                                            for (Map column : featureSources2) {
                                                this.createTableCPforColumn(operation, importItem, column);
                                            }
                                        }
                                        if ((featureTargets2 = (List)featureMaps2.get("FeatureTargets")) == null) continue;
                                        for (Map column : featureTargets2) {
                                            this.createTableCPforColumn(operation, importItem, column);
                                        }
                                    }
                                }
                                if ((featureSources = (List)featureMap.get("FeatureSources")) != null) {
                                    for (Map column : featureSources) {
                                        this.createTableCPforColumn(operation, importItem, column);
                                    }
                                }
                                if ((featureTargets = (List)featureMap.get("FeatureTargets")) == null) continue;
                                for (Map column : featureTargets) {
                                    this.createTableCPforColumn(operation, importItem, column);
                                }
                            }
                        }
                    }
                }
            }
        }
        return iRC;
    }

    private void setServerAndFileSubstitutions(JobImportListener jobImportListener, ImportOperationInterface operation, String pathName, Map fileSourceCode, List listServerContexts, ImportItemInterface importItem, ConnectionPointInterface unknownServerConnection, int count) {
        String serverName = null;
        String pathNameToUse = pathName;
        if (listServerContexts == null || listServerContexts.size() == 0) {
            if (unknownServerConnection == null) {
                unknownServerConnection = operation.getConnectionManager().createUnknownConnection("ServerContext", RB.getStringResource("JobImportListener.UNKNOWN.Object.fmt.txt"));
                String searchValue = "<Search Value=\"*[@ClassIdentifier='SAS Application Server' and @Name='" + unknownServerConnection.getName() + "']\"/>";
                unknownServerConnection.addSourceSearch(searchValue);
            }
            unknownServerConnection.addAssociatedObject((PromotionItemInterface)importItem);
            serverName = unknownServerConnection.getName();
        } else {
            Iterator serverIterator = listServerContexts.iterator();
            while (serverIterator.hasNext() && serverName == null) {
                Map serverObject = (Map)serverIterator.next();
                serverName = (String)serverObject.get("Name");
            }
        }
        String fileName = (String)fileSourceCode.get("FileName");
        if (count > 0) {
            pathNameToUse = jobImportListener.fixKeyForCount(pathName, count);
        }
        if (fileName != null && fileName.trim().length() > 0) {
            operation.getPropertiesManager().createSubstitutionProperty(importItem, pathNameToUse, ExternalFileUtil.decodeXMLEncodedString((String)fileName));
            operation.getPropertiesManager().createSubstitutionProperty(importItem, pathNameToUse + ".ApplicationServer", ExternalFileUtil.decodeXMLEncodedString((String)serverName));
        }
    }

    private void setTransformationServerAndFileSubstitutions(JobImportListener jobImportListener, ImportOperationInterface operation, ImportItemInterface importItem, String pathName, ConnectionPointInterface unknownServerConnection, List txSources) {
        for (int i = 0; i < txSources.size(); ++i) {
            Map transformationSource = (Map)txSources.get(i);
            int count = i + 1;
            List listSourceTxSourceCode = (List)transformationSource.get("SourceCode");
            for (Map txSrcSourceCode : listSourceTxSourceCode) {
                List listServerContexts = (List)txSrcSourceCode.get("DeployedComponents");
                this.setServerAndFileSubstitutions(jobImportListener, operation, pathName, txSrcSourceCode, listServerContexts, importItem, unknownServerConnection, count);
            }
        }
    }

    void analyzeJobFileContentImport(JobImportListener jobImportListener, ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        Map mapAllImportedJobs = operation.getAssociationsForObjects(objects, "<Template><Job><JobActivities><TransformationActivity><Steps><TransformationStep><SourceCode><File FileName=\"\"><DeployedComponents/></File></SourceCode><Transformations><ClassifierMap><SourceCode><File FileName=\"\"><DeployedComponents/></File></SourceCode></ClassifierMap><Select><SourceCode><File FileName=\"\"><DeployedComponents/></File></SourceCode></Select></Transformations><TransformationSources><Transformation><SourceCode><File FileName=\"\"><DeployedComponents/></File></SourceCode></Transformation></TransformationSources><TransformationTargets><Transformation><SourceCode><File FileName=\"\"><DeployedComponents/></File></SourceCode></Transformation></TransformationTargets></TransformationStep></Steps></TransformationActivity></JobActivities><SourceCode><File FileName=\"\"><DeployedComponents/></File></SourceCode><TransformationSources><Transformation><SourceCode><File FileName=\"\"><DeployedComponents/></File></SourceCode></Transformation></TransformationSources><TransformationTargets><Transformation><SourceCode><File FileName=\"\"><DeployedComponents/></File></SourceCode></Transformation></TransformationTargets></Job></Template>");
        int index = 1;
        int importItemCount = objects.size();
        for (ImportItemInterface importItem : objects) {
            jobImportListener.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)importItem.getTypeInterface(), (String)importItem.getName(), (int)index++, (int)importItemCount));
            ConnectionPointInterface unknownServerConnection = null;
            Map mapJobInformation = (Map)mapAllImportedJobs.get(importItem.getID());
            if (mapJobInformation == null) continue;
            List listJobSourceCode = (List)mapJobInformation.get("SourceCode");
            for (Map fileSourceCode : listJobSourceCode) {
                List listServerContexts = (List)fileSourceCode.get("DeployedComponents");
                this.setServerAndFileSubstitutions(jobImportListener, operation, "JobSrcCodeFile.FilePath", fileSourceCode, listServerContexts, importItem, unknownServerConnection, 0);
            }
            List txSources = (List)mapJobInformation.get("TransformationSources");
            this.setTransformationServerAndFileSubstitutions(jobImportListener, operation, importItem, "JobPreProcess.FilePath", unknownServerConnection, txSources);
            List txTargets = (List)mapJobInformation.get("TransformationTargets");
            this.setTransformationServerAndFileSubstitutions(jobImportListener, operation, importItem, "JobPostProcess.FilePath", unknownServerConnection, txTargets);
            List activites = (List)mapJobInformation.get("JobActivities");
            for (Map transformationActivity : activites) {
                List steps = (List)transformationActivity.get("Steps");
                for (int i = 0; i < steps.size(); ++i) {
                    Map step = (Map)steps.get(i);
                    int count = i + 1;
                    String stepName = "JobStep[" + count + "]";
                    String filePath = ".FilePath";
                    List listStepSourceCode = (List)step.get("SourceCode");
                    for (Map stepSrcCode : listStepSourceCode) {
                        List listServerContexts = (List)stepSrcCode.get("DeployedComponents");
                        this.setServerAndFileSubstitutions(jobImportListener, operation, "JobStep.FilePath", stepSrcCode, listServerContexts, importItem, unknownServerConnection, 0);
                    }
                    List stepTrans = (List)step.get("Transformations");
                    for (Map classMap : stepTrans) {
                        String localFilePath = stepName + ".Transformations" + filePath;
                        List classMapSrcCodes = (List)classMap.get("SourceCode");
                        for (int k = 0; k < classMapSrcCodes.size(); ++k) {
                            Map classMapSrcCode = (Map)classMapSrcCodes.get(k);
                            int countTransformations = k + 1;
                            List listServerContexts = (List)classMapSrcCode.get("DeployedComponents");
                            this.setServerAndFileSubstitutions(jobImportListener, operation, localFilePath, classMapSrcCode, listServerContexts, importItem, unknownServerConnection, countTransformations);
                        }
                    }
                    List stepTxSources = (List)step.get("TransformationSources");
                    String localFilePath = stepName + ".PreProcess" + filePath;
                    this.setTransformationServerAndFileSubstitutions(jobImportListener, operation, importItem, localFilePath, unknownServerConnection, stepTxSources);
                    List stepTxTargets = (List)step.get("TransformationTargets");
                    localFilePath = stepName + ".PostProcess" + filePath;
                    this.setTransformationServerAndFileSubstitutions(jobImportListener, operation, importItem, localFilePath, unknownServerConnection, stepTxTargets);
                }
            }
        }
    }
}

