/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.generatedtransform;

import com.sas.metadata.logical.BaseLogicalObject;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.util.UsageVersion;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;

public class GeneratedTransform
extends BaseLogicalObject {
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    public static final UsageVersion FAILED_MIGRATION_VERSION = new UsageVersion(0, 5);

    public GeneratedTransform(Prototype mdoGeneratedTransform, TypeInterface type, Factory factory) throws RemoteException {
        super((Root)mdoGeneratedTransform, type, factory);
        this.setCompatibility(FAILED_MIGRATION_VERSION, CURRENT_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String name, OperationUserInteractionInterface opUI) throws LogicalTypeException {
        String oldName = this.getName();
        super.rename(name, opUI);
        if (oldName == null || !oldName.equals(name)) {
            try {
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "GeneratedTransform:rename:" + this.getID());
                try {
                    Prototype metadataObject = (Prototype)store.getFactory().createComplexMetadataObject(store, this.getName(), this.getTypeInterface().getMetadataType(), this.getID());
                    TransformManager.updateTransformNameAndDescription((Prototype)metadataObject);
                    metadataObject.updateMetadataAll();
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Writing");
                }
                finally {
                    store.dispose();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    public boolean isExportAllowed() throws LogicalTypeException {
        boolean exportAllowed = true;
        UsageVersion uv = this.getUsageVersion();
        if (uv != null && uv.encode() < CURRENT_VERSION.encode()) {
            exportAllowed = false;
        }
        if (exportAllowed) {
            exportAllowed = super.isExportAllowed();
        }
        return exportAllowed;
    }

    public boolean isRenameAllowed() throws LogicalTypeException {
        boolean renameAllowed = true;
        UsageVersion uv = this.getUsageVersion();
        if (uv != null && uv.encode() < CURRENT_VERSION.encode()) {
            renameAllowed = false;
        }
        if (renameAllowed) {
            renameAllowed = super.isRenameAllowed();
        }
        return renameAllowed;
    }
}

