/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.permissions;

import com.sas.apps.content.migration.export.permissions.OSFilePermission;
import com.sas.apps.content.migration.export.permissions.OSFilePermissionExtractor;
import com.sas.apps.content.migration.export.permissions.OSPermissionCollection;
import com.sas.apps.content.migration.export.permissions.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class UNIXFilePermission
implements OSFilePermissionExtractor {
    private String path;
    private String owner;
    private String actions;
    private String ownerGroup;
    private File file;
    private static Map actionsMap = new HashMap();
    private OSPermissionCollection collection;
    private static final String PERM_EXECUTE = "--x";
    private static final String PERM_WRITE = "-w-";
    private static final String PERM_WRITE_EXECUTE = "-wx";
    private static final String PERM_READ = "r--";
    private static final String PERM_READ_EXCUTE = "r-x";
    private static final String PERM_READ_WRITE = "rw-";
    private static final String PERM_READ_WRITE_EXECUTE = "rwx";
    private static final String PERM_NONE = "---";
    private static final String CURRENT_DIR = ".";
    private static final String PARENT_DIR = "..";
    private static final String SYMBOLIC_LINK = "l";
    private static final String PERM_READ_WRITE_SPECIAL_S = "rwS";
    private static final String PERM_READ_SPECIAL_S = "r-S";
    private static final String PERM_WRITE_SPECIAL_S = "-wS";
    private static final String PERM_SPECIAL_S = "--S";
    private static final String PERM_READ_WRITE_SPECIAL_s = "rws";
    private static final String PERM_READ_SPECIAL_s = "r-s";
    private static final String PERM_WRITE_SPECIAL_s = "-ws";
    private static final String PERM_SPECIAL_s = "--s";
    private static final String PERM_READ_WRITE_SPECIAL_l = "rwl";
    private static final String PERM_READ_SPECIAL_l = "r-l";
    private static final String PERM_WRITE_SPECIAL_l = "-wl";
    private static final String PERM_SPECIAL_l = "--l";
    private static final String PERM_READ_WRITE_STICKY_T = "rwT";
    private static final String PERM_READ_STICKY_T = "r-T";
    private static final String PERM_WRITE_STICKY_T = "-wT";
    private static final String PERM_STICKY_T = "--T";
    private static final String PERM_READ_WRITE_STICKY_t = "rwt";
    private static final String PERM_READ_STICKY_t = "r-t";
    private static final String PERM_WRITE_STICKY_t = "-wt";
    private static final String PERM_STICKY_t = "--t";
    private static final String SPECIAL_PERMISSION = "s";
    private static final String STICKY_BIT = "t";
    private static final String FILE_LOCK = "l";
    private static final String EXEC_LS_CMD;
    private static final String EXEC_LS_CMD_OPTS;
    private List includeFilterList = null;
    private List globalExcludeList = null;

    private UNIXFilePermission(String filePath, String actions, String owner, String ownerGroup) {
        this.path = filePath;
        this.actions = actions;
        this.owner = owner;
        this.ownerGroup = ownerGroup;
    }

    @Override
    public void extract() {
        String dirPath = this.file.getPath();
        this.performDir(dirPath);
    }

    private void performDir(String dirPath) {
        String[] command = new String[]{EXEC_LS_CMD, EXEC_LS_CMD_OPTS, dirPath};
        Process dir = Tools.perform(command);
        if (dir != null) {
            this.parseDirResult(dir.getInputStream(), dirPath);
        }
    }

    private void parseDirResult(InputStream result, String dirPath) {
        if (result != null) {
            String[] line = null;
            String streamLine = null;
            String fileName = null;
            String resultLine = null;
            String modes = null;
            String filePath = null;
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(result));
                while ((streamLine = br.readLine()) != null) {
                    line = this.parseLine(streamLine, dirPath);
                    if (line == null || line.length < 5 || this.isSymbolicLink(line[0].trim())) continue;
                    modes = this.getModes(line[0].trim());
                    fileName = line[line.length - 1];
                    resultLine = modes + "|" + line[2] + "|" + line[3];
                    String string = filePath = dirPath.equals(fileName) ? fileName : dirPath + File.separator + fileName;
                    if (this.includeFilterList != null) {
                        if (!this.includeFilterList.contains(filePath) || this.globalExcludeList == null || this.globalExcludeList.contains(filePath)) continue;
                        this.collection.add(filePath, resultLine);
                        continue;
                    }
                    this.collection.add(filePath, resultLine);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isSymbolicLink(String modes) {
        return modes == null || modes != null && modes.startsWith("l");
    }

    private String[] parseLine(String line, String dirPath) {
        String fileName;
        String[] splitLine;
        String[] parsedLine = null;
        if (!Tools.isEmpty(line) && (splitLine = line.split("\\s+")) != null && splitLine.length > 5 && (fileName = this.getFileName(splitLine, dirPath)) != null && !fileName.equals(PARENT_DIR)) {
            parsedLine = new String[5];
            if (fileName.equals(CURRENT_DIR)) {
                fileName = dirPath;
            }
            System.arraycopy(splitLine, 0, parsedLine, 0, 4);
            parsedLine[parsedLine.length - 1] = fileName;
        }
        return parsedLine;
    }

    private String getFileName(String[] line, String dirPath) {
        String[] actionsSplit;
        String fileName = "";
        File file = null;
        boolean isFile = false;
        if (!Tools.isEmpty(line) && (actionsSplit = line) != null && actionsSplit.length > 1) {
            for (int index = actionsSplit.length - 1; index >= 0; --index) {
                fileName = actionsSplit[index] + (index != actionsSplit.length - 1 ? " " : "") + fileName;
                file = new File(dirPath, fileName);
                if (!file.exists()) continue;
                isFile = true;
                break;
            }
        }
        return isFile ? fileName : null;
    }

    private String getModes(String lsResult) {
        if (lsResult != null && lsResult.length() >= 10) {
            String otherString;
            String groupString;
            int specialBit = 0;
            String workOn = lsResult.substring(1);
            String userString = workOn.substring(0, 3);
            if (this.specialBitSet(userString)) {
                specialBit = 4;
            }
            if (this.specialBitSet(groupString = workOn.substring(3, 6))) {
                specialBit += 2;
            }
            if (this.specialBitSet(otherString = workOn.substring(6))) {
                ++specialBit;
            }
            return String.valueOf(specialBit) + (String)actionsMap.get(userString) + (String)actionsMap.get(groupString) + (String)actionsMap.get(otherString);
        }
        return null;
    }

    private boolean specialBitSet(String modeString) {
        String lastChar = null;
        boolean spBitSet = false;
        if (modeString != null) {
            lastChar = modeString.substring(modeString.length() - 1);
            spBitSet = lastChar.equalsIgnoreCase(SPECIAL_PERMISSION) || lastChar.equalsIgnoreCase(STICKY_BIT) || lastChar.equalsIgnoreCase("l");
        }
        return spBitSet;
    }

    private UNIXFilePermission(OSPermissionCollection collection) {
        this.collection = collection;
    }

    @Override
    public OSFilePermission getFilePermission() {
        return new UNIXFilePermission(this.path, this.actions, this.owner, this.ownerGroup);
    }

    public static OSFilePermissionExtractor getInstance(OSPermissionCollection collection) {
        return new UNIXFilePermission(collection);
    }

    private void clear() {
        this.owner = "";
        this.actions = "";
        this.ownerGroup = "";
    }

    @Override
    public void setPath(String path) {
        this.path = path;
        this.clear();
        this.file = new File(path);
    }

    @Override
    public String getActions() {
        return this.actions;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public String getOwnerGroup() {
        return this.ownerGroup;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public OSPermissionCollection getPermissionsCollection() {
        return this.collection;
    }

    @Override
    public void setIncludeList(List includeFiles) {
        this.includeFilterList = includeFiles;
    }

    @Override
    public void setGlobalExcludeList(List globalExcludeList) {
        this.globalExcludeList = globalExcludeList;
    }

    static {
        actionsMap.put(PERM_EXECUTE, "1");
        actionsMap.put(PERM_WRITE, "2");
        actionsMap.put(PERM_WRITE_EXECUTE, "3");
        actionsMap.put(PERM_READ, "4");
        actionsMap.put(PERM_READ_EXCUTE, "5");
        actionsMap.put(PERM_READ_WRITE, "6");
        actionsMap.put(PERM_READ_WRITE_EXECUTE, "7");
        actionsMap.put(PERM_READ_WRITE_SPECIAL_S, "6");
        actionsMap.put(PERM_READ_SPECIAL_S, "4");
        actionsMap.put(PERM_WRITE_SPECIAL_S, "2");
        actionsMap.put(PERM_SPECIAL_S, "0");
        actionsMap.put(PERM_READ_WRITE_SPECIAL_s, "7");
        actionsMap.put(PERM_READ_SPECIAL_s, "5");
        actionsMap.put(PERM_WRITE_SPECIAL_s, "3");
        actionsMap.put(PERM_SPECIAL_s, "1");
        actionsMap.put(PERM_READ_WRITE_SPECIAL_l, "6");
        actionsMap.put(PERM_READ_SPECIAL_l, "4");
        actionsMap.put(PERM_WRITE_SPECIAL_l, "2");
        actionsMap.put(PERM_SPECIAL_l, "0");
        actionsMap.put(PERM_READ_WRITE_STICKY_T, "6");
        actionsMap.put(PERM_READ_STICKY_T, "4");
        actionsMap.put(PERM_WRITE_STICKY_T, "2");
        actionsMap.put(PERM_STICKY_T, "0");
        actionsMap.put(PERM_READ_WRITE_STICKY_t, "7");
        actionsMap.put(PERM_READ_STICKY_t, "5");
        actionsMap.put(PERM_WRITE_STICKY_t, "3");
        actionsMap.put(PERM_STICKY_t, "1");
        actionsMap.put(PERM_NONE, "0");
        EXEC_LS_CMD = Tools.encode("ls");
        EXEC_LS_CMD_OPTS = Tools.encode("-al");
    }
}

