/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.permissions;

import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.export.permissions.OSFilePermission;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Tools {
    private static boolean debugMe = true;
    private static int CACHE_THRESHOULD = 5120;

    public static void setDebug(boolean debug) {
        debugMe = debug;
    }

    public static List parseUNXStream(InputStream resultStream, int start) {
        return Tools.parseStream(resultStream, start, "\\s+");
    }

    public static List parseWINStream(InputStream resultStream, int start) {
        return Tools.parseStream(resultStream, start, null);
    }

    public static OSFilePermission getPermission(final String permissionLine) {
        return new OSFilePermission(){

            @Override
            public String getActions() {
                return permissionLine.substring(permissionLine.indexOf(","));
            }

            @Override
            public String getOwner() {
                return "";
            }

            @Override
            public String getOwnerGroup() {
                return null;
            }

            @Override
            public String getPath() {
                return permissionLine.substring(0, permissionLine.indexOf(","));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List parseStream(InputStream resultStream, int start, String splitExpression) {
        ArrayList<String[]> result = null;
        if (resultStream != null) {
            InputStreamReader isr = new InputStreamReader(resultStream);
            BufferedReader br = new BufferedReader(isr);
            result = new ArrayList<String[]>();
            int index = 1;
            String line = "";
            String[] tokens = null;
            try {
                while ((line = br.readLine()) != null) {
                    tokens = splitExpression != null ? line.split(splitExpression) : new String[]{line};
                    if (tokens != null && index >= start) {
                        result.add(tokens);
                    }
                    ++index;
                }
            }
            catch (IOException exception) {
                AnalyzerHelper.log(exception);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public static String getPermissionString(OSFilePermission permission, String relPath) {
        if (permission != null) {
            StringBuffer permissions = new StringBuffer();
            String owner = permission.getOwner();
            String path = relPath;
            String actions = permission.getActions();
            String ownerGroup = permission.getOwnerGroup();
            permissions.append(path != null ? path : "");
            permissions.append(",");
            permissions.append(actions != null ? actions : "");
            permissions.append(",");
            permissions.append(owner != null ? owner : "");
            permissions.append(",");
            permissions.append(ownerGroup != null ? ownerGroup : "");
            permissions.append(",");
            return permissions.toString();
        }
        return null;
    }

    public static Process perform(String command) {
        Process osProcess = null;
        Runtime rt = Runtime.getRuntime();
        String execCommand = command;
        try {
            osProcess = rt.exec(execCommand);
        }
        catch (IOException exception) {
            AnalyzerHelper.log(exception);
        }
        return osProcess;
    }

    public static Process perform(String[] command) {
        Process osProcess = null;
        Runtime rt = Runtime.getRuntime();
        String[] execCommand = command;
        try {
            osProcess = rt.exec(execCommand);
        }
        catch (IOException exception) {
            AnalyzerHelper.log(exception);
        }
        return osProcess;
    }

    public static String encode(String value) {
        String encoded = null;
        if (value != null) {
            try {
                encoded = new String(value.getBytes(Tools.getDefaultSysEncoding()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return encoded;
    }

    public static boolean cachePermOutput(String dirPath) {
        String[] files;
        File subFolder = null;
        boolean cacheOutput = false;
        if (!Tools.isEmpty(dirPath) && (files = (subFolder = new File(dirPath)).list()) != null) {
            cacheOutput = files.length > CACHE_THRESHOULD;
        }
        return cacheOutput;
    }

    public static String getDefaultSysEncoding() {
        String defaultEncoding = null;
        FileWriter writer = null;
        try {
            writer = new FileWriter("out");
            defaultEncoding = writer.getEncoding();
        }
        catch (IOException exception) {
            defaultEncoding = System.getProperty("file.encoding");
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        return defaultEncoding;
    }

    public static boolean isEmpty(Object object) {
        boolean isEmpty = false;
        if (object == null) {
            isEmpty = true;
        } else if (object instanceof String && ((String)object).length() <= 0) {
            isEmpty = true;
        } else if (object instanceof Collection && ((Collection)object).size() <= 0) {
            isEmpty = true;
        } else if (object instanceof Map && ((Map)object).size() <= 0) {
            isEmpty = true;
        } else if (object.getClass().isArray() && ((Object[])object).length <= 0) {
            isEmpty = true;
        }
        return isEmpty;
    }
}

