/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.permissions;

import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.export.common.Directory;
import com.sas.apps.content.migration.export.permissions.OSPermissionCollection;
import com.sas.apps.content.migration.export.permissions.OSPermissionFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.DirectoryScanner;

public class PermissionMigrator {
    private String osFamily;
    private List excludeFilterList;
    private Directory directory;
    private List includeFilterList;
    private DirectoryScanner directoryScanner;

    private PermissionMigrator(String osFamily, Directory directory) {
        this.osFamily = osFamily;
        this.directory = directory;
    }

    public void setFilterList(List excludedFiles) {
        this.excludeFilterList = excludedFiles;
    }

    public void setIncludeList(List includeFiles) {
        this.includeFilterList = includeFiles;
    }

    public void setDirectoryScanner(DirectoryScanner directoryScanner) {
        this.directoryScanner = directoryScanner;
    }

    public static PermissionMigrator getInstance(String osFamily, Directory directory) throws IllegalArgumentException {
        if (!OSPermissionFactory.isOSSupported(osFamily)) {
            throw new IllegalArgumentException(osFamily + " is not supported for permissions migration at this moment");
        }
        return new PermissionMigrator(osFamily, directory);
    }

    public OSPermissionCollection reterivePermission() {
        OSPermissionFactory factory;
        block19: {
            block20: {
                factory = OSPermissionFactory.getPermissionFactory(this.osFamily);
                if (this.directoryScanner == null) break block19;
                String[] includedDirs = this.directoryScanner.getIncludedDirectories();
                if (includedDirs == null || includedDirs.length <= 0) break block20;
                List<String> subDirectories = Arrays.asList(includedDirs);
                String subDirPath = null;
                for (int index = 0; index < subDirectories.size(); ++index) {
                    subDirPath = subDirectories.get(index);
                    ArrayList<String> includedChildFiles = new ArrayList<String>();
                    String sourceDirPath = null;
                    String filePath = null;
                    try {
                        sourceDirPath = this.directory.getFileInstance().getCanonicalPath();
                    }
                    catch (IOException e) {
                        sourceDirPath = this.directory.getFileInstance().getAbsolutePath();
                    }
                    if (sourceDirPath != null) {
                        filePath = subDirPath != null && !subDirPath.equals("") ? sourceDirPath + File.separator + subDirPath : sourceDirPath;
                    }
                    if (filePath == null) continue;
                    for (int i = 0; i < this.includeFilterList.size(); ++i) {
                        String fileName = (String)this.includeFilterList.get(i);
                        if (fileName != null && !fileName.equals("")) {
                            includedChildFiles.add(sourceDirPath + File.separator + fileName);
                            continue;
                        }
                        includedChildFiles.add(sourceDirPath);
                    }
                    try {
                        factory.extractFilePermissions(filePath, includedChildFiles, this.excludeFilterList);
                        continue;
                    }
                    catch (Exception exception) {
                        AnalyzerHelper.log("Unable to retrive file permissions for " + filePath + ": " + exception.getMessage(), 0);
                    }
                }
                break block19;
            }
            if (this.includeFilterList == null || this.includeFilterList.isEmpty()) break block19;
            Set<File> childrenDir = this.directory.listDirectory(this.directory.getFileInstance().getAbsolutePath());
            ArrayList<File> children = null;
            String sourceDirPath = null;
            try {
                sourceDirPath = this.directory.getFileInstance().getCanonicalPath();
            }
            catch (IOException e) {
                sourceDirPath = this.directory.getFileInstance().getAbsolutePath();
            }
            if (sourceDirPath != null) {
                String fileName;
                ArrayList<String> includedChildFiles = new ArrayList<String>();
                ArrayList<String> includedDirsList = new ArrayList<String>();
                String child = null;
                String childPath = null;
                for (int i = 0; i < this.includeFilterList.size(); ++i) {
                    fileName = (String)this.includeFilterList.get(i);
                    includedChildFiles.add(sourceDirPath + File.separator + fileName);
                }
                includedChildFiles.add(sourceDirPath);
                try {
                    factory.extractFilePermissions(sourceDirPath, includedChildFiles, this.excludeFilterList);
                }
                catch (Exception exception) {
                    AnalyzerHelper.log("Unable to retrive file permissions form " + sourceDirPath + ": " + exception.getMessage(), 0);
                }
                if (childrenDir != null) {
                    children = new ArrayList<File>(childrenDir);
                    for (int i = 0; i < children.size(); ++i) {
                        fileName = ((File)children.get(i)).getAbsolutePath();
                        if (fileName == null || fileName.equals("")) continue;
                        includedDirsList.add(fileName);
                    }
                    try {
                        for (int j = 0; j < includedDirsList.size(); ++j) {
                            child = (String)includedDirsList.get(j);
                            factory.extractFilePermissions(child, includedChildFiles, this.excludeFilterList);
                        }
                    }
                    catch (Exception exception) {
                        AnalyzerHelper.log("Unable to retrive file permissions form " + childPath + ": " + exception.getMessage(), 0);
                    }
                }
            }
        }
        return factory.getPermissionsCollection();
    }

    public OSPermissionCollection reterivePermission(boolean scanSubDirs) {
        if (scanSubDirs) {
            return this.reterivePermission();
        }
        OSPermissionFactory factory = OSPermissionFactory.getPermissionFactory(this.osFamily);
        String dirPath = this.directory.getFileInstance().getPath();
        try {
            factory.extractFilePermissions(dirPath, null, null);
        }
        catch (Exception exception) {
            AnalyzerHelper.log("Unable to retrive file permissions for " + dirPath + ": " + exception.getMessage(), 0);
        }
        return factory.getPermissionsCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File storePermissions(OSPermissionCollection collection) {
        block18: {
            String permissionLine = null;
            String relPath = null;
            String fileName = null;
            String permission = null;
            String fileRelativePath = null;
            BufferedWriter permissionsWriter = null;
            String rootDirName = this.directory.getName();
            File tempFile = null;
            try {
                if (collection == null) break block18;
                Iterator collectionIterator = collection.iterator();
                try {
                    tempFile = File.createTempFile("permissions", null);
                }
                catch (Exception e) {
                    File tempFolder = new File(".", "Temp" + File.separator + "CMUTemp");
                    tempFolder.mkdirs();
                    tempFile = File.createTempFile("permissions", null, tempFolder);
                }
                tempFile.deleteOnExit();
                permissionsWriter = new BufferedWriter(new FileWriter(tempFile));
                while (collectionIterator.hasNext()) {
                    permissionLine = (String)collectionIterator.next();
                    fileRelativePath = rootDirName;
                    fileName = OSPermissionCollection.getFileName(permissionLine);
                    relPath = this.directory.getRelativePath(fileName);
                    if (relPath != null) {
                        fileRelativePath = fileRelativePath + File.separator + relPath;
                    }
                    AnalyzerHelper.log(" Actually Storing in permission.tmp : " + fileRelativePath, 2);
                    permission = fileRelativePath + "|" + OSPermissionCollection.getPermissionsString(permissionLine);
                    permissionsWriter.write(permission);
                    permissionsWriter.newLine();
                }
                File file = tempFile;
                return file;
            }
            catch (IOException exception) {
                AnalyzerHelper.log(exception.getMessage(), 0);
            }
            finally {
                if (permissionsWriter != null) {
                    try {
                        permissionsWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }
}

