/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.common;

import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.export.common.DataMigratorHelper;
import com.sas.apps.content.migration.export.common.SASLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class SASRunner {
    private String sasExecutable;
    private String argSplash = "";
    private String argIcon = "";
    private boolean foundationExists = true;
    private SASLog sasLog = null;

    private SASRunner(String sasRoot, String osFamily) throws FileNotFoundException {
        this.sasExecutable = sasRoot;
        if (osFamily.equalsIgnoreCase("Windows")) {
            this.sasExecutable = this.sasExecutable + "\\sas.exe";
            this.argSplash = "-nosplash";
            this.argIcon = "-icon";
        } else {
            this.sasExecutable = osFamily.equalsIgnoreCase("ZOS") ? this.sasExecutable + File.separator + "sas.sh" : this.sasExecutable + File.separator + "sas";
        }
        File sasExecutableFile = new File(this.sasExecutable);
        if (!sasExecutableFile.exists()) {
            AnalyzerHelper.log("SASExecutable not found at :  : " + sasExecutableFile.getPath() + " \n.", 2);
            this.foundationExists = false;
        }
    }

    public static SASRunner getSASRunner(String sasRoot, String osFamily) throws FileNotFoundException {
        return new SASRunner(sasRoot, osFamily);
    }

    public File run(String command) {
        return null;
    }

    public boolean run(File inFile, File outFile, File logFile) {
        boolean ran = false;
        if (this.foundationExists) {
            String runCommand = this.getRunCommand(inFile.getPath(), DataMigratorHelper.getMostAccurateFilePath(logFile));
            Process sasProcess = null;
            try {
                sasProcess = Runtime.getRuntime().exec(runCommand);
                sasProcess.waitFor();
                this.sasLog = SASLog.parseLog(logFile);
                ran = !this.sasLog.errorsPresent();
            }
            catch (IOException exception) {
                AnalyzerHelper.log("Failed to run command : " + runCommand, 1);
                ran = false;
            }
            catch (InterruptedException exception) {
                AnalyzerHelper.log("Failed to run command : " + runCommand, 1);
                ran = false;
            }
        }
        return ran;
    }

    private String getRunCommand(String inFile, String logFile) {
        StringBuffer command = new StringBuffer(this.sasExecutable);
        command.append(" ");
        command.append("-sysin \"");
        command.append(inFile);
        command.append("\"");
        command.append(" ");
        command.append("-log \"");
        command.append(logFile);
        command.append("\"");
        command.append(" ");
        command.append(this.argSplash);
        command.append(" ");
        command.append(this.argIcon);
        return command.toString();
    }
}

