/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.common;

import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SASLog {
    private static final String[] ERROR_WARNING_STRING = new String[]{"ERROR:", "WARNING:", "NOTE:"};
    private List errorList = new ArrayList();

    private SASLog(File logfilePath) {
        this.parse(logfilePath);
    }

    private void parse(File saslogFile) {
        BufferedReader logFile = null;
        String line = null;
        int lineNo = 0;
        LogEntry logEntry = null;
        try {
            logFile = new BufferedReader(new FileReader(saslogFile));
            while ((line = logFile.readLine()) != null) {
                logEntry = this.constructLogEntry(line, lineNo);
                if (logEntry != null && logEntry.isError()) {
                    this.errorList.add(logEntry);
                }
                ++lineNo;
            }
        }
        catch (FileNotFoundException exception) {
            AnalyzerHelper.log(exception);
        }
        catch (IOException exception) {
            AnalyzerHelper.log(exception);
        }
    }

    private LogEntry constructLogEntry(String line, int lineNo) {
        LogEntry logEntry = null;
        String description = null;
        for (int type = 0; type < 2; ++type) {
            String patternToSearch = ERROR_WARNING_STRING[type];
            Pattern errorPattern = Pattern.compile(patternToSearch, 2);
            Matcher matcher = errorPattern.matcher(line);
            if (!matcher.find()) continue;
            description = line.substring(matcher.end());
            logEntry = new LogEntry(description, type, lineNo);
            break;
        }
        return logEntry;
    }

    public static SASLog parseLog(File logfile) {
        return new SASLog(logfile);
    }

    public List getErrors() {
        return new ArrayList(this.errorList);
    }

    public List getWarnings() {
        return null;
    }

    public boolean errorsPresent() {
        return !AnalyzerHelper.isEmpty(this.errorList);
    }

    public boolean warnigsPresent() {
        return false;
    }

    public static void main(String[] args) {
        SASLog log = SASLog.parseLog(new File("C:\\Documents and Settings\\sinbkk\\Local Settings\\Temp\\catalogCPORT56313.saslog56315.log"));
    }

    public class LogEntry {
        private String description;
        private int type;
        private int lineNo;

        LogEntry(String description, int type, int lineNo) {
            this.description = description;
            this.type = type;
            this.lineNo = lineNo;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public int getLineNo() {
            return this.lineNo;
        }

        public void setLineNo(int lineNo) {
            this.lineNo = lineNo;
        }

        public boolean isError() {
            return this.type == 0;
        }

        public boolean isWarning() {
            return this.type == 1;
        }
    }
}

