/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.common;

import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.export.common.MetadataAccess;
import com.sas.apps.content.migration.export.common.RB;
import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.AssociationList;
import com.sas.metadata.AuthenticationDomain;
import com.sas.metadata.CMetadata;
import com.sas.metadata.Connection;
import com.sas.metadata.Identity;
import com.sas.metadata.LogicalServer;
import com.sas.metadata.Login;
import com.sas.metadata.Machine;
import com.sas.metadata.MdException;
import com.sas.metadata.MdFactory;
import com.sas.metadata.MdObjectFactory;
import com.sas.metadata.MdObjectStore;
import com.sas.metadata.MdStore;
import com.sas.metadata.MetadataUtil;
import com.sas.metadata.MetadataWorkspace;
import com.sas.metadata.OLAPSchema;
import com.sas.metadata.Property;
import com.sas.metadata.Root;
import com.sas.metadata.SASClientConnection;
import com.sas.metadata.ServerComponent;
import com.sas.metadata.ServerContext;
import com.sas.metadata.TCPIPConnection;
import com.sas.metadata.Transformation;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.text.Message;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetadataServerUtil
implements MetadataAccess {
    private static IOMI omiConnection = null;
    private static MdFactory mdFactory;
    private static MdOMRConnection omrConnection;
    public static final String CONNECTION_TCPIP = "TCPIPConnection";
    public static final String CONNECTION_SASCLIENT = "SASClientConnection";
    public static final String PROTOCOL_OPERATOR = "Operator";
    public static final String PROTOCOL_BRIDGE = "Bridge";
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_CONNECT = "CONNECT";
    public static final String PROTOCOL_MULTIBRIDGE = "MultiBridge";
    private static final String SPAWNER_CLASS_IDENTIFIER = "IOM Spawner";
    private static final String ERR_LOGICALSERVER = "logical server";
    private static final String ERR_SERVERCONTEXT = "server context";
    private static final String ERR_CONFIGCOMMAND = "config command property";
    private static final String ERR_PROPERTIES = "properties";
    private static final String ERR_CONNECTION = "TCPIP connection";
    private String sasVersion = "";
    private String localHost;
    private boolean mdTier;
    protected static Map templates;
    public static String m_metadataHost;
    public static String m_metadataPort;
    public static String m_metadataUser;
    public static String m_metadataPassword;

    @Override
    public String getSASVersion() {
        return this.sasVersion;
    }

    @Override
    public boolean connect(String host, String port, String uName, String pass) {
        m_metadataHost = host;
        m_metadataPort = port;
        m_metadataUser = uName;
        m_metadataPassword = pass;
        this.init(host, uName, pass, port);
        return true;
    }

    protected String getTemplate(String metadataObject) {
        return (String)templates.get(metadataObject);
    }

    private void init(String host, String user, String passWord, String port) {
        try {
            MetadataWorkspace metadataworkspace = MetadataWorkspace.getWorkspace();
            IOMI iOMI = metadataworkspace.makeOMRConnection(host, port, user, passWord);
        }
        catch (RemoteException exception) {
            AnalyzerHelper.log(exception);
        }
        catch (MdException exception) {
            AnalyzerHelper.log(exception);
            String exceptionMessage = Message.format((String)RB.getStringResource("metadata.log.unable.connect.fmt"), (Object[])new String[]{host, port});
            AnalyzerHelper.log(exceptionMessage, exception);
        }
    }

    @Override
    public Map getServerComponentByClassId(String classId) {
        Map repositories = this.getRepositories();
        HashMap<String, List> serverComponenets = null;
        List servers = null;
        String repositoryName2 = null;
        if (repositories != null) {
            serverComponenets = new HashMap<String, List>();
            for (String repositoryName2 : repositories.keySet()) {
                servers = this.getServerComponentByClassId(classId, (String)repositories.get(repositoryName2));
                if (AnalyzerHelper.isEmpty(servers)) continue;
                serverComponenets.put(repositoryName2, servers);
            }
        }
        return serverComponenets;
    }

    protected Map getServerContexts() {
        Map repositories = this.getRepositories();
        HashMap<String, List> serverContexts = null;
        List servers = null;
        String repositoryName2 = null;
        if (repositories != null) {
            serverContexts = new HashMap<String, List>();
            for (String repositoryName2 : repositories.keySet()) {
                String reposID = (String)repositories.get(repositoryName2);
                servers = this.getServerContexts(reposID);
                if (servers == null) continue;
                serverContexts.put(reposID, servers);
            }
        }
        return serverContexts;
    }

    @Override
    public Map getConfiguredContexts(String hostName, boolean isMdTier) {
        Map mpAlContexts = this.getServerContexts();
        HashMap mpValidContexts = new HashMap();
        if (!AnalyzerHelper.isEmpty(mpAlContexts)) {
            for (String reposID : mpAlContexts.keySet()) {
                List lstAlContexts = (List)mpAlContexts.get(reposID);
                if (AnalyzerHelper.isEmpty(lstAlContexts)) continue;
                ArrayList<ServerContext> lstValidContexts = new ArrayList<ServerContext>();
                for (int index = 0; index < lstAlContexts.size(); ++index) {
                    ServerContext context = (ServerContext)lstAlContexts.get(index);
                    if (!this.isConfigured(context, hostName, isMdTier)) continue;
                    lstValidContexts.add(context);
                }
                if (AnalyzerHelper.isEmpty(lstValidContexts)) continue;
                mpValidContexts.put(reposID, lstValidContexts);
            }
        }
        return AnalyzerHelper.isEmpty(mpValidContexts) ? null : mpValidContexts;
    }

    protected boolean isConfigured(ServerContext context, String hostName, boolean isMdTier) {
        boolean isConfigured = false;
        AssociationList logicalServers = null;
        Object logicalServer = null;
        try {
            if (context != null && !AnalyzerHelper.isEmpty(logicalServers = context.getUsingComponents())) {
                block2: for (int index = 0; index < logicalServers.size() && !isConfigured; ++index) {
                    AssociationList serverComponents;
                    logicalServer = logicalServers.get(index);
                    if (!(logicalServer instanceof LogicalServer) || AnalyzerHelper.isEmpty(serverComponents = ((LogicalServer)logicalServer).getUsingComponents())) continue;
                    for (int cnt = 0; cnt < serverComponents.size(); ++cnt) {
                        Object serverComponent = serverComponents.get(cnt);
                        if (!(serverComponent instanceof ServerComponent) || !this.isOnSpecifiedHost((ServerComponent)serverComponent, hostName, isMdTier)) continue;
                        isConfigured = true;
                        continue block2;
                    }
                }
            }
        }
        catch (MdException exception) {
            AnalyzerHelper.log(exception);
        }
        return isConfigured;
    }

    protected List getServerContexts(String repositoryId) {
        String template = this.getTemplate("ServerContext");
        MdObjectStore objectStore = null;
        List servercontexts = null;
        try {
            objectStore = MdObjectFactory.createObjectStore();
            servercontexts = MetadataUtil.getMetadataObjectsSubset((MdStore)objectStore, (String)repositoryId, (String)"ServerContext", (int)396, (String)template);
        }
        catch (Exception exception) {
            AnalyzerHelper.log(exception);
        }
        return servercontexts;
    }

    protected List getServerComponentByClassId(String ClassId, String repositoryId) {
        ArrayList<ServerComponent> servers = null;
        MdObjectStore objectStore = null;
        try {
            objectStore = MdObjectFactory.createObjectStore();
            ServerComponent serverComponent = null;
            String productName = null;
            String template = this.getTemplate("ServerComponent");
            String xmlSelect = "<XMLSELECT Search=\"@ClassIdentifier='" + ClassId + "'\"/>";
            int flags = 396;
            List serverComponents = MetadataUtil.getMetadataObjectsSubset((MdStore)objectStore, (String)repositoryId, (String)"ServerComponent", (int)flags, (String)(xmlSelect + template));
            if (serverComponents != null) {
                servers = new ArrayList<ServerComponent>();
                for (int index = 0; index < serverComponents.size(); ++index) {
                    serverComponent = (ServerComponent)serverComponents.get(index);
                    productName = serverComponent.getClassIdentifier();
                    if (!productName.equalsIgnoreCase(ClassId)) continue;
                    servers.add(serverComponent);
                }
            }
        }
        catch (MdException exception) {
            String exceptionMessage = RB.getStringResource("metadata.log.unable.servercomponent.classid.txt");
            AnalyzerHelper.log(exceptionMessage, exception);
        }
        return servers;
    }

    @Override
    public Map getRepositories() {
        HashMap<String, String> repos = null;
        CMetadata repository = null;
        try {
            List repositories = MetadataUtil.getRepositories();
            if (repositories != null) {
                repos = new HashMap<String, String>();
                for (int index = 0; index < repositories.size(); ++index) {
                    repository = (CMetadata)repositories.get(index);
                    repos.put(repository.getName(), repository.getId());
                }
            }
        }
        catch (MdException exception) {
            AnalyzerHelper.log(exception);
            String exceptionMessage = RB.getStringResource("metadata.log.unable.repositoy.txt");
            AnalyzerHelper.log(exceptionMessage, exception);
        }
        return repos;
    }

    @Override
    public String getComponentName(ServerComponent component) {
        return component != null ? component.getName() : null;
    }

    @Override
    public ServerComponent getLogicalServer(ServerComponent server) {
        LogicalServer logicalServer = null;
        ServerComponent component = null;
        try {
            AssociationList logicalServers = server.getUsedByComponents();
            if (logicalServers != null && logicalServers.size() > 0) {
                for (int index = 0; index < logicalServers.size(); ++index) {
                    component = (ServerComponent)logicalServers.get(index);
                    if (!(component instanceof LogicalServer)) continue;
                    logicalServer = (LogicalServer)component;
                }
            }
        }
        catch (MdException exception) {
            String exceptionMessage = Message.format((String)RB.getStringResource("metadata.log.unable.serverproperty.fmt"), (Object)ERR_LOGICALSERVER, (Object)server.getName());
            AnalyzerHelper.log(exceptionMessage, exception);
        }
        return logicalServer;
    }

    public static Identity getIdentity(Login login) {
        Identity id = null;
        try {
            id = login.getAssociatedIdentity();
        }
        catch (MdException e) {
            AnalyzerHelper.log(e);
        }
        return id;
    }

    @Override
    public ServerContext getServerContext(ServerComponent server) {
        ServerContext serverContext;
        block4: {
            serverContext = null;
            AssociationList contexts = null;
            Object context = null;
            try {
                if (server == null) break block4;
                ServerComponent logicalServer = this.getLogicalServer(server);
                if (logicalServer != null) {
                    contexts = logicalServer.getUsedByComponents();
                }
                if (contexts == null || contexts.size() <= 0) break block4;
                for (int index = 0; index < contexts.size(); ++index) {
                    context = contexts.get(index);
                    if (!(context instanceof ServerContext)) continue;
                    serverContext = (ServerContext)contexts.get(index);
                    break;
                }
            }
            catch (MdException exception) {
                String exceptionMessage = Message.format((String)RB.getStringResource("metadata.log.unable.serverproperty.fmt"), (Object)ERR_SERVERCONTEXT, (Object)server.getName());
                AnalyzerHelper.log(exceptionMessage, exception);
            }
        }
        return serverContext;
    }

    @Override
    public String getComponentId(ServerComponent component) {
        return component != null ? component.getId() : null;
    }

    @Override
    public String getConfigCommand(ServerComponent server) {
        String configCommand = null;
        try {
            AssociationList properties = server.getProperties();
            Property property = null;
            if (properties != null && properties.size() > 0) {
                for (int index = 0; index < properties.size(); ++index) {
                    property = (Property)properties.get(index);
                    String name = property.getName();
                    if (!"Command".equalsIgnoreCase(name)) continue;
                    configCommand = property.getDefaultValue();
                }
            }
        }
        catch (MdException exception) {
            String exceptionMessage = Message.format((String)RB.getStringResource("metadata.log.unable.serverproperty.fmt"), (Object)ERR_CONFIGCOMMAND, (Object)server.getName());
            AnalyzerHelper.log(exceptionMessage, exception);
        }
        return configCommand;
    }

    @Override
    public Map getProperties(Root server) {
        HashMap<String, String> props = null;
        String name = null;
        String value = null;
        try {
            AssociationList properties = server.getProperties();
            Property property = null;
            if (properties != null && properties.size() > 0) {
                props = new HashMap<String, String>();
                for (int index = 0; index < properties.size(); ++index) {
                    property = (Property)properties.get(index);
                    name = property.getPropertyName();
                    value = property.getDefaultValue();
                    props.put(name, value);
                }
            }
        }
        catch (MdException exception) {
            String exceptionMessage = Message.format((String)RB.getStringResource("metadata.log.unable.serverproperty.fmt"), (Object)ERR_PROPERTIES, (Object)server.getName());
            AnalyzerHelper.log(exceptionMessage, exception);
        }
        return props;
    }

    @Override
    public Map getAllDataPackages() {
        HashMap<String, List> mpDataPkgs = null;
        Map repositories = this.getRepositories();
        String repositoryName2 = null;
        if (repositories != null) {
            for (String repositoryName2 : repositories.keySet()) {
                String reposID = (String)repositories.get(repositoryName2);
                List lstDataPkgs = MetadataServerUtil.getAllDataPackages(reposID);
                if (lstDataPkgs == null) continue;
                if (mpDataPkgs == null) {
                    mpDataPkgs = new HashMap<String, List>();
                }
                mpDataPkgs.put(reposID, lstDataPkgs);
            }
        }
        return mpDataPkgs;
    }

    @Override
    public Map getClassifierMaps(Map mpReposContexts, String reportType) {
        HashMap<String, List> mpCMs = null;
        if (!AnalyzerHelper.isEmpty(mpReposContexts)) {
            Iterator keys = mpReposContexts.keySet().iterator();
            while (keys.hasNext()) {
                try {
                    String reposId = (String)keys.next();
                    List lstContexts = (List)mpReposContexts.get(reposId);
                    if (AnalyzerHelper.isEmpty(lstContexts)) continue;
                    for (int i = 0; i < lstContexts.size(); ++i) {
                        String contextId;
                        List lstCMs;
                        ServerContext context = (ServerContext)lstContexts.get(i);
                        if (context == null || (lstCMs = MetadataServerUtil.getClassifierMaps(reposId, contextId = context.getId(), reportType)) == null) continue;
                        if (mpCMs == null) {
                            mpCMs = new HashMap<String, List>();
                        }
                        mpCMs.put(contextId, lstCMs);
                    }
                }
                catch (ClassCastException e) {
                    AnalyzerHelper.log(e);
                }
            }
        }
        return mpCMs;
    }

    @Override
    public Map getAllDAVServers() {
        HashMap<String, List> mpServers = null;
        Map mpRepos = this.getRepositories();
        String strReposName2 = null;
        try {
            if (mpRepos != null) {
                for (String strReposName2 : mpRepos.keySet()) {
                    String reposID = (String)mpRepos.get(strReposName2);
                    List lstServers = this.getDAVServers(reposID);
                    if (AnalyzerHelper.isEmpty(lstServers)) continue;
                    if (mpServers == null) {
                        mpServers = new HashMap<String, List>();
                    }
                    mpServers.put(reposID, lstServers);
                }
            }
        }
        catch (MdException mdException) {
            // empty catch block
        }
        return mpServers;
    }

    protected List getDAVServers(String reposID) throws MdException {
        List lstReposId = null;
        String davClsidMatch = "<XMLSELECT Search=\"@ClassIdentifier='DAC0D7F0-10DA-11D6-8816-AA0004006D06'\"/>";
        int flags = 8584;
        MdObjectStore objectStore = MdObjectFactory.createObjectStore();
        lstReposId = MetadataUtil.getMetadataObjectsSubset((MdStore)objectStore, (String)reposID, (String)"ServerComponent", (int)flags, (String)davClsidMatch);
        return lstReposId;
    }

    @Override
    public TCPIPConnection getTCPIPConnection(ServerComponent server) {
        Connection connection = this.getConnection(server, CONNECTION_TCPIP);
        return connection != null ? (TCPIPConnection)connection : null;
    }

    @Override
    public SASClientConnection getSasClientConnection(ServerComponent server) {
        Connection connection = this.getConnection(server, CONNECTION_SASCLIENT);
        return connection != null ? (SASClientConnection)connection : null;
    }

    protected Connection getConnection(ServerComponent server, String connectionType) {
        boolean isFound;
        Connection serverConnection;
        block3: {
            serverConnection = null;
            isFound = false;
            try {
                AssociationList connectionList = server.getSourceConnections();
                if (connectionList == null || connectionList.size() <= 0) break block3;
                for (int index = 0; index < connectionList.size(); ++index) {
                    serverConnection = (Connection)connectionList.get(index);
                    if (!this.isSpecifiedServer(serverConnection, connectionType)) continue;
                    isFound = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isFound ? serverConnection : null;
    }

    @Override
    public TCPIPConnection getConnectionByType(ServerComponent server, String connectionType) {
        Connection serverConnection = null;
        try {
            AssociationList connectionList = server.getSourceConnections();
            if (connectionList != null && connectionList.size() > 0) {
                for (int index = 0; index < connectionList.size(); ++index) {
                    serverConnection = (Connection)connectionList.get(index);
                    if (!serverConnection.getApplicationProtocol().equalsIgnoreCase(connectionType) || !this.isSpecifiedServer(serverConnection, CONNECTION_TCPIP)) continue;
                    return (TCPIPConnection)serverConnection;
                }
            }
        }
        catch (MdException exception) {
            String exceptionMessage = Message.format((String)RB.getStringResource("metadata.log.unable.serverproperty.fmt"), (Object)ERR_CONNECTION, (Object)server.getName());
            AnalyzerHelper.log(exceptionMessage, exception);
        }
        return null;
    }

    @Override
    public List getConnectionsByType(ServerComponent server, String connectionType) {
        Connection serverConnection = null;
        ArrayList<Connection> connections = null;
        try {
            AssociationList connectionList = server.getSourceConnections();
            if (connectionList != null && connectionList.size() > 0) {
                for (int index = 0; index < connectionList.size(); ++index) {
                    serverConnection = (Connection)connectionList.get(index);
                    if (!serverConnection.getApplicationProtocol().equalsIgnoreCase(connectionType) || !this.isSpecifiedServer(serverConnection, CONNECTION_TCPIP)) continue;
                    if (connections == null) {
                        connections = new ArrayList<Connection>();
                    }
                    connections.add(serverConnection);
                }
            }
        }
        catch (MdException exception) {
            String exceptionMessage = Message.format((String)RB.getStringResource("metadata.log.unable.serverproperty.fmt"), (Object)ERR_CONNECTION, (Object)server.getName());
            AnalyzerHelper.log(exceptionMessage, exception);
        }
        return connections;
    }

    @Override
    public List getAllConnections(ServerComponent server) {
        AssociationList connectionList = null;
        try {
            connectionList = server.getSourceConnections();
        }
        catch (MdException exception) {
            String exceptionMessage = Message.format((String)RB.getStringResource("metadata.log.unable.serverproperty.fmt"), (Object)ERR_CONNECTION, (Object)server.getName());
            AnalyzerHelper.log(exceptionMessage, exception);
        }
        return connectionList;
    }

    protected boolean isSpecifiedServer(Connection ServerConnection, String type) {
        Class serverClass = ServerConnection.getClass();
        Class<?>[] interfaces = serverClass.getInterfaces();
        String interfaceName = null;
        boolean isSpecified = false;
        for (int index = 0; index < interfaces.length && !(isSpecified = (interfaceName = interfaces[index].getName()).endsWith(type)); ++index) {
        }
        return isSpecified;
    }

    @Override
    public String getAuthenticationDomain(Connection serverConnection) {
        AuthenticationDomain domain = null;
        String domainName = null;
        try {
            if (serverConnection != null && (domain = serverConnection.getDomain()) != null) {
                domainName = domain.getName();
            }
        }
        catch (MdException e) {
            String exceptionMessage = Message.format((String)RB.getStringResource("metadata.log.unable.serverproperty.fmt"), (Object)serverConnection.getName());
            AnalyzerHelper.log(exceptionMessage, e);
        }
        return domainName == null ? "" : domainName;
    }

    public Login getLogin(Connection connection, String regex) {
        try {
            AssociationList logins;
            AuthenticationDomain domain = connection.getDomain();
            if (domain != null && (logins = domain.getLogins()) != null) {
                for (int i = 0; i < logins.size(); ++i) {
                    Pattern pt;
                    Matcher mt;
                    String loginName;
                    Login login = (Login)logins.get(i);
                    if (login == null || (loginName = login.getName()) == null || !(mt = (pt = Pattern.compile(regex, 2)).matcher(loginName)).matches()) continue;
                    return login;
                }
            }
        }
        catch (MdException e) {
            String exceptionMessage = Message.format((String)RB.getStringResource("metadata.log.unable.serverproperty.fmt"), (Object)regex);
            AnalyzerHelper.log(exceptionMessage, e);
        }
        catch (Exception e) {
            AnalyzerHelper.log(e);
        }
        return null;
    }

    private static List getAllDataPackages(String repositoryId) {
        String template = "<Templates><Directory Id=\"\" Name=\"\" DirectoryName=\"\"><DeployedComponents/><UsedByPackages/><Files/><Reports/></Directory><SASLibrary Id=\"\" Name=\"\" ><DeployedComponents/></SASLibrary><ServerContext Id=\"\" Name=\"\" /><ServerComponent Id=\"\" Name=\"\" ClassIdentifier=\"\" /><ArchiveFile Id=\"\" FileName=\"\"><Reports/></ArchiveFile><Report Id=\"\" ReportType=\"\" ><TargetClassifierMaps/></Report><ClassifierMap Id=\"\" Name=\"\"><Trees/></ClassifierMap><Tree Name=\"\"><ParentTree/></Tree></Templates>";
        MdObjectStore objectStore = null;
        List lstDataPkgs = null;
        try {
            objectStore = MdObjectFactory.createObjectStore();
            lstDataPkgs = MetadataUtil.getMetadataObjectsSubset((MdStore)objectStore, (String)repositoryId, (String)"Directory", (int)260, (String)template);
        }
        catch (Exception exception) {
            AnalyzerHelper.log(exception);
        }
        return lstDataPkgs;
    }

    private static List getClassifierMaps(String repositoryId, String contextId, String reportType) {
        String template = "<Templates><ClassifierMap><ClassifierTargets/><ComputeLocations/><Properties/><SourceCode/><Trees/></ClassifierMap><ArchiveFile><Directories/></ArchiveFile><Directory><Parent/><Properties/><DeployedComponents/></Directory><File><Directories/></File><Report><Properties/><ReportLocation/></Report><Stream><Properties/></Stream><Tree><ParentTree/><SoftwareComponents/></Tree></Templates>";
        String reportTypeAppender = "";
        if (!AnalyzerHelper.isEmpty(reportType)) {
            reportTypeAppender = "[@ReportType='" + reportType + "']";
        }
        String xmlSelect = "<XMLSelect search=\"*[@TransformRole='StoredProcess'][ClassifierTargets/Report" + reportTypeAppender + "/TargetClassifierMaps/ClassifierMap/ComputeLocations/LogicalServer/UsedByComponents/ServerContext[@Id='" + contextId + "']]\"/>";
        MdObjectStore objectStore = null;
        List lstCMs = null;
        try {
            objectStore = MdObjectFactory.createObjectStore();
            int flags = 396;
            lstCMs = MetadataUtil.getMetadataObjectsSubset((MdStore)objectStore, (String)repositoryId, (String)"ClassifierMap", (int)flags, (String)(xmlSelect + template));
        }
        catch (Exception exception) {
            AnalyzerHelper.log(exception);
        }
        return lstCMs;
    }

    @Override
    public boolean isOnSpecifiedHost(ServerComponent server, String hostName, boolean isMdTier) {
        Machine machine = null;
        Object metaHostName = null;
        boolean isOnSpecifiedHost = false;
        try {
            machine = server.getAssociatedMachine();
            if (machine != null) {
                isOnSpecifiedHost = this.isLocalMachine(machine, hostName, isMdTier);
            }
        }
        catch (MdException exception) {
            AnalyzerHelper.log(exception);
        }
        return isOnSpecifiedHost;
    }

    @Override
    public List getProductsConfigured(String hostName, String productName, boolean isMDTier) {
        Map repositories = this.getRepositories();
        List allProducts = null;
        ServerComponent server = null;
        ArrayList<ServerComponent> productsConfigured = new ArrayList<ServerComponent>();
        if (!AnalyzerHelper.isEmpty(repositories)) {
            Iterator reposIds = repositories.values().iterator();
            String reposId = null;
            while (reposIds.hasNext()) {
                reposId = (String)reposIds.next();
                allProducts = this.getServerComponentByClassId(productName, reposId);
                if (AnalyzerHelper.isEmpty(allProducts)) continue;
                for (int index = 0; index < allProducts.size(); ++index) {
                    server = (ServerComponent)allProducts.get(index);
                    if (!this.isOnSpecifiedHost(server, hostName, isMDTier)) continue;
                    productsConfigured.add(server);
                }
            }
        }
        return productsConfigured;
    }

    protected boolean isLocalMachine(Machine machine, String localHostName, boolean isMdTier) {
        boolean isLocalMachine = false;
        InetAddress localHost = AnalyzerHelper.convertToInetAddress("localhost");
        if (machine != null) {
            isLocalMachine = AnalyzerHelper.isHostsEqual(machine.getName(), localHostName);
            if (isMdTier) {
                isLocalMachine = isLocalMachine || AnalyzerHelper.isHostsEqual(localHost.getHostName(), machine.getName());
            }
        }
        return isLocalMachine;
    }

    private static List getCubes(String reposId) {
        String template = "<Templates><Cube Id=\"\" Name=\"\"><AssociatedFile></AssociatedFile></Cube><File Id=\"\" FileName=\"\"><Directories></Directories></File><Directory Id=\"\" DirectoryName=\"\"></Directory></Templates>";
        List cubes = null;
        try {
            MdObjectStore objectStore = MdObjectFactory.createObjectStore();
            cubes = MetadataUtil.getMetadataObjectsSubset((MdStore)objectStore, (String)reposId, (String)"Cube", (int)388, (String)template);
        }
        catch (MdException exception) {
            AnalyzerHelper.log(exception);
        }
        return cubes;
    }

    @Override
    public List getCubes() {
        Map repositories = this.getRepositories();
        ArrayList cubes = new ArrayList();
        List reposCubes = null;
        boolean isFound = false;
        if (!AnalyzerHelper.isEmpty(repositories)) {
            Iterator reposIds = repositories.values().iterator();
            String reposId = null;
            while (reposIds.hasNext()) {
                reposId = (String)reposIds.next();
                reposCubes = MetadataServerUtil.getCubes(reposId);
                if (AnalyzerHelper.isEmpty(reposCubes)) continue;
                cubes.addAll(reposCubes);
                isFound = true;
            }
        }
        return isFound ? cubes : null;
    }

    @Override
    public ServerComponent getSpawner(ServerComponent server) {
        boolean found;
        ServerComponent spawner;
        block3: {
            spawner = null;
            AssociationList usingComponents = null;
            found = false;
            try {
                usingComponents = server.getUsingComponents();
                Object component = null;
                if (usingComponents == null) break block3;
                for (int index = 0; index < usingComponents.size(); ++index) {
                    component = usingComponents.get(index);
                    if (!(component instanceof ServerComponent) || !this.isSpawner(((ServerComponent)component).getClassIdentifier()) || !this.isOnSpecifiedHost(spawner = (ServerComponent)component, this.localHost, this.mdTier)) continue;
                    found = true;
                    break;
                }
            }
            catch (MdException exception) {
                AnalyzerHelper.log(exception);
            }
        }
        return found ? spawner : null;
    }

    private boolean isSpawner(String classIdentifier) {
        boolean isSpawner = false;
        String spawnerPattern = "[a-zA-Z]*\\sSpawner";
        if (!AnalyzerHelper.isEmpty(classIdentifier)) {
            isSpawner = Pattern.matches(spawnerPattern, classIdentifier);
        }
        return isSpawner;
    }

    @Override
    public String getContextRelativePath(ServerContext context, String commandPattern) {
        String contextRelPath = null;
        try {
            if (context != null) {
                AssociationList logicalServers = context.getUsingComponents();
                AssociationList servers = null;
                LogicalServer logicalServer = null;
                ServerComponent server = null;
                if (!AnalyzerHelper.isEmpty(logicalServers)) {
                    for (int index = 0; index < logicalServers.size(); ++index) {
                        if (!(logicalServers.get(index) instanceof LogicalServer) || AnalyzerHelper.isEmpty(servers = (logicalServer = (LogicalServer)logicalServers.get(index)).getUsingComponents())) continue;
                        for (int serverIndex = 0; serverIndex < servers.size(); ++serverIndex) {
                            server = (ServerComponent)servers.get(serverIndex);
                            contextRelPath = this.getConfigCommand(server);
                            if (AnalyzerHelper.isEmpty(contextRelPath) || AnalyzerHelper.isEmpty(contextRelPath = AnalyzerHelper.parseConfigFile(contextRelPath, commandPattern))) continue;
                            return contextRelPath;
                        }
                    }
                }
            }
        }
        catch (MdException exception) {
            AnalyzerHelper.log(exception);
        }
        return null;
    }

    protected List getLogins(String repositoryId, String identityGroup) {
        List lstLogins = null;
        MdObjectStore objectStore = null;
        int iFlags = 260;
        String template = "<Templates><Login Id=\"\" UserID=\"\" Name=\"\"><AssociatedIdentity></AssociatedIdentity><SourceTranformations></SourceTranformations></Login><IdentityGroup Name=\"\"></IdentityGroup><Transformation Name=\"\"><DeployedComponents></DeployedComponents></Transformation><LogicalServer><UsingComponents></UsingComponents></LogicalServer><ServerComponent Name=\"\"><AssociatedMachine></AssociatedMachine></ServerComponent><Machine Name=\"\"></Machine></Templates>";
        if (identityGroup != null) {
            template = template.concat("<XMLSelect Search=\"Login[AssociatedIdentity/IdentityGroup[@Name='" + identityGroup + "']]\"/>");
            iFlags |= 0x80;
        }
        try {
            objectStore = MdObjectFactory.createObjectStore();
            lstLogins = MetadataUtil.getMetadataObjectsSubset((MdStore)objectStore, (String)repositoryId, (String)"Login", (int)iFlags, (String)template);
        }
        catch (Exception exception) {
            AnalyzerHelper.log(exception);
        }
        return lstLogins;
    }

    protected Map getAllLogins(String identityGroup) {
        Object[] reposIDs;
        Collection colReposIDS;
        HashMap<Object, List> mpLogins = null;
        Map repositories = this.getRepositories();
        if (!(AnalyzerHelper.isEmpty(repositories) || AnalyzerHelper.isEmpty(colReposIDS = repositories.values()) || AnalyzerHelper.isEmpty(reposIDs = colReposIDS.toArray()))) {
            for (int i = 0; i < reposIDs.length; ++i) {
                List lstLogins;
                if (!(reposIDs[i] instanceof String) || AnalyzerHelper.isEmpty(lstLogins = this.getLogins((String)reposIDs[i], identityGroup))) continue;
                if (mpLogins == null) {
                    mpLogins = new HashMap<Object, List>();
                }
                mpLogins.put(reposIDs[i], lstLogins);
            }
        }
        return mpLogins;
    }

    @Override
    public List getAllLogins(String identityGroup, String localhost, boolean isMDTier) {
        List lstAllLogins;
        ArrayList<Login> validLogins = new ArrayList<Login>();
        Map mpAllLogins = this.getAllLogins(identityGroup);
        if (!AnalyzerHelper.isEmpty(mpAllLogins) && !AnalyzerHelper.isEmpty(lstAllLogins = AnalyzerHelper.getMultiMapValues(mpAllLogins))) {
            for (int i = 0; i < lstAllLogins.size(); ++i) {
                Object obj = lstAllLogins.get(i);
                if (!(obj instanceof Login)) continue;
                try {
                    boolean isValid = false;
                    Login login = (Login)obj;
                    boolean isSCCheckDone = false;
                    AssociationList lstTransformations = login.getSourceTransformations();
                    if (!AnalyzerHelper.isEmpty(lstTransformations)) {
                        for (int j = 0; j < lstTransformations.size(); ++j) {
                            Transformation trans;
                            AssociationList lstDepComps;
                            Object objTrans = lstTransformations.get(j);
                            if (objTrans instanceof Transformation && !AnalyzerHelper.isEmpty(lstDepComps = (trans = (Transformation)objTrans).getDeployedComponents())) {
                                for (int k = 0; k < lstDepComps.size(); ++k) {
                                    Object objServer = lstDepComps.get(k);
                                    if (objServer instanceof LogicalServer) {
                                        isSCCheckDone = true;
                                        AssociationList lstSrvComps = ((LogicalServer)objServer).getUsingComponents();
                                        if (!AnalyzerHelper.isEmpty(lstSrvComps)) {
                                            for (int l = 0; l < lstSrvComps.size(); ++l) {
                                                objServer = lstSrvComps.get(l);
                                                if (!(objServer instanceof ServerComponent) || !this.isOnSpecifiedHost((ServerComponent)objServer, localhost, isMDTier)) continue;
                                                isValid = true;
                                                break;
                                            }
                                        }
                                    } else if (objServer instanceof ServerComponent) {
                                        isSCCheckDone = true;
                                        if (this.isOnSpecifiedHost((ServerComponent)objServer, localhost, isMDTier)) {
                                            isValid = true;
                                        }
                                    }
                                    if (isValid) break;
                                }
                            }
                            if (isValid) break;
                        }
                    }
                    if (!isSCCheckDone) {
                        String userID = login.getUserID();
                        String message = Message.format((String)RB.getStringResource("metautil.login.not.associated.with.server.log.fmt"), (Object)login.getName(), (Object)userID);
                        AnalyzerHelper.log(message, 2);
                        if (userID != null) {
                            String domain;
                            int index = userID.indexOf("\\");
                            if (index > 0) {
                                domain = userID.substring(0, index);
                                isValid = AnalyzerHelper.isHostsEqual(domain, localhost);
                            } else {
                                index = userID.indexOf("@");
                                if (index > 0 && index < userID.length() - 2) {
                                    domain = userID.substring(index + 1, userID.length());
                                    isValid = AnalyzerHelper.isHostsEqual(domain, localhost);
                                }
                            }
                        }
                    }
                    if (!isValid) continue;
                    validLogins.add(login);
                    continue;
                }
                catch (MdException e) {
                    AnalyzerHelper.log(e);
                }
            }
        }
        return validLogins.isEmpty() ? null : validLogins;
    }

    @Override
    public Login getAssociatedLogin(ServerComponent server) {
        block6: {
            if (server != null) {
                try {
                    AssociationList lstInitProcesses = server.getInitProcesses();
                    if (AnalyzerHelper.isEmpty(lstInitProcesses)) break block6;
                    for (int i = 0; i < lstInitProcesses.size(); ++i) {
                        Object objTrans = lstInitProcesses.get(i);
                        if (!(objTrans instanceof Transformation)) continue;
                        Transformation trans = (Transformation)objTrans;
                        AssociationList lstTransSources = trans.getTransformationSources();
                        if (!AnalyzerHelper.isEmpty(lstTransSources)) {
                            for (int j = 0; j < lstTransSources.size(); ++j) {
                                Object objLogin = lstTransSources.get(j);
                                if (!(objLogin instanceof Login)) continue;
                                return (Login)objLogin;
                            }
                        }
                        break;
                    }
                }
                catch (MdException e) {
                    AnalyzerHelper.log(e);
                }
            }
        }
        return null;
    }

    @Override
    public Machine getServerClusterMachine(ServerComponent server, String hostName, boolean isMdTier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List getServerClusterGroup(ServerComponent server) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHost(String localHost, boolean mdTier) {
        this.localHost = localHost;
        this.mdTier = mdTier;
    }

    @Override
    public OLAPSchema getOLAPSchema(ServerComponent server) {
        ServerContext context = this.getServerContext(server);
        String contextId = context.getId();
        String xmlSelect = "<XMLSelect Search=\"OLAPSchema[DeployedComponents/ServerContext[@Id='" + contextId + "']]\"/>";
        AnalyzerHelper.log("Searching OLAP Schema for : " + server.getName(), 2);
        int flags = 388;
        boolean found = false;
        Map repository = this.getRepositories();
        List schemas = null;
        OLAPSchema olapSchema = null;
        String repositoryId2 = null;
        if (repository != null) {
            for (String repositoryId2 : repository.values()) {
                try {
                    MdObjectStore objectStore = MdObjectFactory.createObjectStore();
                    schemas = MetadataUtil.getMetadataObjectsSubset((MdStore)objectStore, (String)repositoryId2, (String)"OLAPSchema", (int)flags, (String)xmlSelect);
                    if (AnalyzerHelper.isEmpty(schemas)) continue;
                    olapSchema = (OLAPSchema)schemas.get(0);
                    found = true;
                    break;
                }
                catch (Exception exception) {
                    AnalyzerHelper.log("Unable to find the OLAP Schema : " + exception.getMessage(), 0);
                }
            }
        }
        String logMessage = olapSchema != null ? "Found OLAP Schema " + olapSchema.getName() : "OLAP Schema not found";
        AnalyzerHelper.log(logMessage, 2);
        return olapSchema;
    }

    static {
        templates = null;
        m_metadataHost = null;
        m_metadataPort = null;
        m_metadataUser = null;
        m_metadataPassword = null;
        templates = new HashMap();
        templates.put("ServerComponent", "");
        templates.put("ServerContext", "");
        templates.put("DeployedDataPackage", "");
        templates.put("Login", "");
        templates.put("ClassifierMap", "");
        templates.put("Cube", "");
        MdObjectFactory mdFactory = MdObjectFactory.getInstance();
        mdFactory.setDebug(false);
        mdFactory.setLoggingEnabled(false);
    }
}

