/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.common;

import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FileCollection {
    private static final int DEFAULT_CACHE_SIZE = 8192;
    private static int CACHE_SIZE = 8192;
    private Map<String, List<String>> filesCollection = new LinkedHashMap<String, List<String>>();
    private int capacity = 0;
    private File dumpFile;
    private boolean isInCache = false;

    public FileCollection(File dumpFile) {
        this.dumpFile = dumpFile;
    }

    public void put(String dirPath, List<String> files) {
        if (this.cacheFull()) {
            this.dump(true);
        }
        this.filesCollection.put(dirPath, files);
    }

    public void putAll(Map map) {
        if (this.cacheFull()) {
            this.dump(true);
        }
        this.filesCollection.putAll(map);
    }

    public List<String> getFiles(String dirPath) {
        List<String> files = null;
        this.ensurePresence(dirPath);
        if (this.filesCollection.containsKey(dirPath)) {
            files = this.filesCollection.get(dirPath);
        }
        return files;
    }

    private void ensurePresence(String dirPath) {
        if (!this.filesCollection.containsKey(dirPath)) {
            this.pull(dirPath);
        }
    }

    private boolean cacheFull() {
        return this.filesCollection.size() >= CACHE_SIZE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(boolean clear) {
        BufferedWriter writer = null;
        String dirPath2 = null;
        List<String> files = null;
        String dumpString = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.dumpFile, true));
            if (!AnalyzerHelper.isEmpty(this.filesCollection)) {
                this.capacity += this.filesCollection.size();
                for (String dirPath2 : this.filesCollection.keySet()) {
                    files = this.filesCollection.get(dirPath2);
                    dumpString = dirPath2 + "|" + "|" + AnalyzerHelper.listAsString(files, "|");
                    writer.write(dumpString);
                    writer.newLine();
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            if (clear) {
                this.filesCollection.clear();
            }
        }
    }

    public static List<String> getFileList(String line) {
        int dirPathIndex;
        List<String> perms = null;
        String tempStr = null;
        if (!AnalyzerHelper.isEmpty(line) && (dirPathIndex = line.indexOf("||")) != -1 && line.length() > dirPathIndex) {
            tempStr = line.substring(dirPathIndex + 1);
        }
        if (!AnalyzerHelper.isEmpty(tempStr)) {
            perms = Arrays.asList(tempStr.split("\\|"));
        }
        return perms;
    }

    public static String getDirectoryPath(String line) {
        int fileNameIndex;
        String fileName = null;
        if (!AnalyzerHelper.isEmpty(line) && (fileNameIndex = line.indexOf("||")) != -1) {
            fileName = line.substring(0, fileNameIndex);
        }
        return fileName;
    }

    public boolean contains(String dirPath) {
        boolean contains = true;
        if (!this.filesCollection.containsKey(dirPath)) {
            contains = this.checkDump(dirPath);
        }
        return contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDump(String dirPath) {
        BufferedReader reader = null;
        String line = null;
        boolean isPresent = false;
        try {
            reader = new BufferedReader(new FileReader(this.dumpFile));
            while ((line = reader.readLine()) != null) {
                if (line.indexOf(dirPath) == -1) continue;
                isPresent = true;
                break;
            }
        }
        catch (IOException exception) {
            AnalyzerHelper.log(exception);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return isPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pull(String dirPath) {
        BufferedReader reader = null;
        String line = null;
        boolean extract = false;
        int extracatedCount = 0;
        try {
            reader = new BufferedReader(new FileReader(this.dumpFile));
            while ((line = reader.readLine()) != null) {
                if (line.indexOf(dirPath) != -1) {
                    this.filesCollection.put(dirPath, FileCollection.getFileList(line));
                    extract = true;
                    continue;
                }
                if (!extract) continue;
                if (extracatedCount < CACHE_SIZE) {
                    this.filesCollection.put(FileCollection.getDirectoryPath(line), FileCollection.getFileList(line));
                    continue;
                }
                break;
            }
        }
        catch (IOException exception) {
            AnalyzerHelper.log(exception);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.isInCache = extract;
        return extract;
    }

    public Iterator iterator() {
        if (!this.isInCache) {
            this.dump(false);
        }
        return new Iterator(){
            private BufferedReader streamReader;
            private String nextLine = null;
            {
                try {
                    this.streamReader = new BufferedReader(new FileReader(FileCollection.this.dumpFile));
                    this.nextLine = this.streamReader.readLine();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public boolean hasNext() {
                return this.nextLine != null;
            }

            public Object next() {
                String nextObject = this.nextLine;
                try {
                    this.nextLine = this.streamReader.readLine();
                    if (this.nextLine == null) {
                        this.closeStream();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return nextObject;
            }

            @Override
            public void remove() {
            }

            private void closeStream() {
                if (this.streamReader != null) {
                    try {
                        this.streamReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
    }
}

