/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.common;

import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.export.common.FileCollection;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Directory {
    private List cacheUnaccessible;
    private List cacheSoftLinks;
    private Map cacheDirectorySizes;
    private FileCollection packagedFiles;
    private FileCollection excludedFiles;
    private Set<File> resultList = new HashSet<File>();
    private boolean packagedFileListCreated = false;
    private String root;
    private static Directory instance0;
    private File rootDirectory;
    private long rootOnlySize;
    private boolean rootOnlyInstance;

    public boolean isPackagedFileListCreated() {
        return this.packagedFileListCreated;
    }

    public FileCollection getPackagedFiles() {
        return this.packagedFiles;
    }

    public void setPackagedFiles(FileCollection packagedFiles) {
        if (this.packagedFileListCreated) {
            AnalyzerHelper.log("List already created", 1);
        } else {
            this.packagedFiles = packagedFiles;
            this.packagedFileListCreated = true;
        }
    }

    public FileCollection getExcludedFiles() {
        return this.excludedFiles;
    }

    public long getRootOnlySize() {
        return this.rootOnlySize;
    }

    private Directory(String root, boolean rootOnly) {
        this.root = root;
        this.cacheDirectorySizes = new HashMap();
        this.cacheUnaccessible = new ArrayList();
        this.cacheSoftLinks = new ArrayList();
        this.rootDirectory = new File(root);
        this.rootOnlyInstance = rootOnly;
        long cuurtime = System.currentTimeMillis();
        this.rootOnlySize = this.scanDirectory(this.rootDirectory, 0L, rootOnly);
    }

    private Directory(String root, Set<File> includeFile) {
        this.root = root;
        this.cacheDirectorySizes = new HashMap();
        this.cacheUnaccessible = new ArrayList();
        this.cacheSoftLinks = new ArrayList();
        this.rootDirectory = new File(root);
        long cuurtime = System.currentTimeMillis();
        this.rootOnlySize = this.scanDirectory(this.rootDirectory, 0L, includeFile);
    }

    public static Directory getDirectoryInstance(String rootPath) {
        return new Directory(rootPath, false);
    }

    public static Directory getRootDiretctoryInstance(String rootPath) {
        return new Directory(rootPath, true);
    }

    public static Directory getDirectoryFilterInstance(String rootPath, Set<File> includeFile) {
        return new Directory(rootPath, includeFile);
    }

    private long scanDirectory(File root, long size, Set<File> includeFile) {
        long dirSize = 0L;
        if (root != null) {
            ArrayList<File> children = null;
            Set<File> listDir = this.listDirectory(root.getAbsolutePath());
            if (listDir != null) {
                children = new ArrayList<File>(listDir);
            }
            if (children != null && children.size() > 0) {
                ArrayList filterDirectory = new ArrayList();
                for (int i = 0; i < children.size(); ++i) {
                    if (!includeFile.contains(children.get(i))) continue;
                    filterDirectory.add(children.get(i));
                }
                if (filterDirectory != null && filterDirectory.size() >= 1) {
                    for (int index = 0; index < filterDirectory.size(); ++index) {
                        File file = (File)filterDirectory.get(index);
                        if (!Directory.isSoftLink(file)) {
                            if (Directory.canRead(file)) {
                                if (file.isFile()) {
                                    size += file.length();
                                    continue;
                                }
                                if (!file.isDirectory()) continue;
                                size += dirSize;
                                this.cacheDirectorySizes.put(file.getPath(), String.valueOf(dirSize));
                                continue;
                            }
                            this.cacheUnaccessible.add(file.getPath());
                            continue;
                        }
                        this.cacheSoftLinks.add(file.getPath());
                    }
                }
            }
        }
        return size;
    }

    public Set<File> listDirectory(String root) {
        File directory = new File(root);
        File[] fList = directory.listFiles();
        if (fList != null) {
            for (File f : fList) {
                if (!f.isDirectory()) continue;
                this.resultList.add(f);
                this.listDirectory(f.getAbsolutePath());
            }
        }
        return this.resultList;
    }

    private long scanDirectory(File root, long size, boolean rootOnly) {
        File[] children;
        long dirSize = 0L;
        if (root != null && (children = root.listFiles()) != null && children.length > 0) {
            for (int index = 0; index < children.length; ++index) {
                if (!Directory.isSoftLink(children[index])) {
                    if (Directory.canRead(children[index])) {
                        if (children[index].isFile()) {
                            size += children[index].length();
                            continue;
                        }
                        if (rootOnly || !children[index].isDirectory()) continue;
                        dirSize = this.scanDirectory(children[index], 0L, rootOnly);
                        size += dirSize;
                        this.cacheDirectorySizes.put(children[index].getPath(), String.valueOf(dirSize));
                        continue;
                    }
                    this.cacheUnaccessible.add(children[index].getPath());
                    continue;
                }
                this.cacheSoftLinks.add(children[index].getPath());
            }
        }
        return size;
    }

    public static boolean isAccessible(File file) {
        return file != null && file.exists() && (!Directory.isSoftLink(file) || !Directory.canRead(file));
    }

    public static boolean isSoftLink(File file) {
        boolean isSoftLink = false;
        try {
            if (file != null && file.exists()) {
                String canonicalPath = file.getCanonicalPath();
                String absolutePath = file.getAbsolutePath();
                isSoftLink = canonicalPath.toLowerCase().indexOf(absolutePath.toLowerCase()) != -1;
                boolean bl = isSoftLink = !canonicalPath.toLowerCase().equals(absolutePath.toLowerCase());
                if (isSoftLink) {
                    isSoftLink = canonicalPath.toLowerCase().indexOf(absolutePath.toLowerCase()) == -1;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isSoftLink;
    }

    private static String getPath(File file) {
        String path = null;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException exception) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    public List getUnaccessibleFileList() {
        return new ArrayList(this.cacheUnaccessible);
    }

    public String getRelativePath(File child) {
        return Directory.getRelativePath(this.rootDirectory, child);
    }

    public String getRelativePath(String childPath) {
        if (childPath != null) {
            File child = new File(childPath);
            return Directory.getRelativePath(this.rootDirectory, child);
        }
        return null;
    }

    public static String getRelativePath(File parent, File child) {
        String relativePath = null;
        if (parent != null && child != null) {
            String parentPath = null;
            String childPath = null;
            parentPath = Directory.getPath(parent);
            childPath = Directory.getPath(child);
            if (childPath.indexOf(parentPath) == 0 && childPath.length() > parentPath.length()) {
                relativePath = childPath.substring(parentPath.length() + (parent.getParent() == null ? 0 : 1));
            }
        }
        return relativePath;
    }

    public boolean isChild(String child) {
        if (child != null) {
            File childFile = new File(child);
            return this.getRelativePath(childFile) != null;
        }
        return false;
    }

    public long size(String childPath) {
        long size = -1L;
        if (this.isChild(childPath) && !this.cacheUnaccessible.contains(childPath)) {
            size = this.getCachedSize(childPath);
        }
        return size;
    }

    private long getCachedSize(String path) {
        long size = -1L;
        if (this.cacheDirectorySizes.containsKey(path)) {
            String sizeValue = (String)this.cacheDirectorySizes.get(path);
            size = Long.parseLong(sizeValue);
        } else {
            File childFile = new File(path);
            size = childFile.length();
        }
        return size;
    }

    public List listFiles(String subDirectory) {
        List<Object> subDirectories = null;
        if (this.canAccess(subDirectory)) {
            subDirectories = new ArrayList();
            File subDir = new File(subDirectory);
            if (this.rootOnlyInstance) {
                subDirectories = this.getFileObjects(this.listFilesOnly());
            } else {
                File[] list = subDir.listFiles();
                if (!AnalyzerHelper.isEmpty(list)) {
                    subDirectories = Arrays.asList(list);
                }
            }
        }
        return subDirectories;
    }

    private List getFileObjects(List filePaths) {
        ArrayList<File> files = null;
        if (!AnalyzerHelper.isEmpty(filePaths)) {
            files = new ArrayList<File>(filePaths.size());
            for (int index = 0; index < filePaths.size(); ++index) {
                files.add(new File((String)filePaths.get(index)));
            }
        }
        return files;
    }

    public List listFilesOnly() {
        return this.filterOnly(true);
    }

    private List filterOnly(final boolean isFile) {
        ArrayList<String> filesOnly = null;
        File[] files = this.rootDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                return isFile ? child.isFile() : child.isDirectory();
            }
        });
        if (!AnalyzerHelper.isEmpty(files)) {
            String filePath = null;
            filesOnly = new ArrayList<String>();
            for (int index = 0; index < files.length; ++index) {
                if (!Directory.isAccessible(files[index])) continue;
                filePath = files[index].getPath();
                filesOnly.add(filePath);
            }
        }
        return filesOnly;
    }

    public List lisDirOnly() {
        return this.filterOnly(false);
    }

    public static boolean contains(File root, String pattern) {
        boolean contains = false;
        String child = null;
        if (root != null && pattern != null) {
            String[] children = root.list();
            Pattern pat = Pattern.compile(pattern);
            Matcher matcher = null;
            if (children != null) {
                for (int index = 0; index < children.length; ++index) {
                    child = children[index];
                    matcher = pat.matcher(child);
                    if (!matcher.find()) continue;
                    contains = true;
                    break;
                }
            }
        }
        return contains;
    }

    public List listAll(String pattern) {
        ArrayList<String> files = null;
        List subDirs = this.listDirs(pattern);
        File subDir = null;
        File[] searched = null;
        if (subDirs != null) {
            files = new ArrayList<String>();
            final Pattern pat = Pattern.compile(pattern);
            for (int index = 0; index < subDirs.size(); ++index) {
                subDir = new File((String)subDirs.get(index));
                searched = subDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File parent, String name) {
                        Matcher matcher = pat.matcher(name);
                        return matcher.find();
                    }
                });
                if (searched == null) continue;
                for (int fIndex = 0; fIndex < searched.length; ++fIndex) {
                    files.add(searched[fIndex].getPath());
                }
            }
        }
        return files;
    }

    public List listDirs(String pattern) {
        ArrayList<String> dirs = new ArrayList<String>();
        ArrayList allDirs = new ArrayList();
        List accessibleDirs = this.getAccessibleDirs();
        String path = null;
        if (!AnalyzerHelper.isEmpty(accessibleDirs)) {
            allDirs.addAll(accessibleDirs);
        }
        for (int index = 0; index < allDirs.size(); ++index) {
            path = (String)allDirs.get(index);
            if (!Directory.contains(new File(path), pattern)) continue;
            dirs.add(path);
        }
        return !AnalyzerHelper.isEmpty(dirs) ? dirs : null;
    }

    private boolean isSubDirectory(String subDirectory) {
        return this.cacheDirectorySizes.containsKey(subDirectory);
    }

    public boolean canAccess(String child) {
        return !this.cacheUnaccessible.contains(child);
    }

    public static String getRelativePath(String parentPath, String childPath) {
        if (parentPath != null && childPath != null) {
            File parent = new File(parentPath);
            File child = new File(childPath);
            return Directory.getRelativePath(parent, child);
        }
        return null;
    }

    public List getUnaccessibleFiles(String parentPath) {
        List allUnaccessible = new ArrayList();
        List unaccessible = this.getUnaccessibleFiles(parentPath, this.cacheUnaccessible);
        if (unaccessible != null) {
            allUnaccessible = unaccessible;
        }
        if ((unaccessible = this.getUnaccessibleFiles(parentPath, this.cacheSoftLinks)) != null) {
            allUnaccessible.addAll(unaccessible);
        }
        return AnalyzerHelper.isEmpty(allUnaccessible) ? null : allUnaccessible;
    }

    private List getUnaccessibleFiles(String parentPath, List excludeList) {
        String unaccessiblePath = null;
        ArrayList<String> unaccessible = new ArrayList<String>();
        String relPath = null;
        for (int index = 0; index < excludeList.size(); ++index) {
            unaccessiblePath = (String)excludeList.get(index);
            relPath = Directory.getRelativePath(parentPath, unaccessiblePath);
            if (relPath == null) continue;
            unaccessible.add(relPath);
        }
        return AnalyzerHelper.isEmpty(unaccessible) ? null : unaccessible;
    }

    public boolean dumpUnAccessibleFileList(String toFile) {
        return false;
    }

    public File getFileInstance() {
        return new File(this.rootDirectory.getPath());
    }

    public boolean softLinksPresent() {
        return this.cacheSoftLinks.size() > 0;
    }

    public boolean unaccessibleFilesPresent() {
        return this.cacheUnaccessible.size() > 0;
    }

    public List getSoftLinks() {
        return this.softLinksPresent() ? new ArrayList(this.cacheSoftLinks) : null;
    }

    public List getAccessibleDirs() {
        ArrayList<String> subDirectories = null;
        subDirectories = new ArrayList<String>();
        subDirectories.add(this.rootDirectory.getPath());
        if (!AnalyzerHelper.isEmpty(this.cacheDirectorySizes)) {
            Iterator subDirs = this.cacheDirectorySizes.keySet().iterator();
            String subDirPath = null;
            while (subDirs.hasNext()) {
                subDirPath = (String)subDirs.next();
                if (this.isUnaccessible(subDirPath)) continue;
                subDirectories.add(subDirPath);
            }
        }
        return subDirectories;
    }

    public boolean isUnaccessible(String path) {
        return this.cacheSoftLinks.contains(path) || this.cacheUnaccessible.contains(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canRead(File file) {
        boolean canRead = false;
        if (file != null) {
            String[] newfiles;
            canRead = file.canRead();
            FileReader reader = null;
            if (canRead && !file.isDirectory()) {
                try {
                    reader = new FileReader(file);
                }
                catch (FileNotFoundException exception) {
                    canRead = false;
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException exception) {}
                    }
                }
            } else if (file.isDirectory() && (newfiles = file.list()) == null) {
                canRead = false;
            }
        }
        return canRead;
    }

    public static boolean canRead(String path) {
        boolean canRead = false;
        if (path != null) {
            File file = new File(path);
            canRead = Directory.canRead(file);
        }
        return canRead;
    }

    public static boolean isChild(String parent, String child) {
        boolean isChild = false;
        if (parent != null && child != null) {
            File parentFile = new File(parent);
            File childFile = new File(child);
            try {
                parentFile = parentFile.getCanonicalFile();
            }
            catch (IOException e) {
                AnalyzerHelper.log(e);
            }
            try {
                childFile = childFile.getCanonicalFile();
            }
            catch (IOException e) {
                AnalyzerHelper.log(e);
            }
            for (File childParent = childFile.getParentFile(); childParent != null; childParent = childParent.getParentFile()) {
                if (!parentFile.equals(childParent)) continue;
                isChild = true;
                break;
            }
        }
        return isChild;
    }

    public static String getChildPath(String parent, String child) {
        boolean isChild = false;
        String relChildPath = null;
        if (parent != null && child != null) {
            File parentFile = new File(parent);
            File childFile = new File(child);
            try {
                parentFile = parentFile.getCanonicalFile();
            }
            catch (IOException e) {
                AnalyzerHelper.log(e);
            }
            try {
                childFile = childFile.getCanonicalFile();
            }
            catch (IOException e) {
                AnalyzerHelper.log(e);
            }
            String tmpChildPath = childFile.getName();
            for (File childParent = childFile.getParentFile(); childParent != null; childParent = childParent.getParentFile()) {
                if (parentFile.equals(childParent)) {
                    isChild = true;
                    relChildPath = tmpChildPath;
                    break;
                }
                tmpChildPath = childParent.getName() + File.separator + tmpChildPath;
            }
        }
        return relChildPath;
    }

    public String getName() {
        return this.rootDirectory.getName();
    }

    public static boolean dirEquals(String path1, String path2) {
        boolean equals = false;
        if (path1 != null && path2 != null) {
            File file1 = new File(path1);
            File file2 = new File(path2);
            equals = file1.equals(file2);
        }
        return equals;
    }

    public boolean rootOnlyInstance() {
        return this.rootOnlyInstance;
    }
}

