/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.common;

import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.export.common.Directory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataFilterProperties {
    static String PROP_EXCLUDE_DIR_SUFFIX = "levconfig.exclude.dir.";
    static String PROP_INCLUDE_DIR = "";
    private Map<String, List<File>> excludedDirs = new HashMap<String, List<File>>();
    private static DataFilterProperties props;

    private DataFilterProperties() {
        this.init();
    }

    private void init() {
        Map<String, String> excluded = AnalyzerHelper.getProperties(PROP_EXCLUDE_DIR_SUFFIX);
        if (!AnalyzerHelper.isEmpty(excluded)) {
            Set<String> props = excluded.keySet();
            String _12Byte = null;
            String value = null;
            for (String prop : props) {
                _12Byte = prop.substring(PROP_EXCLUDE_DIR_SUFFIX.length());
                value = excluded.get(prop);
                this.addMultiMapValue(_12Byte, this.normalize(value));
            }
        }
    }

    private String normalize(String path) {
        String normalized = null;
        if (path != null) {
            normalized = path;
            File f = new File(path);
            String configDir = AnalyzerHelper.getProperty("SMU.config.dir");
            if (!f.isAbsolute()) {
                f = new File(configDir, path);
                try {
                    normalized = f.getCanonicalPath();
                }
                catch (IOException excpetion) {
                    normalized = f.getAbsolutePath();
                }
            }
        }
        return normalized;
    }

    public static DataFilterProperties getInstance() {
        if (props == null) {
            props = new DataFilterProperties();
        }
        return props;
    }

    public List<File> getAllExcluded() {
        return AnalyzerHelper.getMultiMapValues(this.excludedDirs);
    }

    public List<String> getExcluded(String root) {
        ArrayList<String> excluded = null;
        List allValues = AnalyzerHelper.getMultiMapValues(this.excludedDirs);
        if (!AnalyzerHelper.isEmpty(allValues)) {
            excluded = new ArrayList<String>(allValues.size());
            for (File path : allValues) {
                AnalyzerHelper.log(" Finding Excluded for : " + path, 4);
                if (!Directory.isChild(root, path.getAbsolutePath())) continue;
                excluded.add(path.getAbsolutePath());
            }
        }
        return excluded;
    }

    public List<String> getExcludedfor12Byte(String _12Byte) {
        List<File> files = this.excludedDirs.get(_12Byte);
        ArrayList<String> fileNames = null;
        if (files != null) {
            fileNames = new ArrayList<String>(files.size());
            for (File file : files) {
                fileNames.add(file.getAbsolutePath());
            }
        }
        return fileNames;
    }

    public boolean isExcluded(String path) {
        if (path != null) {
            File f = new File(path);
            File canPath = new File(path);
            try {
                canPath = f.getCanonicalFile();
                List allValues = AnalyzerHelper.getMultiMapValues(this.excludedDirs);
                return !AnalyzerHelper.isEmpty(allValues) && allValues.contains(canPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private void addMultiMapValue(String _12Byte, String value) {
        List<Object> values = null;
        if (this.excludedDirs.containsKey(_12Byte)) {
            values = this.excludedDirs.get(_12Byte);
        } else {
            values = new ArrayList();
            this.excludedDirs.put(_12Byte, values);
        }
        values.add(new File(value));
    }
}

