/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.common;

import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.export.common.ConfigItemFilterData;
import com.sas.apps.content.migration.export.common.ConfigItems;
import com.sas.apps.content.migration.export.common.DataFilterProperties;
import com.sas.apps.content.migration.export.common.Directory;
import com.sas.apps.content.migration.export.common.MetadataAccess;
import com.sas.apps.content.migration.export.common.ReadableSelector;
import com.sas.metadata.AssociationList;
import com.sas.metadata.Cube;
import com.sas.metadata.Root;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.FileSelector;

public class ConfigItemFilter {
    private String configFolder;
    private Directory directory;
    private ConfigItems configItems;
    private MetadataAccess metaAccess;
    private static final String METHOD_PREFIX = "process";
    private static final String PREFIX_EXCLUDE = "ExcludeType";
    private final String PROP_CUBE_FOLDER_NAME = "CUBEFOLDER";
    private static final String EXCLUDE_ITEM_WRSTEMP = "WRSTEMP";
    private static ConfigItemFilter filter = null;

    private ConfigItemFilter(String configFolder) {
        this.configFolder = configFolder;
    }

    private ConfigItemFilter(String configFolder, Directory dir) {
        this.configFolder = configFolder;
        this.directory = dir;
    }

    public static ConfigItemFilter getConfigItemsFilter(String configFolder) {
        filter = new ConfigItemFilter(configFolder);
        return filter;
    }

    public static ConfigItemFilter getConfigItemsFilter(Directory dir) {
        File fileInstance = dir.getFileInstance();
        String configFolder = fileInstance.getName();
        filter = new ConfigItemFilter(configFolder, dir);
        return filter;
    }

    public void setMetaAccess(MetadataAccess metaAccess) {
        this.metaAccess = metaAccess;
    }

    public List doExcludeFilter(String filterData) {
        String processMethodName = "processExcludeType" + filterData;
        return this.invokeMethod(processMethodName, null);
    }

    public List doFilter(ConfigItemFilterData filterData) {
        String methodName = METHOD_PREFIX + filterData.getProcessName();
        List filteredData = this.invokeMethod(methodName, filterData);
        return filteredData;
    }

    private List invokeMethod(String processMethodName, ConfigItemFilterData filterData) {
        Method processMethod = null;
        Object result = null;
        Class<?> filterReference = null;
        ArrayList methodResult = new ArrayList();
        Object params = null;
        try {
            filterReference = filter.getClass();
            if (filterData != null && filterData.paramSet()) {
                processMethod = filterReference.getDeclaredMethod(processMethodName, String.class);
                result = processMethod.invoke((Object)filter, filterData.getPattern());
            } else {
                processMethod = filterReference.getDeclaredMethod(processMethodName, null);
                result = processMethod.invoke((Object)filter, null);
            }
            if (result != null && result instanceof List) {
                methodResult.addAll((List)result);
            }
        }
        catch (NoSuchMethodException exception) {
            AnalyzerHelper.log(exception);
        }
        catch (IllegalAccessException exception) {
            AnalyzerHelper.log(exception);
        }
        catch (InvocationTargetException exception) {
            AnalyzerHelper.log(exception);
        }
        return methodResult;
    }

    List processCubes(String contextName) {
        if (!AnalyzerHelper.isEmpty(this.metaAccess)) {
            List cubes = this.metaAccess.getCubes();
            Cube cube = null;
            com.sas.metadata.File cubeFile = null;
            com.sas.metadata.Directory directory = null;
            String directoryName = null;
            String fileName = null;
            AssociationList directories = null;
            File context = contextName != null ? new File(contextName) : this.directory.getFileInstance();
            File cubeDirectory = null;
            ArrayList<String> cubeExcludeFolders = null;
            try {
                if (!AnalyzerHelper.isEmpty(cubes)) {
                    cubeExcludeFolders = new ArrayList<String>();
                    for (int index = 0; index < cubes.size(); ++index) {
                        cube = (Cube)cubes.get(index);
                        cubeFile = cube.getAssociatedFile();
                        if (cubeFile == null) continue;
                        fileName = this.getCubeFolderName(cube);
                        directories = cubeFile.getDirectories();
                        if (directories == null) continue;
                        for (int dirIndex = 0; dirIndex < directories.size(); ++dirIndex) {
                            directory = (com.sas.metadata.Directory)directories.get(dirIndex);
                            if (directory == null) continue;
                            directoryName = directory.getDirectoryName();
                            AnalyzerHelper.log("Directory Name is : " + directoryName, 2);
                            cubeDirectory = new File(directoryName);
                            String cubeFileRoot = null;
                            if (!cubeDirectory.isAbsolute()) {
                                AnalyzerHelper.log("Relative path specified : ", 2);
                                cubeFileRoot = context.getPath() + File.separator + directoryName;
                            } else {
                                AnalyzerHelper.log("Absolute path specified : ", 2);
                                cubeFileRoot = directoryName;
                            }
                            String cubeFolderName = AnalyzerHelper.getConfigItemAsFileName(cubeFileRoot, fileName);
                            if (cubeFolderName == null) continue;
                            File cFile = new File(cubeFileRoot, cubeFolderName);
                            if (!Directory.isChild(this.directory.getFileInstance().getPath(), cFile.getPath())) continue;
                            cubeExcludeFolders.add(new File(cubeFileRoot + File.separator + fileName).getCanonicalPath());
                            AnalyzerHelper.log("Adding to cube exclude list : " + cubeFileRoot + File.separator + fileName, 2);
                        }
                    }
                }
            }
            catch (Exception exception) {
                AnalyzerHelper.log(exception);
            }
            return !AnalyzerHelper.isEmpty(cubeExcludeFolders) ? cubeExcludeFolders : null;
        }
        return null;
    }

    private String getCubeFolderName(Cube cube) {
        Map props = this.metaAccess.getProperties((Root)cube);
        if (props != null) {
            return (String)props.get("CUBEFOLDER");
        }
        return null;
    }

    List processCatalogs(String patrn) {
        return this.directory.listAll(patrn);
    }

    List processCatalogDirs(String pattern) {
        return this.directory.listDirs(pattern);
    }

    List processSASFiles(String pattern) {
        List sasFiles = this.directory.listAll(pattern);
        return sasFiles;
    }

    List processFilesOnly() {
        return this.directory.listFilesOnly();
    }

    List processDirectoryOnly() {
        return this.directory.lisDirOnly();
    }

    List<String> processCustom12Byte() {
        DataFilterProperties props = DataFilterProperties.getInstance();
        return props.getExcluded(this.directory.getFileInstance().getAbsolutePath());
    }

    List processUserExcludeFiles(String pattern) {
        ArrayList<String> userExcludeFiles = new ArrayList<String>();
        if (pattern != null) {
            String[] userExcludes = pattern.split(",");
            for (int i = 0; i < userExcludes.length; ++i) {
                String userDirPath = userExcludes[i];
                userExcludeFiles.add(userDirPath);
            }
        }
        return userExcludeFiles;
    }

    List processUserCatalogs(String pattern) {
        String[] files = null;
        ArrayList<String> userIncludeCatalogsList = new ArrayList<String>();
        List userIncludeCatalogs = new ArrayList();
        ArrayList<String> userIncludeFiles = new ArrayList<String>();
        if (pattern != null) {
            String[] userIncludes = pattern.split(",");
            for (int i = 0; i < userIncludes.length; ++i) {
                String userDirPath;
                if (userIncludes[i].contains("sas7bcat")) {
                    userDirPath = userIncludes[i];
                    userIncludeCatalogs = this.directory.listAll(userDirPath);
                    continue;
                }
                userDirPath = userIncludes[i];
                files = this.find(this.directory.getFileInstance(), userDirPath);
                for (int j = 0; j < files.length; ++j) {
                    userIncludeFiles.add(files[j]);
                }
            }
            for (String s : userIncludeFiles) {
                s = this.directory.getFileInstance().getAbsolutePath() + File.separator + s;
                if (!userIncludeCatalogs.contains(s)) continue;
                userIncludeCatalogsList.add(s);
            }
        }
        return userIncludeCatalogsList;
    }

    List processUserIncludeFiles(String pattern) {
        String[] files = null;
        ArrayList<String> userIncludeFiles = new ArrayList<String>();
        if (pattern != null) {
            String[] userIncludes = pattern.split(",");
            for (int i = 0; i < userIncludes.length; ++i) {
                String userDirPath = userIncludes[i];
                files = this.find(this.directory.getFileInstance(), userDirPath);
                if (files == null || files.length < 1) continue;
                for (int index = 0; index < files.length; ++index) {
                    String includeFile = files[index];
                    includeFile = this.directory.getFileInstance().getAbsolutePath() + File.separator + includeFile;
                    userIncludeFiles.add(includeFile);
                }
            }
        }
        return userIncludeFiles;
    }

    List processUserPermissionExcludeFiles(String pattern) {
        String[] files = null;
        ArrayList<String> userPermissionExcludeFiles = new ArrayList<String>();
        if (pattern != null) {
            String[] userPermissionExclude = pattern.split(",");
            for (int i = 0; i < userPermissionExclude.length; ++i) {
                String userDirPath = userPermissionExclude[i];
                files = this.find(this.directory.getFileInstance(), userDirPath);
                if (files == null || files.length < 1) continue;
                for (int index = 0; index < files.length; ++index) {
                    String includeFile = files[index];
                    includeFile = this.directory.getFileInstance().getAbsolutePath() + File.separator + includeFile;
                    userPermissionExcludeFiles.add(includeFile);
                }
            }
        }
        return userPermissionExcludeFiles;
    }

    private String[] find(File file, String pattern) {
        Object[] all = null;
        try {
            ReadableSelector readableSelector = new ReadableSelector();
            pattern = pattern.replaceAll(" ", "?");
            FileSet fileSet = new FileSet();
            Project antProject = new Project();
            fileSet.setProject(antProject);
            fileSet.setDir(file);
            fileSet.setIncludes(pattern);
            fileSet.add((FileSelector)readableSelector);
            Object[] files = fileSet.getDirectoryScanner(antProject).getIncludedFiles();
            String[] dirs = fileSet.getDirectoryScanner(antProject).getIncludedDirectories();
            ArrayList<String> emptyDir = new ArrayList<String>();
            if (dirs != null) {
                for (int i = 0; i < dirs.length; ++i) {
                    String dir = dirs[i];
                    File childDir = new File(file, dir);
                    if (childDir.list().length > 0) continue;
                    emptyDir.add(dir);
                }
            }
            all = emptyDir != null && !emptyDir.isEmpty() ? (String[])ArrayUtils.addAll((Object[])files, (Object[])emptyDir.toArray()) : files;
        }
        catch (BuildException exception) {
            AnalyzerHelper.log("Error while creating DirectoryScanner :" + exception.getMessage(), 0);
        }
        catch (Exception exception) {
            AnalyzerHelper.log("Error while creating DirectoryScanner :" + exception.getMessage(), 0);
        }
        return all;
    }
}

