/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.common;

import com.sas.apps.content.migration.core.ContentExporter;
import com.sas.apps.content.migration.export.common.Directory;
import com.sas.apps.content.migration.export.common.RB;
import com.sas.apps.content.migration.utils.Constants;
import com.sas.metadata.AssociationList;
import com.sas.metadata.Root;
import com.sas.text.Message;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.Task;

public class AnalyzerHelper {
    private static final String PARAM_CONFIG = "-config";
    private static final int PARAM_CONFIG_LENGTH = 7;
    private static final String FILE_TYPE_CFG = ".cfg";
    private static final String FILE_TYPE_TXT = ".txt";
    private static final String FILE_TYPE_XML = ".xml";
    private static final String FILE_TYPE_BAT = ".bat";
    private static final String FILE_TYPE_SH = ".sh";
    private static final String FILE_TYPE_SAS = ".sas";
    public static final String SPACE = " ";
    public static final String PIPE = "|";
    private static final List _92InCompatibleChars = Arrays.asList("/", "\\\\");
    private static Task analyzer;

    public static String parseConfigFile(String configCommand, String commandPattern) {
        String configFile = null;
        if (!AnalyzerHelper.isEmpty(configCommand)) {
            Pattern pattern = Pattern.compile(commandPattern);
            Matcher matcher = pattern.matcher(configCommand);
            if (matcher.find()) {
                configFile = matcher.group();
                configFile = AnalyzerHelper.trimQuotes(configFile);
            } else {
                File configScript = new File(configCommand);
                if (configScript.exists() && configScript.isFile()) {
                    configFile = configCommand;
                }
            }
        }
        return configFile;
    }

    public static String trimQuotes(String quotedString) {
        boolean isQuoted = false;
        if (!AnalyzerHelper.isEmpty(quotedString)) {
            isQuoted = quotedString.startsWith("\"");
        }
        return isQuoted ? quotedString.substring(1, quotedString.length() - 1) : quotedString;
    }

    public static boolean isEmpty(Object object) {
        boolean isEmpty = false;
        if (object == null) {
            isEmpty = true;
        } else if (object instanceof String && ((String)object).length() <= 0) {
            isEmpty = true;
        } else if (object instanceof Collection && ((Collection)object).size() <= 0) {
            isEmpty = true;
        } else if (object instanceof Map && ((Map)object).size() <= 0) {
            isEmpty = true;
        } else if (object.getClass().isArray() && ((Object[])object).length <= 0) {
            isEmpty = true;
        }
        return isEmpty;
    }

    public static boolean isInContextDirectory(String contextName, List contexts) {
        boolean isPresent = false;
        if (!AnalyzerHelper.isEmpty(contexts) && !AnalyzerHelper.isEmpty(contextName)) {
            for (int index = 0; index < contexts.size(); ++index) {
                if (!contextName.equalsIgnoreCase(((File)contexts.get(index)).getName())) continue;
                isPresent = true;
                break;
            }
        }
        return isPresent;
    }

    public static boolean isDirectory(String fileName) {
        boolean isDirectory = false;
        if (fileName != null) {
            File dir = new File(fileName);
            isDirectory = dir.exists() && dir.isDirectory();
        }
        return isDirectory;
    }

    public static boolean isProductInstalled(File serverContext, String serverName) {
        boolean isInstalled = false;
        if (serverName != null && serverContext != null) {
            File server = new File(serverContext, serverName);
            isInstalled = server.exists() && server.isDirectory();
        }
        return isInstalled;
    }

    public static String parseConfigItemName(String configItem) {
        String config = null;
        if (configItem != null) {
            File configFile = new File(configItem);
            config = configFile.exists() ? configFile.getName() : null;
        }
        return config;
    }

    public static boolean isConfigItemExists(String configItem) {
        File config = new File(configItem);
        return config.exists();
    }

    public static boolean isConfigItemExists(String parentPath, String configItem) {
        String config = AnalyzerHelper.getConfigItemAsFileName(parentPath, configItem);
        return new File(parentPath, configItem).exists();
    }

    public static String getConfigItemAsFileName(String parentPath, final String configItem) {
        File config = new File(parentPath);
        File[] configItems = new File[]{};
        if (config.exists()) {
            configItems = config.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File parent, String fileName) {
                    return fileName.toLowerCase().equals(configItem.toLowerCase());
                }
            });
        }
        return configItems.length > 0 ? configItems[0].getName() : null;
    }

    public static String getExceptionMessage(Exception exception) {
        StackTraceElement[] stackTrace = exception.getStackTrace();
        String exceptionMessage = exception.getMessage();
        if (!AnalyzerHelper.isEmpty(stackTrace)) {
            exceptionMessage = "Exception occured : " + exception.getClass().getName() + " at " + stackTrace[0].toString();
        }
        return exceptionMessage;
    }

    public static List getComponentConfigFiles(final File component) {
        List configs = null;
        File[] configFiles = null;
        if (component != null && component.isDirectory()) {
            configFiles = component.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File directory, String fileName) {
                    return directory.getName().equals(component.getName()) && (fileName.endsWith(AnalyzerHelper.FILE_TYPE_CFG) || fileName.endsWith(AnalyzerHelper.FILE_TYPE_TXT) || fileName.endsWith(AnalyzerHelper.FILE_TYPE_XML) || fileName.endsWith(AnalyzerHelper.FILE_TYPE_BAT) || fileName.endsWith(AnalyzerHelper.FILE_TYPE_SH) || fileName.endsWith(AnalyzerHelper.FILE_TYPE_SAS));
                }
            });
        }
        if (!AnalyzerHelper.isEmpty(configFiles)) {
            configs = Arrays.asList(configFiles);
        }
        return configs;
    }

    public static List getComponentConfigFilePaths(File context) {
        List configs = AnalyzerHelper.getComponentConfigFiles(context);
        ArrayList<String> configPaths = null;
        if (configs != null) {
            configPaths = new ArrayList<String>(configs.size());
            for (int index = 0; index < configs.size(); ++index) {
                configPaths.add(((File)configs.get(index)).getPath());
            }
        }
        return configPaths;
    }

    public static List getProductInstalledContexts(List contextDirs, String serverName) {
        ArrayList<File> productInsDirs = null;
        File contextDir = null;
        if (!AnalyzerHelper.isEmpty(contextDirs)) {
            for (int index = 0; index < contextDirs.size(); ++index) {
                contextDir = (File)contextDirs.get(index);
                if (!AnalyzerHelper.isProductInstalled(contextDir, serverName)) continue;
                if (productInsDirs == null) {
                    productInsDirs = new ArrayList<File>();
                }
                productInsDirs.add(contextDir);
            }
        }
        return productInsDirs;
    }

    public static String getPropertyName(Map properties, String property) {
        String propertyName2 = null;
        boolean isFound = false;
        if (properties != null && property != null) {
            for (String propertyName2 : properties.keySet()) {
                if (propertyName2.indexOf(property) == -1) continue;
                isFound = true;
                break;
            }
        }
        return isFound ? propertyName2 : "";
    }

    public static String getPropertyValue(Map properties, String property) {
        String propertyName = AnalyzerHelper.getPropertyName(properties, property);
        return (String)properties.get(propertyName);
    }

    public static void initLogger(Task task) {
        analyzer = task;
    }

    public static void log(String message, int messageType) {
        if (analyzer != null) {
            analyzer.log(message, messageType);
        } else {
            switch (messageType) {
                case 0: {
                    Constants.logger.error(message);
                    break;
                }
                case 1: {
                    Constants.logger.warn(message);
                    break;
                }
                case 2: {
                    Constants.logger.info(message);
                    break;
                }
                case 3: {
                    Constants.logger.info(message);
                    break;
                }
                case 4: {
                    Constants.logger.debug(message);
                    break;
                }
                default: {
                    Constants.logger.info(message);
                }
            }
        }
    }

    public static void log(Throwable exception) {
        if (analyzer != null) {
            analyzer.log(exception, 0);
        } else {
            Constants.logger.error("Exception :" + exception.getMessage(), exception);
        }
    }

    public static void log(String message, Throwable exception) {
        if (analyzer != null) {
            analyzer.log(message, exception, 0);
        } else {
            Constants.logger.error("Exception ", exception);
        }
    }

    public static List getMultiMapValues(Map multiMap) {
        ArrayList allValues = null;
        Object value2 = null;
        if (multiMap != null) {
            allValues = new ArrayList();
            for (Object value2 : multiMap.values()) {
                if (!(value2 instanceof List)) continue;
                allValues.addAll(value2);
            }
        }
        return allValues;
    }

    public static List<String> getStringTokens(String stringWithTokens, String token) {
        ArrayList<String> stringTokens = null;
        if (!AnalyzerHelper.isEmpty(stringWithTokens)) {
            stringTokens = new ArrayList<String>();
            if (stringWithTokens.indexOf(token) != -1) {
                StringTokenizer tokenizer = new StringTokenizer(stringWithTokens, token);
                while (tokenizer.hasMoreTokens()) {
                    stringTokens.add(tokenizer.nextToken().trim());
                }
            } else {
                stringTokens.add(stringWithTokens.trim());
            }
        }
        return stringTokens;
    }

    public static String make92Compatible(String literal, String replace) {
        Pattern incompatible = null;
        Matcher match = null;
        String compatibleLiteral = literal;
        for (int index = 0; index < _92InCompatibleChars.size(); ++index) {
            incompatible = Pattern.compile((String)_92InCompatibleChars.get(index));
            match = incompatible.matcher(compatibleLiteral);
            compatibleLiteral = match.replaceAll(replace);
        }
        return compatibleLiteral;
    }

    public static InetAddress convertToInetAddress(String host) {
        InetAddress address = null;
        try {
            if (!AnalyzerHelper.isEmpty(host)) {
                address = InetAddress.getByName(host);
            }
        }
        catch (UnknownHostException unknownHost) {
            String exceptionMessage = Message.format((String)RB.getStringResource("servercommons.unknownhost.exception.msg.fmt"), (Object)host);
            AnalyzerHelper.log(exceptionMessage, 1);
        }
        return address;
    }

    public static boolean isValid92Name(String name) {
        boolean isValid = true;
        if (!AnalyzerHelper.isEmpty(name) && name.length() < 60) {
            for (int index = 0; index < _92InCompatibleChars.size(); ++index) {
                boolean bl = isValid = name.indexOf((String)_92InCompatibleChars.get(index)) == -1;
                if (isValid) continue;
                return false;
            }
        }
        return isValid;
    }

    public static boolean isHostsEqual(String host1, String host2) {
        InetAddress hostAddress1 = AnalyzerHelper.convertToInetAddress(host1);
        InetAddress hostAddress2 = AnalyzerHelper.convertToInetAddress(host2);
        return hostAddress1 != null && hostAddress1.equals(hostAddress2);
    }

    public static boolean isParent(String fileName, String parent) {
        boolean isParent = false;
        File file = new File(fileName);
        File parentFile = null;
        parentFile = file.getParentFile();
        if (parentFile != null) {
            isParent = parent.equalsIgnoreCase(parentFile.getName()) ? true : AnalyzerHelper.isParent(parentFile.getAbsolutePath(), parent);
        }
        return isParent;
    }

    public static Root getMetadataObject(AssociationList list) {
        return AnalyzerHelper.isEmpty(list) ? null : (Root)list.get(0);
    }

    public static boolean isUserLocal(String userID, String localhost) {
        boolean isLocal = false;
        if (userID != null && localhost != null) {
            String domain = null;
            int index = userID.indexOf("@");
            if (index > 0) {
                domain = userID.substring(index + 1);
            } else {
                index = userID.indexOf("\\");
                if (index > 0) {
                    domain = userID.substring(0, index);
                }
            }
            if (domain != null) {
                isLocal = AnalyzerHelper.isHostsEqual(domain, localhost);
            }
        }
        return isLocal;
    }

    public static File dumpProperties(Properties properties) {
        File propDump = null;
        if (properties != null) {
            try {
                try {
                    propDump = File.createTempFile(String.valueOf(Math.abs(properties.hashCode())), ".properties");
                }
                catch (Exception e) {
                    File tempFolder = new File(".", "Temp" + File.separator + "CMUTemp");
                    tempFolder.mkdirs();
                    propDump = File.createTempFile(String.valueOf(Math.abs(properties.hashCode())), ".properties", tempFolder);
                }
                propDump.deleteOnExit();
                properties.store(new FileOutputStream(propDump), "");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return propDump;
    }

    public static String listAsString(List vals) {
        StringBuffer bf = null;
        String val = null;
        if (!AnalyzerHelper.isEmpty(vals)) {
            bf = new StringBuffer();
            for (int index = 0; index < vals.size(); ++index) {
                val = (String)vals.get(index);
                val = index != 0 ? "," + val : val;
                bf.append(val);
            }
        }
        return bf != null ? bf.toString() : "";
    }

    public static String listAsString(List vals, String separator) {
        StringBuffer bf = null;
        String val = null;
        if (!AnalyzerHelper.isEmpty(vals)) {
            bf = new StringBuffer();
            for (int index = 0; index < vals.size(); ++index) {
                val = (String)vals.get(index);
                val = index != 0 ? separator + val : val;
                bf.append(val);
            }
        }
        return bf != null ? bf.toString() : "";
    }

    public static String insideDirectory(List contextDirectories, String filePath) {
        String contextdir = null;
        if (!AnalyzerHelper.isEmpty(contextDirectories) && !AnalyzerHelper.isEmpty(filePath)) {
            for (int index = 0; index < contextDirectories.size(); ++index) {
                File contextDir = (File)contextDirectories.get(index);
                if (AnalyzerHelper.isEmpty(Directory.getRelativePath(contextDir.getPath(), filePath))) continue;
                contextdir = contextDir.getPath();
                break;
            }
        }
        return contextdir;
    }

    public static String getProperty(String property) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(ContentExporter.getProperties());
        return AnalyzerHelper.getPropertyValue(map, property);
    }

    public static Map<String, String> getProperties(String pattern) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(ContentExporter.getProperties());
        Set propNames = map.keySet();
        HashMap<String, String> props = new HashMap<String, String>();
        String value = null;
        for (String propName : propNames) {
            if (!propName.contains(pattern)) continue;
            value = (String)map.get(propName);
            props.put(propName, value);
        }
        return props;
    }
}

