/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.AuthenticationTicketFactory;
import com.sas.iom.orb.AuthenticationTicketFactoryHolder;
import com.sas.iom.orb.SASURI;
import com.sas.iom.orb.SelectionHub;
import com.sas.iom.orb.brg.UnexpectedUserException;
import com.sas.net.brg.orb.BrgOrb;
import com.sas.services.connection.AuthenticationTicketCredential;
import com.sas.services.connection.BadLocaleException;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionEnvelope;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionRequest;
import com.sas.services.connection.ConnectionResources;
import com.sas.services.connection.ConnectionTimeoutException;
import com.sas.services.connection.Credential;
import com.sas.services.connection.ExpiredCredentialsException;
import com.sas.services.connection.FatalConnectionFactoryException;
import com.sas.services.connection.InvalidCredentialsException;
import com.sas.services.connection.LoginException;
import com.sas.services.connection.PasswordCredential;
import com.sas.services.connection.RB;
import com.sas.services.connection.Server;
import com.sas.text.Message;
import java.util.Locale;
import java.util.Random;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;

@SASScope
public final class ClusterEnvelope {
    private ConnectionFactoryKernel _kernel;
    private Cluster _cluster;
    private Random _random;

    protected ClusterEnvelope(ConnectionFactoryKernel kernel, Cluster cluster) {
        this._kernel = kernel;
        this._cluster = cluster;
        this._random = new Random();
    }

    protected ConnectionEnvelope getConnection(ConnectionRequest cxReq) {
        int first;
        ConnectionEnvelope cxEnv = new ConnectionEnvelope();
        Credential cred = cxReq.getCredential();
        cxEnv.setOwnerCredential(cred);
        Server[] serverArray = this._cluster.getServerArray();
        int serverArrayL = serverArray.length;
        int index = first = serverArrayL == 1 ? 0 : this._random.nextInt(serverArrayL);
        while (true) {
            Server server = serverArray[index];
            try {
                cxEnv.setServer(server);
                this.failWorkspaceServerTokenConnectionRequest(cxReq, cxEnv);
                this.createObject(cxReq, cxEnv);
                cxEnv.setServerIndex(index);
            }
            catch (NO_PERMISSION np) {
                String serverEntryPoint;
                Credential credential = cxEnv.getOwnerCredential();
                Locale locale = credential.getLocale();
                LoginException le = null;
                String logMessage = null;
                if ((np.minor & 0xFFF) == 3) {
                    serverEntryPoint = server.getEntryPoint();
                    String userName = ((PasswordCredential)credential).getUserName();
                    String msgIndex = "cxf.401.ex.fmt";
                    String msgPattern = RB.getStringResource(msgIndex, locale);
                    String msg = Message.format((String)msgPattern, (java.lang.Object)serverEntryPoint, (java.lang.Object)userName);
                    le = new ExpiredCredentialsException(msg, np, credential);
                    logMessage = "The password has expired: ";
                } else if ((np.minor & 0xFFF) == 4) {
                    String userName = ((PasswordCredential)credential).getUserName();
                    String serverEntryPoint2 = server.getEntryPoint();
                    String msgIndex = "cxf.402.ex.fmt";
                    String msgPattern = RB.getStringResource(msgIndex, locale);
                    String msg = Message.format((String)msgPattern, (java.lang.Object)serverEntryPoint2, (java.lang.Object)userName);
                    le = new InvalidCredentialsException(msg, np, credential);
                    logMessage = "The user ID or password is incorrect: ";
                } else if ((np.minor & 0xFFF) == 5) {
                    serverEntryPoint = server.getEntryPoint();
                    String msgIndex = "cxf.406.ex.fmt";
                    String msgPattern = RB.getStringResource(msgIndex, locale);
                    String msg = Message.format((String)msgPattern, (java.lang.Object)serverEntryPoint);
                    le = new LoginException(msg, np);
                    logMessage = "IWA failed: ";
                } else {
                    serverEntryPoint = server.getEntryPoint();
                    String msgIndex = "cxf.403.ex.fmt";
                    String msgPattern = RB.getStringResource(msgIndex, locale);
                    String msg = Message.format((String)msgPattern, (java.lang.Object)serverEntryPoint);
                    le = new LoginException(msg, np);
                    logMessage = "Login failed: ";
                }
                if (cxReq.isLoggableFINE()) {
                    String msg = logMessage + credential.toString();
                    cxReq.logFINE(msg, le);
                }
                cxEnv.setBogus(true, le);
            }
            catch (SystemException se) {
                String msg;
                Locale locale;
                Credential credential;
                String serverEntryPoint;
                if (se instanceof COMM_FAILURE && (se.minor & 0xFFF) == 7) {
                    serverEntryPoint = server.getEntryPoint();
                    credential = cxEnv.getOwnerCredential();
                    locale = credential.getLocale();
                    String msgIndex = "cxf.404.ex.fmt";
                    String msgPattern = RB.getStringResource(msgIndex, locale);
                    String msg2 = Message.format((String)msgPattern, (java.lang.Object)serverEntryPoint);
                    ConnectionTimeoutException cte = new ConnectionTimeoutException(msg2, se);
                    cxEnv.setBogus(true, cte);
                    if (!cxReq.isLoggableFINE()) break;
                    cxReq.logFINE("The load balancing object spawner timed out.", se);
                    break;
                }
                if (se instanceof BAD_PARAM && (se.minor & 0xFFF) == 2) {
                    msg = se.getMessage();
                    BadLocaleException ble = new BadLocaleException(msg);
                    ble.initCause(se);
                    cxEnv.setBogus(true, ble);
                    if (!cxReq.isLoggableFINE()) break;
                    Credential credential2 = cxEnv.getOwnerCredential();
                    Locale locale2 = credential2.getLocale();
                    cxReq.logFINE("Bad locale: " + locale2, ble);
                    break;
                }
                if (se instanceof UNKNOWN && (se.minor & 0xFFF) == 2) {
                    serverEntryPoint = server.getEntryPoint();
                    credential = cxEnv.getOwnerCredential();
                    locale = credential.getLocale();
                    String msgIndex = "cxf.405.ex.fmt";
                    String msgPattern = RB.getStringResource(msgIndex, locale);
                    String msg3 = Message.format((String)msgPattern, (java.lang.Object)serverEntryPoint);
                    FatalConnectionFactoryException fcfe = new FatalConnectionFactoryException(msg3, se);
                    cxEnv.setBogus(true, fcfe);
                    if (!cxReq.isLoggableFINE()) break;
                    cxReq.logFINE("The object spawner discovered an invalid server configuration.", se);
                    break;
                }
                if (se instanceof UnexpectedUserException) {
                    msg = se.getMessage();
                    UNKNOWN unknown = new UNKNOWN(msg);
                    Throwable cause = se.getCause();
                    if (cause != null) {
                        unknown.initCause(cause);
                    }
                    if (cxReq.isLoggableFINE()) {
                        cxReq.logFINE("Converting UnexpectedUserException to CORBA.UNKNOWN");
                    }
                }
                if (cxReq.isLoggableFINE()) {
                    msg = "new connection failed";
                    cxReq.logFINE(msg, se);
                }
                if ((index = (index + 1) % serverArrayL) == first) {
                    if (cxReq.isLoggableFINE()) {
                        cxReq.logFINE("no more servers in cluster");
                    }
                    if (serverArray.length == 1) {
                        String message = se.getMessage();
                        cxEnv.setBogus(true, new FatalConnectionFactoryException(message, se));
                        break;
                    }
                    String clusterEntryPoint = this._cluster.getEntryPoint();
                    String messageIndex = "cxf.400.ex.fmt";
                    String messagePattern = RB.getStringResource(messageIndex);
                    String message = Message.format((String)messagePattern, (java.lang.Object)clusterEntryPoint);
                    cxEnv.setBogus(true, new FatalConnectionFactoryException(message, se));
                    break;
                }
                if (!cxReq.isLoggableFINE()) continue;
                cxReq.logFINE("trying next server in cluster");
                continue;
            }
            break;
        }
        return cxEnv;
    }

    private void failWorkspaceServerTokenConnectionRequest(ConnectionRequest cxReq, ConnectionEnvelope cxEnv) {
        try {
            String failInvalidWorkspaceServerConnectionRequestValue = System.getProperty("com.sas.services.connection.failWorkspaceServerTokenConnectionRequest");
            if (cxReq.isLoggableFINE()) {
                cxReq.logFINE("value of com.sas.services.connection.failWorkspaceServerTokenConnectionRequest is " + failInvalidWorkspaceServerConnectionRequestValue);
            }
            if (!Boolean.valueOf(failInvalidWorkspaceServerConnectionRequestValue).booleanValue()) {
                return;
            }
        }
        catch (SecurityException se) {
            if (cxReq.isLoggableFINE()) {
                cxReq.logFINE("value of com.sas.services.connection.failWorkspaceServerTokenConnectionRequest could not be determined due to security exception");
            }
            return;
        }
        Credential cred = cxReq.getCredential();
        if (!(cred instanceof PasswordCredential)) {
            return;
        }
        PasswordCredential pCred = (PasswordCredential)cred;
        String userName = pCred.getUserName();
        if (userName == null || !userName.contains("!*(generatedpassworddomain)*!")) {
            return;
        }
        Server server = cxEnv.getServer();
        if (server == null) {
            return;
        }
        String clsid = server.getNormalizedClassID();
        if (Server.clsidToServerType(clsid) != 1 || Server.isPooledSasClsid(clsid)) {
            return;
        }
        String authService = server.getAuthService();
        if ("Metadata".equals(authService)) {
            return;
        }
        String serverName = server instanceof BridgeServer ? ((BridgeServer)server).getServerName() : "Unknown";
        Locale locale = cred.getLocale();
        String msgIndex = "cxf.407.ex.fmt";
        String msgPattern = RB.getStringResource(msgIndex, locale);
        String msg = Message.format((String)msgPattern, (java.lang.Object)serverName);
        throw new NO_PERMISSION(msg, 4, CompletionStatus.COMPLETED_NO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createObject(ConnectionRequest cxReq, ConnectionEnvelope cxEnv) {
        ConnectionFactoryManager cxfManager;
        ConnectionResources cxResources;
        Server server = cxEnv.getServer();
        SASURI uri = server.toURI(cxReq);
        String connectionID = uri.getConnectionID();
        if (cxReq.isLoggableFINE()) {
            String blottedURI = uri.toBlottedString();
            cxReq.logFINE("new connection attempt: " + connectionID + blottedURI);
        }
        SelectionHub hub = (cxResources = (cxfManager = this._kernel.getManager()).getConnectionResources()) != null ? cxResources.getSelectionHub() : null;
        BrgOrb orb = new BrgOrb(hub);
        Credential cred = cxReq.getCredential();
        if (cred != null && cred instanceof AuthenticationTicketCredential) {
            AuthenticationTicketFactory authTicketFactory = ((AuthenticationTicketCredential)cred).getAuthenticationTicketFactory();
            AuthenticationTicketFactoryHolder.set(authTicketFactory);
        }
        try {
            Object obj = orb.uri_to_object(uri);
            cxEnv.setRootObject(obj);
        }
        finally {
            AuthenticationTicketFactoryHolder.clear();
        }
        cxEnv.setConnectionRequest(cxReq);
        cxEnv.setConnectionID(connectionID);
    }

    protected Cluster getCluster() {
        return this._cluster;
    }
}

