/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import com.sas.rio.Column;
import com.sas.rio.MVAResultSet;
import com.sas.rio.MVASQLException;
import com.sas.rio.MessageCode;
import com.sas.rio.RB;
import com.sas.rio.RIOException;
import com.sas.rio.RIOResultSetMetaDataInterface;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MVAResultSetMetaData
implements RIOResultSetMetaDataInterface {
    private final int bindKey;
    private final Column[] columns;

    @SASScope
    public MVAResultSetMetaData(MVAResultSet rs) throws SQLException {
        if (rs == null) {
            throw new MVASQLException(MessageCode.MVAResultSetMetaData_noResultSetError, new Object[0]);
        }
        this.columns = Arrays.copyOf(rs.getCache().getColumns(), rs.getCache().getColumns().length);
        this.bindKey = rs.getBindKey();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columns.length;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        boolean isCaseSensitive = this.columns[column - 1].getSqlType() == 12;
        return isCaseSensitive;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        boolean isNullable = this.columns[column - 1].getSqlType() == 12;
        return isNullable ? 0 : 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        boolean isSigned = this.columns[column - 1].getSqlType() != 12 && this.columns[column - 1].getSqlType() != 16;
        return isSigned;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        int sqlType = this.columns[column - 1].getSqlType();
        switch (sqlType) {
            case 1: 
            case 12: {
                if (this.columns[column - 1].getLength() > Short.MAX_VALUE) {
                    return Short.MAX_VALUE;
                }
                return this.columns[column - 1].getLength();
            }
            case -7: 
            case 16: {
                return 1;
            }
            case -6: {
                return 4;
            }
            case 5: {
                return 6;
            }
            case 4: {
                return 11;
            }
            case -5: {
                return 209;
            }
            case 7: {
                return 13;
            }
            case 6: 
            case 8: {
                return 22;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 8;
            }
            case 93: {
                return 21;
            }
        }
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        return this.columns[column - 1].getLabel();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        return this.columns[column - 1].getName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        int sqlType = this.columns[column - 1].getSqlType();
        switch (sqlType) {
            case 1: 
            case 12: {
                return this.columns[column - 1].getLength();
            }
            case -7: {
                return 1;
            }
            case 16: {
                return 0;
            }
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case 7: {
                return 7;
            }
            case 6: 
            case 8: {
                return 15;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 8;
            }
            case 93: {
                return 21;
            }
        }
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        if (this.bindKey != 3) {
            return this.columns[column - 1].getSqlType();
        }
        return 12;
    }

    @SASScope
    public int[] getColumnTypes() {
        int[] columnTypes = new int[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            Column c = this.columns[i];
            columnTypes[i] = c.getSqlType();
        }
        return columnTypes;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        String formatName = this.columns[column - 1].getFormatName();
        if (formatName == null) {
            return "";
        }
        formatName = formatName.trim();
        if (this.columns[column - 1].getFormatWidth() != 0) {
            formatName = formatName + this.columns[column - 1].getFormatWidth();
        }
        if (!formatName.equals("")) {
            formatName = formatName + ".";
        }
        if (this.columns[column - 1].getFormatDecimal() != 0) {
            formatName = formatName + this.columns[column - 1].getFormatDecimal();
        }
        return formatName;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        return false;
    }

    @Override
    public String getColumnClassName(int columnIndex) throws SQLException {
        Object columnObject;
        if (columnIndex < 1 || columnIndex > this.columns.length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        int sqlType = this.columns[columnIndex - 1].getSqlType();
        if (this.bindKey == 3) {
            columnObject = "";
        } else if (sqlType != 12) {
            switch (sqlType) {
                case 91: {
                    columnObject = new Date(0L);
                    break;
                }
                case 92: {
                    columnObject = new Time(0L);
                    break;
                }
                case 93: {
                    columnObject = new Timestamp(0L);
                    break;
                }
                case -7: 
                case 16: {
                    columnObject = Boolean.TRUE;
                    break;
                }
                case 4: 
                case 5: {
                    columnObject = 0;
                    break;
                }
                default: {
                    columnObject = 0.0;
                    break;
                }
            }
        } else {
            columnObject = "";
        }
        return columnObject.getClass().getName();
    }

    @Override
    public String getColumnFormatName(int columnIndex) throws RIOException {
        if (columnIndex < 1 || columnIndex > this.columns.length) {
            String reason = RB.getStringResource(MessageCode.General_invalidColumnValue.getResourceKey());
            throw new RIOException(MessageCode.General_invalidColumnValue.getMessageCode(), reason);
        }
        String formatName = this.columns[columnIndex - 1].getFormatName();
        if (formatName == null) {
            return "";
        }
        return formatName;
    }

    @Override
    public String[] getColumnFormatNames() throws RIOException {
        String[] formatNames = new String[this.columns.length];
        int nColumns = this.columns.length;
        for (int i = 0; i < nColumns; ++i) {
            formatNames[i] = this.columns[i].getFormatName();
        }
        return formatNames;
    }

    @Override
    public int getColumnFormatLength(int columnIndex) throws RIOException {
        if (columnIndex < 1 || columnIndex > this.columns.length) {
            String reason = RB.getStringResource(MessageCode.General_invalidColumnValue.getResourceKey());
            throw new RIOException(MessageCode.General_invalidColumnValue.getMessageCode(), reason);
        }
        return this.columns[columnIndex - 1].getFormatLength();
    }

    @Override
    public int[] getColumnFormatLengths() throws RIOException {
        int[] formatLengths = new int[this.columns.length];
        int nColumns = this.columns.length;
        for (int i = 0; i < nColumns; ++i) {
            formatLengths[i] = this.columns[i].getFormatLength();
        }
        return formatLengths;
    }

    @Override
    public int getColumnFormatWidth(int columnIndex) throws RIOException {
        if (columnIndex < 1 || columnIndex > this.columns.length) {
            String reason = RB.getStringResource(MessageCode.General_invalidColumnValue.getResourceKey());
            throw new RIOException(MessageCode.General_invalidColumnValue.getMessageCode(), reason);
        }
        return this.columns[columnIndex - 1].getFormatWidth();
    }

    @Override
    public int[] getColumnFormatWidths() throws RIOException {
        int[] formatWidths = new int[this.columns.length];
        int nColumns = this.columns.length;
        for (int i = 0; i < nColumns; ++i) {
            formatWidths[i] = this.columns[i].getFormatWidth();
        }
        return formatWidths;
    }

    @Override
    public int getColumnFormatDecimal(int columnIndex) throws RIOException {
        if (columnIndex < 1 || columnIndex > this.columns.length) {
            String reason = RB.getStringResource(MessageCode.General_invalidColumnValue.getResourceKey());
            throw new RIOException(MessageCode.General_invalidColumnValue.getMessageCode(), reason);
        }
        return this.columns[columnIndex - 1].getFormatDecimal();
    }

    @Override
    public int[] getColumnFormatDecimals() throws RIOException {
        int[] formatDecimals = new int[this.columns.length];
        int nColumns = this.columns.length;
        for (int i = 0; i < nColumns; ++i) {
            formatDecimals[i] = this.columns[i].getFormatDecimal();
        }
        return formatDecimals;
    }

    @Override
    public String getColumnInformatName(int columnIndex) throws RIOException {
        if (columnIndex < 1 || columnIndex > this.columns.length) {
            String reason = RB.getStringResource(MessageCode.General_invalidColumnValue.getResourceKey());
            throw new RIOException(MessageCode.General_invalidColumnValue.getMessageCode(), reason);
        }
        String informatName = this.columns[columnIndex - 1].getInformatName();
        if (informatName == null) {
            return "";
        }
        return informatName;
    }

    @Override
    public String[] getColumnInformatNames() throws RIOException {
        String[] informatNames = new String[this.columns.length];
        int nColumns = this.columns.length;
        for (int i = 0; i < nColumns; ++i) {
            informatNames[i] = this.columns[i].getInformatName();
        }
        return informatNames;
    }

    @Override
    public int getColumnInformatLength(int columnIndex) throws RIOException {
        if (columnIndex < 1 || columnIndex > this.columns.length) {
            String reason = RB.getStringResource(MessageCode.General_invalidColumnValue.getResourceKey());
            throw new RIOException(MessageCode.General_invalidColumnValue.getMessageCode(), reason);
        }
        return this.columns[columnIndex - 1].getFormatLength();
    }

    @Override
    public int[] getColumnInformatLengths() throws RIOException {
        return new int[this.columns.length];
    }

    @Override
    public int getColumnInformatWidth(int columnIndex) throws RIOException {
        if (columnIndex < 1 || columnIndex > this.columns.length) {
            String reason = RB.getStringResource(MessageCode.General_invalidColumnValue.getResourceKey());
            throw new RIOException(MessageCode.General_invalidColumnValue.getMessageCode(), reason);
        }
        return this.columns[columnIndex - 1].getInformatWidth();
    }

    @Override
    public int[] getColumnInformatWidths() throws RIOException {
        int[] informatWidths = new int[this.columns.length];
        int nColumns = this.columns.length;
        for (int i = 0; i < nColumns; ++i) {
            informatWidths[i] = this.columns[i].getInformatWidth();
        }
        return informatWidths;
    }

    @Override
    public int getColumnInformatDecimal(int columnIndex) throws RIOException {
        if (columnIndex < 1 || columnIndex > this.columns.length) {
            String reason = RB.getStringResource(MessageCode.General_invalidColumnValue.getResourceKey());
            throw new RIOException(MessageCode.General_invalidColumnValue.getMessageCode(), reason);
        }
        return this.columns[columnIndex - 1].getInformatDecimal();
    }

    @Override
    public int[] getColumnInformatDecimals() throws RIOException {
        int[] informatDecimals = new int[this.columns.length];
        int nColumns = this.columns.length;
        for (int i = 0; i < nColumns; ++i) {
            informatDecimals[i] = this.columns[i].getInformatDecimal();
        }
        return informatDecimals;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            throw new MVASQLException(MessageCode.General_unwrapFailInputParameterIsNull, new Object[0]);
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new MVASQLException(MessageCode.General_unwrapFail, iface.getName(), this.getClass().getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    public String getFormatName(int columnIndex) throws SQLException {
        try {
            return this.getColumnFormatName(columnIndex);
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }

    public String[] getFormatNames() throws SQLException {
        try {
            return this.getColumnFormatNames();
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }

    public int getFormatLength(int columnIndex) throws SQLException {
        try {
            return this.getColumnFormatLength(columnIndex);
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }

    public int[] getFormatLengths() throws SQLException {
        try {
            return this.getColumnFormatLengths();
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }

    public int getFormatWidth(int columnIndex) throws SQLException {
        try {
            return this.getColumnFormatWidth(columnIndex);
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }

    public int[] getFormatWidths() throws SQLException {
        try {
            return this.getColumnFormatWidths();
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }

    public int getFormatDecimal(int columnIndex) throws SQLException {
        try {
            return this.getColumnFormatDecimal(columnIndex);
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }

    public int[] getFormatDecimals() throws SQLException {
        try {
            return this.getColumnFormatDecimals();
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }

    public String getInformatName(int columnIndex) throws SQLException {
        try {
            return this.getColumnInformatName(columnIndex);
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }

    public String[] getInformatNames() throws SQLException {
        try {
            return this.getColumnInformatNames();
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }

    public int getInformatLength(int columnIndex) throws SQLException {
        try {
            return this.getColumnInformatLength(columnIndex);
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }

    public int[] getInformatLengths() throws SQLException {
        try {
            return this.getColumnInformatLengths();
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }

    public int getInformatWidth(int columnIndex) throws SQLException {
        try {
            return this.getColumnInformatWidth(columnIndex);
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }

    public int[] getInformatWidths() throws SQLException {
        try {
            return this.getColumnInformatWidths();
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }

    public int getInformatDecimal(int columnIndex) throws SQLException {
        try {
            return this.getColumnInformatDecimal(columnIndex);
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }

    public int[] getInformatDecimals() throws SQLException {
        try {
            return this.getColumnInformatDecimals();
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }
}

