/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import com.sas.rio.MVAConnection;
import com.sas.rio.MVASQLException;
import com.sas.rio.MVASQLExceptionUnsupported;
import com.sas.rio.MVAStatement;
import com.sas.rio.MessageCode;
import com.sas.rio.ParsedQuery;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class MVAPreparedStatement
extends MVAStatement
implements PreparedStatement {
    private static final String SAS_NULL_CHAR = " '' ";
    private static final String SAS_NULL_NUM = ".";
    private final String[] _parameters;
    private final int _parameterCount;
    private final ParsedQuery _parsedQuery;

    @SASScope
    MVAPreparedStatement(MVAConnection inconnection, String sql) throws SQLException {
        super(inconnection);
        this._parsedQuery = new ParsedQuery(this.librefs, sql, this.m_sasifyTableNames);
        this._parameterCount = this._parsedQuery.getParameterCount();
        this._parameters = new String[this._parameterCount];
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        this.checkClosed();
        return super.execute2(this._parsedQuery, this._parameters);
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        return super.executeQuery2(this._parsedQuery, this._parameters);
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        this.checkClosed();
        return super.executeUpdate2(this._parsedQuery, this._parameters);
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        if (parameterIndex > this._parameterCount || parameterIndex < 1) {
            throw new MVASQLException(MessageCode.MVAPreparedStatement_invalidParamIndexError, new Object[0]);
        }
        switch (sqlType) {
            case 4: 
            case 6: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                this._parameters[parameterIndex - 1] = SAS_NULL_NUM;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this._parameters[parameterIndex - 1] = SAS_NULL_CHAR;
                break;
            }
            default: {
                throw new MVASQLException(MessageCode.MVAPreparedStatement_setNullError, new Object[0]);
            }
        }
    }

    @Override
    public synchronized void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClosed();
        if (parameterIndex > this._parameterCount || parameterIndex < 1) {
            throw new MVASQLException(MessageCode.MVAPreparedStatement_invalidParamIndexError, new Object[0]);
        }
        this._parameters[parameterIndex - 1] = x ? "1.0" : "0.0";
    }

    @Override
    public synchronized void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkClosed();
        if (parameterIndex > this._parameterCount || parameterIndex < 1) {
            throw new MVASQLException(MessageCode.MVAPreparedStatement_invalidParamIndexError, new Object[0]);
        }
        this._parameters[parameterIndex - 1] = Byte.toString(x);
    }

    @Override
    public synchronized void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        if (parameterIndex > this._parameterCount || parameterIndex < 1) {
            throw new MVASQLException(MessageCode.MVAPreparedStatement_invalidParamIndexError, new Object[0]);
        }
        this._parameters[parameterIndex - 1] = Short.toString(x);
    }

    @Override
    public synchronized void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        if (parameterIndex > this._parameterCount || parameterIndex < 1) {
            throw new MVASQLException(MessageCode.MVAPreparedStatement_invalidParamIndexError, new Object[0]);
        }
        this._parameters[parameterIndex - 1] = Integer.toString(x);
    }

    @Override
    public synchronized void setLong(int parameterIndex, long x) throws SQLException {
        throw new MVASQLExceptionUnsupported(MessageCode.MVAPreparedStatement_sqlTypeBigIntUnsupported, new Object[0]);
    }

    @Override
    public synchronized void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        if (parameterIndex > this._parameterCount || parameterIndex < 1) {
            throw new MVASQLException(MessageCode.MVAPreparedStatement_invalidParamIndexError, new Object[0]);
        }
        if (Float.isNaN(x)) {
            this.setNull(parameterIndex, 6);
        } else {
            this._parameters[parameterIndex - 1] = Float.toString(x);
        }
    }

    @Override
    public synchronized void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        if (parameterIndex > this._parameterCount || parameterIndex < 1) {
            throw new MVASQLException(MessageCode.MVAPreparedStatement_invalidParamIndexError, new Object[0]);
        }
        if (Double.isNaN(x)) {
            this.setNull(parameterIndex, 8);
        } else {
            this._parameters[parameterIndex - 1] = Double.toString(x);
        }
    }

    @Override
    public synchronized void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw new MVASQLExceptionUnsupported(MessageCode.MVAPreparedStatement_sqlTypeNumericUnsupported, new Object[0]);
    }

    @Override
    public synchronized void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        if (parameterIndex > this._parameterCount || parameterIndex < 1) {
            throw new MVASQLException(MessageCode.MVAPreparedStatement_invalidParamIndexError, new Object[0]);
        }
        if (x == null) {
            this.setNull(parameterIndex, -1);
            return;
        }
        if (x.indexOf("'") > -1) {
            boolean done = false;
            String esc = x;
            int index = 0;
            while (!done) {
                String y = esc.substring(0, esc.indexOf("'", index));
                String z = esc.substring(esc.indexOf("'", index), esc.length());
                index = esc.indexOf("'", index);
                esc = y + "'" + z;
                if (esc.indexOf("'", index += 2) >= 0) continue;
                done = true;
            }
            this._parameters[parameterIndex - 1] = "'" + esc + "'";
        } else {
            this._parameters[parameterIndex - 1] = "'" + x + "'";
        }
    }

    @Override
    public synchronized void setBytes(int parameterIndex, byte[] x) throws SQLException {
        throw new MVASQLExceptionUnsupported(MessageCode.MVAPreparedStatement_sqlTypeBINARYUnsupported, new Object[0]);
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date x) throws SQLException {
        String val;
        this.checkClosed();
        if (parameterIndex > this._parameterCount || parameterIndex < 1) {
            throw new MVASQLException(MessageCode.MVAPreparedStatement_invalidParamIndexError, new Object[0]);
        }
        if (x == null) {
            this.setNull(parameterIndex, 91);
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(x);
        int day = cal.get(5);
        int mon = cal.get(2) + 1;
        int year = cal.get(1);
        this._parameters[parameterIndex - 1] = val = "'" + day + ParsedQuery.MONTHS.get(mon) + year + "'d ";
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time x) throws SQLException {
        String val;
        this.checkClosed();
        if (parameterIndex > this._parameterCount || parameterIndex < 1) {
            throw new MVASQLException(MessageCode.MVAPreparedStatement_invalidParamIndexError, new Object[0]);
        }
        if (x == null) {
            this.setNull(parameterIndex, 92);
            return;
        }
        this._parameters[parameterIndex - 1] = val = "'" + x.toString() + "'t ";
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        String val;
        this.checkClosed();
        if (parameterIndex > this._parameterCount || parameterIndex < 1) {
            throw new MVASQLException(MessageCode.MVAPreparedStatement_invalidParamIndexError, new Object[0]);
        }
        if (x == null) {
            this.setNull(parameterIndex, 93);
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(x);
        int day = cal.get(5);
        int mon = cal.get(2) + 1;
        int year = cal.get(1);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int seconds = cal.get(13);
        int nanos = x.getNanos();
        this._parameters[parameterIndex - 1] = val = "'" + day + ParsedQuery.MONTHS.get(mon) + year + ":" + hour + ":" + minute + ":" + seconds + SAS_NULL_NUM + nanos + "'dt ";
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new MVASQLExceptionUnsupported(MessageCode.MVAPreparedStatement_sqlTypeLONGVARCHARUnsupported, new Object[0]);
    }

    @Override
    public synchronized void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new MVASQLExceptionUnsupported(MessageCode.MVAPreparedStatement_sqlTypeLONGVARCHARUnsupported, new Object[0]);
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new MVASQLExceptionUnsupported(MessageCode.MVAPreparedStatement_sqlTypeLONGVARBINARYUnsupported, new Object[0]);
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        for (int i = 0; i < this._parameterCount; ++i) {
            this._parameters[i] = null;
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, int sqlType, int scale) throws SQLException {
        this.checkClosed();
        this.setObject(parameterIndex, x, sqlType);
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClosed();
        if (parameterIndex > this._parameterCount || parameterIndex < 1) {
            throw new MVASQLException(MessageCode.MVAPreparedStatement_invalidParamIndexError, new Object[0]);
        }
        if (x == null) {
            this.setObject(parameterIndex, null, -1);
            return;
        }
        if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
            return;
        }
        if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
            return;
        }
        if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
            return;
        }
        if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
            return;
        }
        if (x instanceof Character) {
            this.setString(parameterIndex, ((Character)x).toString());
            return;
        }
        if (x instanceof Integer || x instanceof Float || x instanceof Double) {
            this._parameters[parameterIndex - 1] = x.toString();
            return;
        }
        throw new MVASQLException(MessageCode.MVAPreparedStatement_unknownObjectType, new Object[0]);
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, int sqlType) throws SQLException {
        this.checkClosed();
        if (parameterIndex > this._parameterCount || parameterIndex < 1) {
            throw new MVASQLException(MessageCode.MVAPreparedStatement_invalidParamIndexError, new Object[0]);
        }
        if (x == null) {
            this.setNull(parameterIndex, sqlType);
            return;
        }
        switch (sqlType) {
            case 4: 
            case 6: 
            case 8: {
                if (x instanceof Integer || x instanceof Float || x instanceof Double || x instanceof String || x instanceof Character) {
                    String tempString;
                    this._parameters[parameterIndex - 1] = tempString = x.toString();
                    break;
                }
                throw new MVASQLException(MessageCode.MVAPreparedStatement_unknownObjectType, new Object[0]);
            }
            case -1: 
            case 1: 
            case 12: {
                if (x instanceof Integer || x instanceof Float || x instanceof Double || x instanceof String || x instanceof Character || x instanceof Date || x instanceof Time || x instanceof Timestamp) {
                    this.setString(parameterIndex, x.toString());
                    break;
                }
                throw new MVASQLException(MessageCode.MVAPreparedStatement_unknownObjectType, new Object[0]);
            }
            case 91: {
                Date tDate = null;
                if (x instanceof Timestamp) {
                    String s = x.toString();
                    tDate = Date.valueOf(s.substring(0, 10));
                } else if (x instanceof String) {
                    tDate = Date.valueOf(x.toString());
                } else if (x instanceof Date) {
                    tDate = (Date)x;
                } else {
                    throw new MVASQLException(MessageCode.MVAPreparedStatement_unknownObjectType, new Object[0]);
                }
                this.setDate(parameterIndex, tDate);
                break;
            }
            case 92: {
                Time tTime = null;
                if (x instanceof Timestamp) {
                    String s = x.toString();
                    tTime = Time.valueOf(s.substring(11, 19));
                } else if (x instanceof String) {
                    tTime = Time.valueOf(x.toString());
                } else if (x instanceof Time) {
                    tTime = (Time)x;
                } else {
                    throw new MVASQLException(MessageCode.MVAPreparedStatement_unknownObjectType, new Object[0]);
                }
                this.setTime(parameterIndex, tTime);
                break;
            }
            case 93: {
                Timestamp tStamp = null;
                if (x instanceof Timestamp) {
                    tStamp = (Timestamp)x;
                } else if (x instanceof String) {
                    tStamp = Timestamp.valueOf(x.toString());
                } else if (x instanceof Date) {
                    long lTime = ((Date)x).getTime();
                    tStamp = new Timestamp(lTime);
                } else {
                    throw new MVASQLException(MessageCode.MVAPreparedStatement_unknownObjectType, new Object[0]);
                }
                this.setTimestamp(parameterIndex, tStamp);
                break;
            }
            default: {
                throw new MVASQLException(MessageCode.MVAPreparedStatement_unknownObjectType, new Object[0]);
            }
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkClosed();
        super.addBatch2(this._parsedQuery, this._parameters);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        int endIndex;
        this.checkClosed();
        String sasifiedSql = this._parsedQuery.getSasifiedQuery();
        for (endIndex = sasifiedSql.length(); endIndex != 0 && sasifiedSql.charAt(endIndex - 1) == ';'; --endIndex) {
        }
        sasifiedSql = sasifiedSql.substring(0, endIndex);
        if (!this._parsedQuery.queryReturnsResultSet()) {
            return null;
        }
        if (this._currentResultSet != null) {
            return this._currentResultSet.getMetaData();
        }
        try {
            if (this._parameters.length == 0) {
                String shortCircuitQuery = "SELECT * FROM ( " + sasifiedSql + " ) WHERE 0";
                super.execute(shortCircuitQuery);
                return this.getResultSet().getMetaData();
            }
            String query = this._parsedQuery.buildQuery(this._parameters);
            for (endIndex = query.length(); endIndex != 0 && query.charAt(endIndex - 1) == ';'; --endIndex) {
            }
            String shortCircuitQuery = "SELECT * FROM ( " + query.substring(0, endIndex) + " ) WHERE 0";
            super.execute(shortCircuitQuery);
            return this.getResultSet().getMetaData();
        }
        catch (SQLException e) {
            Throwable t = e.getCause();
            throw new MVASQLException(MessageCode.MVAPreparedStatement_getMetaDataError, t != null ? t : e, new Object[0]);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkClosed();
        if (cal == null) {
            this.setDate(parameterIndex, x);
            return;
        }
        if (x == null) {
            this.setNull(parameterIndex, 91);
            return;
        }
        Date tdate = new Date(x.getTime() + (long)cal.getTimeZone().getOffset(x.getTime()));
        this.setDate(parameterIndex, tdate);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkClosed();
        if (cal == null) {
            this.setTime(parameterIndex, x);
            return;
        }
        if (x == null) {
            this.setNull(parameterIndex, 92);
            return;
        }
        Time ttime = new Time(x.getTime() + (long)cal.getTimeZone().getOffset(x.getTime()));
        this.setTime(parameterIndex, ttime);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkClosed();
        if (cal == null) {
            this.setTimestamp(parameterIndex, x);
            return;
        }
        if (x == null) {
            this.setNull(parameterIndex, 93);
            return;
        }
        Timestamp ttimestamp = new Timestamp(x.getTime() + (long)cal.getTimeZone().getOffset(x.getTime()));
        this.setTimestamp(parameterIndex, ttimestamp);
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType, String x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }
}

