/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SSLSocketChannel
extends SocketChannel {
    private static final Logger _logger = LogManager.getLogger(SSLSocketChannel.class);
    private static final String _endpointIdentificationAlg = "HTTPS";
    private SocketChannel _channel;
    private String _host;
    private int _port;
    private boolean _close;
    private SocketAdapter _socket;
    private Method _setEndpointIdentificationAlgorithmMethod;
    private SSLContext _sslContext;
    private SSLEngine _sslEngine;
    private ByteBuffer _incmAppBuf;
    private ByteBuffer _incmNetBuf;
    private ByteBuffer _outgNetBuf;
    private boolean _handshaking;
    private boolean _closing;

    protected SSLSocketChannel(SelectorProvider provider) {
        super(provider);
    }

    @Override
    public synchronized Socket socket() {
        if (this._socket == null) {
            this._socket = new SocketAdapter(this);
        }
        return this._socket;
    }

    @Override
    public boolean isConnected() {
        return this._channel.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        return this._channel.isConnectionPending();
    }

    @Override
    public boolean connect(SocketAddress remote) throws IOException {
        return this._channel.connect(remote);
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this._channel.finishConnect();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return (int)this.read(new ByteBuffer[]{dst}, 0, 1);
    }

    @Override
    public synchronized long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        int bytesUnwrapped;
        if (this._closing) {
            throw new ClosedChannelException();
        }
        if (!this._channel.isBlocking()) {
            throw new IllegalStateException("Non-blocking read not supported.");
        }
        long maxBytesToRead = 0L;
        for (int i = offset; i < offset + length; ++i) {
            maxBytesToRead = dsts[i].remaining();
        }
        if (maxBytesToRead == 0L) {
            return 0L;
        }
        long l = 0L;
        int i = offset;
        while (true) {
            if (l < maxBytesToRead && this._incmAppBuf.hasRemaining()) {
                ByteBuffer dst = dsts[i];
                int spaceAvail = dst.remaining();
                int bytesAvail = this._incmAppBuf.remaining();
                int bytesToCopy = Math.min(spaceAvail, bytesAvail);
                this.copyBuf(this._incmAppBuf, dst, bytesToCopy);
                l += (long)bytesToCopy;
                if (!dst.hasRemaining()) continue;
                ++i;
                continue;
            }
            if (l > 0L) {
                return l;
            }
            bytesUnwrapped = this.readAndUnwrap();
            if (bytesUnwrapped < 0) break;
        }
        return l > 0L ? l : (long)bytesUnwrapped;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return (int)this.write(new ByteBuffer[]{src}, 0, 1);
    }

    @Override
    public synchronized long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (this._closing) {
            throw new ClosedChannelException();
        }
        long l = 0L;
        for (int i = offset; i < offset + length; ++i) {
            ByteBuffer src = srcs[i];
            int r = src.remaining();
            if (!this.wrapAndWrite(src)) {
                l += (long)(r - src.remaining());
                break;
            }
            l += (long)r;
        }
        return l;
    }

    public SocketChannel getSelectableChannel() {
        return this._channel instanceof SSLSocketChannel ? ((SSLSocketChannel)this._channel).getSelectableChannel() : this._channel;
    }

    public synchronized boolean hasRemaining() {
        return this._incmAppBuf.hasRemaining() || this._incmNetBuf.hasRemaining() || this._channel instanceof SSLSocketChannel && ((SSLSocketChannel)this._channel).hasRemaining();
    }

    public static SSLSocketChannel createSocketChannel(SocketChannel channel, String host, int port, boolean close) throws IOException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("creating SSLSocketChannel: host=" + host + ",port=" + port + ",close=" + close);
        }
        SelectorProvider provider = channel.provider();
        SSLSocketChannel sslChannel = new SSLSocketChannel(provider);
        sslChannel.setChannel(channel);
        sslChannel.setHost(host);
        sslChannel.setPort(port);
        sslChannel.setClose(close);
        sslChannel.init();
        return sslChannel;
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Closing channel for " + this.toString() + " _close = " + this._close);
        }
        this.shutdownHandshake();
        if (this._close) {
            this._channel.close();
        }
    }

    protected void shutdownHandshake() throws IOException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Sending shutdownHandShake for " + this.toString());
        }
        if (this._closing) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("We already sent shutdownHandShake for " + this.toString());
            }
            return;
        }
        Socket underlyingSocket = this.getSelectableChannel().socket();
        if (underlyingSocket.isClosed() || !underlyingSocket.isConnected() || underlyingSocket.isOutputShutdown()) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Socket is already closed for " + this.toString());
            }
            return;
        }
        this._closing = true;
        this._sslEngine.closeOutbound();
        ByteBuffer emptyBuf = ByteBuffer.allocate(0);
        this.wrapAndWrite(emptyBuf);
        if (this._channel instanceof SSLSocketChannel) {
            ((SSLSocketChannel)this._channel).shutdownHandshake();
        }
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        this._channel.configureBlocking(block);
    }

    protected void setChannel(SocketChannel channel) {
        this._channel = channel;
    }

    private void setHost(String host) {
        this._host = host;
    }

    private void setPort(int port) {
        this._port = port;
    }

    private void setClose(boolean close) {
        this._close = close;
    }

    private void init() throws IOException {
        String sslProtocol = System.getProperty("com.sas.iom.orb.ssl.protocol", "TLSv1.2");
        if (_logger.isDebugEnabled()) {
            _logger.debug("initializing SSLContext for protocol " + sslProtocol);
        }
        try {
            this._sslContext = SSLContext.getInstance(sslProtocol);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IOException(nsae);
        }
        TrustManager[] trustManagerArr = this.getDefaultTrustManagers();
        boolean java7HostnameVerificationAvailable = this.initHostnameVerification();
        if (!java7HostnameVerificationAvailable) {
            trustManagerArr = this.decorateTrustManagersForHostnameVerificationInJava6(trustManagerArr);
        }
        trustManagerArr = this.decorateTrustManagersForTrustedCertificateValidation(trustManagerArr);
        try {
            this._sslContext.init(null, trustManagerArr, null);
        }
        catch (KeyManagementException kme) {
            throw new IOException(kme);
        }
        this._sslEngine = this._sslContext.createSSLEngine(this._host, this._port);
        if (java7HostnameVerificationAvailable) {
            this.setEndpointIdentificationAlgorithm();
        }
        SSLSession sslSession = this._sslEngine.getSession();
        int netBufL = sslSession.getPacketBufferSize();
        this._incmNetBuf = ByteBuffer.allocate(netBufL);
        this._outgNetBuf = ByteBuffer.allocate(netBufL);
        int appBufL = sslSession.getApplicationBufferSize();
        this._incmAppBuf = ByteBuffer.allocate(appBufL);
        this._sslEngine.setUseClientMode(true);
        this._sslEngine.beginHandshake();
        this._outgNetBuf.limit(0);
        this._incmNetBuf.limit(0);
        this._incmAppBuf.limit(0);
        this.handshake();
    }

    private void handshake() throws IOException {
        try {
            this._handshaking = true;
            this.doHandshake();
        }
        finally {
            this._handshaking = false;
        }
    }

    private void doHandshake() throws IOException {
        if (!this._channel.isBlocking()) {
            throw new IllegalStateException("SSL Handshake in non-blocking mode not supported.");
        }
        while (true) {
            SSLEngineResult.HandshakeStatus hsStatus = this._sslEngine.getHandshakeStatus();
            switch (hsStatus) {
                case NEED_TASK: {
                    Runnable task = this._sslEngine.getDelegatedTask();
                    if (task == null) break;
                    task.run();
                    break;
                }
                case NEED_WRAP: {
                    ByteBuffer emptyBuf = ByteBuffer.allocate(0);
                    this.wrapAndWrite(emptyBuf);
                    break;
                }
                case NEED_UNWRAP: {
                    this.readAndUnwrap();
                    break;
                }
                case FINISHED: 
                case NOT_HANDSHAKING: {
                    return;
                }
            }
        }
    }

    private boolean wrapAndWrite(ByteBuffer outgAppBuf) throws IOException {
        boolean blocking = this._channel.isBlocking();
        while (true) {
            if (this._outgNetBuf.hasRemaining()) {
                this._channel.write(this._outgNetBuf);
                if (blocking) continue;
            }
            if (this._outgNetBuf.hasRemaining()) {
                return false;
            }
            if (outgAppBuf.hasRemaining() || this._closing || this._handshaking && this._sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                this._outgNetBuf.clear();
                SSLEngineResult sslResult = this._sslEngine.wrap(outgAppBuf, this._outgNetBuf);
                SSLEngineResult.Status sslStatus = sslResult.getStatus();
                if (sslStatus == SSLEngineResult.Status.OK || this._closing && sslStatus == SSLEngineResult.Status.CLOSED) {
                    this._outgNetBuf.flip();
                } else {
                    throw new IllegalStateException("SSL wrap status " + sslStatus.toString() + " should not be possible");
                }
            }
            if (!this._outgNetBuf.hasRemaining() && !outgAppBuf.hasRemaining()) break;
        }
        return true;
    }

    private int readAndUnwrap() throws IOException {
        if (this._incmAppBuf.hasRemaining()) {
            throw new IllegalStateException("readAnUnwrap called while decrypted data is still available.");
        }
        if (!this._channel.isBlocking()) {
            throw new IllegalStateException("Non-blocking read not supported.");
        }
        while (true) {
            if (this._incmNetBuf.hasRemaining()) {
                this._incmAppBuf.clear();
                SSLEngineResult sslResult = this._sslEngine.unwrap(this._incmNetBuf, this._incmAppBuf);
                SSLEngineResult.Status sslStatus = sslResult.getStatus();
                if (sslStatus == SSLEngineResult.Status.CLOSED) {
                    this._closing = true;
                    this._sslEngine.closeInbound();
                    ByteBuffer emptyBuf = ByteBuffer.allocate(0);
                    this.wrapAndWrite(emptyBuf);
                    if (sslResult.bytesProduced() > 0) {
                        this._incmAppBuf.flip();
                        return this._incmAppBuf.remaining();
                    }
                    return -1;
                }
                if (sslStatus == SSLEngineResult.Status.OK) {
                    if (this._handshaking && sslResult.bytesConsumed() > 0) {
                        if (sslResult.bytesProduced() > 0) {
                            throw new IllegalStateException("SSL unwrap produced decrypted data during handshake.");
                        }
                        this._incmAppBuf.limit(0);
                        return 0;
                    }
                    if (!this._handshaking && sslResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                        byte[] incmAppArr = null;
                        if (sslResult.bytesProduced() > 0) {
                            this._incmAppBuf.flip();
                            int incmAppBufL = this._incmAppBuf.remaining();
                            incmAppArr = new byte[incmAppBufL];
                            this._incmAppBuf.get(incmAppArr);
                            this._incmAppBuf.clear();
                        }
                        this.handshake();
                        if (incmAppArr != null) {
                            this._incmAppBuf.clear();
                            this._incmAppBuf.put(incmAppArr);
                            this._incmAppBuf.flip();
                            return this._incmAppBuf.remaining();
                        }
                    }
                    if (sslResult.bytesProduced() > 0) {
                        this._incmAppBuf.flip();
                        return this._incmAppBuf.remaining();
                    }
                }
                if (sslStatus == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    throw new IllegalStateException("SSL unwrap status BUFFER_OVERFLOW should not be posible.");
                }
            }
            this._incmNetBuf.compact();
            int bytesRead = this._channel.read(this._incmNetBuf);
            if (bytesRead < 0) {
                this._incmNetBuf.flip();
                return -1;
            }
            this._incmNetBuf.flip();
        }
    }

    private void copyBuf(ByteBuffer src, ByteBuffer dst, int bytesToCopy) {
        for (int i = 0; i < bytesToCopy; ++i) {
            dst.put(src.get());
        }
    }

    private TrustManager[] getDefaultTrustManagers() throws IOException {
        TrustManagerFactory trustManagerFactory = null;
        try {
            String trustManagerFactoryAlg = TrustManagerFactory.getDefaultAlgorithm();
            if (_logger.isDebugEnabled()) {
                _logger.debug("default trust manager factory algorithm is " + trustManagerFactoryAlg);
            }
            trustManagerFactory = TrustManagerFactory.getInstance(trustManagerFactoryAlg);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IOException(nsae);
        }
        try {
            trustManagerFactory.init((KeyStore)null);
        }
        catch (KeyStoreException kse) {
            throw new IOException(kse);
        }
        return trustManagerFactory.getTrustManagers();
    }

    private TrustManager[] decorateTrustManagersForHostnameVerificationInJava6(TrustManager[] trustManagers) {
        if (this._setEndpointIdentificationAlgorithmMethod != null) {
            throw new IllegalStateException("setEndpointIdentificationAlgorithm() is available, and we should be using it");
        }
        ArrayList<TrustManager> decoratedTrustManagerLst = new ArrayList<TrustManager>(trustManagers.length);
        for (TrustManager trustManager : trustManagers) {
            if (trustManager instanceof X509TrustManager) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("decorating trust manager " + trustManager + " for hostname verification");
                }
                trustManager = new Java6HostnameVerifyingTrustManagerDecorator((X509TrustManager)trustManager, this._host);
            }
            decoratedTrustManagerLst.add(trustManager);
        }
        int decoratedTrustManagerLstL = decoratedTrustManagerLst.size();
        TrustManager[] decoratedTrustManagerArr = new TrustManager[decoratedTrustManagerLstL];
        return decoratedTrustManagerLst.toArray(decoratedTrustManagerArr);
    }

    private TrustManager[] decorateTrustManagersForTrustedCertificateValidation(TrustManager[] trustManagers) {
        String checkTrustedCertificatesKey = "com.sas.iom.orb.ssl.checkTrustedCertificates";
        String checkTrustedCertificatesVal = System.getProperty("com.sas.iom.orb.ssl.checkTrustedCertificates");
        if (_logger.isDebugEnabled()) {
            _logger.debug("value of com.sas.iom.orb.ssl.checkTrustedCertificates is " + checkTrustedCertificatesVal);
        }
        if (checkTrustedCertificatesVal == null || Boolean.parseBoolean(checkTrustedCertificatesVal)) {
            ArrayList<TrustManager> decoratedTrustManagerLst = new ArrayList<TrustManager>(trustManagers.length);
            for (TrustManager trustManager : trustManagers) {
                if (trustManager instanceof X509TrustManager) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("decorating trust manager " + trustManager + " for trusted certificate verification");
                    }
                    trustManager = new TrustedCertificateValidatingTrustManagerDecorator((X509TrustManager)trustManager);
                }
                decoratedTrustManagerLst.add(trustManager);
            }
            int decoratedTrustManagerLstL = decoratedTrustManagerLst.size();
            TrustManager[] decoratedTrustManagerArr = new TrustManager[decoratedTrustManagerLstL];
            trustManagers = decoratedTrustManagerLst.toArray(decoratedTrustManagerArr);
        }
        return trustManagers;
    }

    private boolean initHostnameVerification() {
        block2: {
            try {
                this._setEndpointIdentificationAlgorithmMethod = SSLParameters.class.getMethod("setEndpointIdentificationAlgorithm", String.class);
            }
            catch (NoSuchMethodException nsme) {
                if (!_logger.isDebugEnabled()) break block2;
                _logger.debug("endpointIdentificationAlgorithm SSL parameter not available");
            }
        }
        return this._setEndpointIdentificationAlgorithmMethod != null;
    }

    private void setEndpointIdentificationAlgorithm() throws IOException {
        if (this._setEndpointIdentificationAlgorithmMethod == null) {
            throw new IllegalStateException("setEndpointIdentificationAlgorithm() method missing");
        }
        try {
            SSLParameters sslParms = new SSLParameters();
            this._setEndpointIdentificationAlgorithmMethod.invoke((Object)sslParms, _endpointIdentificationAlg);
            this._sslEngine.setSSLParameters(sslParms);
            if (_logger.isDebugEnabled()) {
                _logger.debug("enabled hostname verification using endpointIdentificationAlgorithm SSL parameter");
            }
        }
        catch (InvocationTargetException ite) {
            throw new IOException(SSLSocketChannel.handleInvocationTargetException(ite));
        }
        catch (IllegalAccessException iae) {
            throw new IOException(iae);
        }
    }

    private static Throwable handleInvocationTargetException(InvocationTargetException ite) {
        Throwable ex = ite.getCause();
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        return ex;
    }

    @Override
    public <T> T getOption(SocketOption<T> arg0) throws IOException {
        return null;
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return null;
    }

    @Override
    public SocketChannel bind(SocketAddress arg0) throws IOException {
        return null;
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return null;
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return null;
    }

    @Override
    public <T> SocketChannel setOption(SocketOption<T> arg0, T arg1) throws IOException {
        return null;
    }

    @Override
    public SocketChannel shutdownInput() throws IOException {
        return null;
    }

    @Override
    public SocketChannel shutdownOutput() throws IOException {
        return null;
    }

    private static final class SocketAdapter
    extends Socket {
        private SSLSocketChannel _sslChannel;
        private InputStreamAdapter _inputStream;
        private OutputStreamAdapter _outputStream;

        private SocketAdapter(SSLSocketChannel sslChannel) {
            this._sslChannel = sslChannel;
        }

        @Override
        public synchronized InputStream getInputStream() throws IOException {
            if (this._inputStream == null) {
                this._inputStream = new InputStreamAdapter(this._sslChannel);
            }
            return this._inputStream;
        }

        @Override
        public synchronized OutputStream getOutputStream() throws IOException {
            if (this._outputStream == null) {
                this._outputStream = new OutputStreamAdapter(this._sslChannel);
            }
            return this._outputStream;
        }

        @Override
        public boolean isBound() {
            return this._sslChannel.getSelectableChannel().socket().isBound();
        }

        @Override
        public boolean isClosed() {
            return this._sslChannel.getSelectableChannel().socket().isClosed();
        }

        @Override
        public boolean isConnected() {
            return this._sslChannel.getSelectableChannel().socket().isConnected();
        }

        @Override
        public void shutdownInput() throws IOException {
            this._sslChannel.getSelectableChannel().socket().shutdownInput();
        }

        @Override
        public void shutdownOutput() throws IOException {
            if (this._sslChannel._channel instanceof SSLSocketChannel) {
                ((SSLSocketChannel)this._sslChannel._channel).shutdownHandshake();
            }
            this._sslChannel.getSelectableChannel().socket().shutdownOutput();
        }
    }

    private static final class Java6HostnameVerifyingTrustManagerDecorator
    implements X509TrustManager {
        private X509TrustManager _delegate;
        private String _hostName;
        private Method _checkClientTrustedMethod;
        private Method _checkServerTrustedMethod;

        private Java6HostnameVerifyingTrustManagerDecorator(X509TrustManager delegate, String hostName) {
            this._delegate = delegate;
            this._hostName = hostName;
            this.init();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (this._checkClientTrustedMethod != null) {
                this.invokeCheckTrustedMethod(this._checkClientTrustedMethod, chain, authType);
            } else {
                this._delegate.checkClientTrusted(chain, authType);
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (this._checkServerTrustedMethod != null) {
                this.invokeCheckTrustedMethod(this._checkServerTrustedMethod, chain, authType);
            } else {
                this._delegate.checkServerTrusted(chain, authType);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this._delegate.getAcceptedIssuers();
        }

        private void init() {
            Class<?> x509TrustManagerClass = this._delegate.getClass();
            if (_logger.isDebugEnabled()) {
                for (Class<?> superclass = x509TrustManagerClass; superclass != null && X509TrustManager.class.isAssignableFrom(superclass); superclass = superclass.getSuperclass()) {
                    Method[] methArr;
                    Class<?>[] ifaceArr;
                    _logger.debug("trust manager class is " + superclass.getName());
                    int modifiers = superclass.getModifiers();
                    _logger.debug("trust manager class modifier is " + Modifier.toString(modifiers));
                    for (Class<?> iface : ifaceArr = superclass.getInterfaces()) {
                        _logger.debug("trust manager implements " + iface.getName());
                    }
                    for (Method meth : methArr = superclass.getDeclaredMethods()) {
                        if (!Modifier.isPublic(meth.getModifiers())) continue;
                        _logger.debug("trust manager declared public method: " + meth);
                    }
                }
            }
            while (x509TrustManagerClass != null && !Modifier.isPublic(x509TrustManagerClass.getModifiers())) {
                x509TrustManagerClass = x509TrustManagerClass.getSuperclass();
            }
            if (x509TrustManagerClass == null || !X509TrustManager.class.isAssignableFrom(x509TrustManagerClass)) {
                _logger.warn("could not enable hostname verification because trust manager is not public");
                return;
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("using trust manager class " + x509TrustManagerClass.getName());
            }
            X509Certificate[] chain = new X509Certificate[]{};
            Class[] argt = new Class[]{chain.getClass(), String.class, String.class, String.class};
            try {
                this._checkClientTrustedMethod = x509TrustManagerClass.getMethod("checkClientTrusted", argt);
            }
            catch (NoSuchMethodException nsme) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("checkClientTrusted method not found, trying obfuscated method name a");
                }
                try {
                    this._checkClientTrustedMethod = x509TrustManagerClass.getMethod("a", argt);
                }
                catch (NoSuchMethodException nsme2) {
                    _logger.warn("could not enable client hostname verification because checkClientTrusted method not found", (Throwable)nsme);
                }
            }
            try {
                this._checkServerTrustedMethod = x509TrustManagerClass.getMethod("checkServerTrusted", argt);
            }
            catch (NoSuchMethodException nsme) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("checkServerTrusted method not found, trying obfuscated method name b");
                }
                try {
                    this._checkServerTrustedMethod = x509TrustManagerClass.getMethod("b", argt);
                }
                catch (NoSuchMethodException nsme2) {
                    _logger.warn("could not enable server hostname verification because checkServerTrusted method not found", (Throwable)nsme);
                }
            }
        }

        private void invokeCheckTrustedMethod(Method method, X509Certificate[] chain, String authType) throws CertificateException {
            try {
                method.invoke((Object)this._delegate, chain, authType, this._hostName, SSLSocketChannel._endpointIdentificationAlg);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = SSLSocketChannel.handleInvocationTargetException(ite);
                if (cause instanceof CertificateException) {
                    throw (CertificateException)cause;
                }
                throw new IllegalStateException(cause);
            }
            catch (IllegalAccessException iae) {
                throw new IllegalStateException(iae);
            }
        }
    }

    private static final class TrustedCertificateValidatingTrustManagerDecorator
    implements X509TrustManager {
        private X509TrustManager _delegate;

        private TrustedCertificateValidatingTrustManagerDecorator(X509TrustManager delegate) {
            this._delegate = delegate;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this._delegate.checkClientTrusted(chain, authType);
            this.validateTrusted(chain);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this._delegate.checkServerTrusted(chain, authType);
            this.validateTrusted(chain);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this._delegate.getAcceptedIssuers();
        }

        private void validateTrusted(X509Certificate[] chain) throws CertificateException {
            X509Certificate[] trustedCertArr = this.getAcceptedIssuers();
            for (X509Certificate cert : chain) {
                if (!this.isTrustedCert(cert, trustedCertArr)) continue;
                if (_logger.isDebugEnabled()) {
                    _logger.debug("validating certificate trusted by JSSE: " + cert);
                }
                cert.checkValidity();
                X509Certificate issuer = this.findCertificateIssuer(cert, new X509Certificate[]{cert});
                if (issuer == null && (issuer = this.findCertificateIssuer(cert, chain)) == null) {
                    issuer = this.findCertificateIssuer(cert, trustedCertArr);
                }
                if (issuer != null) {
                    PublicKey issuerPublicKey = issuer.getPublicKey();
                    try {
                        cert.verify(issuerPublicKey);
                        continue;
                    }
                    catch (CertificateException ce) {
                        throw ce;
                    }
                    catch (GeneralSecurityException se) {
                        throw new CertificateException(se);
                    }
                }
                _logger.warn("could not verify signature because issuer public key not found");
            }
        }

        private boolean isTrustedCert(X509Certificate cert, X509Certificate[] trustedCertArr) {
            for (X509Certificate trustedCert : trustedCertArr) {
                PublicKey trustedCertPublicKey;
                PublicKey certPublicKey;
                X500Principal trustedCertPrin;
                if (cert.equals(trustedCert)) {
                    return true;
                }
                X500Principal certPrin = cert.getSubjectX500Principal();
                if (!certPrin.equals(trustedCertPrin = trustedCert.getSubjectX500Principal()) || !(certPublicKey = cert.getPublicKey()).equals(trustedCertPublicKey = trustedCert.getPublicKey())) continue;
                return true;
            }
            return false;
        }

        private X509Certificate findCertificateIssuer(X509Certificate cert, X509Certificate[] issuerArr) {
            X500Principal targetIssuerPrin = cert.getIssuerX500Principal();
            for (X509Certificate issuer : issuerArr) {
                X500Principal issuerPrin = issuer.getSubjectX500Principal();
                if (!targetIssuerPrin.equals(issuerPrin)) continue;
                return issuer;
            }
            return null;
        }
    }

    private static final class OutputStreamAdapter
    extends OutputStream {
        private SSLSocketChannel _sslChannel;

        private OutputStreamAdapter(SSLSocketChannel sslChannel) {
            this._sslChannel = sslChannel;
        }

        @Override
        public void write(int b) throws IOException {
            ByteBuffer buf = ByteBuffer.allocate(1);
            buf.put((byte)b);
            buf.rewind();
            this._sslChannel.write(buf);
        }

        @Override
        public void write(byte[] arr, int off, int len) throws IOException {
            ByteBuffer buf = ByteBuffer.wrap(arr, off, len);
            this._sslChannel.write(buf);
        }
    }

    private static final class InputStreamAdapter
    extends InputStream {
        private SSLSocketChannel _sslChannel;

        private InputStreamAdapter(SSLSocketChannel sslChannel) {
            this._sslChannel = sslChannel;
        }

        @Override
        public int read() throws IOException {
            ByteBuffer buf = ByteBuffer.allocate(1);
            int r = this._sslChannel.read(buf);
            if (r < 0) {
                return r;
            }
            int b = buf.get(0);
            return b >= 0 ? b : b + 256;
        }

        @Override
        public int read(byte[] arr, int off, int len) throws IOException {
            ByteBuffer buf = ByteBuffer.wrap(arr, off, len);
            return this._sslChannel.read(buf);
        }
    }
}

