/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import com.sas.iom.orb.TrackedResourceInterface;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceTracker
implements TrackedResourceInterface {
    private static final Logger _logger = LogManager.getLogger(ResourceTracker.class);
    private static final ResourceTracker _defaultResourceTracker = new ResourceTracker();
    private Map<TrackedResourceInterface, Object> _trackerMap;

    public static ResourceTracker getInstance() {
        return _defaultResourceTracker;
    }

    public synchronized void enable() {
        if (this._trackerMap == null) {
            _logger.debug("enabling resource tracker");
            this._trackerMap = new WeakHashMap<TrackedResourceInterface, Object>();
        }
    }

    public synchronized void trackResource(TrackedResourceInterface resource) {
        if (this._trackerMap != null) {
            _logger.debug("adding resource " + resource);
            this._trackerMap.put(resource, null);
        } else {
            _logger.debug("resource tracker not enabled, not adding resource " + resource);
        }
    }

    public synchronized void untrackResource(TrackedResourceInterface resource) {
        if (this._trackerMap != null) {
            _logger.debug("removing resource " + resource);
            this._trackerMap.remove(resource);
        } else {
            _logger.debug("resource tracker not enabled, not removing resource " + resource);
        }
    }

    @Override
    public synchronized void shutdown(boolean waitForCompletion) {
        _logger.debug("shutting down resource tracker, waitForCompletion=" + waitForCompletion);
        if (this._trackerMap == null) {
            _logger.debug("already shut down or never enabled");
            return;
        }
        Set<TrackedResourceInterface> resourceSet = this._trackerMap.keySet();
        HashSet<TrackedResourceInterface> resourceSetCopy = new HashSet<TrackedResourceInterface>(resourceSet);
        for (TrackedResourceInterface resource : resourceSetCopy) {
            if (resource == null) continue;
            _logger.debug("shutting down tracked resource " + resource);
            resource.shutdown(waitForCompletion);
        }
        this._trackerMap = null;
    }
}

