/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.DelegateBase;
import com.sas.iom.orb.DelegateLocal;
import com.sas.iom.orb.ExecutorServiceThreadPool;
import com.sas.iom.orb.GenericObject;
import com.sas.iom.orb.ORBBase;
import com.sas.iom.orb.SelectionHub;
import com.sas.iom.orb.ThreadPool;
import com.sas.iom.orb.WorkException;
import com.sas.iom.orb.WorkInterface;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA._PolicyStub;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicy;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.NoServant;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicy;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicy;
import org.omg.PortableServer.ThreadPolicyValue;

@SASScope
public final class POAImpl
extends ObjectImpl
implements POA {
    public static final String SINGLE_THREAD_MODEL_KEEP_ALIVE_TIME_KEY = POAImpl.class.getName() + ".singleThreadModelKeepAliveTime";
    private static final long serialVersionUID = 3580119130617274779L;
    private static String[] _iids;
    private static ByteBuffer idBuffer;
    private ORBBase orb;
    private String name;
    private POAImpl parent;
    private List children;
    private AdapterActivator activator;
    private ServantManager servantManager;
    private Servant defaultServant;
    private Set activeObjectMap;
    private Map activeRequestMap;
    private ServantDelegateImpl servantDelegate;
    private boolean destroyed;
    private byte[] oidPrefix;
    private DelegateBase policyDelegate;
    private ThreadPolicyValue threadPolicy;
    private LifespanPolicyValue lifespanPolicy;
    private IdAssignmentPolicyValue idAssignmentPolicy;
    private IdUniquenessPolicyValue idUniquenessPolicy;
    private ServantRetentionPolicyValue servantRetentionPolicy;
    private RequestProcessingPolicyValue requestProcessingPolicy;
    private ImplicitActivationPolicyValue implicitActivationPolicy;
    private Map<Integer, Policy> policyMap;
    private ThreadPool threadPool;

    protected POAImpl(ORBBase orb, String adapter_name, Policy[] policyArray) throws InvalidPolicy {
        this.orb = orb;
        this.name = POAImpl.maskNull(adapter_name);
        this.oidPrefix = POAImpl.generateOIDPrefix(this);
        this.activeRequestMap = new HashMap();
        this.servantDelegate = new ServantDelegateImpl();
        DelegateLocal poaDelegate = new DelegateLocal(orb, this.oidPrefix, (ObjectImpl)this, POAHelper.id());
        this._set_delegate(poaDelegate);
        this.initPolicies(policyArray);
        if (this.servantRetentionPolicy == ServantRetentionPolicyValue.RETAIN) {
            this.activeObjectMap = new HashSet();
        }
    }

    public synchronized POA create_POA(String adapter_name, POAManager a_POAManager, Policy[] policies) throws AdapterAlreadyExists, InvalidPolicy {
        if (a_POAManager != null) {
            throw new NO_IMPLEMENT();
        }
        if (this.destroyed) {
            throw new BAD_INV_ORDER(17, CompletionStatus.COMPLETED_NO);
        }
        try {
            if (this.find_POA(adapter_name, false) != null) {
                throw new AdapterAlreadyExists();
            }
        }
        catch (AdapterNonExistent adapterNonExistent) {
            // empty catch block
        }
        POAImpl poa = new POAImpl(this.orb, adapter_name, policies);
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.add(poa);
        poa.setParent(this);
        return poa;
    }

    public synchronized POA find_POA(String adapter_name, boolean activate_it) throws AdapterNonExistent {
        if (this.name.equals(adapter_name)) {
            return this;
        }
        if (this.children != null) {
            for (POA childPOA : this.children) {
                try {
                    return childPOA.find_POA(adapter_name, activate_it);
                }
                catch (AdapterNonExistent adapterNonExistent) {
                }
            }
        }
        if (activate_it && this.activator != null && this.activator.unknown_adapter((POA)this, adapter_name)) {
            return this.find_POA(adapter_name, false);
        }
        throw new AdapterNonExistent(adapter_name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(boolean etherealize_objects, boolean wait_for_completion) {
        if (etherealize_objects) {
            throw new NO_IMPLEMENT();
        }
        if (wait_for_completion) {
            Set invokingThreadSet = this.orb.getInvokingThreadSet();
            Thread currentThread = Thread.currentThread();
            java.lang.Object object = invokingThreadSet;
            synchronized (object) {
                if (invokingThreadSet.contains(currentThread)) {
                    throw new BAD_INV_ORDER(3, CompletionStatus.COMPLETED_MAYBE);
                }
            }
            object = this.activeRequestMap;
            synchronized (object) {
                try {
                    while (!POAImpl.isActiveRequestMapEmpty(this.activeRequestMap)) {
                        this.activeRequestMap.wait();
                    }
                }
                catch (InterruptedException ie) {
                    UNKNOWN unknown = new UNKNOWN();
                    unknown.initCause((Throwable)ie);
                    throw unknown;
                }
            }
        }
        POAImpl pOAImpl = this;
        synchronized (pOAImpl) {
            this.destroyed = true;
            if (this.children != null) {
                Iterator childItr = this.children.iterator();
                this.children = null;
                while (childItr.hasNext()) {
                    POA childPOA = (POA)childItr.next();
                    childPOA.destroy(etherealize_objects, wait_for_completion);
                }
            }
            if (this.threadPool != null) {
                this.threadPool.term();
                this.threadPool = null;
            }
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    public ThreadPolicy create_thread_policy(ThreadPolicyValue value) {
        return new ThreadPolicyImpl(this.policyDelegate, value);
    }

    public LifespanPolicy create_lifespan_policy(LifespanPolicyValue value) {
        return new LifespanPolicyImpl(this.policyDelegate, value);
    }

    public IdUniquenessPolicy create_id_uniqueness_policy(IdUniquenessPolicyValue value) {
        return new IdUniquenessPolicyImpl(this.policyDelegate, value);
    }

    public IdAssignmentPolicy create_id_assignment_policy(IdAssignmentPolicyValue value) {
        return new IdAssignmentPolicyImpl(this.policyDelegate, value);
    }

    public ImplicitActivationPolicy create_implicit_activation_policy(ImplicitActivationPolicyValue value) {
        return new ImplicitActivationPolicyImpl(this.policyDelegate, value);
    }

    public ServantRetentionPolicy create_servant_retention_policy(ServantRetentionPolicyValue value) {
        return new ServantRetentionPolicyImpl(this.policyDelegate, value);
    }

    public RequestProcessingPolicy create_request_processing_policy(RequestProcessingPolicyValue value) {
        return new RequestProcessingPolicyImpl(this.policyDelegate, value);
    }

    public String the_name() {
        return this.name;
    }

    public POA the_parent() {
        return this.parent;
    }

    public synchronized POA[] the_children() {
        if (this.children == null) {
            return new POA[0];
        }
        int size = this.children.size();
        POA[] childArray = new POA[size];
        childArray = this.children.toArray(childArray);
        return childArray;
    }

    public POAManager the_POAManager() {
        return null;
    }

    public AdapterActivator the_activator() {
        return this.activator;
    }

    public void the_activator(AdapterActivator the_activator) {
        this.activator = the_activator;
    }

    public ServantManager get_servant_manager() throws WrongPolicy {
        if (this.requestProcessingPolicy != RequestProcessingPolicyValue.USE_SERVANT_MANAGER) {
            throw new WrongPolicy();
        }
        return this.servantManager;
    }

    public synchronized void set_servant_manager(ServantManager imgr) throws WrongPolicy {
        if (this.requestProcessingPolicy != RequestProcessingPolicyValue.USE_SERVANT_MANAGER) {
            throw new WrongPolicy();
        }
        if (imgr == null) {
            throw new OBJ_ADAPTER(4, CompletionStatus.COMPLETED_NO);
        }
        if (this.servantManager != null) {
            throw new BAD_INV_ORDER(6, CompletionStatus.COMPLETED_NO);
        }
        if (this.servantRetentionPolicy == ServantRetentionPolicyValue.RETAIN ? !(imgr instanceof ServantActivator) : !(imgr instanceof ServantLocator)) {
            throw new OBJ_ADAPTER(4, CompletionStatus.COMPLETED_NO);
        }
        this.servantManager = imgr;
    }

    public synchronized Servant get_servant() throws NoServant, WrongPolicy {
        if (this.requestProcessingPolicy != RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) {
            throw new WrongPolicy();
        }
        if (this.defaultServant == null) {
            throw new NoServant();
        }
        return this.defaultServant;
    }

    public synchronized void set_servant(Servant p_servant) throws WrongPolicy {
        if (this.requestProcessingPolicy != RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) {
            throw new WrongPolicy();
        }
        this.defaultServant = p_servant;
    }

    public synchronized byte[] activate_object(Servant p_servant) throws ServantAlreadyActive, WrongPolicy {
        if (this.servantRetentionPolicy != ServantRetentionPolicyValue.RETAIN) {
            throw new WrongPolicy();
        }
        if (this.idAssignmentPolicy != IdAssignmentPolicyValue.SYSTEM_ID) {
            throw new WrongPolicy();
        }
        if (this.idUniquenessPolicy == IdUniquenessPolicyValue.UNIQUE_ID && POAImpl.findByServant(this.activeObjectMap, p_servant) != null) {
            throw new ServantAlreadyActive();
        }
        return this.activate(p_servant, null);
    }

    public synchronized void activate_object_with_id(byte[] oid, Servant p_servant) throws ServantAlreadyActive, ObjectAlreadyActive, WrongPolicy {
        if (this.idAssignmentPolicy == IdAssignmentPolicyValue.SYSTEM_ID && !POAImpl.arraysEqual(this.oidPrefix, oid, this.oidPrefix.length)) {
            throw new BAD_PARAM(14, CompletionStatus.COMPLETED_NO);
        }
        if (this.servantRetentionPolicy != ServantRetentionPolicyValue.RETAIN) {
            throw new WrongPolicy();
        }
        if (POAImpl.findByOID(this.activeObjectMap, oid, false) != null) {
            throw new ObjectAlreadyActive();
        }
        if (this.idUniquenessPolicy == IdUniquenessPolicyValue.UNIQUE_ID && POAImpl.findByServant(this.activeObjectMap, p_servant) != null) {
            throw new ServantAlreadyActive();
        }
        this.activate(p_servant, oid);
    }

    public synchronized void deactivate_object(byte[] oid) throws ObjectNotActive, WrongPolicy {
        if (this.servantRetentionPolicy != ServantRetentionPolicyValue.RETAIN) {
            throw new WrongPolicy();
        }
        DelegateLocal entry = POAImpl.findByOID(this.activeObjectMap, oid, true);
        if (entry == null) {
            throw new ObjectNotActive();
        }
        if (this.servantManager != null) {
            Servant servant = entry.getServant();
            ((ServantActivator)this.servantManager).etherealize(oid, (POA)this, servant, true, true);
        }
    }

    public Object create_reference(String iid) throws WrongPolicy {
        if (this.idAssignmentPolicy != IdAssignmentPolicyValue.SYSTEM_ID) {
            throw new WrongPolicy();
        }
        throw new NO_IMPLEMENT();
    }

    public Object create_reference_with_id(byte[] oid, String iid) {
        if (this.idAssignmentPolicy == IdAssignmentPolicyValue.SYSTEM_ID && !POAImpl.arraysEqual(this.oidPrefix, oid, this.oidPrefix.length)) {
            throw new BAD_PARAM(14, CompletionStatus.COMPLETED_NO);
        }
        throw new NO_IMPLEMENT();
    }

    public byte[] servant_to_id(Servant p_servant) throws ServantNotActive, WrongPolicy {
        DelegateLocal entry = this.servant_to_entry(p_servant);
        byte[] oid = entry.getOID();
        return oid;
    }

    public Object servant_to_reference(Servant p_servant) throws ServantNotActive, WrongPolicy {
        DelegateLocal entry = this.servant_to_entry(p_servant);
        ObjectImpl ref = entry.getReference();
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servant reference_to_servant(Object reference) throws ObjectNotActive, WrongPolicy, WrongAdapter {
        Delegate del = ((ObjectImpl)reference)._get_delegate();
        if (!(del instanceof DelegateLocal)) {
            throw new WrongAdapter();
        }
        DelegateLocal delegate = (DelegateLocal)del;
        byte[] oid = delegate.getOID();
        if (this.idAssignmentPolicy == IdAssignmentPolicyValue.SYSTEM_ID && !POAImpl.arraysEqual(this.oidPrefix, oid, this.oidPrefix.length)) {
            throw new WrongAdapter();
        }
        POAImpl pOAImpl = this;
        synchronized (pOAImpl) {
            if (this.requestProcessingPolicy == RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) {
                if (this.defaultServant != null) {
                    return this.defaultServant;
                }
                throw new ObjectNotActive();
            }
            if (this.servantRetentionPolicy == ServantRetentionPolicyValue.RETAIN) {
                if (this.activeObjectMap.contains((java.lang.Object)delegate)) {
                    Servant servant = delegate.getServant();
                    return servant;
                }
                throw new ObjectNotActive();
            }
        }
        throw new WrongPolicy();
    }

    public byte[] reference_to_id(Object reference) throws WrongAdapter, WrongPolicy {
        Delegate del = ((ObjectImpl)reference)._get_delegate();
        if (!(del instanceof DelegateLocal)) {
            throw new WrongAdapter();
        }
        DelegateLocal delegate = (DelegateLocal)del;
        byte[] oid = delegate.getOID();
        if (this.idAssignmentPolicy == IdAssignmentPolicyValue.SYSTEM_ID && !POAImpl.arraysEqual(this.oidPrefix, oid, this.oidPrefix.length)) {
            throw new WrongAdapter();
        }
        return oid;
    }

    public synchronized Servant id_to_servant(byte[] oid) throws ObjectNotActive, WrongPolicy {
        if (this.servantRetentionPolicy == ServantRetentionPolicyValue.RETAIN) {
            DelegateLocal entry = POAImpl.findByOID(this.activeObjectMap, oid, false);
            if (entry != null) {
                Servant servant = entry.getServant();
                return servant;
            }
            throw new ObjectNotActive();
        }
        if (this.requestProcessingPolicy == RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) {
            if (this.defaultServant != null) {
                return this.defaultServant;
            }
            throw new ObjectNotActive();
        }
        throw new WrongPolicy();
    }

    public synchronized Object id_to_reference(byte[] oid) throws ObjectNotActive, WrongPolicy {
        if (this.servantRetentionPolicy == ServantRetentionPolicyValue.RETAIN) {
            DelegateLocal entry = POAImpl.findByOID(this.activeObjectMap, oid, false);
            if (entry != null) {
                ObjectImpl ref = entry.getReference();
                return ref;
            }
            throw new ObjectNotActive();
        }
        throw new WrongPolicy();
    }

    public String[] _ids() {
        return POAImpl.getIIDs();
    }

    public byte[] id() {
        return this.oidPrefix;
    }

    public Object activateTransientObject(Servant servant) {
        servant._set_delegate((org.omg.PortableServer.portable.Delegate)this.servantDelegate);
        GenericObject obj = new GenericObject();
        DelegateLocal delegate = new DelegateLocal(this, null, (ObjectImpl)obj, servant);
        obj._set_delegate(delegate);
        return obj;
    }

    public Servant transientReferenceToServant(Object ref) {
        DelegateLocal delegate = (DelegateLocal)((ObjectImpl)ref)._get_delegate();
        Servant servant = delegate.getServant();
        return servant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activateRequest(DelegateLocal delegate) {
        Map map = this.activeRequestMap;
        synchronized (map) {
            Thread currentThread = Thread.currentThread();
            Stack<DelegateLocal> stack = (Stack<DelegateLocal>)this.activeRequestMap.get(currentThread);
            if (stack == null) {
                stack = new Stack<DelegateLocal>();
                this.activeRequestMap.put(currentThread, stack);
            }
            stack.push(delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivateRequest() {
        Map map = this.activeRequestMap;
        synchronized (map) {
            Thread currentThread = Thread.currentThread();
            Stack stack = (Stack)this.activeRequestMap.get(currentThread);
            if (stack == null) {
                return;
            }
            stack.pop();
            this.activeRequestMap.notifyAll();
        }
    }

    protected Map<Integer, Policy> getPolicies() {
        return this.policyMap;
    }

    protected synchronized void executeWork(WorkInterface work) throws WorkException {
        ThreadPool pool = this.threadPool;
        if (pool == null) {
            SelectionHub hub = this.orb.getSelectionHub();
            pool = hub.getThreadPool();
        }
        pool.executeDaemon(work);
    }

    private void initPolicies(Policy[] policyArray) throws InvalidPolicy {
        this.policyDelegate = new DelegateLocal(this.orb);
        if (policyArray != null) {
            for (int i = 0; i < policyArray.length; ++i) {
                Policy policy = policyArray[i];
                if (policy instanceof ThreadPolicy) {
                    this.threadPolicy = ((ThreadPolicy)policy).value();
                    continue;
                }
                if (policy instanceof LifespanPolicy) {
                    this.lifespanPolicy = ((LifespanPolicy)policy).value();
                    continue;
                }
                if (policy instanceof IdUniquenessPolicy) {
                    this.idUniquenessPolicy = ((IdUniquenessPolicy)policy).value();
                    continue;
                }
                if (policy instanceof IdAssignmentPolicy) {
                    this.idAssignmentPolicy = ((IdAssignmentPolicy)policy).value();
                    continue;
                }
                if (policy instanceof ServantRetentionPolicy) {
                    this.servantRetentionPolicy = ((ServantRetentionPolicy)policy).value();
                    if (this.servantRetentionPolicy != ServantRetentionPolicyValue.NON_RETAIN || this.requestProcessingPolicy != RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY) continue;
                    throw new InvalidPolicy((short)i);
                }
                if (policy instanceof RequestProcessingPolicy) {
                    this.requestProcessingPolicy = ((RequestProcessingPolicy)policy).value();
                    if (this.servantRetentionPolicy != ServantRetentionPolicyValue.NON_RETAIN || this.requestProcessingPolicy != RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY) continue;
                    throw new InvalidPolicy((short)i);
                }
                if (!(policy instanceof ImplicitActivationPolicy)) continue;
                this.implicitActivationPolicy = ((ImplicitActivationPolicy)policy).value();
            }
        }
        if (this.threadPolicy == null) {
            this.threadPolicy = ThreadPolicyValue.ORB_CTRL_MODEL;
        }
        if (this.lifespanPolicy == null) {
            this.lifespanPolicy = LifespanPolicyValue.TRANSIENT;
        }
        if (this.idUniquenessPolicy == null) {
            this.idUniquenessPolicy = IdUniquenessPolicyValue.UNIQUE_ID;
        }
        if (this.idAssignmentPolicy == null) {
            this.idAssignmentPolicy = IdAssignmentPolicyValue.SYSTEM_ID;
        }
        if (this.servantRetentionPolicy == null) {
            this.servantRetentionPolicy = ServantRetentionPolicyValue.RETAIN;
        }
        if (this.requestProcessingPolicy == null) {
            this.requestProcessingPolicy = RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY;
        }
        if (this.implicitActivationPolicy == null) {
            this.implicitActivationPolicy = ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION;
        }
        if (this.lifespanPolicy == LifespanPolicyValue.PERSISTENT) {
            throw new NO_IMPLEMENT();
        }
        if (this.threadPolicy == ThreadPolicyValue.SINGLE_THREAD_MODEL) {
            final String threadName = "executor for [" + this.name + "]";
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, threadName);
                }
            };
            long keepAliveTime = Long.parseLong(System.getProperty(SINGLE_THREAD_MODEL_KEEP_ALIVE_TIME_KEY, "60"));
            LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, 1, keepAliveTime, TimeUnit.SECONDS, workQueue, threadFactory);
            ExecutorService executor = Executors.unconfigurableExecutorService(threadPoolExecutor);
            this.threadPool = new ExecutorServiceThreadPool(executor);
        }
        this.policyMap = new HashMap<Integer, Policy>(7);
        this.policyMap.put(16, (Policy)this.create_thread_policy(this.threadPolicy));
        this.policyMap.put(17, (Policy)this.create_lifespan_policy(this.lifespanPolicy));
        this.policyMap.put(19, (Policy)this.create_id_assignment_policy(this.idAssignmentPolicy));
        this.policyMap.put(18, (Policy)this.create_id_uniqueness_policy(this.idUniquenessPolicy));
        this.policyMap.put(21, (Policy)this.create_servant_retention_policy(this.servantRetentionPolicy));
        this.policyMap.put(22, (Policy)this.create_request_processing_policy(this.requestProcessingPolicy));
        this.policyMap.put(20, (Policy)this.create_implicit_activation_policy(this.implicitActivationPolicy));
    }

    private void setParent(POAImpl mommy) {
        this.parent = mommy;
    }

    private synchronized void removeChild(POAImpl child) {
        if (this.children != null) {
            this.children.remove((java.lang.Object)child);
        }
    }

    private byte[] activate(Servant p_servant, byte[] oid) {
        p_servant._set_delegate((org.omg.PortableServer.portable.Delegate)this.servantDelegate);
        GenericObject obj = new GenericObject();
        if (oid == null) {
            oid = POAImpl.generateOID(this.oidPrefix, obj);
        }
        DelegateLocal delegate = new DelegateLocal(this, oid, (ObjectImpl)obj, p_servant);
        obj._set_delegate(delegate);
        this.activeObjectMap.add(delegate);
        return oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DelegateLocal servant_to_entry(Servant p_servant) throws ServantNotActive, WrongPolicy {
        java.lang.Object object = this.activeRequestMap;
        synchronized (object) {
            Thread currentThread = Thread.currentThread();
            Stack stack = (Stack)this.activeRequestMap.get(currentThread);
            if (stack != null) {
                DelegateLocal entry = (DelegateLocal)((java.lang.Object)stack.peek());
                Servant entryServant = entry.getServant();
                if (entry != null && p_servant == entryServant) {
                    return entry;
                }
            }
        }
        object = this;
        synchronized (object) {
            if (this.servantRetentionPolicy == ServantRetentionPolicyValue.RETAIN) {
                DelegateLocal entry;
                if (this.idUniquenessPolicy == IdUniquenessPolicyValue.UNIQUE_ID && (entry = POAImpl.findByServant(this.activeObjectMap, p_servant)) != null) {
                    return entry;
                }
                if (this.implicitActivationPolicy == ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION) {
                    byte[] oid = this.activate(p_servant, null);
                    DelegateLocal entry2 = POAImpl.findByOID(this.activeObjectMap, oid, false);
                    return entry2;
                }
                throw new ServantNotActive();
            }
            throw new WrongPolicy();
        }
    }

    private static synchronized String[] getIIDs() {
        if (_iids == null) {
            _iids = new String[1];
            POAImpl._iids[0] = "IDL:PortableServer/POA:1.0";
        }
        return _iids;
    }

    private static String maskNull(String str) {
        return str != null ? str : "";
    }

    private static boolean arraysEqual(byte[] a1, byte[] a2, int l) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        int l1 = a1.length;
        int l2 = a2.length;
        if (l < 0) {
            if (l1 != l2) {
                return false;
            }
            l = l1;
        } else if (l1 < l || l2 < l) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean isActiveRequestMapEmpty(Map arm) {
        if (arm.isEmpty()) {
            return true;
        }
        Set entrySet = arm.entrySet();
        for (Map.Entry entry : entrySet) {
            Stack stack = (Stack)entry.getValue();
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static DelegateLocal findByOID(Set aom, byte[] oid, boolean remove) {
        if (aom.size() == 0) {
            return null;
        }
        Iterator entryItr = aom.iterator();
        while (entryItr.hasNext()) {
            DelegateLocal entry = (DelegateLocal)((java.lang.Object)entryItr.next());
            byte[] entryOID = entry.getOID();
            if (!POAImpl.arraysEqual(oid, entryOID, -1)) continue;
            if (remove) {
                entryItr.remove();
            }
            return entry;
        }
        return null;
    }

    private static DelegateLocal findByServant(Set aom, Servant servant) {
        if (aom.size() == 0) {
            return null;
        }
        for (DelegateLocal entry : aom) {
            Servant entryServant = entry.getServant();
            if (servant != entryServant) continue;
            return entry;
        }
        return null;
    }

    private static synchronized byte[] generateOIDPrefix(POA poa) {
        if (idBuffer == null) {
            idBuffer = ByteBuffer.allocate(8);
        }
        int ihc = System.identityHashCode(poa);
        idBuffer.putInt(ihc);
        idBuffer.flip();
        byte[] oidPrefix = new byte[4];
        idBuffer.get(oidPrefix);
        idBuffer.clear();
        return oidPrefix;
    }

    private static synchronized byte[] generateOID(byte[] prefix, GenericObject reference) {
        if (idBuffer == null) {
            idBuffer = ByteBuffer.allocate(8);
        }
        int ihc = System.identityHashCode((java.lang.Object)reference);
        idBuffer.put(prefix);
        idBuffer.putInt(ihc);
        idBuffer.rewind();
        byte[] oid = new byte[8];
        idBuffer.get(oid);
        idBuffer.clear();
        return oid;
    }

    @SASScope
    private class ServantDelegateImpl
    implements org.omg.PortableServer.portable.Delegate {
        private ServantDelegateImpl() {
        }

        public ORB orb(Servant Self) {
            return POAImpl.this.orb;
        }

        public Object this_object(Servant Self) {
            throw new NO_IMPLEMENT();
        }

        public POA poa(Servant Self) {
            return POAImpl.this;
        }

        public byte[] object_id(Servant Self) {
            throw new NO_IMPLEMENT();
        }

        public POA default_POA(Servant Self) {
            throw new NO_IMPLEMENT();
        }

        public boolean is_a(Servant Self, String Repository_Id) {
            throw new NO_IMPLEMENT();
        }

        public boolean non_existent(Servant Self) {
            throw new NO_IMPLEMENT();
        }

        public Object get_interface_def(Servant self) {
            throw new NO_IMPLEMENT();
        }
    }

    @SASScope
    private static class ThreadPolicyImpl
    extends _PolicyBase
    implements ThreadPolicy {
        private static final long serialVersionUID = 791642288850658528L;
        private ThreadPolicyValue value;

        private ThreadPolicyImpl(Delegate delegate, ThreadPolicyValue val) {
            super(delegate, val.value(), 16);
            this.value = val;
        }

        public ThreadPolicyValue value() {
            return this.value;
        }
    }

    @SASScope
    private static class LifespanPolicyImpl
    extends _PolicyBase
    implements LifespanPolicy {
        private static final long serialVersionUID = 7254095552935017103L;
        private LifespanPolicyValue value;

        private LifespanPolicyImpl(Delegate delegate, LifespanPolicyValue val) {
            super(delegate, val.value(), 17);
            this.value = val;
        }

        public LifespanPolicyValue value() {
            return this.value;
        }
    }

    @SASScope
    private static class IdUniquenessPolicyImpl
    extends _PolicyBase
    implements IdUniquenessPolicy {
        private static final long serialVersionUID = -6792480089991732084L;
        private IdUniquenessPolicyValue value;

        private IdUniquenessPolicyImpl(Delegate delegate, IdUniquenessPolicyValue val) {
            super(delegate, val.value(), 18);
            this.value = val;
        }

        public IdUniquenessPolicyValue value() {
            return this.value;
        }
    }

    @SASScope
    private static class IdAssignmentPolicyImpl
    extends _PolicyBase
    implements IdAssignmentPolicy {
        private static final long serialVersionUID = -4534213892741068516L;
        private IdAssignmentPolicyValue value;

        private IdAssignmentPolicyImpl(Delegate delegate, IdAssignmentPolicyValue val) {
            super(delegate, val.value(), 19);
            this.value = val;
        }

        public IdAssignmentPolicyValue value() {
            return this.value;
        }
    }

    @SASScope
    private static class ImplicitActivationPolicyImpl
    extends _PolicyBase
    implements ImplicitActivationPolicy {
        private static final long serialVersionUID = -5793932953964795392L;
        private ImplicitActivationPolicyValue value;

        private ImplicitActivationPolicyImpl(Delegate delegate, ImplicitActivationPolicyValue val) {
            super(delegate, val.value(), 20);
            this.value = val;
        }

        public ImplicitActivationPolicyValue value() {
            return this.value;
        }
    }

    @SASScope
    private static class ServantRetentionPolicyImpl
    extends _PolicyBase
    implements ServantRetentionPolicy {
        private static final long serialVersionUID = -2837666097197626746L;
        private ServantRetentionPolicyValue value;

        private ServantRetentionPolicyImpl(Delegate delegate, ServantRetentionPolicyValue val) {
            super(delegate, val.value(), 21);
            this.value = val;
        }

        public ServantRetentionPolicyValue value() {
            return this.value;
        }
    }

    @SASScope
    private static class RequestProcessingPolicyImpl
    extends _PolicyBase
    implements RequestProcessingPolicy {
        private static final long serialVersionUID = -3100940308375337664L;
        private RequestProcessingPolicyValue value;

        private RequestProcessingPolicyImpl(Delegate delegate, RequestProcessingPolicyValue val) {
            super(delegate, val.value(), 22);
            this.value = val;
        }

        public RequestProcessingPolicyValue value() {
            return this.value;
        }
    }

    @SASScope
    private static abstract class _PolicyBase
    extends _PolicyStub {
        private static final long serialVersionUID = -6457617435236106833L;
        private int value;
        private int type;

        private _PolicyBase(Delegate delegate, int val, int type) {
            super(delegate);
            this.value = val;
            this.type = type;
        }

        public boolean equals(java.lang.Object that) {
            if (that == null || !that.getClass().getName().equals(((java.lang.Object)((java.lang.Object)this)).getClass().getName())) {
                return false;
            }
            _PolicyBase thatPolicy = (_PolicyBase)((java.lang.Object)that);
            return thatPolicy.value == this.value;
        }

        public int hashCode() {
            int hc = ((java.lang.Object)((java.lang.Object)this)).getClass().getName().hashCode();
            return hc ^= this.value;
        }

        public int policy_type() {
            return this.type;
        }
    }
}

