/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.storedprocessreport;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.impl.TransformationImpl;
import com.sas.metadata.remote.impl.TransformationImpl_Stub;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.publicobjects.storedprocessreport.ExpirationPolicy;
import com.sas.publicobjects.storedprocessreport.ExpirationPolicyInterface;
import com.sas.publicobjects.storedprocessreport.MetadataConstants;
import com.sas.publicobjects.storedprocessreport.RB;
import com.sas.publicobjects.storedprocessreport.RRSupport;
import com.sas.publicobjects.storedprocessreport.StoredProcessReportInterface;
import com.sas.publicobjects.storedprocessreport.StoredProcessReportLockedException;
import com.sas.publicobjects.storedprocessreport.StoredProcessReportOutput;
import com.sas.publicobjects.storedprocessreport.StoredProcessReportOutputInterface;
import com.sas.report.repository.CacheFilter;
import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.Repository;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.scheduler.model.DailyRecurrence;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.MonthlyRecurrence;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.WeeklyRecurrence;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.IdentityGroupInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.prompt.PersistenceFactoryWithServices;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.Execution2Interface;
import com.sas.services.storedprocess.ExecutionException;
import com.sas.services.storedprocess.StoredProcess2Interface;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.WaitPolicy;
import com.sas.services.util.Waiter;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.prefs.BackingStoreException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.Level;
import org.xml.sax.SAXException;

@SASScope
public final class StoredProcessReport
extends Metadata
implements StoredProcessReportInterface,
LocalizableProperties {
    static String _CLIENT_NAME = "StoredProcessReport 9.4";
    static String _LOGGING_CONTEXT = "com.sas.publicobjects.storedprocessreport";
    static UsageVersion OLDEST_VERSION = new UsageVersion(1, 0);
    static UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private List<StoredProcessReportOutputInterface> _output;
    private RRSupport _rrSupport = new RRSupport(this);
    private boolean _isModifiedInMemory;
    private boolean _existingSPR;
    private Execution2Interface _execution2Interface;

    public StoredProcessReport() throws RemoteException {
        super(StoredProcessReport.class);
    }

    public StoredProcessReport(Transformation o) throws RemoteException {
        super((Object)o, StoredProcessReport.class);
        this._existingSPR = true;
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public StoredProcessReport(TransformationImpl o) throws RemoteException {
        super((Object)o, StoredProcessReport.class);
        this._existingSPR = true;
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public StoredProcessReport(TransformationImpl_Stub o) throws RemoteException {
        super((Object)o, StoredProcessReport.class);
        this._existingSPR = true;
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public StoredProcessReport(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(StoredProcessReport.class);
        if (repos == null || name == null || parent == null) {
            throw new IllegalArgumentException();
        }
        try {
            Transformation transformation;
            if (repos instanceof OMIRepositoryInterface) {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                transformation = (Transformation)omirepository.createMetadata(name, "Transformation");
                transformation.setUsageVersion(CURRENT_VERSION.encode());
                transformation.setPublicType("Report.StoredProcess");
                this._repositoryObject = transformation;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                try {
                    parent.addItem((MetadataInterface)this);
                }
                catch (Exception ex) {
                    ((MdObjectStore)transformation.getObjectStore()).removeElementFromStore((CMetadata)transformation);
                    throw new RuntimeException(Message.format((ResourceBundle)RB.getResources(), (String)"SPR.exists.ex.fmt.txt", (Object)name, (Object)parent.getName()));
                }
            } else {
                throw new IllegalArgumentException();
            }
            AssociationList properties = transformation.getProperties();
            Property p = (Property)MetadataConstants.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)transformation, "MaxGenerations", "Property");
            p.setDefaultValue("1");
            p.setSQLType(12);
            p.setPropertyName("MaxGenerations");
            properties.add((Object)p);
            p = (Property)MetadataConstants.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)transformation, "ExpirationPolicy", "Property");
            p.setDefaultValue("");
            p.setSQLType(12);
            p.setPropertyName("ExpirationPolicy");
            properties.add((Object)p);
            p = (Property)MetadataConstants.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)transformation, "##CACHE_NAME_LIST##", "Property");
            p.setDefaultValue("SPRCache");
            p.setSQLType(12);
            properties.add((Object)p);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    @Override
    public synchronized void delete() throws ServiceException, RemoteException {
        this.checkIfCompatible();
        this.checkIfModified();
        PathUrl pathUrl = this.getPathUrl();
        Repository myRepository = this._rrSupport.getRepositoryAdapter(pathUrl);
        try {
            EntryInterface entry = myRepository.getEntry(pathUrl);
            entry.delete();
        }
        catch (RepositoryLockedException e) {
            throw new ServiceException(Message.format((String)RB.getStringResource("SPR.cantDelete.ex.fmt.txt"), (Object)e.getMessage()));
        }
        catch (RepositoryException e) {
            throw new ServiceException(Message.format((String)RB.getStringResource("SPR.cantDelete.ex.fmt.txt"), (Object)e.getMessage()));
        }
    }

    public synchronized void moveTo(FolderInterface folder) throws ServiceException, RemoteException {
        this.checkIfCompatible();
        this.checkIfModified();
        PathUrl pathUrl = this.getPathUrl();
        Repository sprRepository = this._rrSupport.getRepositoryAdapter(pathUrl);
        RRSupport folderRRSupport = new RRSupport((MetadataInterface)folder);
        Repository folderRepository = folderRRSupport.getRepositoryAdapter(folder.getPathUrl());
        try {
            EntryInterface sprEntry = sprRepository.getEntry(pathUrl);
            EntryInterface folderEntry = folderRepository.getEntry(folder.getPathUrl());
            sprEntry.moveTo(folderEntry);
            folderRRSupport.clearCacheInterface(true);
            this._rrSupport.clearCacheInterface(true);
            this.clearCachedValues(true, true);
        }
        catch (RepositoryLockedException e) {
            throw new ServiceException(Message.format((String)RB.getStringResource("SPR.cantMove.ex.fmt.txt"), (Object)e.getMessage()));
        }
        catch (RepositoryException e) {
            throw new ServiceException(Message.format((String)RB.getStringResource("SPR.cantMove.ex.fmt.txt"), (Object)e.getMessage()));
        }
    }

    @Override
    public synchronized void rename(String newName) throws IllegalArgumentException, ServiceException, RemoteException {
        this.checkIfCompatible();
        this.checkIfModified();
        PathUrl pathUrl = this.getPathUrl();
        try {
            Repository myRepository = this._rrSupport.getRepositoryAdapter(pathUrl);
            EntryInterface entry = myRepository.getEntry(pathUrl);
            entry.renameTo(newName);
            this.clearCachedValues(true, true);
        }
        catch (RepositoryNotFoundException e) {
            throw new ServiceException(Message.format((String)RB.getStringResource("SPR.cantRename.ex.fmt.txt"), (Object)e.getMessage()));
        }
        catch (RepositoryException e) {
            throw new ServiceException(Message.format((String)RB.getStringResource("SPR.cantRename.ex.fmt.txt"), (Object)e.getMessage()));
        }
        catch (SecurityException e) {
            throw new ServiceException(Message.format((String)RB.getStringResource("SPR.cantRename.ex.fmt.txt"), (Object)e.getMessage()));
        }
    }

    public synchronized void update() throws ServiceException, RemoteException {
        this.checkIfCompatible();
        this.validate();
        super.update();
        this._isModifiedInMemory = false;
        if (!this._existingSPR) {
            try {
                PathUrl pathUrl = this.getPathUrl();
                this._rrSupport.createHighWaterMark(pathUrl);
            }
            catch (Exception e) {
                String msg = Message.format((String)RB.getStringResource("SPR.contentErr.fmt.txt"), (Object)e.getMessage());
                this.logMessage(Level.WARN, msg, _LOGGING_CONTEXT, e);
            }
        }
        this._existingSPR = true;
        this.clearCachedValues(true, true);
    }

    private void validate() throws ServiceException, RemoteException {
        ClassifierMap cm = this.getStoredProcessJomaObject();
        if (cm == null) {
            throw new ServiceException(RB.getStringResource("SPR.noSP.ex.txt"));
        }
        Property pvProperty = this.getPromptValuesProperty();
        if (pvProperty == null || pvProperty.getDefaultValue().length() == 0) {
            return;
        }
        StoredProcessInterface spi = this.getStoredProcess();
        PromptValuesInterface promptValues = spi.getPromptValues();
        ArrayList<PromptDefinitionInterface> ignoredList = new ArrayList<PromptDefinitionInterface>();
        ArrayList<PromptDefinitionInterface> errorList = new ArrayList<PromptDefinitionInterface>();
        this.deserializeAndMergePrompts(promptValues, ignoredList, errorList);
        if (ignoredList.size() > 0 || errorList.size() > 0) {
            throw new ServiceException(RB.getStringResource("SPR.promptsChanged.ex.txt"));
        }
    }

    private synchronized void clearCachedValues(boolean closeRR, boolean disposePackages) throws RemoteException {
        if (this._output != null) {
            if (disposePackages) {
                for (StoredProcessReportOutputInterface sproi : this._output) {
                    try {
                        sproi.disposePackage();
                    }
                    catch (ServiceException serviceException) {}
                }
            }
            this._output = null;
        }
        this._rrSupport.clearCacheInterface(closeRR);
    }

    public String getType() throws RemoteException {
        return "Report.StoredProcess";
    }

    @Override
    public StoredProcessInterface getStoredProcess() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfReadCompatible();
        ClassifierMap cm = this.getStoredProcessJomaObject();
        if (cm == null) {
            return null;
        }
        return (StoredProcessInterface)this.getRepository().factoryProcess((Object)cm);
    }

    @Override
    public void setStoredProcess(StoredProcessInterface storedProcess) throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfCompatible();
        String errorMsg = MetadataConstants.validateStoredProcess(storedProcess, storedProcess.getPromptValues());
        if (errorMsg != null) {
            throw new ServiceException(errorMsg);
        }
        try {
            Transformation t = (Transformation)this._repositoryObject;
            AssociationList al = t.getTransformationSources();
            al.removeAllElements();
            al.add(storedProcess.getRepositoryEntity());
        }
        catch (MdException mde) {
            throw new ServiceException((Throwable)mde);
        }
        Property pvProperty = this.getPromptValuesProperty();
        if (pvProperty != null && pvProperty.getDefaultValue().length() != 0) {
            pvProperty.setDefaultValue("");
        }
        this._isModifiedInMemory = true;
    }

    private ClassifierMap getStoredProcessJomaObject() throws ServiceException, RemoteException {
        AssociationList al;
        Transformation t = (Transformation)this._repositoryObject;
        try {
            al = t.getTransformationSources();
        }
        catch (MdException mde) {
            throw new ServiceException((Throwable)mde);
        }
        int size = al.size();
        if (size == 0) {
            UserContextInterface uc = this._repository.getUserContext();
            int count = com.sas.services.storedprocess.MetadataConstants.getCountNoSecurity((SessionContextInterface)uc.getSessionContext(), (Root)((Root)this._repositoryObject), (String)"TransformationSources");
            if (count > 0) {
                throw new ServiceException(RB.getStringResource("SPR.cantSeeSP.ex.txt"));
            }
            return null;
        }
        if (size > 1) {
            throw new ServiceException(RB.getStringResource("SPR.badMetaMultipleCMs.ex.txt"));
        }
        CMetadata metadata = (CMetadata)al.get(0);
        if (metadata instanceof ClassifierMap) {
            return (ClassifierMap)metadata;
        }
        throw new ServiceException(RB.getStringResource("SPR.badMetaNotCM.ex.txt"));
    }

    @Override
    public PromptValuesInterface getPromptValues(List<PromptDefinitionInterface> ignoredDefinitionsList, List<PromptDefinitionInterface> errorDefinitionsList) throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfReadCompatible();
        StoredProcessInterface storedProcessSmartObject = this.getStoredProcess();
        PromptValuesInterface pv = storedProcessSmartObject.getPromptValues();
        this.deserializeAndMergePrompts(pv, ignoredDefinitionsList, errorDefinitionsList);
        return pv;
    }

    private void deserializeAndMergePrompts(PromptValuesInterface pv, List<PromptDefinitionInterface> ignoredDefinitionsList, List<PromptDefinitionInterface> errorDefinitionsList) throws RemoteException, ServiceException {
        PromptValuesInterface pvi;
        Property pvProperty = this.getPromptValuesProperty();
        if (pvProperty == null || pvProperty.getDefaultValue().length() == 0) {
            return;
        }
        String promptValuesXML = pvProperty.getDefaultValue();
        StringReader reader = new StringReader(promptValuesXML);
        PromptsReadingContext prc = null;
        try {
            UserContextInterface uc = this._repository.getUserContext();
            prc = PersistenceFactoryWithServices.newReadingContext((UserContextInterface)uc);
            LoggerFactoryInterface lf = PersistenceFactoryWithServices.newLoggerFactory((SessionContextInterface)uc.getSessionContext());
            pvi = (PromptValuesInterface)PromptUtil.newObjectFromXML((Reader)reader, (LoggerFactoryInterface)lf, (PromptsReadingContext)prc);
        }
        catch (SAXException e) {
            throw new ServiceException(Message.format((String)RB.getStringResource("SPR.errInPromptVals.ex.fmt.txt"), (Object)e.getMessage()));
        }
        catch (IOException e) {
            throw new ServiceException(Message.format((String)RB.getStringResource("SPR.errInPromptVals.ex.fmt.txt"), (Object)e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException(Message.format((String)RB.getStringResource("SPR.errInPromptVals.ex.fmt.txt"), (Object)e.getMessage()));
        }
        finally {
            reader.close();
            if (prc != null) {
                prc.destroy();
            }
        }
        if (pvi != null) {
            PromptUtil.mergePromptValuesByPromptDefinitionID((PromptValuesInterface)pvi, (PromptValuesInterface)pv, ignoredDefinitionsList, errorDefinitionsList);
        }
    }

    @Override
    public void setPromptValues(PromptValuesInterface promptValues) throws RemoteException, ServiceException {
        String promptValuesXML;
        this.checkPulse(true);
        this.checkIfCompatible();
        if (!(promptValues instanceof PersistenceInterface)) {
            throw new IllegalArgumentException(RB.getStringResource("SPR.parmNotPI.ex.txt"));
        }
        Property pvProperty = this.getPromptValuesProperty();
        if (pvProperty == null) {
            AssociationList properties;
            Transformation t = (Transformation)this._repositoryObject;
            try {
                properties = t.getProperties();
            }
            catch (MdException e) {
                throw new ServiceException((Throwable)e);
            }
            pvProperty = (Property)MetadataConstants.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)t, "PromptValues", "Property");
            pvProperty.setPropertyName("PromptValues");
            pvProperty.setSQLType(12);
            properties.add((Object)pvProperty);
        }
        try {
            promptValuesXML = XmlUtil.promptModelToPrettyString((PersistenceInterface)((PersistenceInterface)promptValues));
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (BackingStoreException e) {
            throw new ServiceException((Throwable)e);
        }
        pvProperty.setDefaultValue(promptValuesXML);
    }

    private Property getPromptValuesProperty() throws RemoteException, ServiceException {
        Transformation t = (Transformation)this._repositoryObject;
        try {
            return MetadataConstants.getProperty((Root)t, "PromptValues", null);
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public synchronized int getOutputCount() throws ServiceException, RemoteException {
        this.checkIfCompatible();
        this.checkIfModified();
        this.readOutputMetadata();
        return this._output.size();
    }

    @Override
    public synchronized void refresh() throws ServiceException, RemoteException {
        super.refresh();
        this.clearCachedValues(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized StoredProcessReportOutputInterface refreshOutput(boolean forceRefresh, WaitPolicy waitPolicy) throws ServiceException, RemoteException, InterruptedException {
        CacheItemInterface highWaterCacheItem;
        block26: {
            this.checkIfCompatible();
            this.checkIfModified();
            this._execution2Interface = null;
            StoredProcessInterface spmi = this.getStoredProcess();
            if (spmi == null) {
                throw new ServiceException(RB.getStringResource("SPR.noSP.ex.txt"));
            }
            spmi.refresh();
            if (!forceRefresh) {
                this.clearCachedValues(false, true);
                try {
                    StoredProcessReportOutputInterface latestOutput = this.getLatestValidOutput();
                    if (latestOutput != null) {
                        return latestOutput;
                    }
                }
                catch (Exception e) {
                    this.clearCachedValues(false, true);
                    StoredProcessReportOutputInterface latestOutput = this.getLatestValidOutput();
                    if (latestOutput == null) break block26;
                    return latestOutput;
                }
            }
        }
        PathUrl pathUrl = this.getPathUrl();
        this.clearCachedValues(false, true);
        this._rrSupport.setCacheInterface(pathUrl);
        try {
            highWaterCacheItem = this._rrSupport._cacheInterface.get("__HighWaterMark__");
        }
        catch (RepositoryNotFoundException e) {
            highWaterCacheItem = RRSupport.createHighWaterMark(this._rrSupport._cacheInterface);
        }
        catch (RepositoryException e) {
            throw new ServiceException((Throwable)e);
        }
        Waiter waiter = null;
        while (true) {
            try {
                highWaterCacheItem.lock();
            }
            catch (RepositoryLockedException e) {
                if (waitPolicy == null) {
                    waitPolicy = WaitPolicy.getDefaultWaitPolicy((WaitPolicy.TYPE)WaitPolicy.TYPE.INFINITE, null);
                }
                if (waitPolicy.getType() == WaitPolicy.TYPE.NONE) {
                    throw new StoredProcessReportLockedException(RB.getStringResource("SPR.locked.ex.txt"));
                }
                if (waiter != null) continue;
                waiter = new Waiter(waitPolicy);
                if (waiter.sleep()) continue;
                throw new StoredProcessReportLockedException(Message.format((String)RB.getStringResource("SPR.lockedAndTimeOut.ex.fmt.txt"), (Object)Long.toString(waiter.getTotalTimeWaited())));
            }
            catch (RepositoryException e) {
                throw new ServiceException(e.getMessage());
            }
            break;
        }
        boolean gotValidHighWaterCacheItem = true;
        try {
            StoredProcessReportOutputInterface spro;
            this.clearCachedValues(false, true);
            this._rrSupport.setCacheInterface(pathUrl);
            gotValidHighWaterCacheItem = false;
            try {
                highWaterCacheItem = this._rrSupport._cacheInterface.get("__HighWaterMark__");
                gotValidHighWaterCacheItem = true;
            }
            catch (RepositoryException e) {
                throw new ServiceException(e.getMessage());
            }
            StoredProcessReportOutputInterface storedProcessReportOutputInterface = spro = this.doRefreshOutput(forceRefresh, highWaterCacheItem);
            return storedProcessReportOutputInterface;
        }
        finally {
            try {
                if (gotValidHighWaterCacheItem) {
                    highWaterCacheItem.unlock();
                }
            }
            catch (RepositoryException e) {
                this.logMessage(Level.WARN, RB.getStringResource("SPR.excpUnlk.txt"), _LOGGING_CONTEXT, e);
            }
        }
    }

    private synchronized StoredProcessReportOutputInterface getLatestValidOutput() throws ServiceException, RemoteException {
        StoredProcessReportOutputInterface latestOutput = this.getOutput();
        if (latestOutput != null && !latestOutput.isExpired()) {
            latestOutput.getPackage();
            return latestOutput;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized StoredProcessReportOutputInterface doRefreshOutput(boolean forceRefresh, CacheItemInterface highWaterCacheItem) throws ServiceException, RemoteException {
        long generationNumberOfNewReport;
        StoredProcessReportOutputInterface latestOutput;
        if (!forceRefresh && (latestOutput = this.getLatestValidOutput()) != null) {
            return latestOutput;
        }
        StoredProcessInterface spmi = this.getStoredProcess();
        if (spmi == null) {
            throw new ServiceException(RB.getStringResource("SPR.noSP.ex.txt"));
        }
        Object o = spmi.newServiceObject();
        if (!(o instanceof StoredProcess2Interface)) {
            throw new IllegalStateException("Some kind of versioning mismatch.  Expected a StoredProcess2Interface from the newServiceObject() call, but got a " + o.getClass().getSimpleName());
        }
        StoredProcess2Interface sp2i = (StoredProcess2Interface)o;
        ArrayList<PromptDefinitionInterface> ignoredList = new ArrayList<PromptDefinitionInterface>();
        ArrayList<PromptDefinitionInterface> errorList = new ArrayList<PromptDefinitionInterface>();
        this.deserializeAndMergePrompts(sp2i.getPromptValues(), ignoredList, errorList);
        if (ignoredList.size() > 0 || errorList.size() > 0) {
            throw new ServiceException(RB.getStringResource("SPR.promptsChanged.ex.txt"));
        }
        String errorMsg = MetadataConstants.validateStoredProcess(spmi, sp2i.getPromptValues());
        if (errorMsg != null) {
            throw new ServiceException(errorMsg);
        }
        try {
            ExecutionException[] exceptions;
            RepositoryInterface ri = this.getRepository();
            if (ri == null) {
                throw new ServiceException(RB.getStringResource("SPR.noRepos.msg.txt"));
            }
            UserContextInterface uc = ri.getUserContext();
            if (uc == null) {
                throw new ServiceException(RB.getStringResource("COM.noUserCtxt.ex.txt"));
            }
            SessionContextInterface sessionContext = uc.getSessionContext();
            if (sessionContext == null) {
                throw new ServiceException(RB.getStringResource("SPR.noSessnCtxt.ex.txt"));
            }
            sp2i.setClientName(_CLIENT_NAME);
            Object lock = sessionContext.lock("Stored Process Report");
            try {
                this._execution2Interface = sp2i.execute(true, null, false, null);
            }
            finally {
                sessionContext.unlock(lock);
            }
            int status = this._execution2Interface.getStatus();
            if ((status == 4 || status == 2) && (exceptions = this._execution2Interface.getExceptions()).length > 0) {
                for (ExecutionException e : exceptions) {
                    this.logMessage(Level.ERROR, RB.getStringResource("SPR.excpExecSP.txt"), _LOGGING_CONTEXT, e);
                }
                throw new ServiceException((Throwable)exceptions[0], RB.getStringResource("SPR.excpExecSP.txt"));
            }
        }
        catch (ExecutionException e) {
            throw new ServiceException((Throwable)e);
        }
        finally {
            sp2i.destroy();
        }
        ResultPackageInterface rpi = this._execution2Interface.getResultPackage();
        if (rpi == null) {
            throw new ServiceException(RB.getStringResource("SPR.cantGetRP.ex.txt"));
        }
        long creationTime = rpi.getCreationDateTime();
        int conditionCode = this._execution2Interface.getSASConditionCode();
        this.readOutputMetadata();
        try {
            String highGen = (String)highWaterCacheItem.getAttribute("{http://www.sas.com/xml/namespace/services.sp.report-1.1}HighestGeneration");
            if (highGen == null) {
                throw new ServiceException(RB.getStringResource("SPR.missnHighWaterMark.ex.txt"));
            }
            try {
                generationNumberOfNewReport = Long.decode(highGen) + 1L;
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
        }
        catch (RepositoryNotFoundException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new ServiceException((Throwable)e);
        }
        try {
            highWaterCacheItem.setAttribute("{http://www.sas.com/xml/namespace/services.sp.report-1.1}HighestGeneration", (Object)Long.toString(generationNumberOfNewReport));
        }
        catch (RepositoryLockedException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new ServiceException((Throwable)e);
        }
        CacheItemInterface item = null;
        InputStream is = null;
        FilterOutputStream bos = null;
        try {
            int len;
            item = this.locateItem(generationNumberOfNewReport);
            OutputStream os = item.getOutputStream();
            bos = new BufferedOutputStream(os);
            is = rpi.getInputStream();
            byte[] buffer = new byte[4096];
            while ((len = is.read(buffer)) > 0) {
                ((BufferedOutputStream)bos).write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            try {
                if (bos != null) {
                    try {
                        bos.close();
                        bos = null;
                    }
                    catch (IOException e1) {
                        this.logMessage(Level.WARN, RB.getStringResource("SPR.cantClosOS.ex.txt"), _LOGGING_CONTEXT, e1);
                    }
                }
                if (item != null) {
                    item.delete();
                }
            }
            catch (Exception e1) {
                String str = Message.format((String)RB.getStringResource("SPR.cantDelCI.ex.fmt.txt"), (Object)item.getName());
                this.logMessage(Level.WARN, str, _LOGGING_CONTEXT, e1);
            }
            throw new ServiceException((Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                this.logMessage(Level.WARN, RB.getStringResource("SPR.cantClosIS.ex.txt"), _LOGGING_CONTEXT, e);
            }
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                this.logMessage(Level.WARN, RB.getStringResource("SPR.cantClosOS.ex.txt"), _LOGGING_CONTEXT, e);
            }
        }
        if (item != null) {
            try {
                item.setAttribute("{http://www.sas.com/xml/namespace/services.sp.report-1.1}Generation", (Object)Long.toString(generationNumberOfNewReport));
                String nameValue = null;
                try {
                    UserContextInterface uci = this._repository.getUserContext();
                    IdentityInterface ii = uci.getPerson();
                    if (ii == null) {
                        nameValue = uci.getResolvedUserId();
                        if (nameValue == null || nameValue.length() == 0) {
                            nameValue = "PublicUser";
                        }
                    } else {
                        String type = ii instanceof PersonInterface ? "User:" : (ii instanceof IdentityGroupInterface ? "UserGroup:" : "");
                        nameValue = type + ii.getName();
                    }
                }
                catch (Exception type) {
                    // empty catch block
                }
                if (nameValue != null) {
                    item.setAttribute("{http://www.sas.com/xml/namespace/services.sp.report-1.1}IdentityTypeAndName", nameValue);
                }
                item.setAttribute("{http://www.sas.com/xml/namespace/services.sp.report-1.1}CreationTime", (Object)Long.toString(creationTime));
                item.setAttribute("{http://www.sas.com/xml/namespace/services.sp.report-1.1}ConditionCode", (Object)Integer.toString(conditionCode));
                ExpirationPolicyInterface epi = this.getExpirationPolicy();
                Date expirationDate = epi.getExpirationDate(new Date(creationTime));
                if (expirationDate == null) {
                    item.setAttribute("{http://www.sas.com/xml/namespace/services.sp.report-1.1}ExpirationTime", (Object)"");
                } else {
                    item.setAttribute("{http://www.sas.com/xml/namespace/services.sp.report-1.1}ExpirationTime", (Object)Long.toString(expirationDate.getTime()));
                }
            }
            catch (RepositoryLockedException e) {
                throw new ServiceException((Throwable)e);
            }
            catch (RepositoryException e) {
                throw new ServiceException((Throwable)e);
            }
            catch (SecurityException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        Date sprModificationDate = this.getModifyDate();
        Date spModificationDate = spmi.getModifyDate();
        StoredProcessReportOutput spro = new StoredProcessReportOutput(this._repository.getUserContext(), item, this._output, spModificationDate, sprModificationDate);
        this._output.add(0, spro);
        ArrayList<StoredProcessReportOutputInterface> deleteList = new ArrayList<StoredProcessReportOutputInterface>();
        int maximumSavedOutput = this.getMaximumSavedOutput();
        for (int i = this._output.size() - 1; i >= maximumSavedOutput; --i) {
            StoredProcessReportOutputInterface oldOutput = this._output.get(i);
            if (!oldOutput.isValid()) continue;
            deleteList.add(oldOutput);
        }
        for (StoredProcessReportOutputInterface sproi : deleteList) {
            sproi.delete();
        }
        spro.getPackage();
        return spro;
    }

    @Override
    public synchronized List<StoredProcessReportOutputInterface> getAllOutput() throws RemoteException, ServiceException {
        this.checkIfCompatible();
        this.checkIfModified();
        this.readOutputMetadata();
        return Collections.unmodifiableList(this._output);
    }

    @Override
    public synchronized StoredProcessReportOutputInterface getOutput() throws RemoteException, ServiceException {
        this.checkIfCompatible();
        this.checkIfModified();
        this.readOutputMetadata();
        if (this._output.isEmpty()) {
            return null;
        }
        for (StoredProcessReportOutputInterface sproi : this._output) {
            if (!sproi.isValid()) continue;
            return sproi;
        }
        return null;
    }

    @Override
    public synchronized StoredProcessReportOutputInterface getOutput(Date date) throws ServiceException, RemoteException {
        this.checkIfCompatible();
        this.checkIfModified();
        this.readOutputMetadata();
        for (StoredProcessReportOutputInterface output : this._output) {
            Date outputCreationDate;
            if (!output.isValid() || !date.after(outputCreationDate = output.getCreationDate())) continue;
            return output;
        }
        return null;
    }

    @Override
    public synchronized StoredProcessReportOutputInterface getOutput(long generation) throws ServiceException, RemoteException {
        this.checkIfCompatible();
        this.checkIfModified();
        this.readOutputMetadata();
        for (StoredProcessReportOutputInterface output : this._output) {
            if (!output.isValid() || output.getGeneration() != generation) continue;
            return output;
        }
        return null;
    }

    @Override
    public synchronized void purgeAllOutput() throws ServiceException, RemoteException {
        this.checkIfCompatible();
        this.checkIfModified();
        this.readOutputMetadata();
        ArrayList<StoredProcessReportOutputInterface> copy = new ArrayList<StoredProcessReportOutputInterface>();
        copy.addAll(this._output);
        for (StoredProcessReportOutputInterface output : copy) {
            output.delete();
        }
    }

    @Override
    public int getMaximumSavedOutput() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfReadCompatible();
        try {
            Property p = this.getMaximumSavedOutputProperty();
            String value = p.getDefaultValue();
            if (value == null || value.length() == 0) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"SPR.missnValueInProp.ex.fmt.txt", (Object)"MaxGenerations"));
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                String msg = Message.format((String)RB.getStringResource("COM.badMaxGen.fmt.txt"), (Object)value);
                throw new ServiceException(msg);
            }
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private Property getMaximumSavedOutputProperty() throws RemoteException, MdException, ServiceException {
        Transformation t = (Transformation)this._repositoryObject;
        Property p = MetadataConstants.getProperty((Root)t, "MaxGenerations");
        if (p == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"SPR.missnProp.ex.fmt.txt", (Object)"ExpirationPolicy"));
        }
        return p;
    }

    @Override
    public void setMaximumSavedOutput(int maximum) throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfCompatible();
        if (maximum < 1) {
            throw new IllegalArgumentException(RB.getStringResource("SPR.invalidMSO.ex.txt"));
        }
        try {
            Property p = this.getMaximumSavedOutputProperty();
            p.setDefaultValue(Integer.toString(maximum));
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        this._isModifiedInMemory = true;
    }

    private void checkIfReadCompatible() throws RemoteException {
        if (!this.isReadCompatible()) {
            throw new IllegalStateException(Message.format((ResourceBundle)RB.getResources(), (String)"SPR.notReadCompat.ex.fmt.txt", (Object)this.getUsageVersion()));
        }
    }

    private void checkIfCompatible() throws RemoteException {
        if (!this.isCompatible()) {
            throw new IllegalStateException(Message.format((ResourceBundle)RB.getResources(), (String)"SPR.notSupp.ex.fmt.txt", (Object)this.getUsageVersion()));
        }
    }

    private synchronized void readOutputMetadata() throws RemoteException, ServiceException {
        if (this._output != null) {
            return;
        }
        PathUrl pathUrl = this.getPathUrl();
        try {
            this._rrSupport.setCacheInterface(pathUrl);
            if (!this._rrSupport._cacheInterface.exists("__HighWaterMark__")) {
                List emptyList = this._rrSupport._cacheInterface.list(null);
                if (emptyList.size() > 0) {
                    throw new ServiceException(RB.getStringResource("SPR.badMetaHasCacheItems.ex.txt"));
                }
                this._output = new ArrayList<StoredProcessReportOutputInterface>();
                return;
            }
            this._output = new ArrayList<StoredProcessReportOutputInterface>();
            CacheFilter filter = new CacheFilter(){

                public boolean accept(CacheInterface cache) {
                    return true;
                }

                public boolean accept(CacheItemInterface cacheItem) {
                    return cacheItem.getName().contains(".spk");
                }
            };
            UserContextInterface uc = this._repository.getUserContext();
            List cacheItems = this._rrSupport._cacheInterface.list(filter);
            if (!cacheItems.isEmpty()) {
                Date sprModificationDate = this.getModifyDate();
                StoredProcessInterface sp = this.getStoredProcess();
                Date spModificationDate = sp.getModifyDate();
                for (CacheItemInterface ci : cacheItems) {
                    StoredProcessReportOutput spro = new StoredProcessReportOutput(uc, ci, this._output, spModificationDate, sprModificationDate);
                    this._output.add(spro);
                }
                Collections.sort(this._output, new ReportOutputComparator());
            }
        }
        catch (RepositoryException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private CacheItemInterface locateItem(long nextGeneration) throws ServiceException, RemoteException {
        try {
            String entryName = "_" + Long.toString(nextGeneration) + ".spk";
            CacheItemInterface item = this._rrSupport._cacheInterface.exists(entryName) ? this._rrSupport._cacheInterface.get(entryName) : this._rrSupport._cacheInterface.create(entryName);
            if (item == null) {
                throw new ServiceException(Message.format((String)"SPR.cantCreateItem.ex.fmt.txt", (Object)entryName));
            }
            return item;
        }
        catch (RepositoryException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public synchronized void destroy() throws RemoteException {
        this.checkIfCompatible();
        this.clearCachedValues(true, false);
        super.destroy();
    }

    private void checkIfModified() {
        if (!this._existingSPR || this._isModifiedInMemory) {
            throw new IllegalStateException(RB.getStringResource("SPR.metadataModified.ex.txt"));
        }
    }

    @Override
    public ExpirationPolicyInterface getExpirationPolicy() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfReadCompatible();
        try {
            Property p = this.getExpirationPolicyProperty();
            String xml = p.getDefaultValue();
            ExpirationPolicy ep = new ExpirationPolicy();
            if (xml == null || xml.length() == 0) {
                ep.setPeriod(ExpirationPolicyInterface.Period.NONE);
                return ep;
            }
            TimeEventInfo tei = new TimeEventInfo();
            try {
                tei.initFromXML(xml);
            }
            catch (SchedulerException e) {
                throw new MdException(e.getMessage());
            }
            try {
                ep.setHourOfDay(Integer.parseInt(tei.getHours()));
            }
            catch (NumberFormatException nfe) {
                String msg = Message.format((String)RB.getStringResource("SPR.invHr.msg.fmt.txt"), (Object)tei.getHours());
                throw new MdException(msg);
            }
            try {
                ep.setMinuteOfDay(Integer.parseInt(tei.getMinutes()));
            }
            catch (NumberFormatException nfe) {
                String msg = Message.format((String)RB.getStringResource("SPR.invMin.msg.fmt.txt"), (Object)tei.getHours());
                throw new MdException(msg);
            }
            ep.setTimeZone(TimeZone.getTimeZone(tei.getTimezoneId()));
            IRecurrenceInfo ir = tei.getRecurrence();
            if (ir instanceof DailyRecurrence) {
                ep.setPeriod(ExpirationPolicyInterface.Period.DAILY);
            } else if (ir instanceof WeeklyRecurrence) {
                ep.setPeriod(ExpirationPolicyInterface.Period.WEEKLY);
                WeeklyRecurrence wr = (WeeklyRecurrence)ir;
                int dayMaskValue = wr.getDaysToRun();
                ArrayList<ExpirationPolicyInterface.DayOfWeek> list = new ArrayList<ExpirationPolicyInterface.DayOfWeek>();
                if ((dayMaskValue & 0x40) > 0) {
                    list.add(ExpirationPolicyInterface.DayOfWeek.SUNDAY);
                }
                if ((dayMaskValue & 1) > 0) {
                    list.add(ExpirationPolicyInterface.DayOfWeek.MONDAY);
                }
                if ((dayMaskValue & 2) > 0) {
                    list.add(ExpirationPolicyInterface.DayOfWeek.TUESDAY);
                }
                if ((dayMaskValue & 4) > 0) {
                    list.add(ExpirationPolicyInterface.DayOfWeek.WEDNESDAY);
                }
                if ((dayMaskValue & 8) > 0) {
                    list.add(ExpirationPolicyInterface.DayOfWeek.THURSDAY);
                }
                if ((dayMaskValue & 0x10) > 0) {
                    list.add(ExpirationPolicyInterface.DayOfWeek.FRIDAY);
                }
                if ((dayMaskValue & 0x20) > 0) {
                    list.add(ExpirationPolicyInterface.DayOfWeek.SATURDAY);
                }
                EnumSet<ExpirationPolicyInterface.DayOfWeek> dow = EnumSet.copyOf(list);
                ep.setDaysOfWeek(dow);
            } else if (ir instanceof MonthlyRecurrence) {
                ep.setPeriod(ExpirationPolicyInterface.Period.MONTHLY);
                MonthlyRecurrence mr = (MonthlyRecurrence)ir;
                int domValue = mr.getDayOfMonth();
                if (domValue > 0) {
                    ep.setDayOfMonth(domValue);
                } else if (mr.getDayOfWeek() == 128) {
                    ep.setRecurring(ExpirationPolicyInterface.RecurringDay.DAY, ExpirationPolicyInterface.RecurringOccurrence.LAST);
                } else {
                    String msg = Message.format((String)RB.getStringResource("SPR.invDOW.fmt.txt"), (Object)new Integer(mr.getDayOfWeek()));
                    throw new MdException(msg);
                }
            }
            return ep;
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private Property getExpirationPolicyProperty() throws RemoteException, MdException, ServiceException {
        Transformation t = (Transformation)this._repositoryObject;
        Property p = MetadataConstants.getProperty((Root)t, "ExpirationPolicy");
        if (p == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"SPR.missnProp.ex.fmt.txt", (Object)"ExpirationPolicy"));
        }
        return p;
    }

    @Override
    public void setExpirationPolicy(ExpirationPolicyInterface expirationPolicy) throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfCompatible();
        if (expirationPolicy == null) {
            throw new NullPointerException("expirationPolicy");
        }
        try {
            Property p = this.getExpirationPolicyProperty();
            TimeEventInfo tei = null;
            ExpirationPolicyInterface.Period period = expirationPolicy.getPeriod();
            if (period != ExpirationPolicyInterface.Period.NONE) {
                tei = new TimeEventInfo();
                tei.setHours(String.valueOf(expirationPolicy.getHourOfDay()));
                tei.setMinutes(String.valueOf(expirationPolicy.getMinuteOfDay()));
                TimeZone tz = expirationPolicy.getTimeZone();
                if (tz == null) {
                    tz = TimeZone.getDefault();
                }
                tei.setTimezoneId(tz.getID());
            }
            switch (period) {
                case NONE: {
                    break;
                }
                case DAILY: {
                    DailyRecurrence dr = new DailyRecurrence();
                    tei.setRecurrence((IRecurrenceInfo)dr);
                    break;
                }
                case WEEKLY: {
                    EnumSet<ExpirationPolicyInterface.DayOfWeek> daysOfTheWeek = expirationPolicy.getDaysOfWeek();
                    if (daysOfTheWeek == null || daysOfTheWeek.isEmpty()) {
                        throw new ServiceException(RB.getStringResource("SPR.noDaysOfWeek.ex.txt"));
                    }
                    WeeklyRecurrence wr = new WeeklyRecurrence();
                    int dayMask = 0;
                    if (daysOfTheWeek.contains((Object)ExpirationPolicyInterface.DayOfWeek.SUNDAY)) {
                        dayMask |= 0x40;
                    }
                    if (daysOfTheWeek.contains((Object)ExpirationPolicyInterface.DayOfWeek.MONDAY)) {
                        dayMask |= 1;
                    }
                    if (daysOfTheWeek.contains((Object)ExpirationPolicyInterface.DayOfWeek.TUESDAY)) {
                        dayMask |= 2;
                    }
                    if (daysOfTheWeek.contains((Object)ExpirationPolicyInterface.DayOfWeek.WEDNESDAY)) {
                        dayMask |= 4;
                    }
                    if (daysOfTheWeek.contains((Object)ExpirationPolicyInterface.DayOfWeek.THURSDAY)) {
                        dayMask |= 8;
                    }
                    if (daysOfTheWeek.contains((Object)ExpirationPolicyInterface.DayOfWeek.FRIDAY)) {
                        dayMask |= 0x10;
                    }
                    if (daysOfTheWeek.contains((Object)ExpirationPolicyInterface.DayOfWeek.SATURDAY)) {
                        dayMask |= 0x20;
                    }
                    wr.setDaysToRun(dayMask);
                    tei.setRecurrence((IRecurrenceInfo)wr);
                    break;
                }
                case MONTHLY: {
                    MonthlyRecurrence mr = new MonthlyRecurrence();
                    if (expirationPolicy.getRecurringDay() != null && expirationPolicy.getRecurringOccurrence() != null) {
                        mr.setRecurringDay(128, 6);
                    } else {
                        mr.setDayOfMonth(expirationPolicy.getDayOfMonth());
                    }
                    tei.setRecurrence((IRecurrenceInfo)mr);
                }
            }
            String xml = period != ExpirationPolicyInterface.Period.NONE ? tei.generateXML() : "";
            p.setDefaultValue(xml);
        }
        catch (MdException e) {
            throw new ServiceException(e.getMessage());
        }
    }

    @Override
    public synchronized Execution2Interface getStoredProcessExecutionInterface() throws ServiceException, RemoteException {
        return this._execution2Interface;
    }

    @Override
    public synchronized void destroyStoredProcessExecutionInterface() throws ServiceException, RemoteException {
        if (this._execution2Interface != null) {
            try {
                this._execution2Interface.destroy();
            }
            catch (IllegalStateException e) {
                this.logMessage(Level.WARN, RB.getStringResource("SPR.cantDestryEI.ex.txt"), _LOGGING_CONTEXT, e);
            }
            catch (ConnectionFactoryException e) {
                throw new ServiceException((Throwable)e);
            }
            finally {
                this._execution2Interface = null;
            }
        }
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        return this.getDefaultLocalizableProperties();
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        this.setDefaultLocalizableProperties(map);
    }

    static class ReportOutputComparator
    implements Comparator<StoredProcessReportOutputInterface> {
        ReportOutputComparator() {
        }

        @Override
        public int compare(StoredProcessReportOutputInterface sproi1, StoredProcessReportOutputInterface sproi2) {
            StoredProcessReportOutput spro1 = (StoredProcessReportOutput)sproi1;
            StoredProcessReportOutput spro2 = (StoredProcessReportOutput)sproi2;
            long d1 = spro1._creationDateLong;
            long d2 = spro2._creationDateLong;
            if (d1 < d2) {
                return 1;
            }
            if (d1 > d2) {
                return -1;
            }
            return 0;
        }
    }
}

