/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.reportdocument;

import com.sas.codepolicy.SASScopeExtension;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.impl.TransformationImpl;
import com.sas.metadata.remote.impl.TransformationImpl_Stub;
import com.sas.publicobjects.reportdocument.ReportDocumentInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.GeneralEntryInterface;
import com.sas.report.repository.OMRReportEntry;
import com.sas.report.repository.RepositoryIOException;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.util.UsageVersion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;

@SASScopeExtension(value="sas")
public abstract class ReportDocumentSmartObject
extends OMRReportEntry
implements GeneralEntryInterface,
ReportDocumentInterface {
    private static final long serialVersionUID = 1L;
    public static UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    static Pattern invalidCharacters = null;

    protected ReportDocumentSmartObject() throws RemoteException {
    }

    protected ReportDocumentSmartObject(Transformation o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected ReportDocumentSmartObject(TransformationImpl o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected ReportDocumentSmartObject(TransformationImpl_Stub o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected ReportDocumentSmartObject(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        if (repos == null || name == null || parent == null) {
            throw new IllegalArgumentException();
        }
        try {
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            Transformation transform = (Transformation)omirepository.createMetadata(name, "Transformation");
            transform.setPublicType(this.getType());
            transform.setTransformRole(this.getType());
            transform.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = transform;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            if (parent != null) {
                try {
                    parent.addItem((MetadataInterface)this);
                }
                catch (ServiceException ex) {
                    this.logThrowable(Level.WARN, ex.getMessage(), this.getClass().toString(), ex);
                }
            }
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, ex.getMessage(), this.getClass().toString(), ex);
        }
    }

    public abstract String getType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getDocumentContent() throws ServiceException, RemoteException {
        byte[] byArray;
        InputStream is = ((EntryInterface)this.newServiceObject()).getInputStream();
        try {
            int b;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            while ((b = is.read()) != -1) {
                buffer.write(b);
            }
            buffer.flush();
            byArray = buffer.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e);
            }
            catch (RepositoryIOException e) {
                throw new ServiceException((Throwable)e);
            }
            catch (SecurityException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    @Override
    public void setDocumentContent(byte[] document) throws ServiceException, RemoteException {
        try (OutputStream os = ((EntryInterface)this.newServiceObject()).getOutputStream();){
            os.write(document);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (RepositoryIOException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public static boolean isValidName(String name) {
        if (invalidCharacters == null) {
            invalidCharacters = Pattern.compile("[\\\\/:\\*\\?\"<>\\|@&#]");
        }
        return !invalidCharacters.matcher(name).matches();
    }
}

