/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.decisionlogic;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.impl.TransformationImpl;
import com.sas.metadata.remote.impl.TransformationImpl_Stub;
import com.sas.publicobjects.decisionlogic.DLTarget;
import com.sas.publicobjects.decisionlogic.DSArtifact;
import com.sas.publicobjects.decisionlogic.DSArtifactType;
import com.sas.publicobjects.decisionlogic.DSDataType;
import com.sas.publicobjects.decisionlogic.DSVariable;
import com.sas.publicobjects.decisionlogic.DecisionLogicInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class DecisionLogic
extends Metadata
implements DecisionLogicInterface {
    private static final String PROP_FLOW_NAME = "Flow.Name";
    private static final String PROP_SET_INPUT_VAR = "Input.Variables";
    private static final String PROP_SET_OUTPUT_VAR = "Output.Variables";
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public DecisionLogic() throws RemoteException {
    }

    public DecisionLogic(Transformation o) throws RemoteException {
        super((Object)o, DecisionLogic.class);
    }

    public DecisionLogic(TransformationImpl o) throws RemoteException {
        super((Object)o, DecisionLogic.class);
    }

    public DecisionLogic(TransformationImpl_Stub o) throws RemoteException {
        super((Object)o, DecisionLogic.class);
    }

    protected DecisionLogic(Transformation o, Class theClass) throws RemoteException {
        super((Object)o, theClass);
    }

    protected DecisionLogic(TransformationImpl o, Class theClass) throws RemoteException {
        super((Object)o, theClass);
    }

    protected DecisionLogic(TransformationImpl_Stub o, Class theClass) throws RemoteException {
        super((Object)o, theClass);
    }

    protected DecisionLogic(Class theClass) throws RemoteException {
        super(theClass);
    }

    public DecisionLogic(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        this(repos, name, parent, DecisionLogic.class);
    }

    protected DecisionLogic(RepositoryInterface repos, String name, FolderInterface parent, Class theClass) throws RemoteException {
        block5: {
            super(theClass);
            if (repos == null || name == null || parent == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                Transformation transformation = (Transformation)omirepository.createMetadata(name, "Transformation");
                transformation.setUsageVersion(CURRENT_VERSION.encode());
                transformation.setPublicType("DecisionLogic");
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = transformation;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem((MetadataInterface)this);
                }
                catch (Exception ex) {
                    transformation.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    public String getType() throws RemoteException {
        return "DecisionLogic";
    }

    public String getName() {
        Transformation transformation = (Transformation)this._repositoryObject;
        try {
            return transformation.getName();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Override
    public Collection<DLTarget> getTargets() throws ServiceException, RemoteException {
        Transformation transformation = (Transformation)this._repositoryObject;
        ArrayList<DLTarget> targets = new ArrayList<DLTarget>();
        try {
            AssociationList targetList = transformation.getSourceCodes();
            for (TextStore target : targetList) {
                targets.add(DLTarget.fromString(target.getName()));
            }
        }
        catch (MdException ex) {
            throw new ServiceException((Throwable)ex, ex.getMessage());
        }
        return targets;
    }

    @Override
    public String getTopFlowName() throws ServiceException, RemoteException {
        return this.getPropertyValue(PROP_FLOW_NAME);
    }

    private void setFlowName(String value) throws ServiceException, RemoteException {
        this.setPropertyValue(PROP_FLOW_NAME, value);
    }

    private String getPropertyValue(String propertyName) throws ServiceException, RemoteException {
        Transformation transformation = (Transformation)this._repositoryObject;
        try {
            AssociationList properties = transformation.getProperties();
            for (Property property : properties) {
                if (!propertyName.equals(property.getName())) continue;
                return property.getDefaultValue();
            }
        }
        catch (MdException ex) {
            throw new ServiceException((Throwable)ex, ex.getMessage());
        }
        return "";
    }

    private void setPropertyValue(String propertyName, String propertyValue) throws ServiceException, RemoteException {
        Transformation transformation = (Transformation)this._repositoryObject;
        try {
            AssociationList properties = transformation.getProperties();
            for (Property property : properties) {
                if (!propertyName.equals(property.getPropertyName())) continue;
                property.setDefaultValue(propertyValue);
                return;
            }
            MdObjectStore store = (MdObjectStore)transformation.getObjectStore();
            MdFactory factory = store.getFactory();
            Property newProperty = (Property)factory.createComplexMetadataObject(store, null, propertyName, "Property", transformation.getRepositoryID());
            newProperty.setPropertyName(propertyName);
            newProperty.setDefaultValue(propertyValue);
            transformation.getProperties().add((Object)newProperty);
        }
        catch (MdException ex) {
            throw new ServiceException((Throwable)ex, ex.getMessage());
        }
    }

    private PropertySet getPropertySet(String propertySetName) throws ServiceException, RemoteException {
        Transformation transformation = (Transformation)this._repositoryObject;
        try {
            AssociationList propertySets = transformation.getPropertySets();
            for (PropertySet propertySet : propertySets) {
                if (!propertySetName.equals(propertySet.getName())) continue;
                return propertySet;
            }
        }
        catch (MdException ex) {
            throw new ServiceException((Throwable)ex, ex.getMessage());
        }
        return null;
    }

    private Collection<DSVariable> getVariables(String propertySetName) throws ServiceException, RemoteException {
        ArrayList<DSVariable> retVal = new ArrayList<DSVariable>();
        PropertySet propSet = this.getPropertySet(propertySetName);
        if (propSet != null) {
            try {
                AssociationList properties = propSet.getProperties();
                for (Property property : properties) {
                    DSVariable var = new DSVariable(property.getPropertyName(), property.getPropertyRole(), property.getDefaultValue(), DSDataType.fromSQLType(property.getSQLType()));
                    retVal.add(var);
                }
            }
            catch (MdException ex) {
                throw new ServiceException((Throwable)ex, ex.getMessage());
            }
        }
        return retVal;
    }

    private void setArtifacts(Collection<DSArtifact> artifacts) throws ServiceException, RemoteException {
        Transformation transformation = (Transformation)this._repositoryObject;
        try {
            AssociationList notes = new ArrayList(transformation.getNotes());
            for (TextStore note : notes) {
                note.delete();
            }
            notes = transformation.getNotes();
            PropertySet flows = this.getClearedPropertySet(DSArtifactType.FLOW.toString());
            PropertySet events = this.getClearedPropertySet(DSArtifactType.EVENT.toString());
            PropertySet activities = this.getClearedPropertySet(DSArtifactType.ACTIVITY.toString());
            PropertySet resources = this.getClearedPropertySet(DSArtifactType.RESOURCE.toString());
            PropertySet variables = this.getClearedPropertySet(DSArtifactType.VARIABLE.toString());
            MdObjectStore store = (MdObjectStore)transformation.getObjectStore();
            MdFactory factory = store.getFactory();
            int artifactCount = 0;
            for (DSArtifact artifact : artifacts) {
                AssociationList properties;
                if (artifact.type() == DSArtifactType.FLOW) {
                    properties = flows.getProperties();
                } else if (artifact.type() == DSArtifactType.EVENT) {
                    properties = events.getProperties();
                } else if (artifact.type() == DSArtifactType.ACTIVITY) {
                    properties = activities.getProperties();
                } else if (artifact.type() == DSArtifactType.RESOURCE) {
                    properties = resources.getProperties();
                } else {
                    if (artifact.type() != DSArtifactType.VARIABLE) continue;
                    properties = variables.getProperties();
                }
                Property property = (Property)factory.createComplexMetadataObject(store, null, "Artifact" + artifactCount, "Property", transformation.getRepositoryID());
                property.setPropertyName(artifact.name());
                properties.add(property);
                TextStore note = (TextStore)factory.createComplexMetadataObject(store, null, "Artifact" + artifactCount, "TextStore", transformation.getRepositoryID());
                note.setStoredText(artifact.xml());
                note.setTextRole("Artifact");
                note.setTextType("XML");
                notes.add(note);
                ++artifactCount;
            }
        }
        catch (MdException ex) {
            throw new ServiceException((Throwable)ex, ex.getMessage());
        }
    }

    private PropertySet getClearedPropertySet(String propertySetName) throws ServiceException, RemoteException {
        PropertySet propSet = this.getPropertySet(propertySetName);
        if (propSet == null) {
            Transformation transformation = (Transformation)this._repositoryObject;
            MdObjectStore store = (MdObjectStore)transformation.getObjectStore();
            MdFactory factory = store.getFactory();
            propSet = (PropertySet)factory.createComplexMetadataObject(store, null, propertySetName, "PropertySet", transformation.getRepositoryID());
            propSet.setOwningObject((Root)transformation);
        } else {
            try {
                ArrayList properties = new ArrayList(propSet.getProperties());
                for (Property property : properties) {
                    property.delete();
                }
            }
            catch (MdException ex) {
                throw new ServiceException((Throwable)ex, ex.getMessage());
            }
        }
        return propSet;
    }

    private void setVariables(String propertySetName, Collection<DSVariable> variables) throws ServiceException, RemoteException {
        Transformation transformation = (Transformation)this._repositoryObject;
        PropertySet propSet = this.getClearedPropertySet(propertySetName);
        try {
            MdObjectStore store = (MdObjectStore)propSet.getObjectStore();
            MdFactory factory = store.getFactory();
            AssociationList properties = propSet.getProperties();
            int varCount = 0;
            for (DSVariable var : variables) {
                Property property = (Property)factory.createComplexMetadataObject(store, null, "Variable" + varCount++, "Property", transformation.getRepositoryID());
                property.setPropertyName(var.name());
                property.setPropertyRole(var.displayName());
                property.setDefaultValue(var.description());
                property.setSQLType(var.type().getSQLType());
                properties.add(property);
            }
        }
        catch (MdException ex) {
            throw new ServiceException((Throwable)ex, ex.getMessage());
        }
    }

    @Override
    public String getCode(DLTarget target) throws RemoteException, ServiceException {
        Transformation transformation = (Transformation)this._repositoryObject;
        String code = null;
        try {
            AssociationList targetList = transformation.getSourceCodes();
            for (TextStore textStore : targetList) {
                if (!textStore.getName().equals(target.getName())) continue;
                code = textStore.getStoredText();
            }
        }
        catch (MdException ex) {
            throw new ServiceException((Throwable)ex, ex.getMessage());
        }
        return code;
    }

    private void setSourceCode(HashMap<DLTarget, String> targetCode) throws RemoteException, ServiceException {
        Transformation transformation = (Transformation)this._repositoryObject;
        MdObjectStore store = (MdObjectStore)transformation.getObjectStore();
        MdFactory factory = store.getFactory();
        try {
            AssociationList targetList = new ArrayList(transformation.getSourceCodes());
            for (TextStore textStore : targetList) {
                textStore.delete();
            }
            targetList = transformation.getSourceCodes();
            for (DLTarget dLTarget : targetCode.keySet()) {
                TextStore sourceCode = (TextStore)factory.createComplexMetadataObject(store, null, dLTarget.getName(), "TextStore", transformation.getRepositoryID());
                sourceCode.setTextRole("SourceCode");
                sourceCode.setTextType("DS2");
                sourceCode.setStoredText(targetCode.get((Object)dLTarget));
                targetList.add(sourceCode);
            }
        }
        catch (MdException ex) {
            throw new ServiceException((Throwable)ex, ex.getMessage());
        }
    }

    @Override
    public Collection<DSVariable> getInputVariables() throws ServiceException, RemoteException {
        return this.getVariables(PROP_SET_INPUT_VAR);
    }

    @Override
    public Collection<DSVariable> getOutputVariables() throws ServiceException, RemoteException {
        return this.getVariables(PROP_SET_OUTPUT_VAR);
    }

    @Override
    public Collection<DSVariable> getStatsVariables() throws ServiceException, RemoteException {
        ArrayList<DSVariable> retVal = new ArrayList<DSVariable>();
        DSVariable var = new DSVariable("batch_job_id", "batch_job_id", "", DSDataType.STRING);
        retVal.add(var);
        var = new DSVariable("flow_node_nm", "flow_node_nm", "", DSDataType.STRING);
        retVal.add(var);
        var = new DSVariable("hits_cnt", "hits_cnt", "", DSDataType.INTEGER);
        retVal.add(var);
        var = new DSVariable("timestamp_dttm", "timestamp_dttm", "", DSDataType.DATETIME);
        retVal.add(var);
        return retVal;
    }

    @Override
    public Collection<String> getArtifactXML() throws ServiceException, RemoteException {
        return this.getArtifactXML(null);
    }

    private Collection<String> getArtifactNames(String propertySetName) throws ServiceException, RemoteException {
        ArrayList<String> names = new ArrayList<String>();
        try {
            PropertySet propertySet = this.getPropertySet(propertySetName);
            AssociationList properties = propertySet.getProperties();
            for (Property property : properties) {
                names.add(property.getPropertyName());
            }
        }
        catch (MdException ex) {
            throw new ServiceException((Throwable)ex, ex.getMessage());
        }
        return names;
    }

    private Collection<String> getArtifactXML(String propertySetName) throws ServiceException, RemoteException {
        ArrayList<String> artifactXML = new ArrayList<String>();
        Transformation transformation = (Transformation)this._repositoryObject;
        try {
            AssociationList notes = transformation.getNotes();
            if (propertySetName != null) {
                HashSet<String> artifactToReturn = new HashSet<String>();
                PropertySet propertySet = this.getPropertySet(propertySetName);
                AssociationList properties = propertySet.getProperties();
                for (Property property : properties) {
                    artifactToReturn.add(property.getName());
                }
                for (TextStore note : notes) {
                    if (!artifactToReturn.contains(note.getName())) continue;
                    artifactXML.add(note.getStoredText());
                }
            } else {
                for (TextStore note : notes) {
                    artifactXML.add(note.getStoredText());
                }
            }
        }
        catch (MdException ex) {
            throw new ServiceException((Throwable)ex, ex.getMessage());
        }
        return artifactXML;
    }

    @Override
    public Collection<String> getFlowNames() throws ServiceException, RemoteException {
        return this.getArtifactNames(DSArtifactType.FLOW.name());
    }

    @Override
    public Collection<String> getFlowArtifactXML() throws ServiceException, RemoteException {
        return this.getArtifactXML(DSArtifactType.FLOW.name());
    }

    @Override
    public Collection<String> getActivityNames() throws ServiceException, RemoteException {
        return this.getArtifactNames(DSArtifactType.ACTIVITY.name());
    }

    @Override
    public Collection<String> getActivityArtifactXML() throws ServiceException, RemoteException {
        return this.getArtifactXML(DSArtifactType.ACTIVITY.name());
    }

    @Override
    public Collection<String> getEventNames() throws ServiceException, RemoteException {
        return this.getArtifactNames(DSArtifactType.EVENT.name());
    }

    @Override
    public Collection<String> getEventArtifactXML() throws ServiceException, RemoteException {
        return this.getArtifactXML(DSArtifactType.EVENT.name());
    }

    @Override
    public Collection<String> getGloablVariableNames() throws ServiceException, RemoteException {
        return this.getArtifactNames(DSArtifactType.VARIABLE.name());
    }

    @Override
    public Collection<String> getGlobalVariableArtifactXML() throws ServiceException, RemoteException {
        return this.getArtifactXML(DSArtifactType.VARIABLE.name());
    }

    @Override
    public Collection<String> getResourceNames() throws ServiceException, RemoteException {
        return this.getArtifactNames(DSArtifactType.RESOURCE.name());
    }

    @Override
    public Collection<String> getResourceArtifactXML() throws ServiceException, RemoteException {
        return this.getArtifactXML(DSArtifactType.RESOURCE.name());
    }

    @Override
    public void publish(String flowName, String description, Collection<DSArtifact> artifacts, HashMap<DLTarget, String> targetCode, Collection<DSVariable> inputVariables, Collection<DSVariable> outputVariables) throws ServiceException, RemoteException {
        this.setDescription(description);
        this.setFlowName(flowName);
        this.setArtifacts(artifacts);
        this.setVariables(PROP_SET_INPUT_VAR, inputVariables);
        this.setVariables(PROP_SET_OUTPUT_VAR, outputVariables);
        this.setSourceCode(targetCode);
        this.update();
    }
}

