/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.decisionlogic;

public enum DSDataType {
    INTEGER("INTEGER", 4),
    FLOAT("FLOAT", 8),
    STRING("STRING", 12),
    DATAGRID("DATAGRID", -1),
    BOOLEAN("BOOLEAN", 16),
    DATETIME("DATETIME", 93);

    private final String _name;
    private final int _sqlType;

    private DSDataType(String name, int sqlType) {
        this._name = name;
        this._sqlType = sqlType;
    }

    public String getName() {
        return this._name;
    }

    public int getSQLType() {
        return this._sqlType;
    }

    public static DSDataType fromString(String name) {
        for (DSDataType dt : DSDataType.values()) {
            if (!dt._name.equalsIgnoreCase(name)) continue;
            return dt;
        }
        throw new IllegalArgumentException(name);
    }

    public static DSDataType fromSQLType(int sqlType) {
        for (DSDataType dt : DSDataType.values()) {
            if (dt._sqlType != sqlType) continue;
            return dt;
        }
        throw new IllegalArgumentException("" + sqlType);
    }
}

