/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.impl;

import com.sas.metadata.AssociationList;
import com.sas.metadata.CMetadata;
import com.sas.metadata.MapPool;
import com.sas.metadata.MdEvent;
import com.sas.metadata.MdException;
import com.sas.metadata.MdObjectBaseXML;
import com.sas.metadata.MdObjectFactory;
import com.sas.metadata.MdObjectStore;
import com.sas.metadata.MdStore;
import com.sas.metadata.MetadataUtil;
import com.sas.metadata.impl.MdObjectBaseUtilImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;

public class MdObjectBaseXMLImpl
extends MdObjectBaseUtilImpl
implements MdObjectBaseXML {
    public MdObjectBaseXMLImpl() {
    }

    public MdObjectBaseXMLImpl(String strName) {
        super(strName);
    }

    public MdObjectBaseXMLImpl(String strName, String strFQID) {
        super(strName, strFQID);
    }

    public MdObjectBaseXMLImpl(String strName, String strFQID, String strType) {
        super(strName, strFQID, strType);
    }

    public MdObjectBaseXMLImpl(String strType, NamedNodeMap childNodeMap) {
        super(strType, childNodeMap);
    }

    @Override
    public String getUpdateSimpleSubstring() {
        return this.getUpdateSimpleSubstring((CMetadata)((Object)this));
    }

    protected boolean fCheckUpdateSimpleXML() {
        Map<String, String> attrs = ((CMetadata)((Object)this)).getUpdatedAttrs();
        try {
            boolean bl = attrs.size() > 0;
            return bl;
        }
        finally {
            MapPool.instance();
            MapPool.returnMap(attrs);
            attrs = null;
        }
    }

    @Override
    public String createUpdateSimpleXML() {
        String simple = this.getUpdateSimpleSubstring((CMetadata)((Object)this));
        StringBuffer outXML = new StringBuffer(simple.length() + this.m_strType.length() + this.m_strFQID.length() + 9);
        outXML.append("<");
        outXML.append(this.m_strType);
        outXML.append(" Id=\"");
        outXML.append(this.m_strFQID);
        outXML.append("\" ");
        outXML.append(simple);
        outXML.append(">");
        return outXML.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUpdateSimpleSubstring(CMetadata inObject) {
        Map<String, String> attrs = inObject.getUpdatedAttrs();
        try {
            String string = MetadataUtil.createObjectAttributeString(attrs);
            return string;
        }
        finally {
            MapPool.instance();
            MapPool.returnMap(attrs);
            attrs = null;
        }
    }

    @Override
    public String createEmptyXML() {
        StringBuffer outXML = new StringBuffer(this.m_strType.length() * 2 + this.m_strFQID.length() + 13);
        outXML.append("<");
        outXML.append(this.m_strType);
        outXML.append(" Id=\"");
        outXML.append(this.m_strFQID);
        outXML.append("\" ></");
        outXML.append(this.m_strType);
        outXML.append(">");
        return outXML.toString();
    }

    @Override
    public String createObjectXML(CMetadata inObject) {
        return this.createObjectXML(inObject, false);
    }

    @Override
    public String createObjectXML(CMetadata inObject, boolean includeEmptyAssocs) {
        Map<String, String> attributes = inObject.getAttrs();
        Map<String, AssociationList> associations = inObject.getAssocs();
        Vector<String> inAttr = new Vector<String>(attributes.size());
        Vector<String> inValue = new Vector<String>(attributes.size());
        for (String attributeName : attributes.keySet()) {
            inAttr.add(attributeName);
            inValue.add(attributes.get(attributeName));
        }
        StringBuffer outXML = new StringBuffer("<");
        outXML.append(this.m_strType);
        outXML.append(" ");
        outXML.append(MetadataUtil.createXMLSubString(inAttr, inValue));
        outXML.append(">");
        for (String associationName : associations.keySet()) {
            AssociationList associationValue = associations.get(associationName);
            if (associationValue != null) {
                outXML.append(associationValue.generateAssociationAllXML(inObject.isAssociationRequired(associationName), inObject.getId()));
                continue;
            }
            if (!includeEmptyAssocs) continue;
            outXML.append("<");
            outXML.append(associationName);
            outXML.append("/>");
        }
        outXML.append("</");
        outXML.append(inObject.getCMetadataType());
        outXML.append(">");
        MapPool.instance();
        MapPool.returnMap(associations);
        MapPool.instance();
        MapPool.returnMap(attributes);
        return outXML.toString();
    }

    @Override
    public String createObjectRefreshXML(CMetadata inObject, boolean includeLocallyChangedItems, boolean getFullObjectUpdate) {
        Map<String, String> attributes = inObject.getAttrs();
        Map<String, AssociationList> associations = inObject.getAssocs();
        Vector<String> inAttr = new Vector<String>(attributes.size());
        Vector<String> inValue = new Vector<String>(attributes.size());
        inAttr.add("Id");
        inValue.add(inObject.getId());
        attributes.remove("Id");
        if (!getFullObjectUpdate) {
            for (String attributeName : attributes.keySet()) {
                inAttr.add(attributeName);
                inValue.add("");
            }
        }
        StringBuffer outXML = new StringBuffer("<");
        outXML.append(this.m_strType);
        outXML.append(" ");
        outXML.append(MetadataUtil.createXMLSubString(inAttr, inValue));
        outXML.append(">");
        for (String associationName : associations.keySet()) {
            int associationState;
            AssociationList associationValue = associations.get(associationName);
            if (associationValue == null || ((associationState = associationValue.getState()) & 0x20) > 0 || (associationState & 0x40) > 0 || getFullObjectUpdate) continue;
            outXML.append("<");
            outXML.append(associationName);
            outXML.append("/>");
        }
        outXML.append("</");
        outXML.append(inObject.getCMetadataType());
        outXML.append(">");
        MapPool.instance();
        MapPool.returnMap(associations);
        MapPool.instance();
        MapPool.returnMap(attributes);
        return outXML.toString();
    }

    @Override
    public String closeUpdateMetadataXML(String outXML, String strTagToClose) {
        StringBuffer tempXML = new StringBuffer("");
        if (outXML != null && outXML.length() > 0) {
            tempXML.append("</");
            tempXML.append(strTagToClose);
            tempXML.append(">");
        }
        return tempXML.toString();
    }

    @Override
    public String createUpdateAssociationXML() throws MdException {
        return this.createUpdateAssociationXML((CMetadata)((Object)this), null);
    }

    @Override
    public String createUpdateAssociationXML(CMetadata inObject, StringBuffer outXML) throws MdException {
        if (outXML == null) {
            outXML = new StringBuffer();
        }
        Map<String, AssociationList> assns = inObject.getAssocsWA();
        String Id = inObject.getId();
        boolean isNewObject = Id.indexOf(36) > -1;
        for (String association_name : assns.keySet()) {
            boolean required = inObject.isAssociationRequired(association_name);
            AssociationList association_value = assns.get(association_name);
            if (!(isNewObject && required || isNewObject && association_value != null) && (isNewObject || association_value == null || (association_value.getState() & 1) > 0 && (association_value.getState() & 0) > 0)) continue;
            if (association_value == null) {
                association_value = inObject.getAssociatedObjects(association_name);
                association_value.setParent(inObject);
            }
            outXML.append(association_value.generateAssociationWriteXML(required, Id));
        }
        MapPool.instance();
        MapPool.returnMap(assns);
        assns = null;
        return outXML.toString();
    }

    @Override
    public String doCreateUpdateXML(CMetadata object) throws MdException {
        StringBuffer outXML = new StringBuffer();
        outXML.append(object.createUpdateSimpleXML());
        this.createUpdateAssociationXML(object, outXML);
        if (outXML.length() > 0) {
            outXML.append("</");
            outXML.append(object.getCMetadataType());
            outXML.append(">");
        }
        int emptyUpdateLength = object.getCMetadataType().length() * 2 + object.getId().length() + 12;
        if (outXML.length() <= emptyUpdateLength) {
            return "";
        }
        return outXML.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateMetadataAll() throws MdException {
        if (this.m_OwningStore.getStoreType() != 1) throw new MdException(MdObjectFactory.getBundle().getString("MdObjectBaseXML.NoUpdateServerStore.txt"));
        MdStore grandparentStore = this.m_OwningStore.getOwningStore();
        if (grandparentStore == null) throw new MdException(MdObjectFactory.getBundle().getString("MdObjectBaseXML.grandParentEmpty.txt"));
        if (grandparentStore.getStoreType() == 1) {
            ((MdObjectStore)this.m_OwningStore).flushUpdatesToParentStore();
            return;
        }
        if (grandparentStore.getStoreType() == 0) {
            // empty if block
        }
        if (((MdObjectStore)this.m_OwningStore).is_write_lock()) {
            while (!((MdObjectStore)this.m_OwningStore).is_write_lock()) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e1) {
                    throw new MdException(e1);
                }
            }
        }
        ((MdObjectStore)this.m_OwningStore).set_write_lock(true);
        try {
            StringBuffer requestBuffer = new StringBuffer();
            List deleteList = this.createDeleteRequest(requestBuffer);
            List changedItems = this.createUpdateRequest(requestBuffer, deleteList);
            if (requestBuffer.length() <= 0) return;
            boolean updateIDs = changedItems != null && changedItems.size() > 0;
            MetadataUtil.DoRequestNoReturn(requestBuffer.toString(), updateIDs);
            if (deleteList != null) {
                ((MdObjectStore)this.m_OwningStore).getDeletedObjects().clear();
            }
            ArrayList changes = new ArrayList(this.getChangeList());
            this.getObjectStore().resetStates(changes);
            this.fireMdObjectModified(new MdEvent(this, this.getObjectStore()));
            if (changedItems != null) {
                int length = changedItems.size();
                for (int i = 0; i < length; ++i) {
                    CMetadata cObject = (CMetadata)changedItems.get(i);
                    if (cObject == this) continue;
                    cObject.fireMdObjectModified(new MdEvent(cObject, this.getObjectStore()));
                }
            }
            this.getObjectStore().flushUpdates(changes);
            this.clearChangeList();
            return;
        }
        catch (MdException e) {
            throw e;
        }
        finally {
            ((MdObjectStore)this.m_OwningStore).set_write_lock(false);
            ((MdObjectStore)this.getObjectStore()).clearWriteBuffer();
        }
    }

    private List createUpdateRequest(StringBuffer requestBuffer, List deleteList) throws MdException {
        if (this.m_strFQID.indexOf(36) <= -1 && this.getChangeList().size() == 0 && !this.fCheckUpdateSimpleXML() && (this.objectState & 1) <= 0) {
            return null;
        }
        ArrayList<CMetadata> changedItems = new ArrayList<CMetadata>(10);
        Vector changeList = this.getChangeList();
        if (changeList.contains(this)) {
            int oldIndex = changeList.indexOf(this);
            if (oldIndex != 0) {
                changeList.remove(oldIndex);
                changeList.add(0, this);
            }
        } else {
            CMetadata thisObject = ((MdObjectStore)this.m_OwningStore).getObject(this.getId(), false);
            if (thisObject != null) {
                changeList.add(0, this);
            }
        }
        StringBuffer updateBuffer = new StringBuffer("<UpdateMetadata><Metadata>");
        int writebeforelength = updateBuffer.length();
        int changeListSize = changeList.size();
        if (changeListSize > 0) {
            for (int i = 0; i < changeListSize; ++i) {
                CMetadata object = (CMetadata)changeList.elementAt(i);
                int objectState = object.getState();
                if ((objectState & 2) > 0 || (objectState & 0) > 0 || deleteList != null && deleteList.contains(object.getId())) continue;
                updateBuffer.append(this.doCreateUpdateXML(object));
                changedItems.add(object);
            }
        } else {
            return null;
        }
        String appendBuff = ((MdObjectStore)this.getObjectStore()).getWriteBuffer();
        updateBuffer.append(appendBuff);
        if (writebeforelength == updateBuffer.length()) {
            return null;
        }
        updateBuffer.append("</Metadata><NS>");
        updateBuffer.append(MetadataUtil.getNamespace());
        updateBuffer.append("</NS><Flags>");
        updateBuffer.append(402654208);
        updateBuffer.append("</Flags><Options/></UpdateMetadata>");
        boolean delete = requestBuffer.length() > 0;
        requestBuffer.append(updateBuffer);
        if (delete) {
            requestBuffer.insert(0, "<Multiple_Requests>");
            requestBuffer.append("</Multiple_Requests>");
        }
        return changedItems;
    }

    private List createDeleteRequest(StringBuffer requestBuffer) throws MdException {
        Map deletedObjects = ((MdObjectStore)this.m_OwningStore).getDeletedObjects();
        if (deletedObjects == null || deletedObjects.size() == 0) {
            return null;
        }
        ArrayList<String> deleteList = new ArrayList<String>(deletedObjects.size());
        for (String id : deletedObjects.keySet()) {
            CMetadata meta = (CMetadata)deletedObjects.get(id);
            if (meta.isNewObject()) {
                MdObjectFactory.deleteMetadataObject(meta);
                continue;
            }
            deleteList.add(id);
            requestBuffer.append("<");
            requestBuffer.append(meta.getCMetadataType());
            requestBuffer.append(" Id=\"");
            requestBuffer.append(meta.getFQID());
            requestBuffer.append("\"/>");
        }
        if (deleteList.size() > 0) {
            int flags = 402654208;
            requestBuffer.insert(0, "<DeleteMetadata><Metadata>");
            requestBuffer.append("</Metadata><NS>");
            requestBuffer.append(MetadataUtil.getNamespace());
            requestBuffer.append("</NS><Flags>");
            requestBuffer.append(flags);
            requestBuffer.append("</Flags><Options/>");
            requestBuffer.append("</DeleteMetadata>");
        }
        return deleteList;
    }
}

