/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.entities;

import com.sas.entities.AttributeDescriptor;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroup;
import com.sas.entities.AttributeGroupInterface;
import com.sas.entities.AttributeType;
import com.sas.entities.AttributeTypeInterface;
import com.sas.entities.BaseAttributeDescriptorInterface;
import com.sas.entities.Entity;
import com.sas.entities.RemoteEntityInterface;
import com.sas.metadata.AssociationList;
import com.sas.metadata.CMetadata;
import com.sas.metadata.ExternalIdentity;
import com.sas.metadata.Group;
import com.sas.metadata.MdException;
import com.sas.metadata.MdObjectFactory;
import com.sas.metadata.MdObjectStore;
import com.sas.metadata.MdStore;
import com.sas.metadata.MetadataUtil;
import com.sas.metadata.Property;
import com.sas.metadata.PropertyGroup;
import com.sas.metadata.PropertySet;
import com.sas.metadata.PropertyType;
import com.sas.metadata.Root;
import com.sas.metadata.SoftwareComponent;
import com.sas.metadata.TextStore;
import com.sas.metadata.Util;
import java.rmi.RemoteException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MdOMAEntityUtility {
    public static final String EntityAllGetTemplate = "<TEMPLATES>   <Property Id=\"\" Name=\"\">      <ExternalIdentities/>      <UsingPrototype/>      <Customizers/>      <PrimaryPropertyGroup/>      <OwningType/>      <Properties/>      <LocalizedAttributes/>      <StoredConfiguration/>      <Editors/>      <Resources/>      <Properties/>      <Validators/>   </Property>   <PropertyGroup>      <SubPropertyGroups/>      <Customizers/>      <Notes/>      <Properties/>      <PropertySets/>   </PropertyGroup>   <PropertySet>      <SetProperties/>   </PropertySet>   <PropertyType>      <Validators/>      <StoredConfiguration/>      <Properties/>      <Customizers/>   </PropertyType></TEMPLATES>";
    public static final String EntityStoreAllDeleteTemplate = "<TEMPLATES>   <Property Id=\"\" Name=\"\">      <ExternalIdentities/>      <UsingPrototype/>      <Customizers/>      <PrimaryPropertyGroup/>      <OwningType/>      <Properties/>      <LocalizedAttributes/>      <StoredConfiguration/>      <Editors/>      <Resources/>      <Properties/>   </Property>   <PropertyGroup>      <SubPropertyGroups/>      <Customizers/>      <Notes/>      <Properties/>      <PropertySets/>   </PropertyGroup>   <PropertySet>      <SetProperties/>   </PropertySet>   <PropertyType>      <Validators/>      <StoredConfiguration/>      <Properties/>      <Customizers/>   </PropertyType></TEMPLATES>";
    public static final String EntityStoreAllDeleteTemplate2 = "<TEMPLATES>   <Property Id=\"\" Name=\"\">      <ExternalIdentities/>      <UsingPrototype/>      <Customizers/>      <PrimaryPropertyGroup>      <SubPropertyGroups/>      <Customizers/>      <Notes/>      <Properties/>      <PropertySets>      <SetProperties>      <ExternalIdentities/>      <UsingPrototype/>      <Customizers/>      <PrimaryPropertyGroup>      <SubPropertyGroups/>      <Customizers/>      <Notes/>      <Properties/>      <PropertySets>      <SetProperties/>      </PropertySets>      </PrimaryPropertyGroup>      <OwningType>      <Validators/>      <StoredConfiguration/>      <Properties/>      <Customizers/>      </OwningType>      <Properties/>      <LocalizedAttributes/>      <StoredConfiguration/>      <Editors/>      <Resources/>      </SetProperties>      </PropertySets>      </PrimaryPropertyGroup>      <OwningType>      <Validators/>      <StoredConfiguration/>      <Properties/>      <Customizers/>      </OwningType>      <Properties/>      <LocalizedAttributes/>      <StoredConfiguration/>      <Editors/>      <Resources/>      <Properties/>   </Property></TEMPLATES>";
    public static final String AttributeDescriptorGetTemplate = "<TEMPLATES>   <Property Id=\"\" Name=\"\">      <ExternalIdentities/>      <UsingPrototype/>      <Customizers/>      <PrimaryPropertyGroup/>      <OwningType/>      <Properties/>      <LocalizedAttributes/>      <StoredConfiguration/>      <Editors/>      <Resources/>      <Properties/>      <StoredConfiguration/>      <Validators/>   </Property></TEMPLATES>";
    public static final String AttributeGroupGetTemplate = "<TEMPLATES>   <PropertyGroup>      <SubPropertyGroups/>      <Customizers/>      <Notes/>      <Properties/>      <PropertySets/>   </PropertyGroup>   <PropertySet>      <SetProperties/>   </PropertySet></TEMPLATES>";
    public static final String AttributeTypeGetTemplate = "<TEMPLATES>   <PropertyType>      <Validators/>      <StoredConfiguration/>      <Properties/>      <Customizers/>   </PropertyType></TEMPLATES>";
    public static final String EntityObjectGetTemplate = "<TEMPLATES>   <Property Id=\"\" Name=\"\">      <ExternalIdentities/>      <UsingPrototype/>      <Customizers/>      <PrimaryPropertyGroup/>      <OwningType/>      <Properties/>      <LocalizedAttributes/>      <StoredConfiguration/>      <Editors/>      <Resources/>      <Properties/>   </Property></TEMPLATES>";
    private static final Map propertyTypeMap = new HashMap(10);
    private static boolean _getAllObjects = false;
    private static final String GENERIC_STRING = "GenericString";
    private static Map ENTITY_PROPTYPES_MAP = new HashMap(9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populateEntityFromOMRObject(RemoteEntityInterface entity, Root omrObject) throws MdException {
        AssociationList props = omrObject.getProperties();
        Property propObject = null;
        for (Property propObject2 : props) {
            if (!propObject2.getDefaultValue().equals("com.sas.entities.RemoteEntityInterface")) continue;
            propObject = propObject2;
            break;
        }
        if (propObject != null) {
            try {
                _getAllObjects = true;
                MdOMAEntityUtility.populateEntityFromOMRProperty(entity, propObject);
            }
            finally {
                _getAllObjects = false;
            }
        }
    }

    public static void populateEntityFromOMRProperty(RemoteEntityInterface entity, Property propObject) throws MdException {
        try {
            PropertyGroup OMRGroup;
            Object softComp;
            AssociationList customizers;
            propObject = (Property)MetadataUtil.getMetadataAllDepths(propObject, null, null, EntityObjectGetTemplate, 268, true);
            if (entity == null) {
                entity = new Entity();
            }
            if ((customizers = propObject.getCustomizers()).size() > 0 && (softComp = customizers.get(0)) instanceof SoftwareComponent) {
                MdOMAEntityUtility.setEntityCustomizerFromOMRSoftwareComponent(entity, (SoftwareComponent)softComp);
            }
            AssociationList extIdents = propObject.getExternalIdentities();
            for (ExternalIdentity ident : extIdents) {
                if (!ident.getContext().equals("EntityKeyInterface")) continue;
                entity.setEntityKey(ident.getIdentifier());
            }
            Property entityPrototype = (Property)propObject.getUsingPrototype();
            if (entityPrototype != null) {
                Entity entityPrototypeObject = new Entity();
                entity.setPrototype((RemoteEntityInterface)entityPrototypeObject);
                MdOMAEntityUtility.populateEntityFromOMRProperty((RemoteEntityInterface)entityPrototypeObject, entityPrototype);
            }
            if ((OMRGroup = propObject.getPrimaryPropertyGroup()) != null) {
                AttributeGroupInterface primarygroup = entity.getAttributeGroup();
                MdOMAEntityUtility.populateEntityGroupfromOMRGroup(primarygroup, OMRGroup, true);
            }
        }
        catch (Exception ex) {
            throw new MdException(ex);
        }
    }

    public static void populateEntityGroupfromOMRGroup(AttributeGroupInterface group, PropertyGroup omrGroup) throws MdException {
        MdOMAEntityUtility.populateEntityGroupfromOMRGroup(group, omrGroup, true);
    }

    protected static void populateEntityGroupfromOMRGroup(AttributeGroupInterface group, PropertyGroup omrGroup, boolean goToServer) throws MdException {
        if (omrGroup == null) {
            return;
        }
        if (goToServer) {
            String template;
            int flags = 268;
            if (_getAllObjects) {
                Util.printOutputln("DEBUG NOTE: Going to server to get all entity related objects.");
                template = EntityAllGetTemplate;
                flags |= 0x80000;
            } else {
                template = AttributeGroupGetTemplate;
            }
            omrGroup = (PropertyGroup)MetadataUtil.getMetadataAllDepths(omrGroup, null, null, template, flags, false);
        }
        group.setDescription(Locale.getDefault(), omrGroup.getDesc());
        group.setName(omrGroup.getName());
        int visible = omrGroup.getIsVisible();
        if (visible == 0) {
            group.setVisible(false);
        } else {
            group.setVisible(true);
        }
        boolean f_Modifiable = false;
        boolean f_Expert = false;
        AssociationList props = omrGroup.getProperties();
        boolean b_labelPopulated = false;
        for (Property propAttr : props) {
            if (propAttr.getName().equals("Modifiable")) {
                f_Modifiable = true;
                if (propAttr.getDefaultValue().equals("0")) {
                    group.setModifiable(false);
                    continue;
                }
                group.setModifiable(true);
                continue;
            }
            if (propAttr.getName().equals("Expert")) {
                f_Expert = true;
                if (propAttr.getDefaultValue().equals("0")) {
                    group.setExpert(false);
                    continue;
                }
                group.setExpert(true);
                continue;
            }
            if (propAttr.getName().equals("Label")) {
                b_labelPopulated = true;
                group.setLabel(Locale.getDefault(), propAttr.getDefaultValue());
                continue;
            }
            if (propAttr.getName().equals("LargeIconURL")) {
                group.setLargeIconURL(Locale.getDefault(), propAttr.getDefaultValue());
                continue;
            }
            if (!propAttr.getName().equals("SmallIconURL")) continue;
            group.setSmallIconURL(Locale.getDefault(), propAttr.getDefaultValue());
        }
        if (!b_labelPopulated) {
            group.setLabel(Locale.getDefault(), omrGroup.getName());
        }
        if (!f_Modifiable) {
            group.setModifiable(true);
        }
        if (!f_Expert) {
            group.setExpert(false);
        }
        AssociationList notes = omrGroup.getNotes();
        Object configText = null;
        Iterator iter = notes.iterator();
        while (iter.hasNext() && configText == null) {
            TextStore note = (TextStore)iter.next();
            if (!note.getTextRole().equals("ConfigurationXML")) continue;
            group.setConfigurationXML(note.getStoredText());
        }
        AssociationList customizers = omrGroup.getCustomizers();
        for (SoftwareComponent sc : customizers) {
            if (sc == null) continue;
            group.setCustomizer(sc.getProductIdentifier(), sc.getClassIdentifier());
        }
        AssociationList sets = omrGroup.getPropertySets();
        PropertySet entitySet = null;
        for (PropertySet entPropSet : sets) {
            if (entPropSet == null || !entPropSet.getSetRole().equals("com.sas.entities.AttributeGroupInterface")) continue;
            entitySet = entPropSet;
            break;
        }
        if (entitySet != null) {
            AssociationList attrDescriptors = entitySet.getSetProperties();
            int i = 0;
            for (Property attrDescProp : attrDescriptors) {
                AttributeDescriptor attrdesc = new AttributeDescriptor();
                MdOMAEntityUtility.populateEntityAttributeDescriptorfromOMRProperty((AttributeDescriptorInterface)attrdesc, attrDescProp, false);
                group.addAttributeDescriptor((AttributeDescriptorInterface)attrdesc, i++);
            }
        }
        AssociationList subGroups = omrGroup.getSubpropertyGroups();
        int i = 0;
        for (PropertyGroup propGroup : subGroups) {
            AttributeGroup attrGroup = new AttributeGroup();
            group.addAttributeGroup((AttributeGroupInterface)attrGroup, i++);
            MdOMAEntityUtility.populateEntityGroupfromOMRGroup((AttributeGroupInterface)attrGroup, propGroup, false);
        }
    }

    public static void populateEntityAttributeDescriptorfromOMRProperty(AttributeDescriptorInterface attrDesc, Property propObject) throws MdException {
        MdOMAEntityUtility.populateEntityAttributeDescriptorfromOMRProperty(attrDesc, propObject, true);
    }

    protected static void populateEntityAttributeDescriptorfromOMRProperty(AttributeDescriptorInterface attrDesc, Property propObject, boolean goToServer) throws MdException {
        TextStore textobj;
        if (goToServer) {
            propObject = (Property)MetadataUtil.getMetadataAllDepths(propObject, null, null, AttributeDescriptorGetTemplate, 268, false);
        }
        if ((textobj = (TextStore)propObject.getStoredConfiguration()) != null) {
            attrDesc.setConfigurationXML(textobj.getStoredText());
        }
        AssociationList customizers = propObject.getCustomizers();
        for (SoftwareComponent cust : customizers) {
            if (cust == null) continue;
            attrDesc.setCustomizer(cust.getProductIdentifier(), cust.getClassIdentifier());
        }
        boolean f_DefaultValueHasBeenSet = false;
        boolean f_Property = false;
        boolean f_Modifiable = false;
        boolean f_Label = false;
        AssociationList props = propObject.getProperties();
        for (Property propAttr : props) {
            if (propAttr.getName().equals("DefaultValueHasBeenSet")) {
                f_DefaultValueHasBeenSet = true;
                if (propAttr.getDefaultValue().equals("0")) {
                    attrDesc.setDefaultValueHasBeenSet(false);
                    continue;
                }
                attrDesc.setDefaultValueHasBeenSet(true);
                attrDesc.setDefault((Object)propObject.getDefaultValue());
                continue;
            }
            if (propAttr.getName().equals("Property")) {
                f_Property = true;
                if (propAttr.getDefaultValue().equals("0")) {
                    attrDesc.setProperty(false);
                    continue;
                }
                attrDesc.setProperty(true);
                continue;
            }
            if (propAttr.getName().equals("Modifiable")) {
                f_Modifiable = true;
                if (propAttr.getDefaultValue().equals("0")) {
                    attrDesc.setModifiable(false);
                    continue;
                }
                attrDesc.setModifiable(true);
                continue;
            }
            if (propAttr.getName().equals("Label")) {
                f_Label = true;
                attrDesc.setLabel(Locale.getDefault(), propAttr.getDefaultValue());
                continue;
            }
            if (propAttr.getName().equals("LargeIconURL")) {
                attrDesc.setLargeIconURL(Locale.getDefault(), propAttr.getDefaultValue());
                continue;
            }
            if (!propAttr.getName().equals("SmallIconURL")) continue;
            attrDesc.setSmallIconURL(Locale.getDefault(), propAttr.getDefaultValue());
        }
        AssociationList editors = propObject.getEditors();
        for (SoftwareComponent editor : editors) {
            String context = editor.getProductIdentifier();
            String value = editor.getClassIdentifier();
            attrDesc.setEditor(context, value);
        }
        attrDesc.setDescription(Locale.getDefault(), propObject.getDesc());
        attrDesc.setName(propObject.getPropertyName());
        if (propObject.getIsExpert() == 0) {
            attrDesc.setExpert(false);
        } else {
            attrDesc.setExpert(true);
        }
        if (propObject.getIsRequired() == 0) {
            attrDesc.setRequired(false);
        } else {
            attrDesc.setRequired(true);
        }
        if (propObject.getIsVisible() == 0) {
            attrDesc.setVisible(false);
        } else {
            attrDesc.setVisible(true);
        }
        if (!f_DefaultValueHasBeenSet) {
            if (propObject.getDefaultValue().length() > 0) {
                attrDesc.setDefault((Object)propObject.getDefaultValue());
                attrDesc.setDefaultValueHasBeenSet(true);
            } else {
                attrDesc.setDefaultValueHasBeenSet(false);
            }
        }
        if (!f_Property) {
            attrDesc.setProperty(false);
        }
        if (!f_Modifiable) {
            if (propObject.getIsUpdateable() == 1) {
                attrDesc.setModifiable(true);
            } else {
                attrDesc.setModifiable(false);
            }
        }
        if (!f_Label) {
            attrDesc.setLabel(Locale.getDefault(), propObject.getName());
        }
        AssociationList validators = propObject.getValidators();
        HashMap vals = new HashMap();
        for (SoftwareComponent validator : validators) {
            ArrayList<String> values = (ArrayList<String>)vals.get(validator.getProductIdentifier());
            if (values == null) {
                values = new ArrayList<String>();
            }
            if (!values.contains(validator.getClassIdentifier())) {
                values.add(validator.getClassIdentifier());
            }
            vals.put(validator.getProductIdentifier(), values);
        }
        Set keys = vals.keySet();
        for (String value : keys) {
            attrDesc.setValidators(value, (List)vals.get(value));
        }
        vals.clear();
        vals = null;
        PropertyType propType = propObject.getOwningType();
        AttributeTypeInterface attrType = attrDesc.getType();
        if (propType != null) {
            if (attrType == null) {
                attrType = new AttributeType();
            }
            attrDesc.setType(attrType);
            MdOMAEntityUtility.populateEntityAttributeTypeFromOMRPropertyType(attrType, propType, goToServer);
        }
    }

    public static void populateEntityAttributeTypeFromOMRPropertyType(AttributeTypeInterface attrType, PropertyType propType) throws MdException {
        MdOMAEntityUtility.populateEntityAttributeTypeFromOMRPropertyType(attrType, propType, true);
    }

    protected static void populateEntityAttributeTypeFromOMRPropertyType(AttributeTypeInterface attrType, PropertyType propType, boolean goToServer) throws MdException {
        TextStore textobj;
        if (propType == null) {
            return;
        }
        if (goToServer) {
            propType = (PropertyType)MetadataUtil.getMetadataAllDepths(propType, null, null, AttributeTypeGetTemplate, 268, false);
        }
        if ((textobj = (TextStore)propType.getStoredConfiguration()) != null) {
            attrType.setConfigurationXML(textobj.getStoredText());
        }
        AssociationList customizers = propType.getCustomizers();
        for (SoftwareComponent cust : customizers) {
            attrType.setCustomizer(cust.getProductIdentifier(), cust.getClassIdentifier());
        }
        attrType.setDescription(Locale.getDefault(), propType.getDesc());
        attrType.setName(propType.getName());
        AssociationList props = propType.getProperties();
        for (Property propAttr : props) {
            if (propAttr.getName().equals("ObjectType")) {
                attrType.setObjectType(propAttr.getDefaultValue());
                continue;
            }
            if (propAttr.getName().equals("Label")) {
                attrType.setLabel(Locale.getDefault(), propAttr.getDefaultValue());
                continue;
            }
            if (propAttr.getName().equals("LargeIconURL")) {
                attrType.setLargeIconURL(Locale.getDefault(), propAttr.getDefaultValue());
                continue;
            }
            if (propAttr.getName().equals("SmallIconURL")) {
                attrType.setSmallIconURL(Locale.getDefault(), propAttr.getDefaultValue());
                continue;
            }
            if (!propAttr.getName().equals("Type")) continue;
            attrType.setType(propAttr.getDefaultValue());
        }
        attrType.setSQLType(propType.getSQLType());
        AssociationList validators = propType.getValidators();
        HashMap vals = new HashMap();
        for (SoftwareComponent validator : validators) {
            ArrayList<String> values = (ArrayList<String>)vals.get(validator.getProductIdentifier());
            if (values == null) {
                values = new ArrayList<String>();
            }
            if (!values.contains(validator.getClassIdentifier())) {
                values.add(validator.getClassIdentifier());
            }
            vals.put(validator.getProductIdentifier(), values);
        }
        Set keys = vals.keySet();
        for (String value : keys) {
            attrType.setValidators(value, (List)vals.get(value));
        }
        vals.clear();
        vals = null;
    }

    public static void populateOMRPropertyFromEntity(Property entityProp, RemoteEntityInterface entity) throws MdException {
        if (entity == null) {
            return;
        }
        try {
            PropertyGroup propGroup;
            PropertyType propType;
            Iterator iter;
            Util.printOutputln("DEBUG NOTE: Start remove entity from OMR, cached.");
            Root owningObj = entityProp.getAssociatedObject();
            MdOMAEntityUtility.removeEntityPropertyObjectFromOMR(entityProp);
            Util.printOutputln("DEBUG NOTE: End remove entity from OMR, cached.");
            entityProp = (Property)MdObjectFactory.createComplexMetadataObject(entityProp.getObjectStore(), null, "Entity", "Property", entityProp.getRepositoryID(), null);
            entityProp.setDefaultValue("com.sas.entities.RemoteEntityInterface");
            entityProp.setOwningType(MdOMAEntityUtility.getGenericPropertyType(entityProp));
            if (owningObj != null) {
                owningObj.getProperties().add(entityProp);
            }
            AssociationList customizers = entityProp.getCustomizers();
            List entCustContext = entity.getCustomizerContexts();
            if (entCustContext != null && entCustContext.size() > 0) {
                Iterator contxtIter = entCustContext.iterator();
                while (contxtIter.hasNext()) {
                    boolean found = false;
                    String contextValue = (String)contxtIter.next();
                    SoftwareComponent sc = null;
                    iter = customizers.iterator();
                    while (iter.hasNext() && !found) {
                        sc = (SoftwareComponent)iter.next();
                        if (!sc.getProductIdentifier().equals(contextValue)) continue;
                        found = true;
                        sc.setClassIdentifier(entity.getCustomizer(contextValue));
                    }
                    if (found) continue;
                    sc = (SoftwareComponent)MdObjectFactory.createComplexMetadataObject(entityProp.getObjectStore(), null, "AttributeGroupCustomizer", "SoftwareComponent", entityProp.getRepositoryID(), null);
                    sc.setProductIdentifier(contextValue);
                    sc.setClassIdentifier(entity.getCustomizer(contextValue));
                    customizers.add(sc);
                }
            }
            AssociationList externalIdentities = entityProp.getExternalIdentities();
            boolean addExternalIdentity = false;
            if (externalIdentities.size() == 0) {
                addExternalIdentity = true;
            } else {
                boolean found = false;
                ArrayList<ExternalIdentity> toDelete = new ArrayList<ExternalIdentity>(10);
                iter = externalIdentities.iterator();
                while (iter.hasNext() && !found) {
                    ExternalIdentity identE = (ExternalIdentity)iter.next();
                    String context = identE.getContext();
                    if (!context.equals("EntityKeyInterface")) continue;
                    if (identE.getIdentifier().equals(entity.getEntityKey())) {
                        found = true;
                        break;
                    }
                    toDelete.add(identE);
                }
                for (ExternalIdentity identE : toDelete) {
                    identE.delete();
                }
                if (!found) {
                    addExternalIdentity = true;
                }
            }
            if (addExternalIdentity) {
                ExternalIdentity ident = (ExternalIdentity)MdObjectFactory.createComplexMetadataObject(entityProp.getObjectStore(), null, "EntityGUID", "ExternalIdentity", entityProp.getRepositoryID(), null);
                ident.setIdentifier(entity.getEntityKey());
                ident.setContext("EntityKeyInterface");
                externalIdentities.add(ident);
            }
            Root prototype = entityProp.getUsingPrototype();
            RemoteEntityInterface entprot = entity.getPrototype();
            Property entityPrototype = null;
            if (entprot != null) {
                if (prototype == null) {
                    entityPrototype = (Property)MdObjectFactory.createComplexMetadataObject(entityProp.getObjectStore(), null, "EntityPrototype", "Property", entityProp.getRepositoryID(), null);
                    entityPrototype.setOwningType(MdOMAEntityUtility.getGenericPropertyType(entityPrototype));
                } else {
                    entityPrototype = (Property)prototype;
                }
                entityProp.setUsingPrototype(entityPrototype);
                MdOMAEntityUtility.populateOMRPropertyFromEntity(entityPrototype, entprot);
            }
            if ((propType = entityProp.getOwningType()) == null) {
                entityProp.setOwningType(MdOMAEntityUtility.getGenericPropertyType(entityProp));
            }
            if ((propGroup = entityProp.getPrimaryPropertyGroup()) == null) {
                propGroup = (PropertyGroup)MdObjectFactory.createComplexMetadataObject(entityProp.getObjectStore(), null, "AttributeGroup", "PropertyGroup", entityProp.getRepositoryID(), null);
                entityProp.setPrimaryPropertyGroup(propGroup);
            }
            MdOMAEntityUtility.populateOMRPropertyGroupFromAttributeGroup(propGroup, entity.getAttributeGroup());
            MdOMAEntityUtility.clearPropertyTypesForObjectRepository(entityProp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new MdException(ex);
        }
    }

    public static void populateOMRPropertyGroupFromAttributeGroup(PropertyGroup propGroup, AttributeGroupInterface attrGroup) throws MdException {
        AttributeDescriptorInterface[] attrDescs;
        String smallicon;
        Property propAttrv;
        String largeicon;
        Property propAttrv2;
        String groupname;
        String descrip;
        String configXML;
        if (attrGroup == null) {
            return;
        }
        propGroup = (PropertyGroup)MetadataUtil.getMetadataAllDepths(propGroup, null, null, AttributeGroupGetTemplate, 268, false);
        AssociationList customizers = propGroup.getCustomizers();
        List custContexts = attrGroup.getAttributeCustomizerContexts();
        if (custContexts.size() > 0) {
            ArrayList<SoftwareComponent> toDelete = new ArrayList<SoftwareComponent>(10);
            Iterator contxtIter = custContexts.iterator();
            while (contxtIter.hasNext()) {
                boolean found = false;
                String contextValue = (String)contxtIter.next();
                SoftwareComponent sc = null;
                Iterator iter = customizers.iterator();
                while (iter.hasNext() && !found) {
                    sc = (SoftwareComponent)iter.next();
                    if (sc.getProductIdentifier().equals(contextValue)) {
                        found = true;
                        sc.setClassIdentifier(attrGroup.getCustomizer(contextValue));
                    }
                    if (custContexts.contains(sc.getProductIdentifier()) || toDelete.contains(sc)) continue;
                    toDelete.add(sc);
                }
                if (found) continue;
                sc = (SoftwareComponent)MdObjectFactory.createComplexMetadataObject(propGroup.getObjectStore(), null, "AttributeGroupCustomizer", "SoftwareComponent", propGroup.getRepositoryID(), null);
                sc.setProductIdentifier(contextValue);
                sc.setClassIdentifier(attrGroup.getCustomizer(contextValue));
                customizers.add(sc);
            }
            for (SoftwareComponent sc : toDelete) {
                sc.delete();
            }
        }
        if ((configXML = attrGroup.getConfigurationXML()) != null && configXML.length() > 0) {
            AssociationList notes = propGroup.getNotes();
            TextStore configText = null;
            Iterator iter = notes.iterator();
            while (iter.hasNext() && configText == null) {
                TextStore note = (TextStore)iter.next();
                if (!note.getTextRole().equals("ConfigurationXML")) continue;
                configText = note;
            }
            if (configText == null) {
                configText = (TextStore)MdObjectFactory.createComplexMetadataObject(propGroup.getObjectStore(), null, "AttributeGroupConfigurationXML", "TextStore", propGroup.getRepositoryID(), null);
                configText.setTextRole("ConfigurationXML");
                notes.add(configText);
            }
            configText.setStoredText(attrGroup.getConfigurationXML());
        }
        if ((descrip = attrGroup.getDescription(Locale.getDefault())) != null && descrip.length() > 0) {
            propGroup.setDesc(descrip);
        }
        if ((groupname = attrGroup.getName()) != null && groupname.length() > 0) {
            propGroup.setName(groupname);
        }
        if (attrGroup.isVisible()) {
            propGroup.setIsVisible("1");
        } else {
            propGroup.setIsVisible("0");
        }
        boolean f_Label = false;
        boolean f_LargeIconURL = false;
        boolean f_SmallIconURL = false;
        boolean f_Modifiable = false;
        boolean f_Expert = false;
        AssociationList props = propGroup.getProperties();
        for (Property propAttr : props) {
            if (propAttr.getName().equals("Modifiable")) {
                f_Modifiable = true;
                if (attrGroup.isModifiable()) {
                    propAttr.setDefaultValue("1");
                    continue;
                }
                propAttr.setDefaultValue("0");
                continue;
            }
            if (propAttr.getName().equals("Expert")) {
                f_Expert = true;
                if (attrGroup.isExpert()) {
                    propAttr.setDefaultValue("1");
                    continue;
                }
                propAttr.setDefaultValue("0");
                continue;
            }
            if (propAttr.getName().equals("Label")) {
                f_Label = true;
                propAttr.setDefaultValue(attrGroup.getLabel(Locale.getDefault()));
                continue;
            }
            if (propAttr.getName().equals("LargeIconURL")) {
                f_LargeIconURL = true;
                propAttr.setDefaultValue(attrGroup.getLargeIconURL(Locale.getDefault()));
                continue;
            }
            if (!propAttr.getName().equals("SmallIconURL")) continue;
            f_SmallIconURL = true;
            propAttr.setDefaultValue(attrGroup.getSmallIconURL(Locale.getDefault()));
        }
        if (!f_Modifiable && !attrGroup.isModifiable()) {
            propAttrv2 = (Property)MdObjectFactory.createComplexMetadataObject(propGroup.getObjectStore(), null, "Modifiable", "Property", propGroup.getRepositoryID(), null);
            propAttrv2.setOwningType(MdOMAEntityUtility.getGenericPropertyType(propAttrv2));
            props.add(propAttrv2);
            if (attrGroup.isModifiable()) {
                propAttrv2.setDefaultValue("1");
            } else {
                propAttrv2.setDefaultValue("0");
            }
        }
        if (!f_Expert && attrGroup.isExpert()) {
            propAttrv2 = (Property)MdObjectFactory.createComplexMetadataObject(propGroup.getObjectStore(), null, "Expert", "Property", propGroup.getRepositoryID(), null);
            propAttrv2.setOwningType(MdOMAEntityUtility.getGenericPropertyType(propAttrv2));
            props.add(propAttrv2);
            if (attrGroup.isExpert()) {
                propAttrv2.setDefaultValue("1");
            } else {
                propAttrv2.setDefaultValue("0");
            }
        }
        if (!f_Label) {
            String labelval = attrGroup.getLabel(Locale.getDefault());
            propGroup.setName(labelval);
        }
        if (!f_LargeIconURL && (largeicon = attrGroup.getLargeIconURL(Locale.getDefault())) != null && largeicon.length() > 0) {
            propAttrv = (Property)MdObjectFactory.createComplexMetadataObject(propGroup.getObjectStore(), null, "LargeIconURL", "Property", propGroup.getRepositoryID(), null);
            propAttrv.setOwningType(MdOMAEntityUtility.getGenericPropertyType(propAttrv));
            props.add(propAttrv);
            propAttrv.setDefaultValue(largeicon);
        }
        if (!f_SmallIconURL && (smallicon = attrGroup.getSmallIconURL(Locale.getDefault())) != null && smallicon.length() > 0) {
            propAttrv = (Property)MdObjectFactory.createComplexMetadataObject(propGroup.getObjectStore(), null, "SmallIconURL", "Property", propGroup.getRepositoryID(), null);
            propAttrv.setOwningType(MdOMAEntityUtility.getGenericPropertyType(propAttrv));
            props.add(propAttrv);
            propAttrv.setDefaultValue(smallicon);
        }
        if ((attrDescs = attrGroup.getAttributeDescriptors(false)) != null && attrDescs.length > 0) {
            AssociationList propSets = propGroup.getPropertySets();
            PropertySet propset = null;
            Iterator iter = propSets.iterator();
            while (iter.hasNext() && propset == null) {
                PropertySet set = (PropertySet)iter.next();
                if (!set.getSetRole().equals("com.sas.entities.AttributeGroupInterface")) continue;
                propset = set;
            }
            if (propset == null) {
                propset = (PropertySet)MdObjectFactory.createComplexMetadataObject(propGroup.getObjectStore(), null, "EntityAttributeDescriptors", "PropertySet", propGroup.getRepositoryID(), null);
                propset.setSetRole("com.sas.entities.AttributeGroupInterface");
                propSets.add(propset);
            }
            AssociationList setProps = propset.getSetProperties();
            for (int i = 0; i < attrDescs.length; ++i) {
                AttributeDescriptorInterface attrDesc = attrDescs[i];
                String attrDescName = attrDesc.getName();
                String attrDescdesc = attrDesc.getDescription(Locale.getDefault());
                String attrDescLabel = attrDesc.getLabel(Locale.getDefault());
                if (attrDescName != null && attrDescName.equals("entityKey") && attrDescdesc != null && attrDescLabel != null && attrDescName.equals(attrDescdesc) && attrDescdesc.equals(attrDescLabel)) continue;
                Property attrDescProperty = null;
                String name = attrDesc.getName();
                if (name == null) {
                    name = "";
                }
                attrDescProperty = (Property)MdObjectFactory.createComplexMetadataObject(propGroup.getObjectStore(), null, attrDesc.getName(), "Property", propGroup.getRepositoryID(), null);
                setProps.add(attrDescProperty);
                attrDescProperty.setOwningType(MdOMAEntityUtility.getGenericPropertyType(attrDescProperty));
                MdOMAEntityUtility.populateOMRPropertyFromAttributeDescriptor(attrDescProperty, attrDesc);
            }
        }
        AssociationList childgroups = propGroup.getSubpropertyGroups();
        AttributeGroupInterface[] attributeGroups = attrGroup.getAttributeGroups();
        if (attributeGroups != null && attributeGroups.length > 0) {
            for (int i = 0; i < attributeGroups.length; ++i) {
                AttributeGroupInterface attrGroupI = attributeGroups[i];
                PropertyGroup propgroup = (PropertyGroup)MdObjectFactory.createComplexMetadataObject(propGroup.getObjectStore(), null, attrGroupI.getName(), "PropertyGroup", propGroup.getRepositoryID(), null);
                childgroups.add(propgroup);
                MdOMAEntityUtility.populateOMRPropertyGroupFromAttributeGroup(propgroup, attrGroupI);
            }
        }
    }

    public static void populateOMRPropertyFromAttributeDescriptor(Property propAttr, AttributeDescriptorInterface attrDesc) throws MdException {
        AttributeTypeInterface atype;
        String propertyname;
        String descval;
        String smallicon;
        String largeicon;
        String labelval;
        Property propAttrv;
        Property propAttrv22;
        Object defaltval;
        if (attrDesc == null) {
            return;
        }
        propAttr = (Property)MetadataUtil.getMetadataAllDepths(propAttr, null, null, AttributeDescriptorGetTemplate, 268, false);
        String configXML = attrDesc.getConfigurationXML();
        if (configXML != null && configXML.length() > 0) {
            TextStore textobj = (TextStore)propAttr.getStoredConfiguration();
            if (configXML != null && configXML.length() > 0) {
                if (textobj == null) {
                    textobj = (TextStore)MdObjectFactory.createComplexMetadataObject(propAttr.getObjectStore(), null, "AttributeDescriptorConfigurationXML", "TextStore", propAttr.getRepositoryID(), null);
                    textobj.setTextRole("ConfigurationXML");
                    propAttr.setStoredConfiguration(textobj);
                }
                textobj.setStoredText(configXML);
            }
        }
        AssociationList customizers = propAttr.getCustomizers();
        List custContexts = attrDesc.getAttributeCustomizerContexts();
        if (custContexts.size() > 0) {
            Iterator contxtIter = custContexts.iterator();
            while (contxtIter.hasNext()) {
                boolean found = false;
                String contextValue = (String)contxtIter.next();
                SoftwareComponent sc = null;
                Iterator iter = customizers.iterator();
                while (iter.hasNext() && !found) {
                    sc = (SoftwareComponent)iter.next();
                    if (!sc.getProductIdentifier().equals(contextValue)) continue;
                    found = true;
                    sc.setClassIdentifier(attrDesc.getCustomizer(contextValue));
                }
                if (found) continue;
                sc = (SoftwareComponent)MdObjectFactory.createComplexMetadataObject(propAttr.getObjectStore(), null, "AttributeDescriptorCustomizer", "SoftwareComponent", propAttr.getRepositoryID(), null);
                sc.setProductIdentifier(contextValue);
                sc.setClassIdentifier(attrDesc.getCustomizer(contextValue));
                customizers.add(sc);
            }
        }
        if (attrDesc.isDefaultValueHasBeenSet() && (defaltval = attrDesc.getDefault()) != null) {
            propAttr.setDefaultValue(attrDesc.getStringDefault());
        }
        AssociationList props = propAttr.getProperties();
        boolean f_DefaultValueHasBeenSet = false;
        boolean f_Property = false;
        boolean f_Modifiable = false;
        boolean f_Label = false;
        boolean f_LargeIconURL = false;
        boolean f_SmallIconURL = false;
        for (Property propAttrv22 : props) {
            if (propAttrv22.getName().equals("DefaultValueHasBeenSet")) {
                f_DefaultValueHasBeenSet = true;
                if (attrDesc.isDefaultValueHasBeenSet()) {
                    propAttrv22.setDefaultValue("1");
                    continue;
                }
                propAttrv22.setDefaultValue("0");
                continue;
            }
            if (propAttrv22.getName().equals("Property")) {
                f_Property = true;
                if (attrDesc.isProperty()) {
                    propAttrv22.setDefaultValue("1");
                    continue;
                }
                propAttrv22.setDefaultValue("0");
                continue;
            }
            if (propAttrv22.getName().equals("Modifiable")) {
                f_Modifiable = true;
                if (attrDesc.isModifiable()) {
                    propAttrv22.setDefaultValue("1");
                    continue;
                }
                propAttrv22.setDefaultValue("0");
                continue;
            }
            if (propAttrv22.getName().equals("Label")) {
                f_Label = true;
                propAttrv22.setDefaultValue(attrDesc.getLabel(Locale.getDefault()));
                continue;
            }
            if (propAttrv22.getName().equals("LargeIconURL")) {
                f_LargeIconURL = true;
                propAttrv22.setDefaultValue(attrDesc.getLargeIconURL(Locale.getDefault()));
                continue;
            }
            if (!propAttrv22.getName().equals("SmallIconURL")) continue;
            f_SmallIconURL = true;
            propAttrv22.setDefaultValue(attrDesc.getSmallIconURL(Locale.getDefault()));
        }
        if (!f_DefaultValueHasBeenSet && attrDesc.isDefaultValueHasBeenSet() && propAttr.getDefaultValue().length() <= 0) {
            propAttrv = (Property)MdObjectFactory.createComplexMetadataObject(propAttr.getObjectStore(), null, "DefaultValueHasBeenSet", "Property", propAttr.getRepositoryID(), null);
            propAttrv.setOwningType(MdOMAEntityUtility.getGenericPropertyType(propAttrv));
            props.add(propAttrv);
            if (attrDesc.isDefaultValueHasBeenSet()) {
                propAttrv.setDefaultValue("1");
            } else {
                propAttrv.setDefaultValue("0");
            }
        }
        if (!f_Property && attrDesc.isProperty()) {
            propAttrv = (Property)MdObjectFactory.createComplexMetadataObject(propAttr.getObjectStore(), null, "Property", "Property", propAttr.getRepositoryID(), null);
            propAttrv.setOwningType(MdOMAEntityUtility.getGenericPropertyType(propAttrv));
            props.add(propAttrv);
            if (attrDesc.isProperty()) {
                propAttrv.setDefaultValue("1");
            } else {
                propAttrv.setDefaultValue("0");
            }
        }
        if (!f_Modifiable) {
            // empty if block
        }
        if (!f_Label && (labelval = attrDesc.getLabel(Locale.getDefault())) != null && labelval.length() > 0) {
            propAttr.setName(labelval);
        }
        if (!f_LargeIconURL && (largeicon = attrDesc.getLargeIconURL(Locale.getDefault())) != null && largeicon.length() > 0) {
            propAttrv22 = (Property)MdObjectFactory.createComplexMetadataObject(propAttr.getObjectStore(), null, "LargeIconURL", "Property", propAttr.getRepositoryID(), null);
            propAttrv22.setOwningType(MdOMAEntityUtility.getGenericPropertyType(propAttrv22));
            props.add(propAttrv22);
            propAttrv22.setDefaultValue(largeicon);
        }
        if (!f_SmallIconURL && (smallicon = attrDesc.getSmallIconURL(Locale.getDefault())) != null && smallicon.length() > 0) {
            propAttrv22 = (Property)MdObjectFactory.createComplexMetadataObject(propAttr.getObjectStore(), null, "SmallIconURL", "Property", propAttr.getRepositoryID(), null);
            propAttrv22.setOwningType(MdOMAEntityUtility.getGenericPropertyType(propAttrv22));
            props.add(propAttrv22);
            propAttrv22.setDefaultValue(smallicon);
        }
        AssociationList editors = propAttr.getEditors();
        List editContexts = attrDesc.getAttributeEditorContexts();
        if (editContexts.size() > 0) {
            Iterator contxtIter = editContexts.iterator();
            while (contxtIter.hasNext()) {
                boolean found = false;
                String contextValue = (String)contxtIter.next();
                SoftwareComponent sc = null;
                Iterator iter = editors.iterator();
                while (iter.hasNext() && !found) {
                    sc = (SoftwareComponent)iter.next();
                    if (!sc.getProductIdentifier().equals(contextValue)) continue;
                    found = true;
                    sc.setClassIdentifier(attrDesc.getEditor(contextValue));
                }
                if (found) continue;
                sc = (SoftwareComponent)MdObjectFactory.createComplexMetadataObject(propAttr.getObjectStore(), null, "AttributeDescriptorEditor", "SoftwareComponent", propAttr.getRepositoryID(), null);
                sc.setClassIdentifier(attrDesc.getEditor(contextValue));
                sc.setProductIdentifier(contextValue);
                editors.add(sc);
            }
        }
        if ((descval = attrDesc.getDescription(Locale.getDefault())) != null && descval.length() > 0) {
            propAttr.setDesc(descval);
        }
        if ((propertyname = attrDesc.getName()) != null && propertyname.length() > 0) {
            propAttr.setPropertyName(attrDesc.getName());
        }
        if (attrDesc.isExpert()) {
            propAttr.setIsExpert("1");
        } else {
            propAttr.setIsExpert("0");
        }
        if (attrDesc.isRequired()) {
            propAttr.setIsRequired("1");
        } else {
            propAttr.setIsRequired("0");
        }
        if (attrDesc.isVisible()) {
            propAttr.setIsVisible("1");
        } else {
            propAttr.setIsVisible("0");
        }
        if (attrDesc.isModifiable()) {
            propAttr.setIsUpdateable("1");
        } else {
            propAttr.setIsUpdateable("0");
        }
        List valContexts = attrDesc.getValidatorsContexts();
        if (valContexts.size() > 0) {
            HashMap<String, List> vals = new HashMap<String, List>(10);
            Iterator contxtIter = valContexts.iterator();
            while (contxtIter.hasNext()) {
                boolean found = false;
                String contextValue = (String)contxtIter.next();
                List ctxvalues = attrDesc.getValidators(contextValue);
                vals.put(contextValue, ctxvalues);
                for (String value : ctxvalues) {
                    SoftwareComponent sc = null;
                    AssociationList validators = propAttr.getValidators();
                    Iterator iter = validators.iterator();
                    while (iter.hasNext() && !found) {
                        sc = (SoftwareComponent)iter.next();
                        if (!sc.getProductIdentifier().equals(contextValue) || !sc.getClassIdentifier().equals(value)) continue;
                        found = true;
                    }
                    if (found) continue;
                    sc = (SoftwareComponent)MdObjectFactory.createComplexMetadataObject(propAttr.getObjectStore(), null, "AttributeTypeValidator", "SoftwareComponent", propAttr.getRepositoryID(), null);
                    validators.add(sc);
                    sc.setProductIdentifier(contextValue);
                    sc.setClassIdentifier(value);
                }
            }
            vals.clear();
            vals = null;
        }
        if ((atype = attrDesc.getType()) != null) {
            PropertyType propType = (PropertyType)MdObjectFactory.createComplexMetadataObject(propAttr.getObjectStore(), null, atype.getName(), "PropertyType", propAttr.getRepositoryID(), null);
            propAttr.setOwningType(propType);
            MdOMAEntityUtility.populateOMRPropertyTypeFromAttributeType(propType, atype);
        } else {
            propAttr.setOwningType(MdOMAEntityUtility.getGenericPropertyType(propAttr));
        }
    }

    public static void populateOMRPropertyTypeFromAttributeType(PropertyType propType, AttributeTypeInterface attrType) throws MdException {
        String typeval;
        String smallicon;
        String largeicon;
        String labelval;
        Property propAttrv;
        String objtypeval;
        String descval;
        String nameval;
        if (attrType == null) {
            return;
        }
        boolean useStdType = true;
        boolean isGenericType = false;
        propType = (PropertyType)MetadataUtil.getMetadataAllDepths(propType, null, null, AttributeTypeGetTemplate, 268, false);
        String configXML = attrType.getConfigurationXML();
        if (configXML != null && configXML.length() > 0) {
            useStdType = false;
            TextStore textobj = (TextStore)propType.getStoredConfiguration();
            if (configXML != null && configXML.length() > 0) {
                if (textobj == null) {
                    textobj = (TextStore)MdObjectFactory.createComplexMetadataObject(propType.getObjectStore(), null, "AttributeTypeConfigurationXML", "TextStore", propType.getRepositoryID(), null);
                    textobj.setTextRole("ConfigurationXML");
                    propType.setStoredConfiguration(textobj);
                }
                textobj.setStoredText(configXML);
            }
        }
        AssociationList customizers = propType.getCustomizers();
        List custContexts = attrType.getAttributeCustomizerContexts();
        if (custContexts.size() > 0) {
            useStdType = false;
            Iterator contxtIter = custContexts.iterator();
            while (contxtIter.hasNext()) {
                boolean found = false;
                String contextValue = (String)contxtIter.next();
                SoftwareComponent sc = null;
                Iterator iter = customizers.iterator();
                while (iter.hasNext() && !found) {
                    sc = (SoftwareComponent)iter.next();
                    if (!sc.getProductIdentifier().equals(contextValue)) continue;
                    found = true;
                    sc.setClassIdentifier(attrType.getCustomizer(contextValue));
                }
                if (found) continue;
                sc = (SoftwareComponent)MdObjectFactory.createComplexMetadataObject(propType.getObjectStore(), null, "AttributeTypeCustomizer", "SoftwareComponent", propType.getRepositoryID(), null);
                sc.setClassIdentifier(attrType.getCustomizer(contextValue));
                sc.setProductIdentifier(contextValue);
                customizers.add(sc);
            }
        }
        if ((nameval = attrType.getName()) != null && nameval.length() > 0) {
            propType.setName(nameval);
            isGenericType = ENTITY_PROPTYPES_MAP.containsKey(nameval);
        }
        if (!((descval = attrType.getDescription(Locale.getDefault())) == null || descval.length() <= 0 || isGenericType && useStdType && descval.equals(nameval))) {
            useStdType = false;
            propType.setDesc(descval);
        }
        boolean f_ObjectType = false;
        boolean f_Label = false;
        boolean f_LargeIconURL = false;
        boolean f_SmallIconURL = false;
        boolean f_Type = false;
        AssociationList props = propType.getProperties();
        for (Property propAttr : props) {
            if (propAttr.getName().equals("ObjectType")) {
                f_ObjectType = true;
                propAttr.setDefaultValue(attrType.getObjectType());
                continue;
            }
            if (propAttr.getName().equals("Label")) {
                f_Label = true;
                propAttr.setDefaultValue(attrType.getLabel(Locale.getDefault()));
                continue;
            }
            if (propAttr.getName().equals("LargeIconURL")) {
                f_LargeIconURL = true;
                propAttr.setDefaultValue(attrType.getLargeIconURL(Locale.getDefault()));
                continue;
            }
            if (propAttr.getName().equals("SmallIconURL")) {
                f_SmallIconURL = true;
                propAttr.setDefaultValue(attrType.getSmallIconURL(Locale.getDefault()));
                continue;
            }
            if (!propAttr.getName().equals("Type")) continue;
            f_Type = true;
            propAttr.setDefaultValue(attrType.getType());
        }
        if (!f_ObjectType && (objtypeval = attrType.getObjectType()) != null && objtypeval.length() > 0) {
            useStdType = false;
            propAttrv = (Property)MdObjectFactory.createComplexMetadataObject(propType.getObjectStore(), null, "ObjectType", "Property", propType.getRepositoryID(), null);
            propAttrv.setOwningType(MdOMAEntityUtility.getGenericPropertyType(propAttrv));
            props.add(propAttrv);
            propAttrv.setDefaultValue(objtypeval);
        }
        if (!(f_Label || (labelval = attrType.getLabel(Locale.getDefault())) == null || labelval.length() <= 0 || isGenericType && useStdType && labelval.equals(nameval))) {
            useStdType = false;
            propAttrv = (Property)MdObjectFactory.createComplexMetadataObject(propType.getObjectStore(), null, "Label", "Property", propType.getRepositoryID(), null);
            propAttrv.setOwningType(MdOMAEntityUtility.getGenericPropertyType(propAttrv));
            props.add(propAttrv);
            propAttrv.setDefaultValue(labelval);
        }
        if (!f_LargeIconURL && (largeicon = attrType.getLargeIconURL(Locale.getDefault())) != null && largeicon.length() > 0) {
            useStdType = false;
            propAttrv = (Property)MdObjectFactory.createComplexMetadataObject(propType.getObjectStore(), null, "LargeIconURL", "Property", propType.getRepositoryID(), null);
            propAttrv.setOwningType(MdOMAEntityUtility.getGenericPropertyType(propAttrv));
            props.add(propAttrv);
            propAttrv.setDefaultValue(largeicon);
        }
        if (!f_SmallIconURL && (smallicon = attrType.getSmallIconURL(Locale.getDefault())) != null && smallicon.length() > 0) {
            useStdType = false;
            propAttrv = (Property)MdObjectFactory.createComplexMetadataObject(propType.getObjectStore(), null, "SmallIconURL", "Property", propType.getRepositoryID(), null);
            propAttrv.setOwningType(MdOMAEntityUtility.getGenericPropertyType(propAttrv));
            props.add(propAttrv);
            propAttrv.setDefaultValue(smallicon);
        }
        if (!(f_Type || (typeval = attrType.getType()) == null || typeval.length() <= 0 || isGenericType && useStdType && ENTITY_PROPTYPES_MAP.containsValue(typeval))) {
            useStdType = false;
            propAttrv = (Property)MdObjectFactory.createComplexMetadataObject(propType.getObjectStore(), null, "Type", "Property", propType.getRepositoryID(), null);
            propAttrv.setOwningType(MdOMAEntityUtility.getGenericPropertyType(propAttrv));
            props.add(propAttrv);
            propAttrv.setDefaultValue(typeval);
        }
        propType.setSQLType(attrType.getSQLType());
        List valContexts = attrType.getValidatorsContexts();
        if (valContexts.size() > 0) {
            useStdType = false;
            HashMap<String, List> vals = new HashMap<String, List>(10);
            Iterator contxtIter = valContexts.iterator();
            while (contxtIter.hasNext()) {
                boolean found = false;
                String contextValue = (String)contxtIter.next();
                List ctxvalues = attrType.getValidators(contextValue);
                vals.put(contextValue, ctxvalues);
                for (String value : ctxvalues) {
                    SoftwareComponent sc = null;
                    AssociationList validators = propType.getValidators();
                    Iterator iter = validators.iterator();
                    while (iter.hasNext() && !found) {
                        sc = (SoftwareComponent)iter.next();
                        if (!sc.getProductIdentifier().equals(contextValue) || !sc.getClassIdentifier().equals(value)) continue;
                        found = true;
                    }
                    if (found) continue;
                    sc = (SoftwareComponent)MdObjectFactory.createComplexMetadataObject(propType.getObjectStore(), null, "AttributeTypeValidator", "SoftwareComponent", propType.getRepositoryID(), null);
                    validators.add(sc);
                    sc.setProductIdentifier(contextValue);
                    sc.setClassIdentifier(value);
                }
            }
            vals.clear();
            vals = null;
        }
        if (useStdType) {
            String typeName = attrType.getName();
            int SQLType = attrType.getSQLType();
            List types = MdOMAEntityUtility.getPropertyTypesForObjectRepository(propType);
            for (PropertyType genericType : types) {
                if (!genericType.getName().equals(typeName) || genericType.getSQLType() != SQLType) continue;
                AssociationList typedProperties = propType.getTypedProperties();
                for (int i = 0; i < typedProperties.size(); ++i) {
                    Property prop = (Property)typedProperties.get(i);
                    prop.setOwningType(genericType);
                }
                propType.delete();
                break;
            }
        }
    }

    public static void populateOMRObjectFromEntity(Root omrObject, RemoteEntityInterface entity) throws MdException {
        Property entityProp = null;
        if (entity == null) {
            return;
        }
        AssociationList properties = omrObject.getProperties();
        for (Property propObject : properties) {
            if (!propObject.getName().equals("Entity") || !propObject.getDefaultValue().equals("com.sas.entities.RemoteEntityInterface")) continue;
            entityProp = propObject;
            break;
        }
        if (entityProp == null) {
            entityProp = (Property)MdObjectFactory.createComplexMetadataObject(omrObject.getObjectStore(), null, "Entity", "Property", omrObject.getRepositoryID(), null);
            entityProp.setDefaultValue("com.sas.entities.RemoteEntityInterface");
            entityProp.setOwningType(MdOMAEntityUtility.getGenericPropertyType(entityProp));
            properties.add(entityProp);
        }
        MdOMAEntityUtility.populateOMRPropertyFromEntity(entityProp, entity);
    }

    public static Property getEntityPropertyForOMRObject(Root omrObject) throws MdException {
        Property entityProp = null;
        ArrayList<String> complex = new ArrayList<String>();
        complex.add("Properties");
        omrObject = (Root)MetadataUtil.getMetadataAllDepths(omrObject, null, complex, EntityAllGetTemplate, 2316, false);
        AssociationList properties = omrObject.getProperties();
        for (Property propObject : properties) {
            if (!propObject.getName().equals("Entity") || !propObject.getDefaultValue().equals("com.sas.entities.RemoteEntityInterface")) continue;
            entityProp = propObject;
            break;
        }
        return entityProp;
    }

    public static void removeEntityFromOMR(Root omrObject) throws MdException {
        AssociationList props = omrObject.getProperties();
        Property propObject = null;
        for (Property propObject2 : props) {
            if (!propObject2.getDefaultValue().equals("com.sas.entities.RemoteEntityInterface")) continue;
            propObject = propObject2;
            break;
        }
        if (propObject != null) {
            MdOMAEntityUtility.removeEntityPropertyObjectFromOMR(propObject);
        }
    }

    public static void removeEntityPropertyObjectFromOMR(Property omrProperty) throws MdException {
        MdObjectStore store = (MdObjectStore)omrProperty.getObjectStore();
        List toDeleteListServer = null;
        if (omrProperty.isNewObject()) {
            toDeleteListServer = MdOMAEntityUtility.getRemoveObjectListFromStore(omrProperty, EntityStoreAllDeleteTemplate2);
        } else {
            StringBuffer SELECT = new StringBuffer("<XMLSelect search=\"@Id='");
            SELECT.append(omrProperty.getId());
            SELECT.append("'\"/>");
            SELECT.append(EntityStoreAllDeleteTemplate);
            toDeleteListServer = MetadataUtil.getMetadataObjectsSubsetList(store, "A0000001." + omrProperty.getRepositoryID(), omrProperty.getCMetadataType(), 2436, SELECT.toString(), true);
        }
        ArrayList<CMetadata> removeList = new ArrayList<CMetadata>();
        for (CMetadata deleteObject : toDeleteListServer) {
            if (deleteObject.getCMetadataType().equals("PropertyType")) continue;
            removeList.add(deleteObject);
        }
        store.removeObjectsFromStore(removeList);
    }

    static void setAttributeDescriptorCustomizerFromOMRSoftwareComponent(BaseAttributeDescriptorInterface bi, SoftwareComponent softcomp) {
        String customizer = softcomp.getClassIdentifier();
        bi.setCustomizer(null, customizer);
    }

    static void setEntityCustomizerFromOMRSoftwareComponent(Entity entity, SoftwareComponent softcomp) {
        String customizer = softcomp.getClassIdentifier();
        entity.setCustomizer(null, customizer);
    }

    static void setEntityCustomizerFromOMRSoftwareComponent(RemoteEntityInterface entity, SoftwareComponent softcomp) throws RemoteException {
        String customizer = softcomp.getClassIdentifier();
        entity.setCustomizer(null, customizer);
    }

    static PropertyType getPropertyType(Root inObject) throws MdException {
        if (inObject != null) {
            PropertyType propType;
            if (inObject instanceof Property && (propType = ((Property)inObject).getOwningType()) != null) {
                return propType;
            }
            PropertyType proptype = (PropertyType)MdObjectFactory.createComplexMetadataObject(inObject.getObjectStore(), null, "String", "PropertyType", inObject.getRepositoryID(), null);
            proptype.setSQLType(12);
            proptype.setDesc("PropertyType used for an Entity");
            return proptype;
        }
        return null;
    }

    public static void deleteAllEntityObjects(String reposID) throws MdException {
        MdObjectStore store = MdObjectFactory.createObjectStore(null, "MdOMAEntityUtility::deleteAllEntityObjects");
        String XMLSELECT = "<XMLSELECT search=\"*[@Name='Entity' AND @DefaultValue='com.sas.entities.RemoteEntityInterface']\"/>";
        List entities = MetadataUtil.getMetadataObjectsSubset(store, reposID, "Property", 388, XMLSELECT);
        for (Property todelete : entities) {
            MdOMAEntityUtility.removeEntityPropertyObjectFromOMR(todelete);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void deleteObjectFromStore(Property entityProp, String template) throws MdException {
        MdObjectStore store = (MdObjectStore)entityProp.getObjectStore();
        StringBuffer SELECT = new StringBuffer("<XMLSelect search=\"@Id='");
        SELECT.append(entityProp.getId());
        SELECT.append("'\"/>");
        SELECT.append(template);
        List groupList = MdOMAEntityUtility.getPropertyTypesForObjectRepositoryIDList(entityProp);
        List toDeleteListServer = MetadataUtil.getMetadataObjectsSubsetList(store, "A0000001." + entityProp.getRepositoryID(), entityProp.getCMetadataType(), 2436, SELECT.toString(), true);
        ArrayList<Root> toDeletePropTypes = new ArrayList<Root>(10);
        ArrayList<Root> objectsToDelete = new ArrayList<Root>(10);
        for (Root root : toDeleteListServer) {
            if (groupList.contains(root.getId())) continue;
            if (root.getCMetadataType().equals("PropertyType")) {
                toDeletePropTypes.add(root);
                continue;
            }
            objectsToDelete.add(root);
        }
        if (toDeletePropTypes.size() > 0) {
            void var9_11;
            StringBuffer sbXML = new StringBuffer();
            int nObjects = toDeletePropTypes.size();
            boolean bl = false;
            while (var9_11 < nObjects) {
                PropertyType oObject = (PropertyType)toDeletePropTypes.get((int)var9_11);
                if (oObject != null) {
                    sbXML.append("<");
                    sbXML.append(oObject.getCMetadataType());
                    sbXML.append(" Id=\"");
                    sbXML.append(oObject.getFQID());
                    sbXML.append("\" Name=\"\" Desc=\"\" LockedBy = \"\" ChangeState=\"\" ><TypedProperties/>");
                    sbXML.append("</");
                    sbXML.append(oObject.getCMetadataType());
                    sbXML.append(">");
                }
                ++var9_11;
            }
            try {
                MetadataUtil.getMetadataObjects(store, sbXML.toString(), "", 256);
            }
            catch (MdException eMeta) {
                eMeta.printStackTrace();
            }
            for (PropertyType propertyType : toDeletePropTypes) {
                AssociationList objects = propertyType.getTypedProperties();
                boolean deleteObject = true;
                Iterator objI = objects.iterator();
                while (objI.hasNext() && deleteObject) {
                    CMetadata fobject = (CMetadata)objI.next();
                    if (objectsToDelete.contains(fobject)) continue;
                    deleteObject = false;
                }
                if (!deleteObject) continue;
                objectsToDelete.add(propertyType);
            }
        }
        for (CMetadata cMetadata : objectsToDelete) {
            cMetadata.delete();
        }
    }

    public static void copyEntityToNewObject(Root sourceObject, Root targetObject) throws MdException {
        Entity newEntity = new Entity();
        String newKey = newEntity.getEntityKey();
        MdOMAEntityUtility.populateEntityFromOMRObject((RemoteEntityInterface)newEntity, sourceObject);
        if (!newEntity.getEntityKey().equals(newKey)) {
            newEntity.setEntityKey(newKey);
        }
        MdOMAEntityUtility.populateOMRObjectFromEntity(targetObject, (RemoteEntityInterface)newEntity);
    }

    public static synchronized void clearPropertyTypesForObjectRepository(Root sourceObject) {
        String repository = "A0000001." + sourceObject.getRepositoryID();
        if (propertyTypeMap.containsKey(repository)) {
            List returnValue = (List)propertyTypeMap.get(repository);
            if (returnValue != null && returnValue.size() > 0) {
                for (int i = 0; i < returnValue.size(); ++i) {
                    returnValue.remove(0);
                }
            }
            propertyTypeMap.remove(repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List getPropertyTypesForObjectRepository(Root sourceObject) throws MdException {
        String entityPropertyTypeXML = "<Group Name=\"Entity Property Types\">    <Members>       <PropertyType Name=\"Boolean\" SQLType=\"16\"/>       <PropertyType Name=\"Integer\" SQLType=\"4\"/>       <PropertyType Name=\"String\" SQLType=\"12\"/>       <PropertyType Name=\"Multi-line Text\" SQLType=\"-1\"/>       <PropertyType Name=\"Float\" SQLType=\"6\"/>       <PropertyType Name=\"Date\" SQLType=\"91\"/>       <PropertyType Name=\"Color\" SQLType=\"12\"/>       <PropertyType Name=\"File Name\" SQLType=\"12\"/>       <PropertyType Name=\"GenericString\" SQLType=\"12\"/>    </Members></Group>";
        String XMLSelect = "<XMLSelect search=\"Group[@Name='Entity Property Types']\"/>";
        String Template = "<Templates><Group><Members/></Group></Templates>";
        ArrayList returnValue = null;
        MdStore objectStore = sourceObject.getObjectStore();
        String repository = "A0000001." + sourceObject.getRepositoryID();
        if (propertyTypeMap.containsKey(repository)) {
            Root obj;
            returnValue = (ArrayList)propertyTypeMap.get(repository);
            if (returnValue != null && returnValue.size() > 0 && (obj = (Root)returnValue.get(0)).getName() != null) {
                return returnValue;
            }
        } else {
            propertyTypeMap.put(repository, returnValue);
        }
        boolean gotoServer = objectStore.isGoToServerForMetadata();
        try {
            objectStore.setGoToServerForMetadata(true);
            List groups = MetadataUtil.getMetadataObjectsSubset(objectStore, repository, "Group", 8588, XMLSelect + Template, false);
            if (groups != null && groups.size() > 0) {
                Group mygroup = (Group)groups.get(0);
                AssociationList members = mygroup.getMembers();
                returnValue = new ArrayList(10);
                returnValue.addAll(members);
                propertyTypeMap.put(repository, returnValue);
                ArrayList arrayList = returnValue;
                return arrayList;
            }
            MetadataUtil.ApplyXML(entityPropertyTypeXML, repository);
            List list = MdOMAEntityUtility.getPropertyTypesForObjectRepository(sourceObject);
            return list;
        }
        finally {
            objectStore.setGoToServerForMetadata(gotoServer);
        }
    }

    public static List getPropertyTypesForObjectRepositoryIDList(Root inObject) throws MdException {
        List objects = MdOMAEntityUtility.getPropertyTypesForObjectRepository(inObject);
        ArrayList<String> returnL = new ArrayList<String>(objects.size());
        for (Root object : objects) {
            returnL.add(object.getId());
        }
        return returnL;
    }

    public static PropertyType getGenericPropertyType(Root sourceObject) throws MdException {
        List propertyTypes = MdOMAEntityUtility.getPropertyTypesForObjectRepository(sourceObject);
        for (int i = propertyTypes.size() - 1; i >= 0; --i) {
            PropertyType propType = (PropertyType)propertyTypes.get(i);
            if (!propType.getName().equals(GENERIC_STRING)) continue;
            return propType;
        }
        return null;
    }

    private static List getRemoveObjectListFromStore(CMetadata deleteObject, String deleteTemplate) throws MdException {
        ArrayList<CMetadata> objectsToRemove = new ArrayList<CMetadata>();
        if (deleteTemplate != null && deleteTemplate.length() > 0) {
            Document doc = MetadataUtil.parseXML(deleteTemplate);
            Node firstNode = doc.getFirstChild();
            MdOMAEntityUtility.removeObjects(deleteObject, firstNode.getAttributes(), firstNode.getChildNodes(), objectsToRemove);
        }
        if (!objectsToRemove.contains(deleteObject)) {
            objectsToRemove.add(deleteObject);
        }
        return objectsToRemove;
    }

    private static void removeObjects(CMetadata metaObject, NamedNodeMap simpleNodeMap, NodeList removeNodeList, List outRemoveObjects) {
        MdOMAEntityUtility.doRemove(metaObject, removeNodeList, outRemoveObjects);
        if (!outRemoveObjects.contains(metaObject)) {
            outRemoveObjects.add(metaObject);
        }
    }

    private static void doRemove(CMetadata thisObject, NodeList thisNodeList, List outRemoveObjects) {
        int numChildLists = thisNodeList.getLength();
        for (int k = 0; k < numChildLists; ++k) {
            String nodeName;
            Node childnode = thisNodeList.item(k);
            if (childnode == null || (nodeName = childnode.getNodeName()) == null || nodeName.length() == 0 || nodeName.indexOf("#") > -1) continue;
            AssociationList associatedObjects = null;
            try {
                associatedObjects = thisObject.getMdObjectAssociation(nodeName);
            }
            catch (MdException mex) {
                mex.printStackTrace();
                continue;
            }
            if (associatedObjects != null) {
                for (int i = 0; i < associatedObjects.size(); ++i) {
                    CMetadata objectToRemove = (CMetadata)associatedObjects.get(i);
                    if (objectToRemove == null) continue;
                    if (childnode.hasChildNodes()) {
                        MdOMAEntityUtility.removeObjects(objectToRemove, childnode.getAttributes(), childnode.getChildNodes(), outRemoveObjects);
                        continue;
                    }
                    outRemoveObjects.add(objectToRemove);
                }
                continue;
            }
            if (!childnode.hasChildNodes()) continue;
            MdOMAEntityUtility.removeObjects(thisObject, childnode.getAttributes(), childnode.getChildNodes(), outRemoveObjects);
        }
    }

    static {
        ENTITY_PROPTYPES_MAP.put("Boolean", Boolean.TYPE.getName());
        ENTITY_PROPTYPES_MAP.put("Integer", Integer.TYPE.getName());
        ENTITY_PROPTYPES_MAP.put("String", String.class.getName());
        ENTITY_PROPTYPES_MAP.put("Multi-line Text", String.class.getName());
        ENTITY_PROPTYPES_MAP.put("Float", Float.TYPE.getName());
        ENTITY_PROPTYPES_MAP.put("Date", Date.class.getName());
        ENTITY_PROPTYPES_MAP.put("Color", String.class.getName());
        ENTITY_PROPTYPES_MAP.put("File Name", String.class.getName());
        ENTITY_PROPTYPES_MAP.put(GENERIC_STRING, String.class.getName());
    }
}

