/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata;

import com.sas.metadata.MdObjectFactory;
import com.sas.metadata.MdObjectStore;
import com.sas.metadata.MetadataUtil;
import com.sas.net.crypto.CipherInterface;
import com.sas.net.crypto.Crypto;
import com.sas.text.SASDateTimeFormat;
import com.sas.util.Encryption;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Util {
    private static final String CLIENT_BEGIN_TAG = "<Client>";
    private static final String CLIENT_END_TAG = "</Client>";
    private static final String SERVER_BEGIN_TAG = "<Server>";
    private static final String SERVER_END_TAG = "</Server>";
    private static String _defaultEncoding;
    private static PrintWriter outputWriter;
    private static PrintWriter logWriter;
    private static PrintWriter perfWriter;
    private static OutputStream outputStream;
    private static OutputStream logStream;
    private static OutputStream perfStream;
    private static String cryType;
    private static boolean _useOldEncryption;

    public static void setOutputToNull() {
        outputStream = new OutputStream(){

            @Override
            public void write(int bytes) {
            }
        };
        Util.setOutputStream(outputStream);
    }

    public static void setLogToNull() {
        logStream = new OutputStream(){

            @Override
            public void write(int bytes) {
            }
        };
        Util.setLogStream(logStream);
    }

    public static final boolean equals(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    public static final boolean equalsIgnoreCase(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equalsIgnoreCase(s2);
    }

    public static void setEncryptionTo913Technique(boolean value) {
        _useOldEncryption = value;
    }

    public static String encrypt(String input) {
        if (input != null) {
            if (_useOldEncryption) {
                return Util.safeEncrypt(input);
            }
            return Encryption.encrypt((String)input);
        }
        return null;
    }

    public static String decrypt(String input) {
        return Encryption.decrypt((String)input);
    }

    public static String safeEncrypt(String input) {
        String binaryEncrypted = Util.encryptString(input);
        if (binaryEncrypted == null) {
            return null;
        }
        byte[] expandedBinary = new byte[binaryEncrypted.length()];
        for (int i = 0; i < binaryEncrypted.length(); ++i) {
            expandedBinary[i] = (byte)binaryEncrypted.charAt(i);
        }
        String safeEncryption = Util.convertByteArrayToHexString(expandedBinary);
        return safeEncryption;
    }

    public static String safeDecrypt(String input) {
        if (input == null) {
            return null;
        }
        byte[] expandedBinary = Util.convertHexStringToByteArray(input);
        String ret = "";
        for (int i = 0; i < expandedBinary.length; ++i) {
            ret = ret + (char)expandedBinary[i];
        }
        ret = Util.decryptString(ret);
        return ret;
    }

    private static String encryptString(String intext) {
        String ret = null;
        try {
            Properties p = new Properties();
            Crypto sssss = Crypto.getCrypto((String)cryType, (Properties)p);
            CipherInterface ci = sssss.openCipher();
            byte[] inbytes = intext.getBytes();
            ByteArrayOutputStream outstr = new ByteArrayOutputStream(ci.getCipherTextLength(inbytes.length));
            ci.encrypt(inbytes, 0, inbytes.length, (OutputStream)outstr);
            byte[] outbytes = outstr.toByteArray();
            ret = "";
            for (int i = 0; i < outbytes.length; ++i) {
                ret = ret + (char)outbytes[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static String decryptString(String intext) {
        String ret = null;
        try {
            Properties p = new Properties();
            Crypto sssss = Crypto.getCrypto((String)cryType, (Properties)p);
            CipherInterface ci = sssss.openCipher();
            byte[] inbytes = new byte[intext.length()];
            for (int i = 0; i < intext.length(); ++i) {
                char c = intext.charAt(i);
                inbytes[i] = (byte)c;
            }
            ByteArrayInputStream instr = new ByteArrayInputStream(inbytes);
            byte[] result = new byte[ci.getMaxPlainTextLength(inbytes.length)];
            int returnLength = ci.decrypt((InputStream)instr, inbytes.length, result, 0);
            ret = new String(result, 0, returnLength);
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = null;
        }
        return ret;
    }

    public static byte[] convertHexStringToByteArray(String strValue) {
        byte[] byteArray = new byte[strValue.length() / 2];
        int byteIndex = 0;
        int length = strValue.length();
        byte[] charArray = strValue.getBytes();
        for (int index = 0; index < length; index += 2) {
            byteArray[byteIndex++] = Util.convertHexCharsToByte(charArray[index], charArray[index + 1]);
        }
        return byteArray;
    }

    protected static byte convertHexCharsToByte(byte leftChar, byte rightChar) {
        int result = 0;
        boolean negative = false;
        int digit = leftChar >= 65 ? leftChar - 65 + 10 : leftChar - 48;
        result = -digit;
        digit = rightChar >= 65 ? rightChar - 65 + 10 : rightChar - 48;
        result *= 16;
        result -= digit;
        if (negative) {
            return (byte)result;
        }
        return (byte)(-result);
    }

    public static String convertByteArrayToHexString(byte[] byteArray) {
        String returnValue = "";
        for (int index = 0; index < byteArray.length; ++index) {
            returnValue = returnValue + Util.getByteAsHexChar(byteArray[index], 1);
            returnValue = returnValue + Util.getByteAsHexChar(byteArray[index], 0);
        }
        return returnValue;
    }

    public static char getByteAsHexChar(int value, int index) {
        byte b = (byte)(value >> index * 4 & 0xF);
        char c = Character.forDigit(b, 16);
        if (c >= 'a' && c <= 'f') {
            c = (char)(c - 32);
        }
        return c;
    }

    public static double getSASDateTimeLongForDate(Date inDate) {
        long time = inDate.getTime();
        double SASDate = SASDateTimeFormat.javaDateToSASDateTime((long)(time -= (long)(Util.getRawOffset() + Util.getDSTOffset())));
        return SASDate;
    }

    public static double getSASDateLongForDate(Date inDate) {
        long time = inDate.getTime();
        double SASDate = SASDateTimeFormat.javaDateToSASDate((long)(time -= (long)(Util.getRawOffset() + Util.getDSTOffset())));
        return SASDate;
    }

    public static double getSASTimeLongForDate(Date inDate) {
        long time = inDate.getTime();
        double SASDate = SASDateTimeFormat.javaDateToSASTime((long)(time -= (long)Util.getRawOffset()));
        return SASDate;
    }

    public static String getFormattedDateStringForDoubleSASDateTimeString(String inDouble) {
        return Util.getFormattedDateStringForDoubleSASDateTimeString(inDouble, TimeZone.getTimeZone("GMT"));
    }

    public static String getFormattedDateStringForDoubleSASDateTimeString(String inDouble, TimeZone timezone) {
        if (inDouble.length() <= 0) {
            return inDouble;
        }
        try {
            if (timezone == null) {
                timezone = TimeZone.getTimeZone("GMT");
            }
            Date returnDate = Util.getDateForDoubleSASDateTimeString(inDouble);
            DateFormat format = DateFormat.getDateTimeInstance(2, 1, Locale.getDefault());
            format.setTimeZone(timezone);
            return format.format(returnDate);
        }
        catch (NumberFormatException exp) {
            exp.printStackTrace();
            return inDouble;
        }
    }

    public static String getFormattedDateStringForDoubleSASDateString(String inDouble) {
        return Util.getFormattedDateStringForDoubleSASDateString(inDouble, TimeZone.getTimeZone("GMT"));
    }

    public static String getFormattedDateStringForDoubleSASDateString(String inDouble, TimeZone timezone) {
        if (inDouble.length() <= 0) {
            return inDouble;
        }
        try {
            if (timezone == null) {
                timezone = TimeZone.getTimeZone("GMT");
            }
            Date returnDate = Util.getDateForDoubleSASDateString(inDouble);
            DateFormat format = DateFormat.getDateTimeInstance(2, 1, Locale.getDefault());
            format.setTimeZone(timezone);
            return format.format(returnDate);
        }
        catch (NumberFormatException exp) {
            exp.printStackTrace();
            return inDouble;
        }
    }

    public static String getFormattedDateStringForDoubleSASTimeString(String inDouble) {
        return Util.getFormattedDateStringForDoubleSASTimeString(inDouble, TimeZone.getTimeZone("GMT"));
    }

    public static String getFormattedDateStringForDoubleSASTimeString(String inDouble, TimeZone timezone) {
        if (inDouble.length() <= 0) {
            return inDouble;
        }
        try {
            if (timezone == null) {
                timezone = TimeZone.getTimeZone("GMT");
            }
            double myDate = Double.parseDouble(inDouble);
            long javadate = SASDateTimeFormat.SASTimeToJavaDate((double)myDate);
            Date returnDate = new Date(javadate += (long)Util.getRawOffset());
            DateFormat format = DateFormat.getDateTimeInstance(2, 1, Locale.getDefault());
            format.setTimeZone(timezone);
            return format.format(returnDate);
        }
        catch (NumberFormatException exp) {
            exp.printStackTrace();
            return inDouble;
        }
    }

    public static Date getDateForDoubleSASDateTimeString(String inSASDateTimeDoubleString) throws NumberFormatException {
        double myDate = Double.parseDouble(inSASDateTimeDoubleString);
        long javadate = SASDateTimeFormat.SASDateTimeToJavaDate((double)myDate);
        Date returnDate = new Date(javadate += (long)(Util.getRawOffset() + Util.getDSTOffset()));
        return returnDate;
    }

    public static Date getDateForDoubleSASDateString(String inSASDateDoubleString) throws NumberFormatException {
        double myDate = Double.parseDouble(inSASDateDoubleString);
        long javadate = SASDateTimeFormat.SASDateToJavaDate((double)myDate);
        Date returnDate = new Date(javadate += (long)(Util.getRawOffset() + Util.getDSTOffset()));
        return returnDate;
    }

    public static String getDoubleStringForDouble(double inValue) throws NumberFormatException {
        DecimalFormat numberFormat = new DecimalFormat("#.##");
        return numberFormat.format(inValue);
    }

    private static int getDSTOffset() {
        Calendar cal = Calendar.getInstance();
        return cal.get(16);
    }

    private static int getRawOffset() {
        return TimeZone.getDefault().getRawOffset();
    }

    public static void dumpEnvironment() {
        Util.dumpEnvironment(System.out);
    }

    public static void dumpEnvironment(PrintStream x) {
        Properties props = System.getProperties();
        Enumeration<?> propNames = props.propertyNames();
        int i = 0;
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propValue = props.getProperty(propName);
            x.println(propName + "=" + propValue);
            if (++i != 5) continue;
            x.println("");
            i = 0;
        }
    }

    public static String createStringForNode(Node node) {
        return Util.createStringForNode(node, true);
    }

    public static String createStringForNode(Node node, boolean omitXMLDeclarationInOutput) {
        String string = null;
        if (node != null) {
            try {
                DOMSource domSource = new DOMSource(node);
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                if (omitXMLDeclarationInOutput) {
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                }
                transformer.transform(domSource, streamResult);
                string = stringWriter.toString();
            }
            catch (Exception e) {
                string = null;
            }
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static synchronized void println(String inString, PrintWriter printer, OutputStream outStream) {
        if (inString == null) {
            return;
        }
        try {
            if (outStream == null) {
                System.out.println(inString);
                return;
            }
            if (printer == null) {
                printer = new PrintWriter(outStream, true);
            }
            printer.println(inString);
            printer.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void printOutputln(String inString) {
        if (MdObjectFactory.getInstance().getDebug()) {
            Util.println(inString, outputWriter, Util.getOutputStream());
        }
    }

    public static synchronized void printPerfln(String inString) {
        if (MdObjectFactory.getInstance().getPerf()) {
            Util.println(inString, perfWriter, Util.getPerfStream());
        }
    }

    public static synchronized void printLogln(String inString) {
        if (MdObjectFactory.getInstance().getLoggingEnabled()) {
            Util.println(inString, logWriter, Util.getLogStream());
        }
    }

    public static void printLoglnClient(Document doc) {
        if (MdObjectFactory.getInstance().getLoggingEnabled()) {
            Document myDoc = doc;
            Util.printLoglnClientDoc(myDoc);
        }
    }

    public static void printLoglnClient(String inString) {
        if (MdObjectFactory.getInstance().getLoggingEnabled()) {
            String myString = inString;
            StringBuffer myBuf = new StringBuffer(myString == null ? 17 : myString.length() + 17);
            myBuf.append(CLIENT_BEGIN_TAG);
            myBuf.append(myString);
            myBuf.append(CLIENT_END_TAG);
            Util.printLogln(MetadataUtil.formatXML(myBuf.toString()));
        }
    }

    public static void printLoglnServer(String inString) {
        if (MdObjectFactory.getInstance().getLoggingEnabled()) {
            String myString = inString;
            StringBuffer myBuf = new StringBuffer(myString == null ? 17 : myString.length() + 17);
            myBuf.append(SERVER_BEGIN_TAG);
            myBuf.append(myString);
            myBuf.append(SERVER_END_TAG);
            Util.printLogln(MetadataUtil.formatXML(myBuf.toString()));
        }
    }

    public static void printLoglnServer(Document doc) {
        if (MdObjectFactory.getInstance().getLoggingEnabled()) {
            Document myDoc = doc;
            Util.printLoglnServerDoc(myDoc);
        }
    }

    public static void printLoglnClientDoc(Document doc) {
        StringBuffer output = new StringBuffer();
        output.append(CLIENT_BEGIN_TAG);
        output.append(Util.createStringForNode(doc));
        output.append(CLIENT_END_TAG);
        Util.printLogln(MetadataUtil.formatXML(output.toString()));
    }

    public static void printLoglnServerDoc(Document doc) {
        StringBuffer output = new StringBuffer();
        output.append(SERVER_BEGIN_TAG);
        output.append(Util.createStringForNode(doc));
        output.append(SERVER_END_TAG);
        Util.printLogln(MetadataUtil.formatXML(output.toString()));
    }

    public static void printLogln(Document doc) {
        String output = Util.createStringForNode(doc);
        Util.printLogln(MetadataUtil.formatXML(output));
    }

    public static void setDefaultEncoding(String encoding) {
        _defaultEncoding = encoding;
    }

    public static void setOutputStream(OutputStream output) {
        Util.setOutputStream(output, null);
    }

    public static void setOutputStream(OutputStream output, String encoding) {
        outputStream = null;
        if (output != null) {
            outputStream = new BufferedOutputStream(output);
            try {
                outputWriter = encoding != null && encoding.length() > 0 ? new PrintWriter((Writer)new OutputStreamWriter(outputStream, encoding), true) : (_defaultEncoding != null && _defaultEncoding.length() > 0 ? new PrintWriter((Writer)new OutputStreamWriter(outputStream, _defaultEncoding), true) : new PrintWriter(outputStream, true));
            }
            catch (UnsupportedEncodingException e) {
                outputWriter = new PrintWriter(outputStream, true);
            }
        }
    }

    public static void setPerfStream(OutputStream output) {
        Util.setPerfStream(output, null);
    }

    public static void setPerfStream(OutputStream output, String encoding) {
        perfStream = null;
        if (output != null) {
            perfStream = new BufferedOutputStream(output);
            try {
                perfWriter = encoding != null && encoding.length() > 0 ? new PrintWriter((Writer)new OutputStreamWriter(perfStream, encoding), true) : (_defaultEncoding != null && _defaultEncoding.length() > 0 ? new PrintWriter((Writer)new OutputStreamWriter(perfStream, _defaultEncoding), true) : new PrintWriter(perfStream, true));
            }
            catch (UnsupportedEncodingException e) {
                perfWriter = new PrintWriter(perfStream, true);
            }
        }
    }

    public static void setLogStream(OutputStream output) {
        Util.setLogStream(output, null);
    }

    public static void setLogStream(OutputStream output, String encoding) {
        logStream = null;
        if (output != null) {
            logStream = new BufferedOutputStream(output);
            try {
                logWriter = encoding != null && encoding.length() > 0 ? new PrintWriter((Writer)new OutputStreamWriter(logStream, encoding), true) : (_defaultEncoding != null && _defaultEncoding.length() > 0 ? new PrintWriter((Writer)new OutputStreamWriter(logStream, _defaultEncoding), true) : new PrintWriter(logStream, true));
            }
            catch (UnsupportedEncodingException e) {
                logWriter = new PrintWriter(logStream, true);
            }
        }
    }

    public static OutputStream getOutputStream() {
        return outputStream;
    }

    public static OutputStream getPerfStream() {
        return perfStream;
    }

    public static OutputStream getLogStream() {
        return logStream;
    }

    public static void printStackTrace() {
        try {
            throw new Throwable();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
    }

    public static void printStackTrace(Throwable e) {
        try {
            if (MdObjectFactory.getInstance().getDebug()) {
                if (outputWriter == null || Util.getOutputStream() == null) {
                    OutputStream output = Util.getOutputStream();
                    if (output == null) {
                        e.printStackTrace();
                        return;
                    }
                    if (outputWriter == null) {
                        outputWriter = new PrintWriter(output);
                        e.printStackTrace(outputWriter);
                        return;
                    }
                }
                e.printStackTrace(outputWriter);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void printMdObjectStore(MdObjectStore instore) {
        if (instore != null && instore.getDetailObjectMap() != null) {
            StringBuffer outString = new StringBuffer();
            outString.append("<MdObjectStore Address=\"");
            outString.append(instore);
            outString.append("\">");
            outString.append(instore.createXMLforStore());
            outString.append("</MdObjectStore>");
            Util.printOutputln(MetadataUtil.formatXML(outString.toString()));
        }
    }

    public static Constructor findValidConstructor(Class cls, Class[] aParms) throws NoSuchMethodException {
        try {
            return cls.getConstructor(aParms);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Constructor<?>[] aConstructors = cls.getConstructors();
        int nConstructors = aConstructors.length;
        int nParms = aParms.length;
        block3: for (int iConstructor = 0; iConstructor < nConstructors; ++iConstructor) {
            Class<?>[] aFormalParms = aConstructors[iConstructor].getParameterTypes();
            if (aFormalParms.length != nParms) continue;
            boolean bMatch = true;
            for (int iParm = 0; iParm < nParms; ++iParm) {
                if (!aFormalParms[iParm].isAssignableFrom(aParms[iParm])) {
                    bMatch = false;
                    continue block3;
                }
                if (!bMatch) continue;
                return aConstructors[iConstructor];
            }
        }
        throw new NoSuchMethodException();
    }

    public static Method findValidMethods(Class cls, String sMethod, Class[] aParms) throws NoSuchMethodException {
        try {
            return cls.getMethod(sMethod, aParms);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Method[] aMethods = cls.getMethods();
        int nMethods = aMethods.length;
        int nParms = aParms.length;
        block3: for (int iMethod = 0; iMethod < nMethods; ++iMethod) {
            Class<?>[] aFormalParms = aMethods[iMethod].getParameterTypes();
            if (!aMethods[iMethod].getName().equals(sMethod) || aFormalParms.length != nParms) continue;
            boolean bMatch = true;
            for (int iParm = 0; iParm < nParms; ++iParm) {
                if (!aFormalParms[iParm].isAssignableFrom(aParms[iParm])) {
                    bMatch = false;
                    continue block3;
                }
                if (!bMatch) continue;
                return aMethods[iMethod];
            }
        }
        throw new NoSuchMethodException();
    }

    public static void main(String[] args) {
        String start = "heABCDEFGHLKJSOIJWERLKWJ LDSFJ SF SAFSF person ";
        for (int j = 0; j < 20; ++j) {
            System.out.println(start);
            String r = Util.safeEncrypt(start);
            System.out.println(r);
            String t = Util.safeDecrypt(r);
            System.out.println(t);
            if (t != null) {
                System.out.println(" compare gives                         RESULT:" + start.compareTo(t));
            } else {
                System.out.println("ERROR:  NULL return from decrypt       ERROR!");
            }
            start = start + "a";
        }
    }

    static {
        outputWriter = null;
        logWriter = null;
        perfWriter = null;
        outputStream = null;
        logStream = null;
        perfStream = null;
        cryType = "SASPROPRIETARY";
        _useOldEncryption = false;
    }
}

