/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata;

import com.sas.metadata.AssociationList;
import com.sas.metadata.CMetadata;
import com.sas.metadata.MapPool;
import com.sas.metadata.MdEvent;
import com.sas.metadata.MdException;
import com.sas.metadata.MdFactory;
import com.sas.metadata.MdFactoryEvent;
import com.sas.metadata.MdObjectFactory;
import com.sas.metadata.MdObjectListener;
import com.sas.metadata.MdServerStore;
import com.sas.metadata.MdStore;
import com.sas.metadata.MdStoreIDChangeListener;
import com.sas.metadata.MdStoreListener;
import com.sas.metadata.MdStoreUtil;
import com.sas.metadata.MetadataObjects;
import com.sas.metadata.MetadataUtil;
import com.sas.metadata.MetadataWorkspace;
import com.sas.metadata.Root;
import com.sas.metadata.Util;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MdObjectStore
implements MetadataObjects,
MdStore,
MdObjectListener,
MdStoreListener {
    private volatile boolean _write_lock = false;
    protected Map ObjectMap;
    protected Map deletedObjects;
    private MdFactory m_factory = null;
    protected EventListenerList MdStoreListenerList = new EventListenerList();
    protected EventListenerList MdObjectListenerList = new EventListenerList();
    protected EventListenerList MdStoreIDChangeListenerList = new EventListenerList();
    private MdStore OwningStore;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    protected Vector changeList = new Vector();
    protected String projectReposID = "";
    protected String newObjectReposID = "";
    protected List createdItems = new ArrayList(5);
    protected boolean goToServerForMetadata = true;
    protected boolean IsObjectCopiedFromParentOnCreation = true;
    protected StringBuffer writeBuffer = new StringBuffer();
    protected List childStores = Collections.synchronizedList(new ArrayList(5));
    protected String storeName = null;
    private boolean _refreshingObjects = false;
    private boolean _deepCopyObjects = true;

    public MdObjectStore(MdStore owningStore, MdFactory OwningFactory) {
        this(owningStore, OwningFactory, null);
    }

    public MdObjectStore(MdStore owningStore, MdFactory OwningFactory, String NameOfStore) {
        this();
        this.OwningStore = owningStore;
        owningStore.addMdStoreListener(this);
        owningStore.addChildStore(this);
        this.m_factory = OwningFactory;
        if (NameOfStore != null && NameOfStore.length() > 0) {
            this.storeName = NameOfStore;
        }
        this.setGoToServerForMetadata(owningStore.isGoToServerForMetadata());
        if (this.m_factory.getDebug()) {
            Util.printOutputln("DEBUG NOTE: Creating MdObjectStore..." + this);
        }
    }

    private MdObjectStore() {
        LinkedHashMap oMap = new LinkedHashMap();
        this.ObjectMap = Collections.synchronizedMap(oMap);
        HashMap dMap = new HashMap();
        this.deletedObjects = Collections.synchronizedMap(dMap);
    }

    @Override
    public MdFactory getFactory() {
        return this.m_factory;
    }

    public boolean getIsObjectCopiedFromParentOnCreation() {
        return this.IsObjectCopiedFromParentOnCreation;
    }

    public void setIsObjectCopiedFromParentOnCreation(boolean inValue) {
        this.IsObjectCopiedFromParentOnCreation = inValue;
    }

    @Override
    public int getStoreType() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updatedMetadataAll() throws MdException {
        Vector changelist = this.getChangeList();
        if (changelist.size() > 0) {
            CMetadata firstObject = (CMetadata)changelist.get(0);
            firstObject.updateMetadataAll();
        } else if (this.deletedObjects.size() > 0) {
            Map map = this.deletedObjects;
            synchronized (map) {
                Object[] keys = this.deletedObjects.keySet().toArray();
                if (keys.length > 0) {
                    CMetadata firstObject;
                    String firstKey = null;
                    for (int i = 0; i < keys.length && firstKey == null; ++i) {
                        firstKey = (String)keys[i];
                    }
                    if (firstKey != null && (firstObject = (CMetadata)this.deletedObjects.get(firstKey)) != null) {
                        firstObject.updateMetadataAll();
                    }
                }
            }
        }
    }

    public String getProjectRepositoryID() {
        return this.projectReposID;
    }

    public void setProjectRepositoryID(String projReposID) {
        this.projectReposID = new String(projReposID);
    }

    public String getNewObjectRepositoryID() {
        return this.newObjectReposID;
    }

    public void setNewObjectRepositoryID(String newObjReposID) {
        this.newObjectReposID = new String(newObjReposID);
    }

    @Override
    public void setOwningStore(MdStore parent) {
        this.OwningStore = parent;
    }

    @Override
    public MdStore getOwningStore() {
        return this.OwningStore;
    }

    public Map getDeletedObjects() {
        return this.deletedObjects;
    }

    public boolean isDeepCopyObjects() {
        return this._deepCopyObjects;
    }

    public void setDeepCopyObjects(boolean copy) {
        this._deepCopyObjects = copy;
    }

    @Override
    public boolean getIsGoToServerForMetadata() {
        return this.isGoToServerForMetadata();
    }

    @Override
    public void setIsGotToServerForMetadata(boolean goToServer) {
        this.setGoToServerForMetadata(goToServer);
    }

    @Override
    public void setGoToServerForMetadata(boolean goToServer) {
        this.goToServerForMetadata = goToServer;
    }

    @Override
    public boolean isGoToServerForMetadata() {
        return this.goToServerForMetadata;
    }

    protected boolean isRefreshingObjects() {
        return this._refreshingObjects;
    }

    @Override
    public boolean isDisposed() {
        return this.ObjectMap == null && this.m_factory == null;
    }

    public Map getSimpleObjectMap() {
        MdObjectFactory cfr_ignored_0 = (MdObjectFactory)this.m_factory;
        Map returnHash = MdObjectFactory.getSimpleObjectMap();
        return returnHash;
    }

    @Override
    public Map getDetailObjectMap() {
        return this.ObjectMap;
    }

    public void deleteComplexMetadataObject(CMetadata oDelete) {
    }

    @Override
    public void createExternalIdentityObject(CMetadata owningObject) {
        ((Root)owningObject).setChangeState("");
    }

    public void deleteDetailMetadataObject(String strFQID) {
        CMetadata delobject = (CMetadata)this.ObjectMap.get(strFQID);
        if (delobject != null) {
            ArrayList<String> items = new ArrayList<String>(1);
            items.add(strFQID);
            this.fireMdObjectsRemoved(new MdEvent(delobject, this), items);
            delobject.dispose();
        }
        this.ObjectMap.put(strFQID, null);
        this.ObjectMap.remove(strFQID);
        delobject = null;
    }

    @Override
    public String makeID(String shortID) {
        MdObjectFactory cfr_ignored_0 = (MdObjectFactory)this.m_factory;
        return MdObjectFactory.makeID(shortID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpDetailHashMap() {
        if (this.isDisposed()) {
            return;
        }
        Object object = this.ObjectMap;
        synchronized (object) {
            Collection values = this.ObjectMap.values();
            if (values.size() == 0) {
                Util.printOutputln("    DEBUG GOOD NEWS:  Object Store is empty, object=" + this.toString());
                return;
            }
            Util.printOutputln("    DEBUG BAD NEWS:  Object Store is not empty! object=" + this.toString());
            for (CMetadata object2 : values) {
                Util.printOutputln("      Object type=" + object2.getCMetadataType() + " id=" + object2.getId());
            }
        }
        object = this.childStores;
        synchronized (object) {
            for (MdStore cStore : this.childStores) {
                if (cStore.getStoreType() != 1) continue;
                ((MdObjectStore)cStore).dumpDetailHashMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object[] listeners;
        int i;
        if (this.isDisposed()) {
            Util.printOutputln("DEBUG NOTE: MdObjectStore Dispose alread called...." + this.toString());
            return;
        }
        Util.printOutputln("DEBUG NOTE: Destroying MdObjectStore..." + this.toString());
        List list = this.childStores;
        synchronized (list) {
            for (i = this.childStores.size(); i > 0; --i) {
                MdStore cStore = (MdStore)this.childStores.get(i - 1);
                cStore.dispose();
            }
        }
        this.childStores = null;
        this.deletedObjects = null;
        if (this.MdObjectListenerList != null) {
            listeners = this.MdObjectListenerList.getListenerList();
            for (i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MdObjectListener.class) continue;
                this.removeMdObjectListener((MdObjectListener)listeners[i + 1]);
            }
            this.MdObjectListenerList = null;
        }
        if (this.MdStoreListenerList != null) {
            listeners = this.MdStoreListenerList.getListenerList();
            for (i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MdStoreListener.class) continue;
                this.removeMdStoreListener((MdStoreListener)listeners[i + 1]);
            }
            this.MdStoreListenerList = null;
        }
        if (this.MdStoreIDChangeListenerList != null) {
            listeners = this.MdStoreIDChangeListenerList.getListenerList();
            for (i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MdStoreIDChangeListener.class) continue;
                this.removeMdStoreIDChangeListener((MdStoreIDChangeListener)listeners[i + 1]);
            }
            this.MdStoreIDChangeListenerList = null;
        }
        if (this.vetos != null) {
            VetoableChangeListener[] vetoLs = this.vetos.getVetoableChangeListeners();
            for (i = vetoLs.length; i > 0; --i) {
                this.vetos.removeVetoableChangeListener(vetoLs[i - 1]);
            }
            this.vetos = null;
        }
        if (this.OwningStore != null && !this.OwningStore.isDisposed()) {
            if (this.OwningStore.getStoreType() == 0) {
                ((MdServerStore)this.OwningStore).removeMdStoreListener(this);
                ((MdServerStore)this.OwningStore).removeStore(this);
            } else if (this.OwningStore.getStoreType() == 1) {
                ((MdObjectStore)this.OwningStore).removeMdStoreListener(this);
                ((MdObjectStore)this.OwningStore).removeStore(this);
            }
        }
        if (this.changeList != null && this.changeList.size() > 0) {
            this.changeList.clear();
        }
        this.changeList = null;
        if (this.createdItems != null && this.createdItems.size() > 0) {
            this.createdItems.clear();
        }
        this.createdItems = null;
        this.m_factory = null;
        if (this.ObjectMap != null) {
            this.ObjectMap = null;
        }
        this.OwningStore = null;
        this.newObjectReposID = null;
        this.projectReposID = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushUpdates(List updatedItems) {
        Map map = this.ObjectMap;
        synchronized (map) {
            for (String objectId : this.ObjectMap.keySet()) {
                CMetadata updatedObject = this.getObject(objectId, true);
                if (updatedObject == null || this.OwningStore.getStoreType() == 0 && !MdObjectFactory.getServerStore().isObjectInServerStore(objectId)) continue;
                updatedObject.resetObject();
                MdStoreUtil.refreshMetaObject((MdStore)this, this.getOwningStore(), objectId);
            }
        }
        if (this.OwningStore.getStoreType() == 0) {
            LinkedHashMap<String, String> objectMap = new LinkedHashMap<String, String>(10);
            ArrayList<String> createdObjects = new ArrayList<String>(10);
            for (String objectID : this.createdItems) {
                if (objectID.indexOf(36) > -1 || createdObjects.contains(objectID)) continue;
                createdObjects.add(objectID);
                CMetadata updatedObject = this.getObject(objectID, true);
                if (updatedObject == null) continue;
                objectMap.put(objectID, updatedObject.getCMetadataType());
            }
            if (createdObjects.size() > 0) {
                MdObjectFactory.fireMdObjectsCreated(new MdEvent(this, this), createdObjects);
                if (objectMap.size() > 0) {
                    MdObjectFactory.fireMdObjectsCreated(new MdFactoryEvent(this.m_factory, objectMap));
                }
            }
        }
        MdEvent ce = new MdEvent(this, this);
        ArrayList idList = new ArrayList(this.ObjectMap.keySet());
        List list = this.childStores;
        synchronized (list) {
            for (MdObjectStore cStore : this.childStores) {
                cStore.MdObjectsModified(ce, idList);
            }
        }
        idList = null;
        ce = null;
        this.OwningStore.removeMdStoreListener(this);
        if (this.OwningStore.getStoreType() == 0) {
            ((MdServerStore)this.OwningStore).flushUpdates(this, updatedItems);
        } else {
            this.OwningStore.flushUpdates(updatedItems);
        }
        this.OwningStore.addMdStoreListener(this);
        this.createdItems.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushUpdatesToParentStore() {
        this.getOwningStore().removeMdStoreListener(this);
        ArrayList<String> UpdatedIDs = new ArrayList<String>(10);
        Map map = this.ObjectMap;
        synchronized (map) {
            for (String id : this.ObjectMap.keySet()) {
                CMetadata updatedObject = this.getObject(id, true);
                if (updatedObject == null) continue;
                MdStoreUtil.refreshMetaObject((MdStore)this, this.getOwningStore(), id);
                UpdatedIDs.add(id);
            }
        }
        for (CMetadata changeListObject : this.changeList) {
            String fqid = changeListObject.getId();
            CMetadata parentObject = null;
            if (this.OwningStore.getStoreType() == 1) {
                parentObject = ((MdObjectStore)this.OwningStore).getObject(fqid, true);
            } else if (this.OwningStore.getStoreType() == 0) {
                parentObject = ((MdServerStore)this.OwningStore).getObject(fqid, true);
            }
            if (parentObject == null || parentObject.getChangeList().contains(parentObject)) continue;
            parentObject.addElementToChangeList(parentObject);
        }
        if (this.OwningStore.getStoreType() == 1) {
            for (String id : this.deletedObjects.keySet()) {
                CMetadata parentObject = ((MdObjectStore)this.OwningStore).getObject(id, true);
                if (parentObject == null) continue;
                this.OwningStore.deleteObject(parentObject);
                ((MdObjectStore)this.OwningStore).removeElementFromStore(parentObject);
            }
        }
        this.getOwningStore().fireMdObjectsModified(new MdEvent(this, this), UpdatedIDs);
        this.clearChangeList();
        this.getOwningStore().addMdStoreListener(this);
    }

    public void removeStore(MdStore childStore) {
        this.removeChildStore(childStore);
    }

    public CMetadata getObject(String strFQID, boolean hashonly) {
        if (hashonly) {
            if (this.ObjectMap == null) {
                return null;
            }
            CMetadata tempHashObject = (CMetadata)this.ObjectMap.get(strFQID);
            if (tempHashObject != null && this.deletedObjects != null && this.deletedObjects.containsKey(strFQID)) {
                return null;
            }
            return tempHashObject;
        }
        return this.getObject(strFQID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CMetadata getObject(String strFQID) {
        if (this.ObjectMap == null) {
            return null;
        }
        if (this.deletedObjects != null && this.deletedObjects.containsKey(strFQID)) {
            return null;
        }
        CMetadata tempHashObject = (CMetadata)this.ObjectMap.get(strFQID);
        if (tempHashObject == null) {
            CMetadata parentObject = null;
            parentObject = this.OwningStore.getStoreType() == 0 ? ((MdServerStore)this.OwningStore).getObjectFromServerStoreOnly(strFQID) : this.OwningStore.getObject(strFQID);
            if (parentObject != null) {
                if (this.OwningStore.getStoreType() == 0) {
                    Util.printOutputln("Copying object from server store to object store: " + parentObject);
                    MdStoreUtil.copyMetaObject((MdServerStore)this.OwningStore, this, strFQID);
                } else if (this.OwningStore.getStoreType() == 1) {
                    MdStoreUtil.copyMetaObject((MdObjectStore)this.OwningStore, this, strFQID);
                }
                tempHashObject = (CMetadata)this.ObjectMap.get(strFQID);
            }
        } else {
            if (this.deletedObjects != null && this.deletedObjects.containsKey(strFQID)) {
                return null;
            }
            if ((tempHashObject.getState() & 4) > 0 && !this._refreshingObjects && !tempHashObject.isNewObject()) {
                try {
                    this._refreshingObjects = true;
                    this.refreshObjectFromServer(tempHashObject, true, true);
                }
                catch (MdException e) {
                    Util.printOutputln("DEBUG NOTE: Error refreshing object: Object type=" + tempHashObject.getCMetadataType() + " id=" + tempHashObject.getId());
                }
                finally {
                    this._refreshingObjects = false;
                }
            }
        }
        return tempHashObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeHashKey(String strOldId, String strNewId) {
        Object object = this.ObjectMap.get(strOldId);
        ArrayList<String> itemsOld = new ArrayList<String>(1);
        ArrayList<String> itemsNew = new ArrayList<String>(1);
        if (object != null) {
            this.ObjectMap.remove(strOldId);
            itemsOld.add(strOldId);
            this.fireMdObjectsRemoved(new MdEvent(object, this), itemsOld);
            itemsNew.add(strNewId);
            ((CMetadata)object).setFQID(strNewId);
            this.ObjectMap.put(strNewId, object);
            this.fireMdObjectsAdded(new MdEvent(object, this), itemsNew);
            if (((CMetadata)object).getFQID().equalsIgnoreCase(strOldId)) {
                ((CMetadata)object).setFQID(strNewId);
            }
            ((CMetadata)object).updateAssnsIds(strOldId, strNewId);
        }
        if (strOldId != null && strOldId.indexOf(36) > 0) {
            ArrayList<String> created = new ArrayList<String>(1);
            created.add(strNewId);
            this.fireMdObjectsAdded(new MdEvent(this.m_factory, this), created);
            if (!this.createdItems.contains(strNewId)) {
                this.createdItems.add(strNewId);
            } else {
                Util.printOutputln("DEBUG: Duplicate object changed...");
            }
        }
        List list = this.childStores;
        synchronized (list) {
            for (MdStore cStore : this.childStores) {
                if (cStore.getStoreType() != 1) continue;
                ((MdObjectStore)cStore).changeHashKey(strOldId, strNewId);
            }
        }
        if (strOldId != null && strNewId != null && object != null) {
            this.fireMdStoreIDChange(new MdEvent(this, this), itemsOld, itemsNew);
        }
    }

    public void removeElementFromStore(CMetadata removeObject) {
        this.removeElementFromStore(removeObject, ((MdObjectFactory)this.m_factory).getRemoveDependentObjects());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElementFromStore(CMetadata removeObject, boolean removeDependents) {
        CMetadata storeRemoveObject;
        if (removeObject != null && (storeRemoveObject = (CMetadata)this.ObjectMap.get(removeObject.getId())) != null) {
            ArrayList<CMetadata> requiredObjectsToDelete = null;
            Map<String, AssociationList> assnMap = removeObject.getPopulatedAssocs();
            for (String nameOflist : assnMap.keySet()) {
                AssociationList list = assnMap.get(nameOflist);
                if (list == null) continue;
                try {
                    if (removeDependents && removeObject.isNewObject()) {
                        Vector ids = list.getObjectIDs();
                        for (int i = 0; i < ids.size(); ++i) {
                            CMetadata meta;
                            String id = (String)ids.get(i);
                            AssociationList oppositeSideAssoc = list.getOppositeAssn(id);
                            if (oppositeSideAssoc == null || !oppositeSideAssoc.getIsRequired() || oppositeSideAssoc.size() != 1 || (meta = (CMetadata)this.ObjectMap.get(id)) == null || !meta.isNewObject()) continue;
                            if (requiredObjectsToDelete == null) {
                                requiredObjectsToDelete = new ArrayList<CMetadata>();
                            }
                            requiredObjectsToDelete.add(meta);
                        }
                    }
                    list.removeAllElements(false);
                }
                catch (MdException e) {
                    Util.printOutputln(e.getLocalizedMessage());
                    e.printStackTrace();
                }
            }
            MapPool.instance();
            MapPool.returnMap(assnMap);
            assnMap = null;
            this.ObjectMap.remove(removeObject.getFQID());
            List iter = this.childStores;
            synchronized (iter) {
                for (MdStore cStore : this.childStores) {
                    if (cStore.getStoreType() != 1) continue;
                    ((MdObjectStore)cStore).removeElementFromStore(((MdObjectStore)cStore).getObject(removeObject.getFQID(), true));
                }
            }
            this.removeElementFromChangeList(storeRemoveObject);
            storeRemoveObject = null;
            if (requiredObjectsToDelete != null) {
                int size = requiredObjectsToDelete.size();
                for (int i = 0; i < size; ++i) {
                    CMetadata meta = (CMetadata)requiredObjectsToDelete.get(i);
                    if (this.m_factory.getDebug()) {
                        Util.printOutputln("DEBUG NOTE: Removing dependent object from store - " + meta.getCMetadataType() + " (" + meta.getName() + ")");
                    }
                    this.removeElementFromStore(meta, removeDependents);
                }
            }
        }
    }

    @Override
    public void updateChangeListObjectIDs(String OldReposID, String NewReposID) {
        this.updateChangeListObjectIDs(OldReposID, NewReposID, null);
    }

    @Override
    public void updateChangeListObjectIDs(String OldReposID, String NewReposID, String targetReposID) {
        for (Root changeObject : this.changeList) {
            String changeObjectsID = changeObject.getFQID();
            String newID = null;
            if (!changeObjectsID.startsWith(OldReposID)) continue;
            newID = NewReposID + "." + changeObjectsID.substring(9, 17);
            MdObjectFactory cfr_ignored_0 = (MdObjectFactory)this.m_factory;
            MdObjectFactory.changeHashKey(changeObjectsID, newID);
        }
    }

    public void refreshObjects(List items) {
        this.refreshObjects(this.getOwningStore(), items);
    }

    protected void refreshObjects(MdStore sourceStore, List items) {
        if (sourceStore == null) {
            sourceStore = this.getOwningStore();
        }
        for (String objectID : items) {
            MdStoreUtil.refreshMetaObject(sourceStore, (MdStore)this, objectID);
            CMetadata changedObject = this.getObject(objectID, true);
            if (changedObject == null) continue;
            changedObject.removeMdObjectListener(this);
            changedObject.fireMdObjectModified(new MdEvent(changedObject, this));
            changedObject.addMdObjectListener(this);
        }
        this.fireMdObjectsModified(new MdEvent(this, this), items);
    }

    @Override
    public void resetStates(List items) {
        for (CMetadata objectUpdated : items) {
            if (objectUpdated == null) continue;
            objectUpdated.resetStates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectsToStale() {
        Map map = this.ObjectMap;
        synchronized (map) {
            for (String id : this.ObjectMap.keySet()) {
                CMetadata meta_object = (CMetadata)this.ObjectMap.get(id);
                if (meta_object == null || (meta_object.getState() & 4) != 0) continue;
                meta_object.setState(4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObjectFromStore(String strFQID) {
        if (this.isDisposed()) {
            return;
        }
        CMetadata object = (CMetadata)this.ObjectMap.get(strFQID);
        if (object == null) {
            object = (CMetadata)this.deletedObjects.get(strFQID);
        }
        if (object != null) {
            Map<String, AssociationList> assns = object.getPopulatedAssocs();
            for (String assnName : assns.keySet()) {
                AssociationList assn = assns.get(assnName);
                if (assn == null) continue;
                try {
                    assn.removeAllElements(false);
                }
                catch (MdException exp) {
                    Util.printOutputln(exp.getLocalizedMessage());
                    exp.printStackTrace();
                }
            }
            MapPool.instance();
            MapPool.returnMap(assns);
            assns = null;
            this.ObjectMap.remove(strFQID);
            if (this.changeList.contains(object)) {
                this.removeElementFromChangeList(object);
            }
            object = null;
        }
        List list = this.childStores;
        synchronized (list) {
            for (MdStore cStore : this.childStores) {
                if (cStore.getStoreType() != 1) continue;
                ((MdObjectStore)cStore).deleteObjectFromStore(strFQID);
            }
        }
    }

    @Override
    public void MdObjectModified(MdEvent e) {
    }

    @Override
    public void MdObjectsModified(MdEvent e, List items) {
        boolean InList = false;
        if (e.getSource().equals(this)) {
            return;
        }
        Iterator it = items.iterator();
        while (!InList && it.hasNext()) {
            String objectID = (String)it.next();
            if (this.ObjectMap.get(objectID) == null) continue;
            InList = true;
        }
        if (InList) {
            try {
                this.vetos.fireVetoableChange("HashMap", this.ObjectMap, items);
                this.refreshObjects(e.getSourceStore(), items);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    @Override
    public void MdObjectsRemoved(MdEvent e, List ids) {
    }

    @Override
    public void MdObjectsAdded(MdEvent e, List ids) {
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.vetos.addVetoableChangeListener(l);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.vetos.removeVetoableChangeListener(l);
    }

    @Override
    public void addMdStoreListener(MdStoreListener l) {
        this.MdStoreListenerList.add(MdStoreListener.class, l);
    }

    @Override
    public void removeMdStoreListener(MdStoreListener l) {
        this.MdStoreListenerList.remove(MdStoreListener.class, l);
    }

    public void addMdObjectListener(MdObjectListener l) {
        this.MdObjectListenerList.add(MdObjectListener.class, l);
    }

    public void removeMdObjectListener(MdObjectListener l) {
        this.MdObjectListenerList.remove(MdObjectListener.class, l);
    }

    public void addMdStoreIDChangeListener(MdStoreIDChangeListener l) {
        if (this.MdStoreIDChangeListenerList != null) {
            this.MdStoreIDChangeListenerList.add(MdStoreIDChangeListener.class, l);
        }
        if (this.MdStoreListenerList != null) {
            this.MdStoreListenerList.add(MdStoreListener.class, l);
        }
    }

    public void removeMdStoreIDChangeListener(MdStoreIDChangeListener l) {
        if (this.MdStoreIDChangeListenerList != null) {
            this.MdStoreIDChangeListenerList.remove(MdStoreIDChangeListener.class, l);
        }
        if (this.MdStoreListenerList != null) {
            this.MdStoreListenerList.remove(MdStoreListener.class, l);
        }
    }

    public void fireMdObjectModified(MdEvent e) {
        Object[] listeners = this.MdObjectListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdObjectListener.class) continue;
            ((MdObjectListener)listeners[i + 1]).MdObjectModified(e);
        }
    }

    public void fireMdStoreIDChange(MdEvent e, List idsOld, List idsNew) {
        Object[] listeners = this.MdStoreIDChangeListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdStoreIDChangeListener.class) continue;
            ((MdStoreIDChangeListener)listeners[i + 1]).MdStoreIDChange(e, idsOld, idsNew);
        }
    }

    @Override
    public void fireMdObjectsModified(MdEvent e, List items) {
        Object[] listeners = this.MdStoreListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdStoreListener.class) continue;
            ((MdStoreListener)listeners[i + 1]).MdObjectsModified(e, items);
        }
    }

    @Override
    public void fireMdObjectsAdded(MdEvent e, List ids) {
        Object[] listeners = this.MdStoreListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdStoreListener.class) continue;
            ((MdStoreListener)listeners[i + 1]).MdObjectsAdded(e, ids);
        }
    }

    @Override
    public void fireMdObjectsRemoved(MdEvent e, List ids) {
        if (this.MdStoreListenerList != null) {
            Object[] listeners = this.MdStoreListenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MdStoreListener.class) continue;
                ((MdStoreListener)listeners[i + 1]).MdObjectsRemoved(e, ids);
            }
        }
    }

    @Override
    public boolean deleteObject(CMetadata inObject) {
        String id;
        if (inObject != null && (id = inObject.getFQID()) != null && id.length() > 0) {
            this.deletedObjects.put(id, inObject);
            return true;
        }
        return false;
    }

    @Override
    public CMetadata restoreObject(String objectID) {
        if (objectID != null && objectID.length() > 0) {
            CMetadata delobject = (CMetadata)this.deletedObjects.get(objectID);
            this.deletedObjects.remove(objectID);
            return delobject;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getChangedObjects() {
        ArrayList<CMetadata> changedObjects = new ArrayList<CMetadata>(10);
        Map map = this.ObjectMap;
        synchronized (map) {
            for (String id : this.ObjectMap.keySet()) {
                CMetadata obj = (CMetadata)this.ObjectMap.get(id);
                if ((obj.getState() & 1) <= 0) continue;
                changedObjects.add(obj);
            }
        }
        return changedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getNewObjects() {
        ArrayList<CMetadata> newObjects = new ArrayList<CMetadata>(10);
        Map map = this.ObjectMap;
        synchronized (map) {
            for (String id : this.ObjectMap.keySet()) {
                CMetadata obj = (CMetadata)this.ObjectMap.get(id);
                if (obj.getFQID().indexOf(36) <= -1) continue;
                newObjects.add(obj);
            }
        }
        return newObjects;
    }

    public void addElementToChangeList(CMetadata object) {
        if (object != null && !this.changeList.contains(object)) {
            this.changeList.add(object);
        }
    }

    public void removeElementFromChangeList(CMetadata object) {
        if (object != null && this.changeList.contains(object)) {
            this.changeList.remove(object);
        }
    }

    public void clearChangeList() {
        this.changeList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createRefreshXMLforStore(boolean includeLocallyChangedItems, boolean getFullObjectUpdate) {
        StringBuffer outXML = new StringBuffer();
        Map map = this.ObjectMap;
        synchronized (map) {
            for (String objectID : this.ObjectMap.keySet()) {
                CMetadata inObject = this.getObject(objectID, true);
                if (inObject.isNewObject()) continue;
                outXML.append(MetadataUtil.createRefreshXML(inObject, false, getFullObjectUpdate));
            }
        }
        return outXML.toString();
    }

    public String createXMLforStore() {
        return this.createXMLforStore(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createXMLforStore(boolean beautifyOutput) {
        StringBuffer outXML = new StringBuffer();
        Map map = this.ObjectMap;
        synchronized (map) {
            Object[] map2 = this.ObjectMap.keySet().toArray();
            for (int i = 0; i < map2.length; ++i) {
                String objectID = (String)map2[i];
                CMetadata inObject = this.getObject(objectID, true);
                outXML.append(inObject.createObjectXML(inObject, beautifyOutput));
            }
        }
        if (beautifyOutput) {
            return MetadataUtil.formatXML(outXML.toString());
        }
        return outXML.toString();
    }

    public void refreshStoreFromServer(boolean includeLocallyChangedItems, boolean getFullObjectUpdate) throws MdException {
        if (MdObjectFactory.getInstance().getParsingType() == 0) {
            MetadataUtil.getOMIUtility().refreshStoreFromServer(this, includeLocallyChangedItems, getFullObjectUpdate);
            return;
        }
        String updateXML = this.createRefreshXMLforStore(includeLocallyChangedItems, getFullObjectUpdate);
        String strFQID = null;
        int flags = 2312;
        if (getFullObjectUpdate) {
            flags |= 1;
        }
        StringHolder outXML = new StringHolder();
        if (MdObjectFactory.getInstance().getLoggingEnabled()) {
            StringBuffer inputXML = new StringBuffer(102 + updateXML.length());
            inputXML.append("<GetMetadata><Metadata>");
            inputXML.append(updateXML);
            inputXML.append("</Metadata><NS>");
            inputXML.append(MetadataUtil.getNamespace());
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags><Options>");
            inputXML.append("");
            inputXML.append("</Options></GetMetadata>");
            Util.printLoglnClient(inputXML.toString());
        }
        try {
            MetadataWorkspace.getWorkspace().getCMRHandle().GetMetadata(updateXML, outXML, "", flags, "");
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        StringBuffer outputXML = new StringBuffer(19 + outXML.value.length());
        outputXML.append("<Objects>");
        outputXML.append(outXML.value);
        outputXML.append("</Objects>");
        String xml = outputXML.toString();
        Util.printLoglnServer(xml);
        Document doc = MetadataUtil.parseXML(xml);
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int allObjects = secondLevelList.getLength();
        for (int k = 0; k < allObjects; ++k) {
            NamedNodeMap attributeMap = secondLevelList.item(k).getAttributes();
            Node idNode = attributeMap.getNamedItem("Id");
            if (idNode == null) {
                idNode = attributeMap.getNamedItem("ObjRef");
            }
            if (idNode == null) {
                throw new MdException(MdObjectFactory.getBundle().getString("MdObjectStore.InvalidObjectNoId.txt"));
            }
            strFQID = idNode.getNodeValue();
            CMetadata metaObject = this.getObject(strFQID);
            if (metaObject == null) continue;
            MetadataUtil.populateObject(metaObject, secondLevelList.item(k).getAttributes(), secondLevelList.item(k).getChildNodes(), false);
            if (metaObject.getObjectStore().getStoreType() != 0) continue;
            metaObject.resetObject();
        }
        doc = null;
    }

    public void refreshObjectFromServer(CMetadata inObject, boolean includeLocallyChangedItems, boolean getFullObjectUpdate) throws MdException {
        this.refreshObjectFromServer(inObject, includeLocallyChangedItems, getFullObjectUpdate, false);
    }

    public void refreshObjectFromServer(CMetadata inObject, boolean includeLocallyChangedItems, boolean getFullObjectUpdate, boolean refreshAssocsSetByServerOnly) throws MdException {
        if (inObject == null || inObject.getId() == null) {
            return;
        }
        if (MdObjectFactory.getInstance().getParsingType() == 0) {
            MetadataUtil.getOMIUtility().refreshObjectFromServer(inObject, includeLocallyChangedItems, getFullObjectUpdate, refreshAssocsSetByServerOnly);
            return;
        }
        String strFQID = null;
        int flags = 264;
        if (getFullObjectUpdate && !refreshAssocsSetByServerOnly) {
            flags |= 1;
        }
        if (!MdObjectFactory.getInstance().getUseServerFormattedDates()) {
            flags |= 0x4000000;
        }
        String refreshXML = MetadataUtil.createRefreshXML(inObject, refreshAssocsSetByServerOnly, getFullObjectUpdate);
        StringHolder outXML = new StringHolder();
        if (MdObjectFactory.getInstance().getLoggingEnabled()) {
            StringBuffer inputXML = new StringBuffer(102 + refreshXML.length());
            inputXML.append("<GetMetadata><Metadata>");
            inputXML.append(refreshXML);
            inputXML.append("</Metadata><NS>");
            inputXML.append(MetadataUtil.getNamespace());
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags><Options>");
            inputXML.append("");
            inputXML.append("</Options></GetMetadata>");
            Util.printLoglnClient(inputXML.toString());
        }
        try {
            MetadataWorkspace.getWorkspace().getCMRHandle().GetMetadata(refreshXML, outXML, "", flags, "");
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        StringBuffer outputXML = new StringBuffer(19 + outXML.value.length());
        outputXML.append("<Objects>");
        outputXML.append(outXML.value);
        outputXML.append("</Objects>");
        String xml = outputXML.toString();
        Util.printLoglnServer(xml);
        Document doc = MetadataUtil.parseXML(xml);
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int allObjects = secondLevelList.getLength();
        for (int k = 0; k < allObjects; ++k) {
            NamedNodeMap attributeMap = secondLevelList.item(k).getAttributes();
            Node idNode = attributeMap.getNamedItem("Id");
            if (idNode == null) {
                idNode = attributeMap.getNamedItem("ObjRef");
            }
            if (idNode == null) {
                throw new MdException(MdObjectFactory.getBundle().getString("MdObjectStore.InvalidObjectNoId.txt"));
            }
            strFQID = idNode.getNodeValue();
            CMetadata metaObject = this.getObject(strFQID);
            MetadataUtil.populateObject(metaObject, secondLevelList.item(k).getAttributes(), secondLevelList.item(k).getChildNodes(), false, !includeLocallyChangedItems, 2);
            if (metaObject.getObjectStore().getStoreType() != 0) continue;
            metaObject.resetObject();
        }
        doc = null;
    }

    public Vector getChangeList() {
        return this.changeList;
    }

    public void removeObjectsFromStore(List deletedObjects) throws MdException {
        ArrayList objectsToRemove = new ArrayList(deletedObjects.size());
        Iterator inIter = deletedObjects.iterator();
        while (inIter.hasNext()) {
            objectsToRemove.add(inIter.next());
        }
        boolean removeDependents = ((MdObjectFactory)this.m_factory).getRemoveDependentObjects();
        for (CMetadata toDeleteObject : objectsToRemove) {
            this.removeElementFromStore(toDeleteObject, removeDependents);
            this.deleteObject(toDeleteObject);
        }
    }

    public void removeObjectFromStore(CMetadata deleteObject, String deleteTemplate) throws MdException {
        boolean templateExists = false;
        if (((MdObjectFactory)this.m_factory).getRemoveDependentObjects()) {
            templateExists = deleteTemplate != null && deleteTemplate.length() > 0;
        }
        ArrayList<CMetadata> objectsToRemove = new ArrayList<CMetadata>();
        if (templateExists) {
            Document doc = MetadataUtil.parseXML(deleteTemplate);
            Node firstNode = doc.getFirstChild();
            this.removeObjects(deleteObject, firstNode.getAttributes(), firstNode.getChildNodes(), objectsToRemove);
        }
        if (!objectsToRemove.contains(deleteObject)) {
            objectsToRemove.add(deleteObject);
        }
        for (CMetadata toDeleteObject : objectsToRemove) {
            this.removeElementFromStore(toDeleteObject, !templateExists);
            this.deleteObject(toDeleteObject);
        }
    }

    private void removeObjects(CMetadata metaObject, NamedNodeMap simpleNodeMap, NodeList removeNodeList, List outRemoveObjects) {
        this.doRemove(metaObject, removeNodeList, outRemoveObjects);
        if (!outRemoveObjects.contains(metaObject)) {
            outRemoveObjects.add(metaObject);
        }
    }

    private void doRemove(CMetadata thisObject, NodeList thisNodeList, List outRemoveObjects) {
        int numChildLists = thisNodeList.getLength();
        for (int k = 0; k < numChildLists; ++k) {
            String nodeName;
            Node childnode = thisNodeList.item(k);
            if (childnode == null || (nodeName = childnode.getNodeName()) == null || nodeName.length() == 0 || nodeName.indexOf("#") > -1) continue;
            AssociationList associatedObjects = null;
            try {
                associatedObjects = thisObject.getMdObjectAssociation(nodeName);
            }
            catch (MdException mex) {
                mex.printStackTrace();
                continue;
            }
            if (associatedObjects != null) {
                for (int i = 0; i < associatedObjects.size(); ++i) {
                    CMetadata objectToRemove = (CMetadata)associatedObjects.get(i);
                    if (objectToRemove == null) continue;
                    if (childnode.hasChildNodes()) {
                        this.removeObjects(objectToRemove, childnode.getAttributes(), childnode.getChildNodes(), outRemoveObjects);
                        continue;
                    }
                    outRemoveObjects.add(objectToRemove);
                }
                continue;
            }
            if (!childnode.hasChildNodes()) continue;
            this.removeObjects(thisObject, childnode.getAttributes(), childnode.getChildNodes(), outRemoveObjects);
        }
    }

    public void clearWriteBuffer() {
        if (this.writeBuffer.length() > 0) {
            this.writeBuffer = null;
            this.writeBuffer = new StringBuffer();
        }
    }

    public String getWriteBuffer() {
        return this.writeBuffer.toString();
    }

    public void appendWriteBuffer(String appendText) {
        this.writeBuffer.append(appendText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearObjectsFromStore() {
        ArrayList objects = new ArrayList();
        Map map = this.ObjectMap;
        synchronized (map) {
            Set keys = this.getDetailObjectMap().keySet();
            Iterator keyI = keys.iterator();
            while (keyI.hasNext()) {
                objects.add(keyI.next());
            }
        }
        for (String Id : objects) {
            if (Id == null) continue;
            this.deleteDetailMetadataObject(Id);
        }
    }

    @Override
    public List getCreatedItemsList() {
        return this.createdItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCreatedItemsList(List items) {
        for (String id : items) {
            if (!this.createdItems.contains(id)) continue;
            this.createdItems.remove(id);
        }
        List list = this.childStores;
        synchronized (list) {
            for (MdStore cStore : this.childStores) {
                cStore.updateCreatedItemsList(items);
            }
        }
    }

    @Override
    public void addChildStore(MdStore inStore) {
        if (!this.childStores.contains(inStore)) {
            this.childStores.add(inStore);
        }
    }

    @Override
    public void removeChildStore(MdStore inStore) {
        if (this.childStores.contains(inStore)) {
            this.childStores.remove(inStore);
        }
    }

    public String toString() {
        if (this.storeName != null) {
            return "[" + this.storeName + "]" + super.toString();
        }
        return "[UNKNOWN]" + super.toString();
    }

    public boolean is_write_lock() {
        return this._write_lock;
    }

    public void set_write_lock(boolean b) {
        this._write_lock = b;
    }
}

